/*
 *========================================================================
 * $Id: libwulf_prototypes.h 90 2004-09-30 17:38:02Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf_copyright.h>

 /*
  *========================================================================
  * Subroutine Prototypes
  *
  * The organization of the following is straightforward.
  *  hosts.c creates, clears/zeros, destroys a Host.
  *  connect.c creates, manages, shuts down a Host connection
  *  init.c initializes Host data via a live connection
  *  update.c updates Host data via a live connection
  *  send.c manages sending commands to single hosts or all hosts
  *  wulfhosts.c opens and parses a wulfhosts file
  *  xml_xtract.c contains xml utility routines for parsing xml
  *  parse.c contains parsing utility routines
  *  util.c contains non-xml, non-parsing utility routines.
  *
  *========================================================================
  */

 /* connect.c */
 void connect_to_all_hosts(Connectlist *connectlist);
 int connect_to_host_by_ptr(Host *hostptr);
 void send_command_to_host_by_ptr(Host *hostptr, char *cmd);
 void send_command_to_all_hosts(char *cmd);
 /* placeholders that don't do anything yet */
 int disconnect_from_host_by_ptr(Host *hostptr);
 void disconnect_from_all_hosts();

 /* hosts.c */
 void clear_values(Host *hostptr);
 void clear_host_values(List *hostlist);

 /* init.c */
 void init_values(Host *hostptr);
 void init_identity(Host *hostptr);
 void init_time(Host *hostptr);
 void init_users(Host *hostptr);
 void init_cpuinfo(Host *hostptr);
 void init_loadavg(Host *hostptr);
 void init_meminfo(Host *hostptr);
 void init_net(Host *hostptr);
 void init_stat(Host *hostptr);
 void init_sysvipc(Host *hostptr);
 void init_uptime(Host *hostptr);
 void init_version(Host *hostptr);
 void init_pids(Host *hostptr);
 void init_host_values(List *hostlist);
 void send_userlist(Host *hostptr,List *userlistptr);
 void send_tasklist(Host *hostptr,List *tasklistptr);
 void init_state(Host *hostptr);

 /* update.c */
 void update_values(Host *hostptr);
 void update_identity(Host *hostptr);
 void update_time(Host *hostptr);
 void update_users(Host *hostptr);
 void update_cpuinfo(Host *hostptr);
 void update_meminfo(Host *hostptr);
 void update_net(Host *hostptr);
 void update_stat(Host *hostptr);
 void update_sysvipc(Host *hostptr);
 void update_uptime(Host *hostptr);
 void update_version(Host *hostptr);
 void update_pids(Host *hostptr);
 void update_loadavg(Host *hostptr);
 void update_host_values(List *hostlist);


 /* from wulfhosts.c */
 void allocate_hostlists();
 int read_wulfhosts(char *hostfile);

 /* from wulfhosts_util.c */
 void parse_hostrange(xmlXPathContextPtr xp_hostdoc);
 int validate_hostrange(List *hostrangelistptr);
 void validate_host(Host *hostptr);
 void parse_iprange(xmlXPathContextPtr xp_hostdoc);
 int validate_iprange(List *iprangelistptr);
 void parse_hosttag(xmlXPathContextPtr xp_hostdoc);
 void add_localhost();
 int validate_hosttag(List *hosttaglistptr);
 void parse_tasktag(xmlXPathContextPtr xp_hostdoc);
 void parse_usertag(xmlXPathContextPtr xp_hostdoc);
 void parse_roottag(xmlXPathContextPtr xp_hostdoc);

 /* from xmlsysd_util.c */
 int recv_xmlDoc(Host *hostptr,char *msgbuf);
 void create_xmlsysd_xpath(Host *hostptr,char *msgbuf);
 void destroy_xmlsysd_xpath(Host *hostptr);


 /* from xml_xtract.c */
 int xtract(int type, void *dest, char *xpath, xmlXPathContextPtr xp_doc);
 int xtract_attribute(int type, void *dest, char *xpath,
                       char *attribute,  xmlXPathContextPtr xp_doc);

 /* util.c */
 int readn_from_hostptr(Host *hostptr, char *msgbuf, size_t len);
 int readn(int fd, char *bp, size_t len);
 int readline(int fd, char *msgbuf, int maxstrlen);
 int readline_from_hostptr(Host *hostptr,char *msgbuf, size_t maxstrlen);
 int select_fd (int fd, int seconds, int microseconds);
 int wgetread(int fd, char *buf, int len);
 void make_uptime(double total_secs,char *uptime);
 char *scale_k(long unsigned int k,long unsigned int width,long unsigned int unit);


 /* parse.c */
 char **allocate_fields(size_t maxfields,size_t maxfieldlength);
 int parse(char *inbuffer,char **outfields,int maxfields,int maxfieldlength);
 int split(char *inbuffer,char **outfields,char *delim,
               int maxfields,int maxfieldlength);


