/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.geodesic;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.geodesic.Geodesic;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.FastBitSet;

public final class EnvelopeCalculation {
    private FastBitSet geodesicMap;
    private FastBitSet mapT;
    private short[] mads;
    private AtomData atomData = new AtomData();
    private AtomDataServer viewer;
    private int atomCount;
    private FastBitSet emptySet;
    public static final float SURFACE_DISTANCE_FOR_CALCULATION = 3.0f;
    public static final int MAX_LEVEL = 3;
    private float maxRadius = 0.0f;
    private boolean modelZeroBased;
    private FastBitSet[] dotsConvexMaps;
    private int dotsConvexMax;
    private int geodesicCount;
    private BitSet bsSurface;
    private boolean disregardNeighbors = false;
    private BitSet bsMySelected;
    private float radiusP;
    private float diameterP;
    private Point3f[] currentPoints;
    private int indexI;
    private Point3f centerI;
    private float radiusI;
    private float radiiIP2;
    private final Point3f pointT = new Point3f();
    private Point3f centerT;
    private final Point3f[] vertexTest = new Point3f[12];
    private static int[] power4 = new int[]{1, 4, 16, 64, 256};
    private int neighborCount;
    private int[] neighborIndices;
    private Point3f[] neighborCenters;
    private float[] neighborPlusProbeRadii2;
    private float[] neighborRadii2;

    public EnvelopeCalculation(AtomDataServer atomDataServer, int n, short[] sArray, boolean bl) {
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i] = new Point3f();
        }
        this.neighborIndices = new int[16];
        this.neighborCenters = new Point3f[16];
        this.neighborPlusProbeRadii2 = new float[16];
        this.neighborRadii2 = new float[16];
        this.viewer = atomDataServer;
        this.atomCount = n;
        this.mads = sArray;
        this.geodesicCount = Geodesic.getVertexVectorsCount();
        this.geodesicMap = FastBitSet.allocateBitmap(this.geodesicCount);
        this.mapT = FastBitSet.allocateBitmap(this.geodesicCount);
        this.emptySet = FastBitSet.getEmptySet();
    }

    public FastBitSet[] getDotsConvexMaps() {
        return this.dotsConvexMaps;
    }

    public int getDotsConvexMax() {
        return this.dotsConvexMax;
    }

    public void allocDotsConvexMaps(int n) {
        if (this.dotsConvexMax >= n) {
            return;
        }
        this.dotsConvexMax = n;
        this.dotsConvexMaps = new FastBitSet[n];
    }

    public BitSet getBsSurfaceClone() {
        return BitSetUtil.copy(this.bsSurface);
    }

    public void setMads(short[] sArray) {
        this.mads = sArray;
    }

    public void setFromBits(int n, BitSet bitSet) {
        this.geodesicMap.set(0, this.geodesicCount);
        int n2 = this.geodesicCount;
        while (--n2 >= 0) {
            if (bitSet.get(n2)) continue;
            this.geodesicMap.clear(n2);
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new FastBitSet[this.atomCount];
        }
        FastBitSet fastBitSet = this.geodesicMap.isEmpty() ? this.emptySet : new FastBitSet(this.geodesicMap);
        this.dotsConvexMaps[n] = fastBitSet;
        this.dotsConvexMax = Math.max(this.dotsConvexMax, n);
    }

    public void newSet() {
        this.dotsConvexMax = 0;
        this.dotsConvexMaps = null;
        this.diameterP = 0.0f;
        this.radiusP = 0.0f;
        this.mads = null;
    }

    public void calculate(RadiusData radiusData, float f, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        int n2;
        this.atomData.radiusData = radiusData;
        if (radiusData.value == Float.MAX_VALUE) {
            radiusData.value = 3.0f;
        }
        this.atomData.modelIndex = bl4 ? -1 : 0;
        this.modelZeroBased = !bl4;
        this.viewer.fillAtomData(this.atomData, this.mads == null ? 2 : 1);
        this.atomCount = this.atomData.atomCount;
        if (this.mads != null) {
            for (n2 = 0; n2 < this.atomCount; ++n2) {
                this.atomData.atomRadius[n2] = (float)this.mads[n2] / 1000.0f;
            }
        }
        this.bsMySelected = bl2 && bitSet != null ? BitSetUtil.copy(bitSet) : (bitSet2 != null ? BitSetUtil.setAll(this.atomCount) : null);
        BitSetUtil.andNot(this.bsMySelected, bitSet2);
        this.disregardNeighbors = bl;
        this.bsSurface = new BitSet();
        this.maxRadius = f;
        n2 = bitSet == null ? 1 : 0;
        int n3 = n = n2 != 0 ? this.atomCount - 1 : bitSet.nextSetBit(0);
        while (n3 >= 0) {
            if (bitSet2 == null || !bitSet2.get(n3)) {
                this.setAtomI(n3);
                this.getNeighbors();
                this.calcConvexMap(bl3);
            }
            n3 = n2 != 0 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        this.currentPoints = null;
        this.setDotsConvexMax();
    }

    public float getRadius(int n) {
        return this.atomData.atomRadius[n];
    }

    public Point3f[] getPoints() {
        if (this.dotsConvexMaps == null) {
            this.calculate(new RadiusData(3.0f, 0, 0), Float.MAX_VALUE, this.bsMySelected, null, false, false, false, false);
        }
        if (this.currentPoints != null) {
            return this.currentPoints;
        }
        int n = 0;
        int n2 = 42;
        int n3 = this.dotsConvexMax;
        while (--n3 >= 0) {
            if (this.dotsConvexMaps[n3] == null) continue;
            n += this.dotsConvexMaps[n3].cardinality(n2);
        }
        Point3f[] point3fArray = new Point3f[n];
        if (n == 0) {
            return point3fArray;
        }
        n = 0;
        int n4 = this.dotsConvexMax;
        while (--n4 >= 0) {
            if (this.dotsConvexMaps[n4] == null) continue;
            int n5 = this.dotsConvexMaps[n4].size();
            if (n5 > n2) {
                n5 = n2;
            }
            while (--n5 >= 0) {
                if (!this.dotsConvexMaps[n4].get(n5)) continue;
                Point3f point3f = new Point3f();
                point3f.scaleAdd(this.atomData.atomRadius[n4], Geodesic.getVertexVector(n5), this.atomData.atomXyz[n4]);
                point3fArray[n++] = point3f;
            }
        }
        this.currentPoints = point3fArray;
        return point3fArray;
    }

    private void setDotsConvexMax() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            int n = this.atomCount;
            while (--n >= 0 && this.dotsConvexMaps[n] == null) {
            }
            this.dotsConvexMax = n + 1;
        }
    }

    public float getAppropriateRadius(int n) {
        return this.mads != null ? (float)this.mads[n] / 1000.0f : this.atomData.atomRadius[n];
    }

    private void setAtomI(int n) {
        this.indexI = n;
        this.centerI = this.atomData.atomXyz[n];
        this.radiusI = this.atomData.atomRadius[n];
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    private void calcConvexMap(boolean bl) {
        FastBitSet fastBitSet;
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new FastBitSet[this.atomCount];
        }
        this.calcConvexBits();
        if (this.geodesicMap.isEmpty()) {
            fastBitSet = this.emptySet;
        } else {
            this.bsSurface.set(this.indexI);
            if (bl) {
                this.addIncompleteFaces(this.geodesicMap);
                this.addIncompleteFaces(this.geodesicMap);
            }
            fastBitSet = new FastBitSet(this.geodesicMap);
        }
        this.dotsConvexMaps[this.indexI] = fastBitSet;
    }

    private void addIncompleteFaces(FastBitSet fastBitSet) {
        this.mapT.clear();
        short[] sArray = Geodesic.getFaceVertexes(3);
        int n = sArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = sArray[n3++];
            int n5 = sArray[n3++];
            int n6 = sArray[n3++];
            boolean bl = fastBitSet.get(n4);
            boolean bl2 = fastBitSet.get(n5);
            boolean bl3 = fastBitSet.get(n6);
            if (!bl && !bl2 && !bl3 || bl && bl2 && bl3) continue;
            if (!bl) {
                this.mapT.set(n4);
                if (n2 < n4) {
                    n2 = n4;
                }
            }
            if (!bl2) {
                this.mapT.set(n5);
                if (n2 < n5) {
                    n2 = n5;
                }
            }
            if (bl3) continue;
            this.mapT.set(n6);
            if (n2 >= n6) continue;
            n2 = n6;
        }
        for (n3 = 0; n3 <= n2; ++n3) {
            if (!this.mapT.get(n3)) continue;
            fastBitSet.set(n3);
        }
    }

    private void calcConvexBits() {
        int n;
        this.geodesicMap.set(0, this.geodesicCount);
        float f = this.radiusI + this.radiusP;
        if (this.neighborCount == 0) {
            return;
        }
        short[] sArray = Geodesic.getFaceVertexes(3);
        int n2 = power4[2];
        this.mapT.clear();
        for (n = 0; n < 12; ++n) {
            this.vertexTest[n].set(Geodesic.getVertexVector(n));
            this.vertexTest[n].scaleAdd(f, this.centerI);
        }
        for (n = 0; n < 20; ++n) {
            int n3;
            int n4 = 0;
            short s = sArray[3 * n2 * (4 * n + 0)];
            short s2 = sArray[3 * n2 * (4 * n + 1)];
            short s3 = sArray[3 * n2 * (4 * n + 2)];
            for (n3 = 0; n3 < this.neighborCount; ++n3) {
                boolean bl;
                float f2 = this.neighborPlusProbeRadii2[n3];
                this.centerT = this.neighborCenters[n3];
                boolean bl2 = this.vertexTest[s].distanceSquared(this.centerT) >= f2;
                boolean bl3 = this.vertexTest[s2].distanceSquared(this.centerT) >= f2;
                boolean bl4 = bl = this.vertexTest[s3].distanceSquared(this.centerT) >= f2;
                if (!bl2) {
                    this.geodesicMap.clear(s);
                }
                if (!bl3) {
                    this.geodesicMap.clear(s2);
                }
                if (!bl) {
                    this.geodesicMap.clear(s3);
                }
                if (bl2 || bl3 || bl) continue;
                n4 = -1;
                break;
            }
            n3 = n * 12 * n2;
            int n5 = n3 + 12 * n2;
            for (int i = n3; i < n5; ++i) {
                short s4 = sArray[i];
                if (this.mapT.get(s4) || !this.geodesicMap.get(s4)) continue;
                switch (n4) {
                    case -1: {
                        this.geodesicMap.clear(s4);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float f3 = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.set(Geodesic.getVertexVector(s4));
                            this.pointT.scaleAdd(f, this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < f3)) continue;
                            this.geodesicMap.clear(s4);
                        }
                        break;
                    }
                }
                this.mapT.set(s4);
            }
        }
    }

    private void getNeighbors() {
        this.neighborCount = 0;
        if (this.disregardNeighbors) {
            return;
        }
        AtomIndexIterator atomIndexIterator = this.viewer.getWithinAtomSetIterator(this.indexI, this.radiusI + this.diameterP + this.maxRadius, this.bsMySelected, false, this.modelZeroBased);
        while (atomIndexIterator.hasNext()) {
            int n = atomIndexIterator.next();
            float f = this.atomData.atomRadius[n];
            if (this.centerI.distance(this.atomData.atomXyz[n]) > this.radiusI + this.radiusP + this.radiusP + f) continue;
            if (this.neighborCount == this.neighborIndices.length) {
                this.neighborIndices = ArrayUtil.doubleLength(this.neighborIndices);
                this.neighborCenters = (Point3f[])ArrayUtil.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = ArrayUtil.doubleLength(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = ArrayUtil.doubleLength(this.neighborRadii2);
            }
            this.neighborCenters[this.neighborCount] = this.atomData.atomXyz[n];
            this.neighborIndices[this.neighborCount] = n;
            float f2 = f + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = f2 * f2;
            this.neighborRadii2[this.neighborCount] = f * f;
            ++this.neighborCount;
        }
    }

    public void deleteAtoms(int n, int n2, BitSet bitSet) {
        this.dotsConvexMaps = (FastBitSet[])ArrayUtil.deleteElements(this.dotsConvexMaps, n, n2);
        this.dotsConvexMax = this.dotsConvexMaps.length;
        if (this.mads != null) {
            this.mads = (short[])ArrayUtil.deleteElements(this.mads, n, n2);
        }
        this.atomData.atomRadius = (float[])ArrayUtil.deleteElements(this.atomData.atomRadius, n, n2);
        this.atomData.atomXyz = (Point3f[])ArrayUtil.deleteElements(this.atomData.atomXyz, n, n2);
        this.atomData.atomCount -= n2;
        this.atomCount = this.atomData.atomCount;
    }
}

