/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.vfx;

public class VFXDriver {
    private static final String INACTIVE_MSG = "VFX Device has been shutdown";
    private static VFXDriver instance;
    private boolean enabled = false;
    private boolean deviceActive = true;

    private VFXDriver() {
        System.loadLibrary("vfx_hmd");
        if (!this.initializeVFX()) {
            throw new RuntimeException("Cannot init");
        }
    }

    public static VFXDriver getVFXDriver() {
        if (instance == null) {
            instance = new VFXDriver();
        }
        return instance;
    }

    public void enableStereo(boolean bl) throws IllegalStateException {
        if (!this.deviceActive) {
            throw new IllegalStateException(INACTIVE_MSG);
        }
        if (this.enabled) {
            throw new IllegalStateException("The stereo system is already running");
        }
        this.enableVFXStereo(bl);
        this.enabled = true;
    }

    public void disableStereo() throws IllegalStateException {
        if (!this.deviceActive) {
            throw new IllegalStateException(INACTIVE_MSG);
        }
        this.disableVFXStereo();
        this.enabled = false;
    }

    public void resetZeroPosition() throws IllegalStateException {
        if (!this.deviceActive) {
            throw new IllegalStateException(INACTIVE_MSG);
        }
        this.resetTrackerZero();
    }

    public void getTrackerPosition(float[] fArray) throws IllegalStateException {
        if (!this.deviceActive) {
            throw new IllegalStateException(INACTIVE_MSG);
        }
        this.readTrackerPosition(fArray);
    }

    public boolean isDeviceActive() {
        return this.deviceActive;
    }

    public void shutdownDevice() throws IllegalStateException {
        if (!this.deviceActive) {
            throw new IllegalStateException(INACTIVE_MSG);
        }
        this.shutdown();
        this.deviceActive = false;
    }

    native boolean initializeVFX();

    native void resetTrackerZero();

    native void readTrackerPosition(float[] var1);

    native void enableVFXStereo(boolean var1);

    native void disableVFXStereo();

    native void shutdown();
}

