/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.hanim;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.geom.hanim.HAnimDisplacer;
import org.j3d.geom.hanim.HAnimFactory;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.geom.hanim.HAnimSegment;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLHAnimNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimDisplacer;

public abstract class BaseHAnimSegment
extends BaseGroupingNode
implements VRMLHAnimNodeType {
    protected static final int FIELD_CENTER_OF_MASS = 6;
    protected static final int FIELD_COORD = 7;
    protected static final int FIELD_DISPLACERS = 8;
    protected static final int FIELD_MASS = 9;
    protected static final int FIELD_MOMENTS_OF_INERTIA = 10;
    protected static final int FIELD_NAME = 11;
    protected static final int LAST_DISPLACER_INDEX = 11;
    protected static final int NUM_FIELDS = 12;
    private static final String MASS_ERR_MSG = "Mass must be greater than zero";
    protected static final String COORD_PROTO_MSG = "Proto does not describe a Coordinate object";
    protected static final String COORD_NODE_MSG = "Node does not describe a Coordinate object";
    protected static final String DISPLACEMENT_PROTO_MSG = "Proto does not describe a HAnimDisplacer object";
    protected static final String DISPLACEMENT_NODE_MSG = "Node does not describe a HAnimDisplacer object";
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenterOfMass = new float[3];
    protected VRMLCoordinateNodeType vfCoord;
    protected VRMLProtoInstance pCoord;
    protected ArrayList vfDisplacers = new ArrayList();
    protected float vfMass = 0.0f;
    protected float[] vfMomentsOfInertia = new float[9];
    protected int numMomentsOfInertia = 9;
    private VRMLNodeType[] nodeTmp;
    protected String vfName;
    protected HAnimSegment hanimImpl;
    protected HAnimFactory hanimFactory;

    public BaseHAnimSegment() {
        super("HAnimSegment");
        this.hasChanged = new boolean[6];
    }

    public BaseHAnimSegment(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("centerOfMass");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenterOfMass[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenterOfMass[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenterOfMass[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("mass");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMass = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("momentsOfInertia");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements > this.vfMomentsOfInertia.length) {
                this.vfMomentsOfInertia = new float[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfMomentsOfInertia, 0, vRMLFieldData.numElements);
            this.numMomentsOfInertia = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setHAnimFactory(HAnimFactory hAnimFactory) {
        this.hanimFactory = hAnimFactory;
        int n = this.vfDisplacers.size();
        for (int i = 0; i < n; ++i) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfDisplacers.get(i);
            vRMLHAnimNodeType.setHAnimFactory(hAnimFactory);
        }
        this.hanimImpl = hAnimFactory.createSegment();
        this.hanimImpl.setName(this.vfName);
        this.hanimImpl.setBboxCenter(this.vfBboxCenter);
        this.hanimImpl.setBboxSize(this.vfBboxSize);
        this.hanimImpl.setMomentsOfInertia(this.vfMomentsOfInertia, this.numMomentsOfInertia);
        this.hanimImpl.setCenterOfMass(this.vfCenterOfMass);
        this.hanimImpl.setMass(this.vfMass);
        HAnimDisplacer[] hAnimDisplacerArray = new HAnimDisplacer[n];
        for (int i = 0; i < n; ++i) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfDisplacers.get(i);
            hAnimDisplacerArray[i] = (HAnimDisplacer)vRMLHAnimNodeType.getHAnimObject();
        }
        this.hanimImpl.setDisplacers(hAnimDisplacerArray, n);
    }

    public HAnimObject getHAnimObject() {
        return this.hanimImpl;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pCoord != null) {
            this.pCoord.setupFinished();
        }
        if (this.vfCoord != null) {
            this.vfCoord.setupFinished();
        }
        int n = this.vfDisplacers.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfDisplacers.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 6: {
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfCenterOfMass;
                break;
            }
            case 7: {
                vRMLFieldData.nodeValue = this.pCoord != null ? this.pCoord : this.vfCoord;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 8: {
                vRMLFieldData.numElements = this.vfDisplacers.size();
                if (this.nodeTmp == null || this.nodeTmp.length < vRMLFieldData.numElements) {
                    this.nodeTmp = new VRMLNodeType[vRMLFieldData.numElements];
                }
                this.vfDisplacers.toArray(this.nodeTmp);
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                break;
            }
            case 9: {
                vRMLFieldData.floatValue = this.vfMass;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.numElements = this.numMomentsOfInertia;
                vRMLFieldData.floatArrayValue = this.vfMomentsOfInertia;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 11: {
                vRMLFieldData.stringValue = this.vfName;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenterOfMass, 3);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfMomentsOfInertia, this.numMomentsOfInertia);
                    break;
                }
                case 7: {
                    if (this.pCoord != null) {
                        vRMLNodeType.setValue(n2, this.pCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfCoord);
                    break;
                }
                case 8: {
                    int n3 = this.vfDisplacers.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                        this.nodeTmp = new VRMLNodeType[n3];
                    }
                    this.vfDisplacers.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfMass);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseHAnimSegment.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseHAnimSegment.sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 9: {
                if (f < 0.0f) {
                    throw new InvalidFieldValueException(MASS_ERR_MSG);
                }
                this.vfMass = f;
                if (this.inSetup) break;
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenterOfMass(fArray);
                break;
            }
            case 10: {
                this.setMomentsOfInertia(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 11: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hanimImpl.setName(this.vfName);
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                if (!this.inSetup) {
                    this.clearDisplacers();
                }
                if (vRMLNodeType != null) {
                    this.addDisplacerNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            case 7: {
                this.setCoord(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                if (!this.inSetup) {
                    this.clearDisplacers();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addDisplacerNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void setCenterOfMass(float[] fArray) {
        this.vfCenterOfMass[0] = fArray[0];
        this.vfCenterOfMass[1] = fArray[1];
        this.vfCenterOfMass[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected void setMomentsOfInertia(float[] fArray, int n) throws InvalidFieldValueException {
        for (int i = 0; i < n; ++i) {
            if (!(fArray[i] < 0.0f)) continue;
            throw new InvalidFieldValueException("momentsOfInertia value at index " + i + " is less than zero");
        }
        if (this.vfMomentsOfInertia.length < n) {
            this.vfMomentsOfInertia = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfMomentsOfInertia, 0, n);
        this.numMomentsOfInertia = n;
    }

    protected void setCoord(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = this.pCoord != null ? this.pCoord : this.vfCoord;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof VRMLCoordinateNodeType)) {
                throw new InvalidFieldValueException(COORD_PROTO_MSG);
            }
            this.pCoord = (VRMLProtoInstance)vRMLNodeType;
            this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType3;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLCoordinateNodeType)) {
                throw new InvalidFieldValueException(COORD_NODE_MSG);
            }
            this.pCoord = null;
            this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType;
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void clearDisplacers() {
        int n = this.vfDisplacers.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfDisplacers.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfDisplacers.clear();
    }

    protected void addDisplacerNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseHAnimDisplacer)) {
                throw new InvalidFieldValueException(DISPLACEMENT_PROTO_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseHAnimDisplacer)) {
            throw new InvalidFieldValueException(DISPLACEMENT_NODE_MSG);
        }
        this.vfDisplacers.add(vRMLNodeType);
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
            if (!this.inSetup) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
        }
    }

    static {
        nodeFields = new int[]{1, 0, 7, 8};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(12);
        BaseHAnimSegment.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseHAnimSegment.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseHAnimSegment.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseHAnimSegment.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseHAnimSegment.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseHAnimSegment.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseHAnimSegment.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFString", "name");
        BaseHAnimSegment.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseHAnimSegment.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "centerOfMass");
        BaseHAnimSegment.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFNode", "displacers");
        BaseHAnimSegment.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "mass");
        BaseHAnimSegment.fieldDecl[10] = new VRMLFieldDeclaration(3, "MFFloat", "momentsOfInertia");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("centerOfMass", n);
        fieldMap.put("set_centerOfMass", n);
        fieldMap.put("centerOfMass_changed", n);
        n = new Integer(7);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(8);
        fieldMap.put("displacers", n);
        fieldMap.put("set_displacers", n);
        fieldMap.put("displacers_changed", n);
        n = new Integer(9);
        fieldMap.put("mass", n);
        fieldMap.put("set_mass", n);
        fieldMap.put("mass_changed", n);
        n = new Integer(10);
        fieldMap.put("momentsOfInertia", n);
        fieldMap.put("set_momentsOfInertia", n);
        fieldMap.put("momentsOfInertia_changed", n);
        n = new Integer(11);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
    }
}

