/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * february 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "combocompo.h"
 
/*   
signals map   
*/ 
DEFINE_SIGNAL_MAP(ComboComponent,VDKEventBox)
ON_SIGNAL(combobox,selection_changed_signal,OnComboChange),
ON_SIGNAL(arrows,toggled_signal,OnArrowToggle),
ON_SIGNAL(buttonclear,clicked_signal,OnClearClick),
ON_SIGNAL(buttonadd,clicked_signal,OnAddClick)
END_SIGNAL_MAP 

/*
set up main form
 */
void ComboComponent::Setup()
{
   Usize = VDKPoint(250,150);
   VDKBox *frame = new VDKBox(Owner(),v_box);  
   Add(frame,l_justify,false,false,10);
   VDKBox *vbox;
   frame->Add(vbox = new VDKBox(Owner(),v_box));
   vbox->Add(combobox = new VDKCombo(Owner()));
   VDKBox *hbox = new VDKBox(Owner(),h_box);
   label = new VDKLabel(Owner(),"Current selection:",GTK_JUSTIFY_LEFT);
   hbox->Add(label);
   label2 = new VDKLabel(Owner(),"",GTK_JUSTIFY_LEFT);
   hbox->Add(label2);
   vbox->Add(hbox);
   VDKBox *hbox2 = new VDKBox(Owner(),h_box);
   VDKFrame *arrowframe = new VDKFrame(Owner(),"Arrow Keys",v_box,shadow_etched_in);
   arrows = new VDKRadioButtonGroup(Owner());
   arrows_on = new VDKRadioButton(arrows,"enabled");
   arrows_off = new VDKRadioButton(arrows,"disabled");
   arrowframe->Add(arrows);
   hbox2->Add(arrowframe);
   VDKFrame *buttonframe = new VDKFrame(Owner(),"List",v_box,shadow_etched_in);
   VDKBox *vbox2 = new VDKBox(Owner(),v_box);
   buttonclear = new VDKCustomButton(Owner(),"Clear");
   buttonadd = new VDKCustomButton(Owner(),"Add 5 lines");
   vbox2->Add(buttonclear);
   vbox2->Add(buttonadd);
   buttonframe->Add(vbox2);
   hbox2->Add(buttonframe);
   vbox->Add(hbox2);
   StringList sl;
   VDKString s("this");
   sl.add(s);
   s = "is"; sl.add(s);
   s = "a"; sl.add(s);
   s = "test,"; sl.add(s);
   s = "dude !"; sl.add(s);
   combobox->SetPopdownStrings(sl);
}  

bool ComboComponent::OnComboChange(VDKObject *)
{
    int sel = combobox->Selected;
    VDKString defaultText = "None";
    label2->Caption = (sel == -1) 
	  ? (char*) defaultText
	  : (char*) (combobox->GetPopdownStrings())[sel]; 
    return true;
}

bool ComboComponent::OnArrowToggle(VDKObject*)
{
    combobox->UseArrows(arrows->GetSelected() == 0);
    return true;
}

bool ComboComponent::OnClearClick(VDKObject*)
{
    combobox->ClearList();
    return true;
}

bool ComboComponent::OnAddClick(VDKObject*)
{
    StringList temp = combobox->PopdownStrings;
    char buffer[15];
    for (int i=0; i<5; i++) {
        sprintf(buffer, "Added line %d",i+1);
        VDKString s(buffer);
        temp.add(s);
    }
    combobox->PopdownStrings = temp;
    return true;
}


