import sys
import os
try:
    import headers
    import parser
except Exception, e:
    print e
    sys.exit(1)

def _get_candidates_for_header_file_gen (files):
    """
    Takes a list of files (header files) and returns a list of files
    that should  be considered for "webapps binding" generation
    """
    candidates = [file for file in files if file.endswith('-context.h')
                  and -1 == file.find('-gen-')
                  or file.endswith('webapps-service.h')
                  or file.endswith('script-repo.h')]
    return candidates

def _get_source_file_body_template ():
    return """
/*
 * unity-webapps-binding.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <glib.h>

#include <unity-webapps-service.h>
#include <unity-webapps-context.h>
#include <unity-webapps-music-player-context.h>
#include <unity-webapps-permissions.h>
#include <unity-webapps-launcher-context.h>
#include <unity-webapps-notification-context.h>

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"
#include "npapi-headers/headers/npruntime.h"

#include "wrapped-ptr-type.h"
#include "wrapped-callback-type.h"
#include "unity-webapps-binding-test.h"
#include "unity-npapi-binding-utils.h"
#include "unity-webapps-scriptable-object.h"
#include "unity-webapps-repo-userscript-wrapper.h"
#include "unity-npapi-plugin.h"

#define REACHED_UNITY_WEBAPPS_FUNC_CALL() \
    if (unity_webapps_binding_test_is_test_mode_on()) \
    { \
    g_message("reached func call"); \
    unity_webapps_binding_test_reached_func_call ();    \
    return result;  \
    } \
    do {} while (false)

#define ADD_NPOBJECT_RETAIN_FOR_CONTEXT(npp,context,object) \
  if (! unity_webapps_binding_test_is_test_mode_on()) \
  { \
    unity_npapi_plugin_t * pPlugin = (unity_npapi_plugin_t *) npp->pdata; \
    if (NULL != pPlugin) \
      { \
        unity_npapi_add_retained_objects_for_context (pPlugin,context,object); \
      } \
  }

"""

def _get_header_body_template ():
    return """
/*
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_WEBAPPS_BINDING_H)
#define UNITY_WEBAPPS_BINDING_H

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/nptypes.h"

%s

#endif // UNITY_WEBAPPS_BINDING_H

"""

def _get_unittest_func_header_template():
    return """ #ifndef %s_TEST_H
#define %s_TEST_H

int %s_test(void);

#endif
"""

def _get_function_defs (parsed_data):
    return [parsed_datum for parsed_datum in parsed_data if parsed_datum['type'] == 'func_decl']

def _get_callback_typedefs (parsed_data):
    return [parsed_datum for parsed_datum in parsed_data if parsed_datum['type'] == 'func_typedef' and parsed_datum['name'][1].endswith('Callback')]

if __name__ == "__main__":
    import sys

    import argparse
    parser = argparse.ArgumentParser(description='Generate NPAPI binding from header files.')
    parser.add_argument ('--outf', default='unity-webapps-npapi-binding')
    parser.add_argument ('--inf')
    args = parser.parse_args()
    
    outfilename = args.outf
    infilename = args.inf

    header_content = "// this file has been generated\n\n"
    source_content = "// this file has been generated\n\n" + _get_source_file_body_template()
    
    binding_headers = []
    if infilename is not None:
        import os
        if  not os.path.exists(infilename):
            print "Invalid filename (does not exist):", infilename
            sys.exit(1)
        infilename = os.path.normpath (infilename)
        binding_headers = [infilename]
    else:
        header_file_path = headers.getLibHeaderFilesPath()
        if not os.path.exists(header_file_path):
            print "libunity-webapps not installed or found"
            sys.exit(1)
        
        binding_headers = _get_candidates_for_header_file_gen (headers.getHeaderFilesFrom (header_file_path))
        if len(binding_headers) == 0:
            print "nothing to do, no header found"
            sys.exit(1)
        
        # 'fix' the paths
        binding_headers = [os.path.join (header_file_path, binding_header) for binding_header in binding_headers]

    import common_gen
    import subprocess
    functions_to_generate = [common_gen.get_unity_webapps_function_prefix() + function_to_generate for function_to_generate in subprocess.check_output('./get_functions_to_generate.sh', shell=True).split()]

    import header_generator
    import source_generator
    import unittest_gen

    import prepasses
    import parser
    for binding_header in binding_headers:
        print "--- processing", binding_header
        parsed_data = parser.parse (prepasses.run_prepasses(open(binding_header).read()))
        
        callback_decls = _get_callback_typedefs (parsed_data)
        func_decls = _get_function_defs (parsed_data)
        
        # filter func defs
        func_decls = [func_decl for func_decl in func_decls if func_decl['name'][1] in functions_to_generate]

        # generate
        header_content += header_generator.generate_headers_for(func_decls)
        source_content += source_generator.generate_sources_for(func_decls, callback_decls)
        
        for func_decl in func_decls:
            unittest_content = unittest_gen.generate_unittest_for(func_decl)
            func_name = func_decl['name'][1]
            func_name_filename = func_name.replace('_', '-')
            open(func_name_filename + "-test.c", "w+").write(unittest_content)
            open(func_name_filename + "-test.h", "w+").write(_get_unittest_func_header_template() % (func_name.upper(), func_name.upper(), func_name))
    
    open(outfilename + '.h', 'w+').write (_get_header_body_template() % header_content)
    open(outfilename + '.c', 'w+').write (source_content)


