# -*- coding: utf-8 -*-

# GTK3 widget to implement statuses in Turpial

import os

from gi.repository import Gtk
from gi.repository import GObject
from gi.repository import GdkPixbuf

class ImageButton(Gtk.EventBox):
    __gsignals__ = {
        'clicked': (GObject.SIGNAL_RUN_FIRST, None, ())
    }

    def __init__(self, basedir, pattern):
        Gtk.EventBox.__init__(self)

        self.image = Gtk.Image()
        self.set_visible_window(False)
        # This receives a pattern like "my-image-*" and replace the wildcard
        # to build the name for the normal and hover image
        normal_image_file = os.path.join(basedir, pattern.replace('*', 'normal.png'))
        hover_image_file = os.path.join(basedir, pattern.replace('*', 'hover.png'))

        # Loading both images on memory to speed up things
        self.normal_image = GdkPixbuf.Pixbuf.new_from_file(normal_image_file)
        self.hover_image = GdkPixbuf.Pixbuf.new_from_file(hover_image_file)

        self.add(self.image)
        self.__on_leave(None, None)

        self.connect('enter-notify-event', self.__on_hover)
        self.connect('leave-notify-event', self.__on_leave)
        self.connect('button-release-event', self.__on_click)

    def __on_hover(self, widget, event, data=None):
        self.image.set_from_pixbuf(self.hover_image)

    def __on_leave(self, widget, event, data=None):
        self.image.set_from_pixbuf(self.normal_image)

    def __on_click(self, widget, event, data=None):
        self.__on_leave(None, None)
        self.emit('clicked')

