/* @HEADER@ */
// ************************************************************************
// 
//                             Sundance
//                 Copyright 2011 Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Kevin Long (kevin.long@ttu.edu)
// 

/* @HEADER@ */


#ifndef SUNDANCE_CELLLID_MAPPED_FIELDWRAPPER_H
#define SUNDANCE_CELLLID_MAPPED_FIELDWRAPPER_H

#include "SundanceFieldBase.hpp"

namespace Sundance
{

using Teuchos::Array;
using Teuchos::RCP;

class CellLIDMappedFieldWrapper : public FieldBase
{
public:
  /** */
  CellLIDMappedFieldWrapper(int cellDim,
    int nFuncs, const RCP<Array<double> >& data)
    : cellDim_(cellDim), nFuncs_(nFuncs), data_(data) {}

  /** virtual dtor */
  virtual ~CellLIDMappedFieldWrapper(){}

  /** */
  double getData(int cellDim, int cellID, int elem) const 
    {
      TEUCHOS_TEST_FOR_EXCEPT(cellDim != cellDim_);
      return (*data_)[cellID*nFuncs_ + elem];
    }
  
  /** */
  bool isDefined(int cellDim, int cellID, int elem) const 
    {return true;}
  
  /** */
  int numElems() const {return nFuncs_;}
  
  /** */
  bool isPointData() const {return cellDim_==0;}
  
  /* */
  GET_RCP(FieldBase);

private:
  int cellDim_;
  int nFuncs_;
  RCP<Array<double> > data_;
};



}

#endif
