/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.message;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.tinyos.message.Message;
import net.tinyos.message.MessageListener;
import net.tinyos.message.SerialPacket;
import net.tinyos.packet.PacketListenerIF;
import net.tinyos.packet.PhoenixSource;

public class Receiver
implements PacketListenerIF {
    public static final boolean DEBUG = false;
    public static final boolean DISPLAY_ERROR_MSGS = true;
    Hashtable templateTbl = new Hashtable();
    PhoenixSource source;

    public Receiver(PhoenixSource phoenixSource) {
        this.source = phoenixSource;
        phoenixSource.registerPacketListener(this);
    }

    public void registerListener(Message message, MessageListener messageListener) {
        Integer n = new Integer(message.amType());
        Vector<msgTemplate> vector = (Vector<msgTemplate>)this.templateTbl.get(n);
        if (vector == null) {
            vector = new Vector<msgTemplate>();
        }
        vector.addElement(new msgTemplate(message, messageListener));
        this.templateTbl.put(n, vector);
    }

    public void deregisterListener(Message message, MessageListener messageListener) {
        Integer n = new Integer(message.amType());
        Vector vector = (Vector)this.templateTbl.get(n);
        if (vector == null) {
            throw new IllegalArgumentException("No listeners registered for message type " + message.getClass().getName() + " (AM type " + message.amType() + ")");
        }
        msgTemplate msgTemplate2 = new msgTemplate(message, messageListener);
        while (vector.removeElement(msgTemplate2)) {
        }
        if (vector.size() == 0) {
            this.templateTbl.remove(n);
        }
    }

    private void error(msgTemplate msgTemplate2, String string) {
        System.err.println("receive error for " + msgTemplate2.template.getClass().getName() + " (AM type " + msgTemplate2.template.amType() + "): " + string);
    }

    public void packetReceived(byte[] byArray) {
        if (byArray[0] != 0) {
            return;
        }
        SerialPacket serialPacket = new SerialPacket(byArray, 1);
        Integer n = new Integer(serialPacket.get_header_type());
        Vector vector = (Vector)this.templateTbl.get(n);
        if (vector == null) {
            return;
        }
        short s = serialPacket.get_header_length();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Message message;
            msgTemplate msgTemplate2 = (msgTemplate)enumeration.nextElement();
            try {
                message = msgTemplate2.template.clone(s);
                message.dataSet(serialPacket.dataGet(), SerialPacket.offset_data(0) + serialPacket.baseOffset(), 0, s);
                message.setSerialPacket(serialPacket);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.error(msgTemplate2, "invalid length message received (too long)");
                continue;
            }
            catch (Exception exception) {
                this.error(msgTemplate2, "couldn't clone message!");
                continue;
            }
            if (msgTemplate2.template.dataGet().length > s) {
                this.error(msgTemplate2, "invalid length message received (too short)");
                continue;
            }
            msgTemplate2.listener.messageReceived(serialPacket.get_header_dest(), message);
        }
    }

    class msgTemplate {
        Message template;
        MessageListener listener;

        msgTemplate(Message message, MessageListener messageListener) {
            this.template = message;
            this.listener = messageListener;
        }

        public boolean equals(Object object) {
            try {
                msgTemplate msgTemplate2 = (msgTemplate)object;
                if (msgTemplate2.template.getClass().equals(this.template.getClass()) && msgTemplate2.listener.equals(this.listener)) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

