/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "Observable.hpp"

#include "Observer.hpp"

using namespace indii;

Observable::~Observable() {
  notifyDestroy();
}

void Observable::subscribe(Observer* o) {
  os.insert(o);
}

void Observable::unsubscribe(Observer* o) {
  os.erase(o);
}

void Observable::notifyAll() {
  registry_t::iterator iter;
  for (iter = os.begin(); iter != os.end(); iter++) {
    (*iter)->notify();
  }
}

void Observable::notifyGreyscaleChange() {
  registry_t::iterator iter;
  for (iter = os.begin(); iter != os.end(); iter++) {
    (*iter)->notifyGreyscaleChange();
  }
}

void Observable::notifyDestroy() {
  registry_t::iterator iter;
  for (iter = os.begin(); iter != os.end(); iter++) {
    (*iter)->notifyDestroy();
  }
}
