/*
 * CoordinateDialog.java
 *
 * Created on 19 January 2008, 16:46
 */
package mccombe.terrain;

import java.awt.event.ActionEvent;
import mccombe.mapping.*;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author  Mike
 */
public class CoordinateDialog extends javax.swing.JDialog {

    /** Creates new form CoordinateDialog */
    public CoordinateDialog(java.awt.Frame parent, boolean modal, MappingToolkit toolbox) {
        super(parent, modal);
        initComponents();
        coordSet.addActionListener(new java.awt.event.ActionListener() {

            @Override
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                coordSetActionPerformed(evt);
            }
        });
        toolkit = toolbox ;

        java.util.List<String> coordList = toolkit.getProjectionNames();
        coordSet.setModel(new DefaultComboBoxModel(coordList.toArray(new String[0])));
       

        java.util.List<Datum> datumList = toolkit.getDatumList();
        datumSet.setModel(new DefaultComboBoxModel(datumList.toArray(new Datum[0])));
        java.util.List<Ellipsoid> ellipsoidList = toolkit.getEllipsoidList();
        ellipsoidSet.setModel(new DefaultComboBoxModel(ellipsoidList.toArray(new Ellipsoid[0])));
    }

    int getReturnStatus() {
        return returnStatus;
    }

    void setSelectedCoordType(String currentCoordType) {
        if (currentCoordType != null) {
            coordSet.setSelectedItem(currentCoordType);
        }
    }

    private void coordSetActionPerformed(ActionEvent evt) {
        String selected = (String) coordSet.getSelectedItem();
        Ellipsoid e = toolkit.defaultEllipsoid(selected);
        ellipsoidSet.setSelectedItem(e);
        Datum d = toolkit.defaultDatum(selected);
        datumSet.setSelectedItem(d);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        coordSet = new javax.swing.JComboBox();
        datumSet = new javax.swing.JComboBox();
        ellipsoidSet = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        okButton.setText("OK");
        okButton.setPreferredSize(new java.awt.Dimension(65, 23));
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("Coordinate System");

        jLabel2.setText("Datum");

        jLabel3.setText("Ellipsoid");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2)
                    .addComponent(datumSet, 0, 380, Short.MAX_VALUE)
                    .addComponent(jLabel3)
                    .addComponent(ellipsoidSet, 0, 380, Short.MAX_VALUE)
                    .addComponent(coordSet, 0, 380, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(cancelButton)
                        .addGap(18, 18, 18)
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(11, 11, 11)
                .addComponent(coordSet, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(datumSet, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(ellipsoidSet, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cancelButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        String coordSystemName = (String) coordSet.getSelectedItem();
        doClose(RET_OK);

    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose(RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                CoordinateDialog dialog = new CoordinateDialog(new javax.swing.JFrame(), true, new MappingToolkit());
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }


    public String getExample() {
        String typeName = (String) coordSet.getSelectedItem();
        return toolkit.getExample(typeName);
    }
    public String getProjection() {
        return  (String) coordSet.getSelectedItem();
    }
    public Datum getDatum() {
        return (Datum) datumSet.getSelectedItem();
    }
    public void setDatum(Datum d){
        datumSet.setSelectedItem(d);
    }
    public Ellipsoid getEllipsoid() {
        return (Ellipsoid) ellipsoidSet.getSelectedItem();
    }
    public void setEllipsoid(Ellipsoid e){
        ellipsoidSet.setSelectedItem(e);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    private int returnStatus = RET_CANCEL;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JComboBox coordSet;
    private javax.swing.JComboBox datumSet;
    private javax.swing.JComboBox ellipsoidSet;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables
    private MappingToolkit toolkit ;
}
