package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClasses invokes the rds.ListClasses API synchronously
func (client *Client) ListClasses(request *ListClassesRequest) (response *ListClassesResponse, err error) {
	response = CreateListClassesResponse()
	err = client.DoAction(request, response)
	return
}

// ListClassesWithChan invokes the rds.ListClasses API asynchronously
func (client *Client) ListClassesWithChan(request *ListClassesRequest) (<-chan *ListClassesResponse, <-chan error) {
	responseChan := make(chan *ListClassesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClasses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClassesWithCallback invokes the rds.ListClasses API asynchronously
func (client *Client) ListClassesWithCallback(request *ListClassesRequest, callback func(response *ListClassesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClassesResponse
		var err error
		defer close(result)
		response, err = client.ListClasses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClassesRequest is the request struct for api ListClasses
type ListClassesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CommodityCode        string           `position:"Query" name:"CommodityCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OrderType            string           `position:"Query" name:"OrderType"`
}

// ListClassesResponse is the response struct for api ListClasses
type ListClassesResponse struct {
	*responses.BaseResponse
	RegionId  string      `json:"RegionId" xml:"RegionId"`
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Items     []ClassList `json:"Items" xml:"Items"`
}

// CreateListClassesRequest creates a request to invoke ListClasses API
func CreateListClassesRequest() (request *ListClassesRequest) {
	request = &ListClassesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ListClasses", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListClassesResponse creates a response to parse from ListClasses response
func CreateListClassesResponse() (response *ListClassesResponse) {
	response = &ListClassesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
