// Macintosh port of J. Loewer's tDOM lib for Tcl
// Author: Bernard Desgraupes
// e-mail: bdesgraupes@easyconnect.fr
// web-page: http://webperso.easyconnect.fr/bdesgraupes/
// Last modification : 2003-02-16 19:36:06

#include <Types.r>
#include <SysTypes.r>

#define TDOM_MAJOR 	0
#define TDOM_MINOR 	7
#define TDOM_SUBMINOR 6
#define TCL_MAJOR 		8
#define TCL_MINOR 		4

// developStage, alphaStage, betaStage, finalStage
#define TDOM_STAGE 		betaStage

#if	(TDOM_STAGE == developStage)
#		define	TDOM_STAGE_CODE	'd'
#elif	(TDOM_STAGE == alphaStage)
#		define	TDOM_STAGE_CODE	'a'
#elif	(TDOM_STAGE == betaStage)
#	 	define	TDOM_STAGE_CODE	'b'
#elif	(TDOM_STAGE == finalStage)
#	 	define	TDOM_STAGE_CODE	'f'
#endif

#define	TDOM_MAJOR_BCD	((TDOM_MAJOR / 10) * 16) + (TDOM_MAJOR % 10)
#define	TDOM_MINOR_BCD	(TDOM_MINOR * 16)

// #define	TDOM_VERSION_STRING	$$Format("%d.%d%c%d", TDOM_MAJOR, TDOM_MINOR, \
// 											TDOM_STAGE_CODE, TDOM_SUBMINOR)

#define	TDOM_VERSION_STRING	$$Format("%d.%d.%d", TDOM_MAJOR, TDOM_MINOR, TDOM_SUBMINOR)

resource 'vers' (1) {
	TDOM_MAJOR_BCD, 
	TDOM_MINOR_BCD,
	TDOM_STAGE, 
	0x00, 
	verUS,
	TDOM_VERSION_STRING,
	$$Format("%s %s  %d\nported to Mac by B. Desgraupes", 
					"tDOM", TDOM_VERSION_STRING, $$YEAR)
};


resource 'vers' (2) {
	TDOM_MAJOR_BCD, 
	TDOM_MINOR_BCD,
	TDOM_STAGE, 
	0x00, 
	verUS,
	TDOM_VERSION_STRING,
	"Mac port of J. Loewer's tDOM lib"
};


/*
 * The -16397 string will be displayed by Finder when a user
 * tries to open the shared library. The string should
 * give the user a little detail about the library's capabilities
 * and enough information to install the library in the correct location.  
 * A similar string should be placed in all shared libraries.
 */
resource 'STR ' (-16397, purgeable) {
	"tDOM  Library\n\n"
	"This library provides an XML/DOM/XPath/XSLT implementation for Tcl."
	" It should be placed in the Tool Command Language folder "
	"within the Extensions folder. To load it: "
	"'package require tdom'"
};

data 'TEXT' (1000,"pkgIndex",purgeable, preload) {
		$$Format("# Tcl package index file, version 1.0\npackage ifneeded tdom %d.%d.%d \"load [list [file join $dir tDOM%d.%d[info sharedlibextension]]] Tdom\"\n", TDOM_MAJOR, TDOM_MINOR, TDOM_SUBMINOR, TCL_MAJOR, TCL_MINOR)
};

