C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SMFFLU,SSI=0
C
                     SUBROUTINE SMFFLU
C                    *****************
C
C     ---------------------------------------------------
     *( NFFLUS,VFFLUS,NBFFLU,NFECHS,VFECHS,NBFECH, 
     *  NFRESC,VFRESC,NELERC,
     *  NFRAYS,VFRAYS,NELERA,
     *  NFRAIS,VFRAIS,NBFRAI,
     *  NFCOUS,VFCOUS,NELESS,
     *  TMPSA,B,NODEUS,COORDS,SURFUS, 
     *  NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     *  TRAVF,TRAVP,WCT )
C     ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DU SECOND MEMBRE                           *
C                    PRISE EN COMPTE DES FLUX DE BORD                  *
C                                                                      *
C      Les flux au bord du solide sont de plusieurs types:             *
C          Flux dus au couplage thermique fluide -solide               *
C          Flux imposes par l'utilisateur                              *
C          Flux ayant pour origine un coefficient d'echange            *
C          Flux ayant pour origine une resitance de contact            *
C          Flux ayant pour origine un rayonnement                      *
C                                                                      *
C          Le flux est impose sur les noeuds definis par l'utilisateur *
C          Attention:                                                  *
C                     Les termes de flux sont traites par facette      *
C                     c'est a dire qu'on considere des facettes de     *
C                     type    Couplee                                  *
C                             Echange                                  *
C                             Flux                                     *
C                             Resistance                               *
C                             Rayonnement                              *
C                                                                      *
C     Deux options sont envisageables :                                *
C          une option implicite (qui ameliore le traitement en temps)  *
C          une option explicite (qui ameliore le traitement en espace) *
C                                                                      *
C      En 2D:                                                          *
C      ------              /                                           *
C                 B = B + /     q .  Phj  dS                           *
C                        /                                             *
C                 q est discretise  en iso-P2                          *
C                 dS element de longueur                               *
C                 Phj fonction de base iso-P2                          *
C                                                                      *
C      En 3D:                                                          *
C      ------              /                                           *
C                 B = B + /     q .  Phj  dS                           *
C                        /                                             *
C                 q est discretises en iso-P2                          *
C                 dS element de surface                                *
C                 Phj fonction de base iso-P2                          *
C                                                                      *
C  Rq : Lorsque le flux n'est pas defini, cela revient a dire          *
C       implicitement que ce flux est nul.                             *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NFFLUS  !  TE  ! D  ! No de facette flux ---> face glob        !
C   !   VFFLUS  !  TR  ! D  ! Valeur des flux a chaque point de la face!
C   !   NBFFLU  !  E   ! D  ! Nombre de facette de type flux           ! 
C   !   NFECHS  !  TE  ! D  ! No de facette echange ---> face glob     !
C   !   VFECHS  !  TR  ! D  ! Valeur des echan aux points de la face   !
C   !   NBFECH  !  E   ! D  ! Nombre de facette de type echange        ! 
C   !   NFRESC  !  TE  ! D  ! No de facette resistance ---> face glob  !
C   !   VFRESC  !  TR  ! D  ! Valeur des resista aux points de la face !
C   !   NELERC  !  E   ! D  ! Nombre de facette de type resistance     ! 
C   !   NFRAYS  !  TE  ! D  ! No de facette rayonnement ---> face glob !
C   !   VFRAYS  !  TR  ! D  ! Valeur du rayo aux points de la face     !
C   !   NELERA  !  E   ! D  ! Nombre de facette de type rayonnement    ! 
C   !   NFRAIS  !  TE  ! D  ! No de facette rayonnt inf -->  face glob !
C   !   VFRAIS  !  TR  ! D  ! Valeur du rayo inf aux points de la face !
C   !   NBFRAI  !  E   ! D  ! Nombre de facette de type rayonnement inf! 
C   !   NFCOUS  !  TE  ! D  ! No de facette couplee ---> face glob     !
C   !   VFCOUS  !  TR  ! D  ! Valeur du couplage aux points de la face !
C   !   NELESS  !  E   ! D  ! Nombre de facette de type couplee        ! 
C   !   B       !  TR  ! R  ! SECOND MEMBRE                            !
C   !   NODEUS  !  TE  ! D  ! NOEUDS DE BORD( LOCALE 2D --> GLOBALE 3D)!
C   !   SURFUS  !  TR  ! D  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux) !
C   !           !      !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux) !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !   TRAV    !  TR  ! R  ! TABLEAU DE TRAVAIL                       !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL. ATTENTION On utilise!
C   !           !      !    ! uniquement les  premieres cases          !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
#include "syrth.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDIM,NELEUS,NDMASS
      INTEGER NBFFLU,NBFECH,NELERC,NELERA,NBFRAI,NELESS
      INTEGER NFFLUS(NBFFLU),NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NFRAYS(NELERA),NFRAIS(NBFRAI),NFCOUS(NELESS)
      INTEGER NODEUS(NELEUS,NDMASS)
C
      DOUBLE PRECISION VFFLUS(NBFFLU,NDMASS),VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
      DOUBLE PRECISION B(NPOINS),TRAVP(NPOINS),TRAVF(NELEUS,NDMASS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),TMPSA(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMASS)
      DOUBLE PRECISION SURFUS(NELEUS)   
C
C..Variables internes
      DOUBLE PRECISION R1,R2
      DOUBLE PRECISION F1,F2,F3,F4,F5,F6
      INTEGER I,J,INODE,NF,NCA
      DOUBLE PRECISION S48,SV48,S12,SV12
      DOUBLE PRECISION ZERO
      DOUBLE PRECISION HRAYI,HRAYT 
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
      IF (NELESS
     *   .EQ.0 .AND. .NOT. LSYRTH)
     *    NELESS = NELEUS
C
      ZERO   = 0.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEUS*NDMASS )
C
      S48 = 1.D0 / 48.D0
      S12  = 1.D0 / 12.D0
C
C     2- CALCUL DES CONDITIONS SUR LES FACES DE BORD CONCERNEES
C     =========================================================
C
C
C     2.1 Prise en compte explicite
C     -----------------------------
      IF ( LCLEXP ) THEN
C
          DO 2111 J=1,NDMASS
             DO 2110 I=1,NELESS
                INODE = NODEUS(NFCOUS(I),J)
                NF = NFCOUS(I)
                TRAVF(NF,J) = TRAVF(NF,J) +
     &                        VFCOUS(I,J,2)*(VFCOUS(I,J,1)-TMPSA(INODE))
 2110        CONTINUE
 2111     CONTINUE
C
          DO 2121 J=1,NDMASS
             DO 2120 I=1,NBFFLU
                NF = NFFLUS(I)
                TRAVF(NF,J) = TRAVF(NF,J) + VFFLUS(I,J)
 2120        CONTINUE          
 2121     CONTINUE
C
          DO 2131 J=1,NDMASS
             DO 2130 I=1,NBFECH
                INODE = NODEUS(NFECHS(I),J)
                NF = NFECHS(I)
                TRAVF(NF,J) = TRAVF(NF,J) +
     &                        VFECHS(I,J,2)*(VFECHS(I,J,1)-TMPSA(INODE))
 2130         CONTINUE
 2131     CONTINUE
C
C
          DO 2141 J=1,NDMASS
             DO 2140 I=1,NELERC
                INODE = NODEUS(NFRESC(I),J)
                NF = NFRESC(I)
                TRAVF(NF,J) = TRAVF(NF,J) +
     &                        VFRESC(I,J,2)*(VFRESC(I,J,1)-TMPSA(INODE))
 2140        CONTINUE
 2141     CONTINUE
C
C         
          DO 2151 J=1,NDMASS
             DO 2150 I=1,NBFRAI
                INODE = NODEUS(NFRAIS(I),J)
                NF = NFRAIS(I)
                HRAYI = VFRAIS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAIS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAIS(I,J,1)+TKEL) * (VFRAIS(I,J,1)+TKEL) )
                TRAVF(NF,J) = TRAVF(NF,J) +
     &                        HRAYI*(VFRAIS(I,J,1)-TMPSA(INODE))
 2150        CONTINUE
 2151     CONTINUE
C
C         
          DO 2161 J=1,NDMASS
             DO 2160 I=1,NELERA
                INODE = NODEUS(NFRAYS(I),J)
                NF = NFRAYS(I)
                HRAYT = VFRAYS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAYS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) +
     &                  (VFRAYS(I,J,1)+TKEL) * (VFRAYS(I,J,1)+TKEL) )
                TRAVF(NF,J) = TRAVF(NF,J) +
     &                        HRAYT*(VFRAYS(I,J,1)-TMPSA(INODE))
 2160        CONTINUE
 2161     CONTINUE
C
C     2.2 Prise en compte implicite des conditions d'echange
C     ------------------------------------------------------
      ELSE
C
        CALL OV ( 'X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEUS*NDMASS )
C
        DO 2211 J=1,NDMASS
           DO 2210 I=1,NELESS
              NF = NFCOUS(I)
              TRAVF(NF,J) = TRAVF(NF,J) + VFCOUS(I,J,1)*VFCOUS(I,J,2)
 2210      CONTINUE
 2211   CONTINUE
C
        DO 2231 J=1,NDMASS
           DO 2230 I=1,NBFECH
              NF = NFECHS(I)
              TRAVF(NF,J) = TRAVF(NF,J) + VFECHS(I,J,1)*VFECHS(I,J,2)
 2230      CONTINUE
 2231   CONTINUE
C
C
        DO 2241 J=1,NDMASS
           DO 2240 I=1,NELERC
              NF = NFRESC(I)
              TRAVF(NF,J) = TRAVF(NF,J) + VFRESC(I,J,1)* VFRESC(I,J,2)
 2240      CONTINUE
 2241   CONTINUE
C
C         
        DO 2251 J=1,NDMASS
           DO 2250 I=1,NBFRAI
              INODE = NODEUS(NFRAIS(I),J)
              NF = NFRAIS(I)
              HRAYI = VFRAIS(I,J,2)*SIGMA*
     &               (TMPSA(INODE)+VFRAIS(I,J,1)+2*TKEL)*
     &               ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &               (VFRAIS(I,J,1)+TKEL) * (VFRAIS(I,J,1)+TKEL) )
              TRAVF(NF,J) = TRAVF(NF,J) + VFRAIS(I,J,1)*HRAYI
 2250      CONTINUE
 2251   CONTINUE
C 
C         
        DO 2261 J=1,NDMASS
           DO 2260 I=1,NELERA
              INODE = NODEUS(NFRAYS(I),J)
              NF = NFRAYS(I)
              HRAYT = VFRAYS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAYS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) +
     &                  (VFRAYS(I,J,1)+TKEL) * (VFRAYS(I,J,1)+TKEL) )
c              print*,' T Tr Hray Flux_eq',i,j,TMPSA(INODE),
c     *                 VFRAYS(i,j,1),HRAYT,HRAYT*
c     *                 (TMPSA(INODE)-VFRAYS(i,j,1))
              TRAVF(NF,J) = TRAVF(NF,J) + VFRAYS(I,J,1)*HRAYT
 2260      CONTINUE
 2261   CONTINUE
C 
C
        DO 2311 J=1,NDMASS
           DO 2310 I=1,NBFFLU
              NF = NFFLUS(I)
              TRAVF(NF,J) = TRAVF(NF,J) + VFFLUS(I,J)
 2310   CONTINUE          
 2311   CONTINUE          
C
C         
      ENDIF
C
C               
C     3- CALCUL DU VECTEUR ELEMENTAIRE 
C     ================================
C
C         3.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             3.1.1- Cas cartesien
C             --------------------
              IF (IAXISY.EQ.0) THEN
C
                   DO 3110 I=1,NELEUS
C
                     SV12 = S12 * SURFUS(I)      
C
                     F1  = TRAVF(I,1) * SV12
                     F2  = TRAVF(I,2) * SV12
                     F3  = TRAVF(I,3) * SV12
C                  
C                    ATTENTION  Le point 3 est au milieu du segment           
                     WCT(I,1) = F3+2*F1
                     WCT(I,2) = F3+2*F2
                     WCT(I,3) = 4*F3+F1+F2               
 3110              CONTINUE
C
C             3.1.2- Cas axisymetrique
C             ------------------------
              ELSE
              
                   DO 3120 I=1,NELEUS
C
                     SV48 = S48 * SURFUS(I)
C
                     R1 = ABS (COORDS(NODEUS(I,1),NCA))
                     R2 = ABS (COORDS(NODEUS(I,2),NCA))        
C
                     F1  = TRAVF(I,1) * SV48
                     F2  = TRAVF(I,2) * SV48
                     F3  = TRAVF(I,3) * SV48
C                  
                     WCT(I,1) = R2*F3+R2*F1+3*R1*F3+7*R1*F1 
                     WCT(I,2) = 3*R2*F3+7*R2*F2+R1*F3+R1*F2 
                     WCT(I,3) = 8*R2*F3+R2*F1+8*R1*F3+3*R1*F1
     &                       +3*R2*F2+R1*F2 
C   
 3120              CONTINUE
C              
              ENDIF
C                         
C         3.2- Cas 3D
C         -----------          
          ELSE
                   DO 3200 I=1,NELEUS
C
                   SV48 = S48 * SURFUS(I)                      
C            
                   F1  = TRAVF(I,1) * SV48
                   F2  = TRAVF(I,2) * SV48
                   F3  = TRAVF(I,3) * SV48
                   F4  = TRAVF(I,4) * SV48
                   F5  = TRAVF(I,5) * SV48
                   F6  = TRAVF(I,6) * SV48          
C
C
                   WCT(I,1) =  2 * F1 + F4 + F6 
                   WCT(I,2) =  2 * F2 + F4 + F5 
                   WCT(I,3) =  2 * F3 + F5 + F6 
                   WCT(I,4) =  F1 + F2 + 6 * F4 + 2 * F5 + 2 * F6
                   WCT(I,5) =  F2 + F3 + 2 * F4 + 6 * F5 + 2 * F6
                   WCT(I,6) =  F1 + F3 + 2 * F4 + 2 * F5 + 6 * F6
C
 3200 CONTINUE
C
          ENDIF
C
          CALL OV ( 'X=C     ',TRAVP,TRAVP,TRAVP,ZERO,NPOINS )
          CALL ASSEUS ( TRAVP,NODEUS,NELEMS,NELEUS,NPOINS,NDMASS,
     &                  NDIM,WCT)
C
C
C     4- MISE A JOUR DU SECOND MEMBRE
C     =============================== 
C
      DO 4000 I=1,NPOINS
          B(I) = B(I) + TRAVP(I)
 4000 CONTINUE
C  
C
C     5- IMPRESSIONS POUR CONTROLE
C     ============================
C
      IF (NBLBLA.EQ.12) THEN
        WRITE(NFECRA,5001)
        DO 5000 I=1,NPOINS
          WRITE(NFECRA,5010) I,B(I),TRAVP(I)
 5000   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
 5001 FORMAT(/,' *** SMFFLU : SECOND MEMBRE (PARTIE FLUX)',/,
     &         '        NOEUD       SECOND MEMBRE     FLUX AJOUTE   ')
 5010 FORMAT(7X,I6,5X,G10.4,5X,G10.4)
C                             
      END
