/* smd-applet.c generated by valac 0.30.0, the Vala compiler
 * generated from smd-applet.vala, do not modify */

/* Released under the terms of GPLv3 or at your option any later version.*/
/* No warranties.*/
/* Copyright Enrico Tassi <gares@fettunta.org>*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <libnotify/notify.h>
#include <glib/gstdio.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <gdk/gdk.h>
#include "smd-config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_NETWORK_MANAGER (network_manager_get_type ())
#define NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_MANAGER, NetworkManager))
#define IS_NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_MANAGER))
#define NETWORK_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NETWORK_MANAGER, NetworkManagerIface))

typedef struct _NetworkManager NetworkManager;
typedef struct _NetworkManagerIface NetworkManagerIface;

#define TYPE_NETWORK_MANAGER_PROXY (network_manager_proxy_get_type ())
typedef GDBusProxy NetworkManagerProxy;
typedef GDBusProxyClass NetworkManagerProxyClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
typedef struct _EventPrivate EventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _event_unref0(var) ((var == NULL) ? NULL : (var = (event_unref (var), NULL)))
typedef struct _ParamSpecEvent ParamSpecEvent;

#define TYPE_SMD_APPLET (smd_applet_get_type ())
#define SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SMD_APPLET, smdApplet))
#define SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SMD_APPLET, smdAppletClass))
#define IS_SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SMD_APPLET))
#define IS_SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SMD_APPLET))
#define SMD_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SMD_APPLET, smdAppletClass))

typedef struct _smdApplet smdApplet;
typedef struct _smdAppletClass smdAppletClass;
typedef struct _smdAppletPrivate smdAppletPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	EXIT_ABORT
} Exit;
#define EXIT exit_quark ()
struct _NetworkManagerIface {
	GTypeInterface parent_iface;
	guint (*get_state) (NetworkManager* self);
};

struct _Event {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventPrivate * priv;
	gchar* message;
	gchar* message_icon;
	gboolean enter_network_error_mode;
	gboolean enter_error_mode;
	gboolean transient_error_message;
	gchar* context;
	gchar* cause;
	gchar* permissions;
	gchar* mail_name;
	gchar* mail_body;
	GeeArrayList* commands;
};

struct _EventClass {
	GTypeClass parent_class;
	void (*finalize) (Event *self);
};

struct _ParamSpecEvent {
	GParamSpec parent_instance;
};

struct _smdApplet {
	GtkApplication parent_instance;
	smdAppletPrivate * priv;
};

struct _smdAppletClass {
	GtkApplicationClass parent_class;
};

struct _smdAppletPrivate {
	GtkBuilder* builder;
	GtkStatusIcon* si;
	GtkWindow* win;
	GtkWindow* err_win;
	GtkNotebook* notebook;
	GtkSwitch* sync_active;
	GtkComboBoxText* cblogs;
	GeeArrayList* lognames;
	GSettings* settings;
	GThread* thread;
	gboolean thread_die;
	GPid pid;
	GMutex events_lock;
	GeeArrayList* events;
	gboolean error_mode;
	gboolean network_error_mode;
	gboolean config_wait_mode;
	GHashTable* command_hash;
	NetworkManager* net_manager;
	NotifyNotification* notification;
	gboolean notification_server_has_persistence;
};

struct _Block1Data {
	int _ref_count_;
	smdApplet* self;
	GtkSwitch* bnotify;
	GtkSwitch* bautostart;
};


extern gboolean verbose;
gboolean verbose = FALSE;
static gpointer event_parent_class = NULL;
extern gchar* SMD_LOGS_DIR;
gchar* SMD_LOGS_DIR = NULL;
extern gchar* SMD_LOOP_CFG;
gchar* SMD_LOOP_CFG = NULL;
extern gchar* SMD_PP_DEF_CFG;
gchar* SMD_PP_DEF_CFG = NULL;
extern gchar* XDG_AUTORUN_FILE;
gchar* XDG_AUTORUN_FILE = NULL;
static gpointer smd_applet_parent_class = NULL;
extern gchar* smd_applet_smd_loop_cmd;
gchar* smd_applet_smd_loop_cmd = NULL;
extern gchar* smd_applet_smd_applet_ui;
gchar* smd_applet_smd_applet_ui = NULL;
extern gchar* smd_applet_smd_push_cmd;
gchar* smd_applet_smd_push_cmd = NULL;
extern gchar* smd_applet_smd_applet_desktop;
gchar* smd_applet_smd_applet_desktop = NULL;
static gchar* smd_applet_menu_ui;
static gchar* smd_applet_menu_ui = NULL;

GQuark exit_quark (void);
void debug (const gchar* message);
GType network_manager_get_type (void) G_GNUC_CONST;
GType network_manager_proxy_get_type (void) G_GNUC_CONST;
guint network_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
guint network_manager_get_state (NetworkManager* self);
static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters);
static guint network_manager_dbus_proxy_get_state (NetworkManager* self);
static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface);
static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_network_manager_get_state (NetworkManager* self);
static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data);
static void _network_manager_unregister_object (gpointer user_data);
#define NM_SERVICE "org.freedesktop.NetworkManager"
#define NM_PATH "/org/freedesktop/NetworkManager"
gboolean is_nm_connected (guint code);
gpointer event_ref (gpointer instance);
void event_unref (gpointer instance);
GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_event (GValue* value, gpointer v_object);
void value_take_event (GValue* value, gpointer v_object);
gpointer value_get_event (const GValue* value);
GType event_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_DUMMY_PROPERTY
};
Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands);
Event* event_new (void);
Event* event_construct (GType object_type);
Event* event_generic_error (const gchar* cause);
Event* event_network_error (void);
Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails);
gboolean event_is_error_event (Event* self);
static void event_finalize (Event* obj);
#define SMD_LOOP "/bin/smd-loop"
#define SMD_PUSH "/bin/smd-push"
#define SMD_APPLET_UI "/share/syncmaildir-applet/smd-applet.ui"
#define SMD_APPLET_DESKTOP "/share/applications/smd-applet.desktop"
#define GNOME_AUTOSTART_DISABLED "X-GNOME-Autostart-enabled=false"
GType smd_applet_get_type (void) G_GNUC_CONST;
#define SMD_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SMD_APPLET, smdAppletPrivate))
enum  {
	SMD_APPLET_DUMMY_PROPERTY
};
#define SMD_APPLET_key_newmail "notify-new-mail"
smdApplet* smd_applet_new (GError** error);
smdApplet* smd_applet_construct (GType object_type, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (smdApplet* self, guint s);
static void ____lambda4__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self);
static void smd_applet_update_logcontents (smdApplet* self);
static void __lambda5_ (Block1Data* _data1_);
static void ___lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda6_ (Block1Data* _data1_);
static void ___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void smd_applet_close_err_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (smdApplet* self, GtkButton* b);
static gboolean smd_applet_is_smd_loop_configured (smdApplet* self);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda9_ (smdApplet* self, GtkButton* b);
static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda10_ (smdApplet* self);
static void smd_applet_unpause (smdApplet* self);
static void smd_applet_pause (smdApplet* self);
static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void smd_applet_update_loglist (smdApplet* self);
static gboolean __lambda11_ (smdApplet* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static void __lambda12_ (smdApplet* self, GtkStatusIcon* s);
static void ___lambda12__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void __lambda13_ (smdApplet* self);
static void ___lambda13__g_application_activate (GApplication* _sender, gpointer self);
static void __lambda14_ (smdApplet* self);
static void ___lambda14__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void* smd_applet_smdThread (smdApplet* self);
static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error);
static void smd_applet_start_smdThread (smdApplet* self, gboolean force);
static gpointer _smd_applet_smdThread_gthread_func (gpointer self);
static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error);
static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s);
static void ___lambda7_ (smdApplet* self);
static void ____lambda7__gspawn_child_setup_func (gpointer self);
static gboolean smd_applet_eat_event (smdApplet* self);
static void ______lambda15_ (smdApplet* self, NotifyNotification* not, const gchar* action);
static void _______lambda15__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void ______lambda16_ (smdApplet* self, GtkButton* b);
static void _______lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force);
static gboolean smd_applet_close_err_event (smdApplet* self, GdkEventAny* e);
static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEventAny* e);
static void smd_applet_close_prefs (smdApplet* self);
static gboolean smd_applet_is_smd_stack_configured (smdApplet* self);
void smd_applet_start (smdApplet* self, GError** error);
static gboolean _smd_applet_eat_event_gsource_func (gpointer self);
static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void ___lambda17_ (smdApplet* self, NotifyNotification* n, const gchar* a);
static void ____lambda17__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void smd_applet_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const GDBusMethodInfo * const _network_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _network_manager_dbus_arg_info_state_changed_state = {-1, "state", "u"};
static const GDBusArgInfo * const _network_manager_dbus_arg_info_state_changed[] = {&_network_manager_dbus_arg_info_state_changed_state, NULL};
static const GDBusSignalInfo _network_manager_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_network_manager_dbus_arg_info_state_changed)};
static const GDBusSignalInfo * const _network_manager_dbus_signal_info[] = {&_network_manager_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _network_manager_dbus_property_info_state = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _network_manager_dbus_property_info[] = {&_network_manager_dbus_property_info_state, NULL};
static const GDBusInterfaceInfo _network_manager_dbus_interface_info = {-1, "org.freedesktop.NetworkManager", (GDBusMethodInfo **) (&_network_manager_dbus_method_info), (GDBusSignalInfo **) (&_network_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_network_manager_dbus_property_info)};
static const GDBusInterfaceVTable _network_manager_dbus_interface_vtable = {network_manager_dbus_interface_method_call, network_manager_dbus_interface_get_property, network_manager_dbus_interface_set_property};

GQuark exit_quark (void) {
	return g_quark_from_static_string ("exit-quark");
}


void debug (const gchar* message) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (message != NULL);
	_tmp0_ = verbose;
	if (_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = message;
		fprintf (_tmp1_, "DEBUG: %s\n", _tmp2_);
	}
}


guint network_manager_get_state (NetworkManager* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return NETWORK_MANAGER_GET_INTERFACE (self)->get_state (self);
}


static void network_manager_base_init (NetworkManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("state_changed", TYPE_NETWORK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType network_manager_get_type (void) {
	static volatile gsize network_manager_type_id__volatile = 0;
	if (g_once_init_enter (&network_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetworkManagerIface), (GBaseInitFunc) network_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType network_manager_type_id;
		network_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetworkManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (network_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) network_manager_proxy_get_type);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.NetworkManager");
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_network_manager_dbus_interface_info));
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) network_manager_register_object);
		g_once_init_leave (&network_manager_type_id__volatile, network_manager_type_id);
	}
	return network_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (NetworkManagerProxy, network_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NETWORK_MANAGER, network_manager_proxy_network_manager_interface_init) )
static void network_manager_proxy_class_init (NetworkManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = network_manager_proxy_g_signal;
}


static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint state = 0U;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "state-changed", state);
}


static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_network_manager_state_changed ((NetworkManager*) proxy, parameters);
	}
}


static void network_manager_proxy_init (NetworkManagerProxy* self) {
}


static guint network_manager_dbus_proxy_get_state (NetworkManager* self) {
	GVariant *_inner_reply;
	guint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.NetworkManager"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface) {
	iface->get_state = network_manager_dbus_proxy_get_state;
}


static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_network_manager_get_state (NetworkManager* self) {
	guint result;
	GVariant* _reply;
	result = network_manager_get_state (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_network_manager_get_state (object);
	}
	return NULL;
}


static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.NetworkManager", "StateChanged", _arguments, NULL);
}


guint network_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_network_manager_dbus_interface_info), &_network_manager_dbus_interface_vtable, data, _network_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_network_manager_state_changed, data);
	return result;
}


static void _network_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_network_manager_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gboolean is_nm_connected (guint code) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	_tmp1_ = code;
	if (_tmp1_ == ((guint) 3)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_ = 0U;
		_tmp2_ = code;
		_tmp0_ = _tmp2_ == ((guint) 70);
	}
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands) {
	Event* result = NULL;
	Event* e = NULL;
	Event* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (cause != NULL, NULL);
	g_return_val_if_fail (commands != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("An error occurred, click on the icon for more details");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("error");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_error_mode = TRUE;
	_tmp3_ = cause;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (e->cause);
	e->cause = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (e->context);
	e->context = _tmp6_;
	_tmp7_ = permissions;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (e->permissions);
	e->permissions = _tmp8_;
	_tmp9_ = mail_name;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (e->mail_name);
	e->mail_name = _tmp10_;
	_tmp11_ = mail_body;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (e->mail_body);
	e->mail_body = _tmp12_;
	_tmp13_ = commands;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (e->commands);
	e->commands = _tmp14_;
	result = e;
	return result;
}


Event* event_generic_error (const gchar* cause) {
	Event* result = NULL;
	Event* e = NULL;
	Event* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (cause != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = cause;
	_tmp2_ = g_strconcat ("A failure occurred: ", _tmp1_, NULL);
	_g_free0 (e->message);
	e->message = _tmp2_;
	_tmp3_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp3_;
	e->transient_error_message = TRUE;
	result = e;
	return result;
}


Event* event_network_error (void) {
	Event* result = NULL;
	Event* e = NULL;
	Event* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("A persistent network failure occurred");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_network_error_mode = TRUE;
	result = e;
	return result;
}


Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails) {
	Event* result = NULL;
	gchar* preamble = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Event* e = NULL;
	Event* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = g_strdup_printf ("Synchronize with %s:\n", _tmp0_);
	preamble = _tmp1_;
	_tmp2_ = event_new ();
	e = _tmp2_;
	_tmp4_ = new_mails;
	if (_tmp4_ > 0) {
		gint _tmp5_ = 0;
		_tmp5_ = del_mails;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Event* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		_tmp6_ = e;
		_tmp7_ = preamble;
		_tmp8_ = new_mails;
		_tmp9_ = del_mails;
		_tmp10_ = g_strdup_printf ("%s%d new messages\n%d deleted messages", _tmp7_, _tmp8_, _tmp9_);
		_g_free0 (_tmp6_->message);
		_tmp6_->message = _tmp10_;
	} else {
		gint _tmp11_ = 0;
		_tmp11_ = new_mails;
		if (_tmp11_ > 0) {
			Event* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gchar* _tmp15_ = NULL;
			_tmp12_ = e;
			_tmp13_ = preamble;
			_tmp14_ = new_mails;
			_tmp15_ = g_strdup_printf ("%s%d new messages", _tmp13_, _tmp14_);
			_g_free0 (_tmp12_->message);
			_tmp12_->message = _tmp15_;
		} else {
			Event* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			_tmp16_ = e;
			_tmp17_ = preamble;
			_tmp18_ = del_mails;
			_tmp19_ = g_strdup_printf ("%s%d deleted messages", _tmp17_, _tmp18_);
			_g_free0 (_tmp16_->message);
			_tmp16_->message = _tmp19_;
		}
	}
	result = e;
	_g_free0 (preamble);
	return result;
}


gboolean event_is_error_event (Event* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->enter_error_mode;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->enter_network_error_mode;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->transient_error_message;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


Event* event_construct (GType object_type) {
	Event* self = NULL;
	self = (Event*) g_type_create_instance (object_type);
	return self;
}


Event* event_new (void) {
	return event_construct (TYPE_EVENT);
}


static void value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		event_unref (value->data[0].v_pointer);
	}
}


static void value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Event* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Event** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


void value_take_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


static void event_class_init (EventClass * klass) {
	event_parent_class = g_type_class_peek_parent (klass);
	((EventClass *) klass)->finalize = event_finalize;
}


static void event_instance_init (Event * self) {
	gchar* _tmp0_ = NULL;
	self->message = NULL;
	_tmp0_ = g_strdup ("gtk-about");
	self->message_icon = _tmp0_;
	self->enter_network_error_mode = FALSE;
	self->enter_error_mode = FALSE;
	self->transient_error_message = FALSE;
	self->context = NULL;
	self->cause = NULL;
	self->permissions = NULL;
	self->mail_name = NULL;
	self->mail_body = NULL;
	self->commands = NULL;
	self->ref_count = 1;
}


static void event_finalize (Event* obj) {
	Event * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT, Event);
	g_signal_handlers_destroy (self);
	_g_free0 (self->message);
	_g_free0 (self->message_icon);
	_g_free0 (self->context);
	_g_free0 (self->cause);
	_g_free0 (self->permissions);
	_g_free0 (self->mail_name);
	_g_free0 (self->mail_body);
	_g_object_unref0 (self->commands);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_event_init, value_event_free_value, value_event_copy_value, value_event_peek_pointer, "p", value_event_collect_value, "p", value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Event), 0, (GInstanceInitFunc) event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType event_type_id;
		event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Event", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


gpointer event_ref (gpointer instance) {
	Event* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void event_unref (gpointer instance) {
	Event* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		smdApplet* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->bautostart);
		_g_object_unref0 (_data1_->bnotify);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (smdApplet* self, guint s) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = s;
	_tmp1_ = is_nm_connected (_tmp0_);
	if (_tmp1_) {
		GtkSwitch* _tmp2_ = NULL;
		_tmp2_ = self->priv->sync_active;
		gtk_switch_set_active (_tmp2_, TRUE);
	} else {
		GtkSwitch* _tmp3_ = NULL;
		_tmp3_ = self->priv->sync_active;
		gtk_switch_set_active (_tmp3_, FALSE);
	}
}


static void ____lambda4__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self) {
	___lambda4_ ((smdApplet*) self, state);
}


static void __lambda5_ (Block1Data* _data1_) {
	smdApplet* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = gtk_switch_get_active (_data1_->bnotify);
	_tmp2_ = _tmp1_;
	g_settings_set_boolean (_tmp0_, SMD_APPLET_key_newmail, _tmp2_);
}


static void ___lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda5_ (self);
}


static void __lambda6_ (Block1Data* _data1_) {
	smdApplet* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = gtk_switch_get_active (_data1_->bautostart);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* content = NULL;
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp2_ = smd_applet_smd_applet_desktop;
			g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error_);
			_g_free0 (content);
			content = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_free0 (content);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp4_ = XDG_AUTORUN_FILE;
			_tmp5_ = content;
			g_file_set_contents (_tmp4_, _tmp5_, (gssize) -1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_free0 (content);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally5;
		__catch5_g_file_error:
		{
			GError* e = NULL;
			FILE* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = stderr;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			fprintf (_tmp6_, "%s\n", _tmp8_);
			_g_error_free0 (e);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (content);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
	} else {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = XDG_AUTORUN_FILE;
		g_remove (_tmp9_);
	}
}


static void ___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda6_ (self);
}


static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_err_action ((smdApplet*) self, _sender);
}


static void __lambda8_ (smdApplet* self, GtkButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_ = FALSE;
		gchar* cmd = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp0_ = smd_applet_is_smd_loop_configured (self);
		if (!_tmp0_) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp1_ = smd_applet_smd_loop_cmd;
			_tmp2_ = g_strdup_printf ("%s -t", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp3_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch6_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = SMD_LOOP_CFG;
		_tmp5_ = g_strdup_printf ("gnome-open %s", _tmp4_);
		cmd = _tmp5_;
		_tmp6_ = cmd;
		g_spawn_command_line_async (_tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_loop_configured (self);
		_g_free0 (cmd);
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda8_ ((smdApplet*) self, _sender);
}


static void __lambda9_ (smdApplet* self, GtkButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_ = FALSE;
		gchar* cmd = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp0_ = smd_applet_is_smd_pushpull_configured (self);
		if (!_tmp0_) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp1_ = smd_applet_smd_push_cmd;
			_tmp2_ = g_strdup_printf ("%s -t", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp3_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch7_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = SMD_PP_DEF_CFG;
		_tmp5_ = g_strdup_printf ("gnome-open %s", _tmp4_);
		cmd = _tmp5_;
		_tmp6_ = cmd;
		g_spawn_command_line_async (_tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_pushpull_configured (self);
		_g_free0 (cmd);
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda9_ ((smdApplet*) self, _sender);
}


static void __lambda10_ (smdApplet* self) {
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = self->priv->sync_active;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	if (_tmp1_) {
		smd_applet_unpause (self);
	} else {
		smd_applet_pause (self);
	}
}


static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda10_ ((smdApplet*) self);
}


static gboolean __lambda11_ (smdApplet* self) {
	gboolean result = FALSE;
	GtkWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->win;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		smd_applet_update_loglist (self);
		smd_applet_update_logcontents (self);
	}
	result = TRUE;
	return result;
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ ((smdApplet*) self);
	return result;
}


static void __lambda12_ (smdApplet* self, GtkStatusIcon* s) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->error_mode;
	if (_tmp0_) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->err_win;
		gtk_window_reshow_with_initial_size (_tmp1_);
	} else {
		GtkWindow* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->win;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->config_wait_mode;
		if (_tmp3_) {
			GtkNotebook* _tmp4_ = NULL;
			_tmp4_ = self->priv->notebook;
			g_object_set (_tmp4_, "page", 1, NULL);
		} else {
			GtkNotebook* _tmp5_ = NULL;
			_tmp5_ = self->priv->notebook;
			g_object_set (_tmp5_, "page", 0, NULL);
		}
	}
}


static void ___lambda12__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	__lambda12_ ((smdApplet*) self, _sender);
}


static void __lambda13_ (smdApplet* self) {
}


static void ___lambda13__g_application_activate (GApplication* _sender, gpointer self) {
	__lambda13_ ((smdApplet*) self);
}


static void __lambda14_ (smdApplet* self) {
	GPid _tmp0_ = 0;
	self->priv->thread_die = TRUE;
	_tmp0_ = self->priv->pid;
	if (((gint) _tmp0_) != 0) {
		GPid _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GPid _tmp4_ = 0;
		_tmp1_ = self->priv->pid;
		_tmp2_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) _tmp1_));
		_tmp3_ = _tmp2_;
		debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp4_)), SIGTERM);
	}
	g_application_quit ((GApplication*) self);
}


static void ___lambda14__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda14_ ((smdApplet*) self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


smdApplet* smd_applet_construct (GType object_type, GError** error) {
	smdApplet * self = NULL;
	Block1Data* _data1_;
	GtkBuilder* _tmp3_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	GtkWindow* simple_mainwin = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkWindow* _tmp30_ = NULL;
	GtkApplicationWindow* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkWindow* _tmp33_ = NULL;
	gint w = 0;
	gint h = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	GtkWindow* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	GtkWindow* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkBuilder* _tmp41_ = NULL;
	GObject* _tmp42_ = NULL;
	GtkWindow* _tmp43_ = NULL;
	GtkLabel* lcopyright = NULL;
	GtkBuilder* _tmp44_ = NULL;
	GObject* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkGrid* logs_vb = NULL;
	GtkBuilder* _tmp47_ = NULL;
	GObject* _tmp48_ = NULL;
	GtkGrid* _tmp49_ = NULL;
	GtkComboBoxText* _tmp50_ = NULL;
	GeeArrayList* _tmp51_ = NULL;
	GtkComboBoxText* _tmp52_ = NULL;
	GtkComboBoxText* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkSwitch* _tmp56_ = NULL;
	GSettings* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	GtkBuilder* _tmp59_ = NULL;
	GObject* _tmp60_ = NULL;
	GtkSwitch* _tmp61_ = NULL;
	GtkButton* bc = NULL;
	GtkBuilder* _tmp70_ = NULL;
	GObject* _tmp71_ = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkButton* _tmp73_ = NULL;
	GtkButton* bel = NULL;
	GtkBuilder* _tmp74_ = NULL;
	GObject* _tmp75_ = NULL;
	GtkButton* _tmp76_ = NULL;
	GtkButton* _tmp77_ = NULL;
	GtkButton* bepp = NULL;
	GtkBuilder* _tmp78_ = NULL;
	GObject* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	GtkButton* _tmp81_ = NULL;
	GtkBuilder* _tmp82_ = NULL;
	GObject* _tmp83_ = NULL;
	GtkSwitch* _tmp84_ = NULL;
	GtkSwitch* _tmp85_ = NULL;
	GtkBuilder* _tmp86_ = NULL;
	GObject* _tmp87_ = NULL;
	GtkNotebook* _tmp88_ = NULL;
	GtkStatusIcon* _tmp89_ = NULL;
	GtkStatusIcon* _tmp90_ = NULL;
	GtkStatusIcon* _tmp91_ = NULL;
	GtkStatusIcon* _tmp92_ = NULL;
	GtkWindow* _tmp93_ = NULL;
	GSimpleAction* quit = NULL;
	GSimpleAction* _tmp94_ = NULL;
	GMenuModel* menu = NULL;
	GtkBuilder* _tmp95_ = NULL;
	GObject* _tmp96_ = NULL;
	GMenuModel* _tmp97_ = NULL;
	GMenuModel* _tmp98_ = NULL;
	GSimpleAction* _tmp99_ = NULL;
	GSimpleAction* _tmp100_ = NULL;
	GList* l = NULL;
	GList* _tmp101_ = NULL;
	GList* _tmp102_ = NULL;
	gint _tmp103_ = 0;
	GHashFunc _tmp104_ = NULL;
	GEqualFunc _tmp105_ = NULL;
	GHashTable* _tmp106_ = NULL;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (smdApplet*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	g_application_set_application_id ((GApplication*) self, "org.syncmaildir");
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "%s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp3_;
	{
		GtkBuilder* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->builder;
		_tmp5_ = smd_applet_smd_applet_ui;
		gtk_builder_add_from_file (_tmp4_, _tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_tmp9_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the ui file");
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GtkBuilder* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp10_ = self->priv->builder;
		_tmp11_ = smd_applet_menu_ui;
		_tmp12_ = smd_applet_menu_ui;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_builder_add_from_string (_tmp10_, _tmp11_, (gsize) _tmp14_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		fprintf (_tmp15_, "%s\n", _tmp17_);
		_tmp18_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the menu ui string");
		_inner_error_ = _tmp18_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) event_ref, event_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp19_;
	_tmp20_ = g_settings_new ("org.syncmaildir.applet");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp20_;
	{
		NetworkManager* _tmp21_ = NULL;
		NetworkManager* _tmp22_ = NULL;
		NetworkManager* _tmp23_ = NULL;
		NetworkManager* _tmp24_ = NULL;
		_tmp22_ = g_initable_new (TYPE_NETWORK_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", NM_SERVICE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", NM_PATH, "g-interface-name", "org.freedesktop.NetworkManager", "g-interface-info", g_type_get_qdata (TYPE_NETWORK_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp21_ = (NetworkManager*) _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp23_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = _tmp23_;
		_tmp24_ = self->priv->net_manager;
		g_signal_connect_object (_tmp24_, "state-changed", (GCallback) ____lambda4__network_manager_state_changed, self, 0);
		_g_object_unref0 (_tmp21_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = stderr;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		fprintf (_tmp25_, "%s\n", _tmp27_);
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = self->priv->builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "wMain");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp29_) : NULL);
	simple_mainwin = _tmp30_;
	_tmp31_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->win);
	self->priv->win = (GtkWindow*) _tmp31_;
	_tmp32_ = gtk_bin_get_child ((GtkBin*) simple_mainwin);
	_tmp33_ = self->priv->win;
	gtk_widget_reparent (_tmp32_, (GtkWidget*) _tmp33_);
	w = 0;
	h = 0;
	gtk_widget_get_size_request ((GtkWidget*) simple_mainwin, &_tmp34_, &_tmp35_);
	w = _tmp34_;
	h = _tmp35_;
	_tmp36_ = self->priv->win;
	_tmp37_ = w;
	_tmp38_ = h;
	gtk_widget_set_size_request ((GtkWidget*) _tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = self->priv->win;
	_tmp40_ = gtk_window_get_title (simple_mainwin);
	gtk_window_set_title (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->builder;
	_tmp42_ = gtk_builder_get_object (_tmp41_, "wError");
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp42_) : NULL);
	_g_object_unref0 (self->priv->err_win);
	self->priv->err_win = _tmp43_;
	_tmp44_ = self->priv->builder;
	_tmp45_ = gtk_builder_get_object (_tmp44_, "lCopyright");
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp45_) : NULL);
	lcopyright = _tmp46_;
	gtk_label_set_text (lcopyright, "Copyright " SMD_CONF_COPYRIGHT);
	_tmp47_ = self->priv->builder;
	_tmp48_ = gtk_builder_get_object (_tmp47_, "vbLog");
	_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp48_) : NULL);
	logs_vb = _tmp49_;
	_tmp50_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->cblogs);
	self->priv->cblogs = _tmp50_;
	_tmp51_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->lognames);
	self->priv->lognames = _tmp51_;
	_tmp52_ = self->priv->cblogs;
	gtk_grid_attach (logs_vb, (GtkWidget*) _tmp52_, 0, 0, 1, 1);
	_tmp53_ = self->priv->cblogs;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	smd_applet_update_logcontents (self);
	_tmp54_ = self->priv->builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "sNotify");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, gtk_switch_get_type ()) ? ((GtkSwitch*) _tmp55_) : NULL);
	_data1_->bnotify = _tmp56_;
	_tmp57_ = self->priv->settings;
	_tmp58_ = g_settings_get_boolean (_tmp57_, SMD_APPLET_key_newmail);
	gtk_switch_set_active (_data1_->bnotify, _tmp58_);
	g_signal_connect_data ((GObject*) _data1_->bnotify, "notify::active", (GCallback) ___lambda5__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp59_ = self->priv->builder;
	_tmp60_ = gtk_builder_get_object (_tmp59_, "sAutostart");
	_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, gtk_switch_get_type ()) ? ((GtkSwitch*) _tmp60_) : NULL);
	_data1_->bautostart = _tmp61_;
	{
		gchar* content = NULL;
		gboolean _tmp62_ = FALSE;
		const gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gboolean _tmp65_ = FALSE;
		_tmp63_ = XDG_AUTORUN_FILE;
		_tmp65_ = g_file_get_contents (_tmp63_, &_tmp64_, NULL, &_inner_error_);
		_g_free0 (content);
		content = _tmp64_;
		_tmp62_ = _tmp65_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (content);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (content);
			_g_object_unref0 (logs_vb);
			_g_object_unref0 (lcopyright);
			_g_object_unref0 (simple_mainwin);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (_tmp62_) {
			gboolean _tmp66_ = FALSE;
			_tmp66_ = g_regex_match_simple (GNOME_AUTOSTART_DISABLED, content, 0, 0);
			if (_tmp66_) {
				gtk_switch_set_active (_data1_->bautostart, FALSE);
			} else {
				gtk_switch_set_active (_data1_->bautostart, TRUE);
			}
		} else {
			gtk_switch_set_active (_data1_->bautostart, FALSE);
		}
		_g_free0 (content);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp67_ = NULL;
		GError* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp67_ = stderr;
		_tmp68_ = e;
		_tmp69_ = _tmp68_->message;
		fprintf (_tmp67_, "%s\n", _tmp69_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (logs_vb);
			_g_object_unref0 (lcopyright);
			_g_object_unref0 (simple_mainwin);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (logs_vb);
			_g_object_unref0 (lcopyright);
			_g_object_unref0 (simple_mainwin);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect_data ((GObject*) _data1_->bautostart, "notify::active", (GCallback) ___lambda6__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp70_ = self->priv->builder;
	_tmp71_ = gtk_builder_get_object (_tmp70_, "bClose");
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, gtk_button_get_type ()) ? ((GtkButton*) _tmp71_) : NULL);
	bc = _tmp72_;
	_tmp73_ = bc;
	g_signal_connect_object (_tmp73_, "clicked", (GCallback) _smd_applet_close_err_action_gtk_button_clicked, self, 0);
	_tmp74_ = self->priv->builder;
	_tmp75_ = gtk_builder_get_object (_tmp74_, "bEditLoopCfg");
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, gtk_button_get_type ()) ? ((GtkButton*) _tmp75_) : NULL);
	bel = _tmp76_;
	_tmp77_ = bel;
	g_signal_connect_object (_tmp77_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, self, 0);
	_tmp78_ = self->priv->builder;
	_tmp79_ = gtk_builder_get_object (_tmp78_, "bEditPushPullCfg");
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, gtk_button_get_type ()) ? ((GtkButton*) _tmp79_) : NULL);
	bepp = _tmp80_;
	_tmp81_ = bepp;
	g_signal_connect_object (_tmp81_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, self, 0);
	_tmp82_ = self->priv->builder;
	_tmp83_ = gtk_builder_get_object (_tmp82_, "sSyncActive");
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, gtk_switch_get_type ()) ? ((GtkSwitch*) _tmp83_) : NULL);
	_g_object_unref0 (self->priv->sync_active);
	self->priv->sync_active = _tmp84_;
	_tmp85_ = self->priv->sync_active;
	g_signal_connect_object ((GObject*) _tmp85_, "notify::active", (GCallback) ___lambda10__g_object_notify, self, 0);
	_tmp86_ = self->priv->builder;
	_tmp87_ = gtk_builder_get_object (_tmp86_, "nMain");
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp87_) : NULL);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp88_;
	smd_applet_update_loglist (self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	_tmp89_ = gtk_status_icon_new_from_icon_name ("mail-send-receive");
	_g_object_unref0 (self->priv->si);
	self->priv->si = _tmp89_;
	_tmp90_ = self->priv->si;
	gtk_status_icon_set_visible (_tmp90_, TRUE);
	_tmp91_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp91_, "smd-applet is running");
	_tmp92_ = self->priv->si;
	g_signal_connect_object (_tmp92_, "activate", (GCallback) ___lambda12__gtk_status_icon_activate, self, 0);
	_tmp93_ = self->priv->win;
	gtk_application_add_window ((GtkApplication*) self, _tmp93_);
	g_signal_connect_object ((GApplication*) self, "activate", (GCallback) ___lambda13__g_application_activate, self, 0);
	_tmp94_ = g_simple_action_new ("quit", NULL);
	quit = _tmp94_;
	_tmp95_ = self->priv->builder;
	_tmp96_ = gtk_builder_get_object (_tmp95_, "app-menu");
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp96_) : NULL);
	menu = _tmp97_;
	_tmp98_ = menu;
	gtk_application_set_app_menu ((GtkApplication*) self, _tmp98_);
	_tmp99_ = quit;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp99_);
	_tmp100_ = quit;
	g_signal_connect_object (_tmp100_, "activate", (GCallback) ___lambda14__g_simple_action_activate, self, 0);
	_tmp101_ = notify_get_server_caps ();
	l = _tmp101_;
	_tmp102_ = l;
	_tmp103_ = g_list_index (_tmp102_, "persistence");
	self->priv->notification_server_has_persistence = 0 <= _tmp103_;
	_tmp104_ = g_direct_hash;
	_tmp105_ = g_str_equal;
	_tmp106_ = g_hash_table_new_full (_tmp104_, _tmp105_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->command_hash);
	self->priv->command_hash = _tmp106_;
	__g_list_free__g_free0_0 (l);
	_g_object_unref0 (menu);
	_g_object_unref0 (quit);
	_g_object_unref0 (bepp);
	_g_object_unref0 (bel);
	_g_object_unref0 (bc);
	_g_object_unref0 (logs_vb);
	_g_object_unref0 (lcopyright);
	_g_object_unref0 (simple_mainwin);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


smdApplet* smd_applet_new (GError** error) {
	return smd_applet_construct (TYPE_SMD_APPLET, error);
}


static void* smd_applet_smdThread (smdApplet* self) {
	void* result = NULL;
	gboolean rc = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rc = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		_tmp1_ = rc;
		if (_tmp1_) {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->thread_die;
			_tmp0_ = !_tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		debug ("(re)starting smd-loop");
		{
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			_tmp4_ = smd_applet_run_smd_loop (self, &_inner_error_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == EXIT) {
					goto __catch8_exit;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			rc = _tmp3_;
		}
		goto __finally8;
		__catch8_exit:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			rc = FALSE;
			_g_error_free0 (e);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	return result;
}


static gpointer _smd_applet_smdThread_gthread_func (gpointer self) {
	gpointer result;
	result = smd_applet_smdThread ((smdApplet*) self);
	g_object_unref (self);
	return result;
}


static void smd_applet_start_smdThread (smdApplet* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = force;
	if (!_tmp2_) {
		NetworkManager* _tmp3_ = NULL;
		_tmp3_ = self->priv->net_manager;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		NetworkManager* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->net_manager;
		_tmp5_ = network_manager_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = is_nm_connected (_tmp6_);
		_tmp0_ = !_tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSwitch* _tmp8_ = NULL;
		GtkStatusIcon* _tmp9_ = NULL;
		_tmp8_ = self->priv->sync_active;
		gtk_switch_set_active (_tmp8_, FALSE);
		_tmp9_ = self->priv->si;
		gtk_status_icon_set_from_stock (_tmp9_, "gtk-media-pause");
	} else {
		GThread* _tmp10_ = NULL;
		_tmp10_ = g_thread_new (NULL, _smd_applet_smdThread_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp10_;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error) {
	gboolean result = FALSE;
	GRegex* context = NULL;
	GRegex* _tmp0_ = NULL;
	GRegex* cause = NULL;
	GRegex* _tmp1_ = NULL;
	GRegex* human = NULL;
	GRegex* _tmp2_ = NULL;
	GRegex* actions = NULL;
	GRegex* _tmp3_ = NULL;
	GMatchInfo* i_ctx = NULL;
	GMatchInfo* i_cause = NULL;
	GMatchInfo* i_human = NULL;
	GMatchInfo* i_act = NULL;
	GRegex* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GRegex* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GMatchInfo* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GRegex* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GMatchInfo* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean has_actions = FALSE;
	GRegex* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GMatchInfo* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GMatchInfo* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GMatchInfo* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	gchar* permissions = NULL;
	gchar* mail_name = NULL;
	gchar* mail_body = NULL;
	GeeArrayList* commands = NULL;
	void* _tmp55_ = NULL;
	GDestroyNotify _tmp56_ = NULL;
	GeeEqualDataFunc _tmp57_ = NULL;
	GeeArrayList* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	GeeArrayList* _tmp130_ = NULL;
	GeeArrayList* _tmp131_ = NULL;
	gint _tmp132_ = 0;
	gint _tmp133_ = 0;
	const gchar* _tmp134_ = NULL;
	const gchar* _tmp135_ = NULL;
	GMatchInfo* _tmp136_ = NULL;
	gchar* _tmp137_ = NULL;
	gchar* _tmp138_ = NULL;
	GMatchInfo* _tmp139_ = NULL;
	gchar* _tmp140_ = NULL;
	gchar* _tmp141_ = NULL;
	const gchar* _tmp142_ = NULL;
	const gchar* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	GeeArrayList* _tmp145_ = NULL;
	Event* _tmp146_ = NULL;
	Event* _tmp147_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_tmp0_ = g_regex_new ("context\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	context = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp1_ = g_regex_new ("probable-cause\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	cause = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = g_regex_new ("human-intervention\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	human = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp3_ = g_regex_new ("suggested-actions\\((.*)\\) *$", 0, 0, &_inner_error_);
	actions = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	i_ctx = NULL;
	i_cause = NULL;
	i_human = NULL;
	i_act = NULL;
	_tmp4_ = context;
	_tmp5_ = args;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_unref0 (i_ctx);
	i_ctx = _tmp6_;
	if (!_tmp7_) {
		FILE* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = args;
		fprintf (_tmp8_, "smd-loop error with no context: %s\n", _tmp9_);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp10_ = cause;
	_tmp11_ = args;
	_tmp13_ = g_regex_match (_tmp10_, _tmp11_, 0, &_tmp12_);
	_g_match_info_unref0 (i_cause);
	i_cause = _tmp12_;
	if (!_tmp13_) {
		FILE* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = args;
		fprintf (_tmp14_, "smd-loop error with no cause: %s\n", _tmp15_);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp16_ = human;
	_tmp17_ = args;
	_tmp19_ = g_regex_match (_tmp16_, _tmp17_, 0, &_tmp18_);
	_g_match_info_unref0 (i_human);
	i_human = _tmp18_;
	if (!_tmp19_) {
		FILE* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp20_ = stderr;
		_tmp21_ = args;
		fprintf (_tmp20_, "smd-loop error with no human: %s\n", _tmp21_);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp22_ = actions;
	_tmp23_ = args;
	_tmp25_ = g_regex_match (_tmp22_, _tmp23_, 0, &_tmp24_);
	_g_match_info_unref0 (i_act);
	i_act = _tmp24_;
	has_actions = _tmp25_;
	_tmp27_ = i_human;
	_tmp28_ = g_match_info_fetch (_tmp27_, 1);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strcmp0 (_tmp29_, "necessary") != 0;
	_g_free0 (_tmp29_);
	if (_tmp30_) {
		GMatchInfo* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp31_ = i_cause;
		_tmp32_ = g_match_info_fetch (_tmp31_, 1);
		_tmp33_ = _tmp32_;
		_tmp26_ = g_strcmp0 (_tmp33_, "network") == 0;
		_g_free0 (_tmp33_);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GeeArrayList* _tmp34_ = NULL;
		GeeArrayList* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		Event* _tmp38_ = NULL;
		Event* _tmp39_ = NULL;
		g_mutex_lock (&self->priv->events_lock);
		_tmp34_ = self->priv->events;
		_tmp35_ = self->priv->events;
		_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = event_network_error ();
		_tmp39_ = _tmp38_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp34_, _tmp37_, _tmp39_);
		_event_unref0 (_tmp39_);
		g_mutex_unlock (&self->priv->events_lock);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp40_ = i_human;
	_tmp41_ = g_match_info_fetch (_tmp40_, 1);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_strcmp0 (_tmp42_, "necessary") != 0;
	_g_free0 (_tmp42_);
	if (_tmp43_) {
		FILE* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		GeeArrayList* _tmp46_ = NULL;
		GeeArrayList* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		GMatchInfo* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		Event* _tmp53_ = NULL;
		Event* _tmp54_ = NULL;
		_tmp44_ = stderr;
		_tmp45_ = args;
		fprintf (_tmp44_, "smd-loop giving an avoidable error: %s\n", _tmp45_);
		g_mutex_lock (&self->priv->events_lock);
		_tmp46_ = self->priv->events;
		_tmp47_ = self->priv->events;
		_tmp48_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = i_cause;
		_tmp51_ = g_match_info_fetch (_tmp50_, 1);
		_tmp52_ = _tmp51_;
		_tmp53_ = event_generic_error (_tmp52_);
		_tmp54_ = _tmp53_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp46_, _tmp49_, _tmp54_);
		_event_unref0 (_tmp54_);
		_g_free0 (_tmp52_);
		g_mutex_unlock (&self->priv->events_lock);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	permissions = NULL;
	mail_name = NULL;
	mail_body = NULL;
	_tmp57_ = gee_functions_get_equal_func_for (G_TYPE_STRING, &_tmp55_, &_tmp56_);
	_tmp58_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp57_, _tmp55_, _tmp56_);
	commands = _tmp58_;
	_tmp59_ = has_actions;
	if (_tmp59_) {
		gchar* acts = NULL;
		GMatchInfo* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		GRegex* r_perm = NULL;
		GRegex* _tmp62_ = NULL;
		GRegex* r_mail = NULL;
		GRegex* _tmp63_ = NULL;
		GRegex* r_cmd = NULL;
		GRegex* _tmp64_ = NULL;
		gint from = 0;
		_tmp60_ = i_act;
		_tmp61_ = g_match_info_fetch (_tmp60_, 1);
		acts = _tmp61_;
		_tmp62_ = g_regex_new ("display-permissions\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_perm = _tmp62_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp63_ = g_regex_new ("display-mail\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_mail = _tmp63_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp64_ = g_regex_new ("run\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_cmd = _tmp64_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		from = 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				gboolean _tmp66_ = FALSE;
				const gchar* _tmp67_ = NULL;
				GMatchInfo* i_cmd = NULL;
				GRegex* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				GMatchInfo* _tmp73_ = NULL;
				gboolean _tmp74_ = FALSE;
				const gchar* _tmp127_ = NULL;
				gint _tmp128_ = 0;
				gchar* _tmp129_ = NULL;
				if (!_tmp65_) {
				}
				_tmp65_ = FALSE;
				_tmp67_ = acts;
				if (_tmp67_ != NULL) {
					const gchar* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					_tmp68_ = acts;
					_tmp69_ = strlen (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp66_ = _tmp70_ > 0;
				} else {
					_tmp66_ = FALSE;
				}
				if (!_tmp66_) {
					break;
				}
				i_cmd = NULL;
				_tmp71_ = r_perm;
				_tmp72_ = acts;
				_tmp74_ = g_regex_match (_tmp71_, _tmp72_, 0, &_tmp73_);
				_g_match_info_unref0 (i_cmd);
				i_cmd = _tmp73_;
				if (_tmp74_) {
					GMatchInfo* _tmp75_ = NULL;
					gint _tmp76_ = 0;
					gchar* file = NULL;
					GMatchInfo* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
					gchar* output = NULL;
					gchar* err = NULL;
					_tmp75_ = i_cmd;
					g_match_info_fetch_pos (_tmp75_, 0, NULL, &_tmp76_);
					from = _tmp76_;
					_tmp77_ = i_cmd;
					_tmp78_ = g_match_info_fetch (_tmp77_, 1);
					file = _tmp78_;
					output = NULL;
					err = NULL;
					{
						const gchar* _tmp79_ = NULL;
						gchar* _tmp80_ = NULL;
						gchar* _tmp81_ = NULL;
						gchar* _tmp82_ = NULL;
						gchar* _tmp83_ = NULL;
						const gchar* _tmp84_ = NULL;
						const gchar* _tmp85_ = NULL;
						gchar* _tmp86_ = NULL;
						_tmp79_ = file;
						_tmp80_ = g_strconcat ("ls -ld ", _tmp79_, NULL);
						_tmp81_ = _tmp80_;
						g_spawn_command_line_sync (_tmp81_, &_tmp82_, &_tmp83_, NULL, &_inner_error_);
						_g_free0 (output);
						output = _tmp82_;
						_g_free0 (err);
						err = _tmp83_;
						_g_free0 (_tmp81_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == G_SPAWN_ERROR) {
								goto __catch9_g_spawn_error;
							}
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_unref0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_unref0 (i_act);
							_g_match_info_unref0 (i_human);
							_g_match_info_unref0 (i_cause);
							_g_match_info_unref0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp84_ = output;
						_tmp85_ = err;
						_tmp86_ = g_strconcat (_tmp84_, _tmp85_, NULL);
						_g_free0 (permissions);
						permissions = _tmp86_;
					}
					goto __finally9;
					__catch9_g_spawn_error:
					{
						GError* e = NULL;
						FILE* _tmp87_ = NULL;
						GError* _tmp88_ = NULL;
						const gchar* _tmp89_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp87_ = stderr;
						_tmp88_ = e;
						_tmp89_ = _tmp88_->message;
						fprintf (_tmp87_, "Spawning ls: %s\n", _tmp89_);
						_g_error_free0 (e);
					}
					__finally9:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_unref0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_unref0 (i_act);
							_g_match_info_unref0 (i_human);
							_g_match_info_unref0 (i_cause);
							_g_match_info_unref0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							return FALSE;
						} else {
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_unref0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_unref0 (i_act);
							_g_match_info_unref0 (i_human);
							_g_match_info_unref0 (i_cause);
							_g_match_info_unref0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (err);
					_g_free0 (output);
					_g_free0 (file);
				} else {
					GRegex* _tmp90_ = NULL;
					const gchar* _tmp91_ = NULL;
					GMatchInfo* _tmp92_ = NULL;
					gboolean _tmp93_ = FALSE;
					_tmp90_ = r_mail;
					_tmp91_ = acts;
					_tmp93_ = g_regex_match (_tmp90_, _tmp91_, 0, &_tmp92_);
					_g_match_info_unref0 (i_cmd);
					i_cmd = _tmp92_;
					if (_tmp93_) {
						GMatchInfo* _tmp94_ = NULL;
						gint _tmp95_ = 0;
						gchar* file = NULL;
						GMatchInfo* _tmp96_ = NULL;
						gchar* _tmp97_ = NULL;
						gchar* output = NULL;
						gchar* _tmp98_ = NULL;
						gchar* err = NULL;
						_tmp94_ = i_cmd;
						g_match_info_fetch_pos (_tmp94_, 0, NULL, &_tmp95_);
						from = _tmp95_;
						_tmp96_ = i_cmd;
						_tmp97_ = g_match_info_fetch (_tmp96_, 1);
						file = _tmp97_;
						_tmp98_ = g_strdup ("");
						output = _tmp98_;
						err = NULL;
						{
							const gchar* _tmp99_ = NULL;
							gchar* _tmp100_ = NULL;
							const gchar* _tmp101_ = NULL;
							gchar* _tmp102_ = NULL;
							gchar* _tmp103_ = NULL;
							gchar* _tmp104_ = NULL;
							gchar* _tmp105_ = NULL;
							const gchar* _tmp106_ = NULL;
							const gchar* _tmp107_ = NULL;
							gchar* _tmp108_ = NULL;
							_tmp99_ = file;
							_tmp100_ = g_strdup (_tmp99_);
							_g_free0 (mail_name);
							mail_name = _tmp100_;
							_tmp101_ = file;
							_tmp102_ = g_strconcat ("cat ", _tmp101_, NULL);
							_tmp103_ = _tmp102_;
							g_spawn_command_line_sync (_tmp103_, &_tmp104_, &_tmp105_, NULL, &_inner_error_);
							_g_free0 (output);
							output = _tmp104_;
							_g_free0 (err);
							err = _tmp105_;
							_g_free0 (_tmp103_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == G_SPAWN_ERROR) {
									goto __catch10_g_spawn_error;
								}
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_unref0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_unref0 (i_act);
								_g_match_info_unref0 (i_human);
								_g_match_info_unref0 (i_cause);
								_g_match_info_unref0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
							_tmp106_ = output;
							_tmp107_ = err;
							_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
							_g_free0 (mail_body);
							mail_body = _tmp108_;
						}
						goto __finally10;
						__catch10_g_spawn_error:
						{
							GError* e = NULL;
							FILE* _tmp109_ = NULL;
							GError* _tmp110_ = NULL;
							const gchar* _tmp111_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp109_ = stderr;
							_tmp110_ = e;
							_tmp111_ = _tmp110_->message;
							fprintf (_tmp109_, "Spawning ls: %s\n", _tmp111_);
							_g_error_free0 (e);
						}
						__finally10:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == G_REGEX_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_unref0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_unref0 (i_act);
								_g_match_info_unref0 (i_human);
								_g_match_info_unref0 (i_cause);
								_g_match_info_unref0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								return FALSE;
							} else {
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_unref0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_unref0 (i_act);
								_g_match_info_unref0 (i_human);
								_g_match_info_unref0 (i_cause);
								_g_match_info_unref0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_g_free0 (err);
						_g_free0 (output);
						_g_free0 (file);
					} else {
						GRegex* _tmp112_ = NULL;
						const gchar* _tmp113_ = NULL;
						GMatchInfo* _tmp114_ = NULL;
						gboolean _tmp115_ = FALSE;
						_tmp112_ = r_cmd;
						_tmp113_ = acts;
						_tmp115_ = g_regex_match (_tmp112_, _tmp113_, 0, &_tmp114_);
						_g_match_info_unref0 (i_cmd);
						i_cmd = _tmp114_;
						if (_tmp115_) {
							gchar* command = NULL;
							GMatchInfo* _tmp116_ = NULL;
							gchar* _tmp117_ = NULL;
							GMatchInfo* _tmp118_ = NULL;
							gint _tmp119_ = 0;
							GeeArrayList* _tmp120_ = NULL;
							GeeArrayList* _tmp121_ = NULL;
							gint _tmp122_ = 0;
							gint _tmp123_ = 0;
							const gchar* _tmp124_ = NULL;
							_tmp116_ = i_cmd;
							_tmp117_ = g_match_info_fetch (_tmp116_, 1);
							command = _tmp117_;
							_tmp118_ = i_cmd;
							g_match_info_fetch_pos (_tmp118_, 0, NULL, &_tmp119_);
							from = _tmp119_;
							_tmp120_ = commands;
							_tmp121_ = commands;
							_tmp122_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp121_);
							_tmp123_ = _tmp122_;
							_tmp124_ = command;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp120_, _tmp123_, _tmp124_);
							_g_free0 (command);
						} else {
							FILE* _tmp125_ = NULL;
							const gchar* _tmp126_ = NULL;
							_tmp125_ = stderr;
							_tmp126_ = acts;
							fprintf (_tmp125_, "Unrecognized action: %s\n", _tmp126_);
							_g_match_info_unref0 (i_cmd);
							break;
						}
					}
				}
				_tmp127_ = acts;
				_tmp128_ = from;
				_tmp129_ = string_substring (_tmp127_, (glong) _tmp128_, (glong) -1);
				_g_free0 (acts);
				acts = _tmp129_;
				_g_match_info_unref0 (i_cmd);
			}
		}
		_g_regex_unref0 (r_cmd);
		_g_regex_unref0 (r_mail);
		_g_regex_unref0 (r_perm);
		_g_free0 (acts);
	}
	g_mutex_lock (&self->priv->events_lock);
	_tmp130_ = self->priv->events;
	_tmp131_ = self->priv->events;
	_tmp132_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = account;
	_tmp135_ = host;
	_tmp136_ = i_ctx;
	_tmp137_ = g_match_info_fetch (_tmp136_, 1);
	_tmp138_ = _tmp137_;
	_tmp139_ = i_cause;
	_tmp140_ = g_match_info_fetch (_tmp139_, 1);
	_tmp141_ = _tmp140_;
	_tmp142_ = permissions;
	_tmp143_ = mail_name;
	_tmp144_ = mail_body;
	_tmp145_ = commands;
	_tmp146_ = event_error (_tmp134_, _tmp135_, _tmp138_, _tmp141_, _tmp142_, _tmp143_, _tmp144_, _tmp145_);
	_tmp147_ = _tmp146_;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp130_, _tmp133_, _tmp147_);
	_event_unref0 (_tmp147_);
	_g_free0 (_tmp141_);
	_g_free0 (_tmp138_);
	g_mutex_unlock (&self->priv->events_lock);
	result = FALSE;
	_g_object_unref0 (commands);
	_g_free0 (mail_body);
	_g_free0 (mail_name);
	_g_free0 (permissions);
	_g_match_info_unref0 (i_act);
	_g_match_info_unref0 (i_human);
	_g_match_info_unref0 (i_cause);
	_g_match_info_unref0 (i_ctx);
	_g_regex_unref0 (actions);
	_g_regex_unref0 (human);
	_g_regex_unref0 (cause);
	_g_regex_unref0 (context);
	return result;
}


static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	{
		GMatchInfo* info = NULL;
		GRegex* r_tags = NULL;
		GRegex* _tmp0_ = NULL;
		GRegex* r_skip = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GRegex* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GMatchInfo* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gchar* account = NULL;
		GMatchInfo* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* host = NULL;
		GMatchInfo* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* tags = NULL;
		GMatchInfo* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GMatchInfo* i_args = NULL;
		GRegex* r_stats = NULL;
		GRegex* _tmp18_ = NULL;
		GRegex* r_error = NULL;
		GRegex* _tmp19_ = NULL;
		GRegex* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GMatchInfo* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		info = NULL;
		_tmp0_ = g_regex_new ("^([^:]+): smd-(client|server|loop|push|pull|pushpull)@([^:]+): TAGS:(." \
"*)$", 0, 0, &_inner_error_);
		r_tags = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp1_ = g_regex_new ("^([^:]+): smd-(client|server)@([^:]+): ERROR", 0, 0, &_inner_error_);
		r_skip = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp2_ = r_skip;
		_tmp3_ = s;
		_tmp4_ = g_regex_match (_tmp2_, _tmp3_, 0, NULL);
		if (_tmp4_) {
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			return result;
		}
		_tmp5_ = r_tags;
		_tmp6_ = s;
		_tmp8_ = g_regex_match (_tmp5_, _tmp6_, 0, &_tmp7_);
		_g_match_info_unref0 (info);
		info = _tmp7_;
		if (!_tmp8_) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp9_ = s;
			_tmp10_ = g_strdup_printf ("unhandled smd-loop message: %s", _tmp9_);
			_tmp11_ = _tmp10_;
			debug (_tmp11_);
			_g_free0 (_tmp11_);
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			return result;
		}
		_tmp12_ = info;
		_tmp13_ = g_match_info_fetch (_tmp12_, 1);
		account = _tmp13_;
		_tmp14_ = info;
		_tmp15_ = g_match_info_fetch (_tmp14_, 3);
		host = _tmp15_;
		_tmp16_ = info;
		_tmp17_ = g_match_info_fetch (_tmp16_, 4);
		tags = _tmp17_;
		i_args = NULL;
		_tmp18_ = g_regex_new (" stats::(.*)$", 0, 0, &_inner_error_);
		r_stats = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = g_regex_new (" error::(.*)$", 0, 0, &_inner_error_);
		r_error = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (r_stats);
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (r_stats);
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp20_ = r_stats;
		_tmp21_ = tags;
		_tmp23_ = g_regex_match (_tmp20_, _tmp21_, 0, &_tmp22_);
		_g_match_info_unref0 (i_args);
		i_args = _tmp22_;
		if (_tmp23_) {
			GRegex* r_neW = NULL;
			GRegex* _tmp24_ = NULL;
			GRegex* r_del = NULL;
			GRegex* _tmp25_ = NULL;
			GMatchInfo* i_new = NULL;
			GMatchInfo* i_del = NULL;
			gchar* args = NULL;
			GMatchInfo* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gboolean has_new = FALSE;
			GRegex* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			GMatchInfo* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
			gboolean has_del = FALSE;
			GRegex* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			GMatchInfo* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			gint new_mails = 0;
			gboolean _tmp36_ = FALSE;
			gint del_mails = 0;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp46_ = FALSE;
			const gchar* _tmp47_ = NULL;
			_tmp24_ = g_regex_new ("new-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			r_neW = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch11_g_regex_error;
				}
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp25_ = g_regex_new ("del-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			r_del = _tmp25_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch11_g_regex_error;
				}
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			i_new = NULL;
			i_del = NULL;
			_tmp26_ = i_args;
			_tmp27_ = g_match_info_fetch (_tmp26_, 1);
			args = _tmp27_;
			_tmp28_ = r_neW;
			_tmp29_ = args;
			_tmp31_ = g_regex_match (_tmp28_, _tmp29_, 0, &_tmp30_);
			_g_match_info_unref0 (i_new);
			i_new = _tmp30_;
			has_new = _tmp31_;
			_tmp32_ = r_del;
			_tmp33_ = args;
			_tmp35_ = g_regex_match (_tmp32_, _tmp33_, 0, &_tmp34_);
			_g_match_info_unref0 (i_del);
			i_del = _tmp34_;
			has_del = _tmp35_;
			new_mails = 0;
			_tmp36_ = has_new;
			if (_tmp36_) {
				GMatchInfo* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				_tmp37_ = i_new;
				_tmp38_ = g_match_info_fetch (_tmp37_, 1);
				_tmp39_ = _tmp38_;
				_tmp40_ = atoi (_tmp39_);
				new_mails = _tmp40_;
				_g_free0 (_tmp39_);
			}
			del_mails = 0;
			_tmp41_ = has_del;
			if (_tmp41_) {
				GMatchInfo* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				_tmp42_ = i_del;
				_tmp43_ = g_match_info_fetch (_tmp42_, 1);
				_tmp44_ = _tmp43_;
				_tmp45_ = atoi (_tmp44_);
				del_mails = _tmp45_;
				_g_free0 (_tmp44_);
			}
			_tmp47_ = host;
			if (g_strcmp0 (_tmp47_, "localhost") == 0) {
				gboolean _tmp48_ = FALSE;
				gint _tmp49_ = 0;
				_tmp49_ = new_mails;
				if (_tmp49_ > 0) {
					_tmp48_ = TRUE;
				} else {
					gint _tmp50_ = 0;
					_tmp50_ = del_mails;
					_tmp48_ = _tmp50_ > 0;
				}
				_tmp46_ = _tmp48_;
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				GeeArrayList* _tmp51_ = NULL;
				GeeArrayList* _tmp52_ = NULL;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				const gchar* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				Event* _tmp59_ = NULL;
				Event* _tmp60_ = NULL;
				g_mutex_lock (&self->priv->events_lock);
				_tmp51_ = self->priv->events;
				_tmp52_ = self->priv->events;
				_tmp53_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = account;
				_tmp56_ = host;
				_tmp57_ = new_mails;
				_tmp58_ = del_mails;
				_tmp59_ = event_stats (_tmp55_, _tmp56_, _tmp57_, _tmp58_);
				_tmp60_ = _tmp59_;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp51_, _tmp54_, _tmp60_);
				_event_unref0 (_tmp60_);
				g_mutex_unlock (&self->priv->events_lock);
			} else {
			}
			result = TRUE;
			_g_free0 (args);
			_g_match_info_unref0 (i_del);
			_g_match_info_unref0 (i_new);
			_g_regex_unref0 (r_del);
			_g_regex_unref0 (r_neW);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			return result;
		} else {
			GRegex* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			GMatchInfo* _tmp63_ = NULL;
			gboolean _tmp64_ = FALSE;
			_tmp61_ = r_error;
			_tmp62_ = tags;
			_tmp64_ = g_regex_match (_tmp61_, _tmp62_, 0, &_tmp63_);
			_g_match_info_unref0 (i_args);
			i_args = _tmp63_;
			if (_tmp64_) {
				gchar* args = NULL;
				GMatchInfo* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				gboolean _tmp67_ = FALSE;
				const gchar* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				gboolean _tmp71_ = FALSE;
				_tmp65_ = i_args;
				_tmp66_ = g_match_info_fetch (_tmp65_, 1);
				args = _tmp66_;
				_tmp68_ = args;
				_tmp69_ = account;
				_tmp70_ = host;
				_tmp71_ = smd_applet_eval_smd_loop_error_message (self, _tmp68_, _tmp69_, _tmp70_, &_inner_error_);
				_tmp67_ = _tmp71_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_unref0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_unref0 (info);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch11_g_regex_error;
					}
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_unref0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_unref0 (info);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				result = _tmp67_;
				_g_free0 (args);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				return result;
			} else {
				FILE* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				_tmp72_ = stderr;
				_tmp73_ = s;
				fprintf (_tmp72_, "unhandled smd-loop message: %s\n", _tmp73_);
				result = TRUE;
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				return result;
			}
		}
		_g_regex_unref0 (r_error);
		_g_regex_unref0 (r_stats);
		_g_match_info_unref0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_unref0 (info);
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp74_ = NULL;
		GError* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp74_ = stderr;
		_tmp75_ = e;
		_tmp76_ = _tmp75_->message;
		fprintf (_tmp74_, "%s\n", _tmp76_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void ___lambda7_ (smdApplet* self) {
	setpgid ((pid_t) 0, (pid_t) 0);
}


static void ____lambda7__gspawn_child_setup_func (gpointer self) {
	___lambda7_ ((smdApplet*) self);
}


static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error) {
	gboolean result = FALSE;
	gchar** cmd = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint cmd_length1 = 0;
	gint _cmd_size_ = 0;
	gint child_in = 0;
	gint child_out = 0;
	gint child_err = 0;
	gchar* buff = NULL;
	gchar* _tmp4_ = NULL;
	gint buff_length1 = 0;
	gint _buff_size_ = 0;
	GSpawnFlags flags = 0;
	gboolean rc = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_smd_loop_cmd;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("-v");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	cmd = _tmp3_;
	cmd_length1 = 2;
	_cmd_size_ = cmd_length1;
	_tmp4_ = g_new0 (gchar, 10240);
	buff = _tmp4_;
	buff_length1 = 10240;
	_buff_size_ = buff_length1;
	flags = 0;
	_tmp5_ = smd_applet_smd_loop_cmd;
	_tmp6_ = g_strdup_printf ("spawning %s\n", _tmp5_);
	_tmp7_ = _tmp6_;
	debug (_tmp7_);
	_g_free0 (_tmp7_);
	{
		gboolean _tmp8_ = FALSE;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		GSpawnFlags _tmp10_ = 0;
		GPid _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		_tmp9_ = cmd;
		_tmp9__length1 = cmd_length1;
		_tmp10_ = flags;
		_tmp15_ = g_spawn_async_with_pipes (NULL, _tmp9_, NULL, _tmp10_, ____lambda7__gspawn_child_setup_func, self, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_inner_error_);
		self->priv->pid = _tmp11_;
		child_in = _tmp12_;
		child_out = _tmp13_;
		child_err = _tmp14_;
		_tmp8_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		rc = _tmp8_;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stderr;
		_tmp17_ = smd_applet_smd_loop_cmd;
		_tmp18_ = g_strconcat ("Unable to execute ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, ": ", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
		_tmp27_ = _tmp26_;
		fprintf (_tmp16_, "%s", _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp28_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally12;
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (rc) {
		FILE* input = NULL;
		gint _tmp29_ = 0;
		FILE* _tmp30_ = NULL;
		gchar* s = NULL;
		gboolean goon = FALSE;
		const gchar* _tmp48_ = NULL;
		GPid _tmp58_ = 0;
		GPid _tmp59_ = 0;
		_tmp29_ = child_out;
		_tmp30_ = fdopen (_tmp29_, "r");
		input = _tmp30_;
		s = NULL;
		goon = TRUE;
		while (TRUE) {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gboolean _tmp44_ = FALSE;
			gboolean _tmp45_ = FALSE;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			_tmp33_ = goon;
			if (_tmp33_) {
				FILE* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				_tmp34_ = input;
				_tmp35_ = buff;
				_tmp35__length1 = buff_length1;
				_tmp36_ = fgets (_tmp35_, _tmp35__length1, _tmp34_);
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (s);
				s = _tmp37_;
				_tmp38_ = s;
				_tmp32_ = _tmp38_ != NULL;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				gboolean _tmp39_ = FALSE;
				_tmp39_ = self->priv->thread_die;
				_tmp31_ = !_tmp39_;
			} else {
				_tmp31_ = FALSE;
			}
			if (!_tmp31_) {
				break;
			}
			_tmp40_ = s;
			_tmp41_ = g_strdup_printf ("smd-loop outputs: %s", _tmp40_);
			_tmp42_ = _tmp41_;
			debug (_tmp42_);
			_g_free0 (_tmp42_);
			_tmp43_ = s;
			_tmp44_ = smd_applet_eval_smd_loop_message (self, _tmp43_);
			goon = _tmp44_;
			_tmp45_ = goon;
			_tmp46_ = g_strdup_printf ("eval_smd_loop_message returned %d", (gint) _tmp45_);
			_tmp47_ = _tmp46_;
			debug (_tmp47_);
			_g_free0 (_tmp47_);
		}
		_tmp48_ = s;
		if (_tmp48_ != NULL) {
			FILE* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			_tmp49_ = input;
			_tmp50_ = buff;
			_tmp50__length1 = buff_length1;
			_tmp51_ = fgets (_tmp50_, _tmp50__length1, _tmp49_);
			_tmp52_ = g_strdup (_tmp51_);
			_g_free0 (s);
			s = _tmp52_;
			_tmp53_ = s;
			if (_tmp53_ != NULL) {
				FILE* _tmp54_ = NULL;
				FILE* _tmp55_ = NULL;
				GPid _tmp56_ = 0;
				const gchar* _tmp57_ = NULL;
				_tmp54_ = stderr;
				fprintf (_tmp54_, "smd-loop gave error tag but not died\n");
				_tmp55_ = stderr;
				_tmp56_ = self->priv->pid;
				_tmp57_ = s;
				fprintf (_tmp55_, "smd-loop has pid %d and prints %s\n", (gint) _tmp56_, _tmp57_);
			}
		}
		_tmp58_ = self->priv->pid;
		g_spawn_close_pid (_tmp58_);
		_tmp59_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp59_)), SIGTERM);
		result = goon;
		_g_free0 (s);
		_fclose0 (input);
		buff = (g_free (buff), NULL);
		cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		FILE* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		GError* _tmp66_ = NULL;
		_tmp60_ = stderr;
		_tmp61_ = smd_applet_smd_loop_cmd;
		_tmp62_ = g_strconcat ("Unable to execute ", _tmp61_, NULL);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (_tmp63_, "\n", NULL);
		_tmp65_ = _tmp64_;
		fprintf (_tmp60_, "%s", _tmp65_);
		_g_free0 (_tmp65_);
		_g_free0 (_tmp63_);
		_tmp66_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp66_;
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	buff = (g_free (buff), NULL);
	cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
}


static void ______lambda15_ (smdApplet* self, NotifyNotification* not, const gchar* action) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (not != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->err_win;
	gtk_window_reshow_with_initial_size (_tmp0_);
}


static void _______lambda15__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	______lambda15_ ((smdApplet*) self, notification, action);
}


static void ______lambda16_ (smdApplet* self, GtkButton* b) {
	gint cmd_status = 0;
	gchar* output = NULL;
	gchar* _error_ = NULL;
	GHashTable* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->command_hash;
	_tmp1_ = b;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = g_strdup_printf ("executing: %s\n", (const gchar*) _tmp2_);
	_tmp4_ = _tmp3_;
	debug (_tmp4_);
	_g_free0 (_tmp4_);
	{
		GHashTable* _tmp5_ = NULL;
		GtkButton* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp5_ = self->priv->command_hash;
		_tmp6_ = b;
		_tmp7_ = g_hash_table_lookup (_tmp5_, (GtkWidget*) _tmp6_);
		g_spawn_command_line_sync ((const gchar*) _tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_inner_error_);
		_g_free0 (output);
		output = _tmp8_;
		_g_free0 (_error_);
		_error_ = _tmp9_;
		cmd_status = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch16_g_spawn_error;
			}
			_g_free0 (_error_);
			_g_free0 (output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = WIFEXITED (cmd_status);
		if (_tmp12_) {
			gint _tmp13_ = 0;
			_tmp13_ = WEXITSTATUS (cmd_status);
			_tmp11_ = 0 == _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkButton* _tmp14_ = NULL;
			_tmp14_ = b;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
		} else {
			GtkMessageDialog* w = NULL;
			GtkWindow* _tmp15_ = NULL;
			GtkMessageDialog* _tmp16_ = NULL;
			GtkMessageDialog* _tmp17_ = NULL;
			GtkMessageDialog* _tmp18_ = NULL;
			_tmp15_ = self->priv->err_win;
			_tmp16_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp15_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "An error occurred:\n%s\n%s", output, _error_);
			g_object_ref_sink (_tmp16_);
			w = _tmp16_;
			_tmp17_ = w;
			gtk_dialog_run ((GtkDialog*) _tmp17_);
			_tmp18_ = w;
			gtk_widget_destroy ((GtkWidget*) _tmp18_);
			_g_object_unref0 (w);
		}
	}
	goto __finally16;
	__catch16_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = stderr;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		fprintf (_tmp19_, "Spawning: %s\n", _tmp21_);
		_g_error_free0 (e);
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_error_);
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (_error_);
	_g_free0 (output);
}


static void _______lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda16_ ((smdApplet*) self, _sender);
}


static gboolean smd_applet_eat_event (smdApplet* self) {
	gboolean result = FALSE;
	Event* e = NULL;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp9_ = FALSE;
	Event* _tmp10_ = NULL;
	gboolean _tmp54_ = FALSE;
	Event* _tmp55_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	e = NULL;
	_tmp0_ = self->priv->error_mode;
	if (_tmp0_) {
		result = TRUE;
		_event_unref0 (e);
		return result;
	}
	g_mutex_lock (&self->priv->events_lock);
	_tmp1_ = self->priv->events;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GeeArrayList* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		Event* _tmp8_ = NULL;
		_tmp4_ = self->priv->events;
		_tmp5_ = gee_list_first ((GeeList*) _tmp4_);
		_event_unref0 (e);
		e = (Event*) _tmp5_;
		_tmp6_ = self->priv->events;
		_tmp7_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp6_, 0);
		_tmp8_ = (Event*) _tmp7_;
		_event_unref0 (_tmp8_);
	}
	g_mutex_unlock (&self->priv->events_lock);
	_tmp10_ = e;
	if (_tmp10_ != NULL) {
		Event* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp9_ = _tmp12_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean notify_on_newail = FALSE;
		GSettings* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		Event* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		notify_on_newail = FALSE;
		_tmp13_ = self->priv->settings;
		_tmp14_ = g_settings_get_boolean (_tmp13_, SMD_APPLET_key_newmail);
		notify_on_newail = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->enter_network_error_mode;
		if (_tmp17_) {
			gboolean _tmp18_ = FALSE;
			_tmp18_ = self->priv->network_error_mode;
			_tmp15_ = _tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
		} else {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			Event* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = e;
			_tmp22_ = event_is_error_event (_tmp21_);
			if (!_tmp22_) {
				gboolean _tmp23_ = FALSE;
				_tmp23_ = notify_on_newail;
				_tmp20_ = _tmp23_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				gboolean _tmp24_ = FALSE;
				Event* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				_tmp25_ = e;
				_tmp26_ = event_is_error_event (_tmp25_);
				if (_tmp26_) {
					Event* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
					_tmp27_ = e;
					_tmp28_ = _tmp27_->enter_network_error_mode;
					_tmp24_ = _tmp28_;
				} else {
					_tmp24_ = FALSE;
				}
				_tmp19_ = _tmp24_;
			}
			if (_tmp19_) {
				Event* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				Event* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				NotifyNotification* _tmp33_ = NULL;
				NotifyNotification* _tmp34_ = NULL;
				GVariant* _tmp35_ = NULL;
				GVariant* _tmp36_ = NULL;
				_tmp29_ = e;
				_tmp30_ = _tmp29_->message;
				_tmp31_ = e;
				_tmp32_ = _tmp31_->message_icon;
				_tmp33_ = notify_notification_new ("Syncmaildir", _tmp30_, _tmp32_);
				_g_object_unref0 (self->priv->notification);
				self->priv->notification = _tmp33_;
				_tmp34_ = self->priv->notification;
				_tmp35_ = g_variant_new_boolean (TRUE);
				g_variant_ref_sink (_tmp35_);
				_tmp36_ = _tmp35_;
				notify_notification_set_hint (_tmp34_, "transient", _tmp36_);
				_g_variant_unref0 (_tmp36_);
				{
					NotifyNotification* _tmp37_ = NULL;
					_tmp37_ = self->priv->notification;
					notify_notification_show (_tmp37_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch13_g_error;
					}
				}
				goto __finally13;
				__catch13_g_error:
				{
					GError* e = NULL;
					FILE* _tmp38_ = NULL;
					GError* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp38_ = stderr;
					_tmp39_ = e;
					_tmp40_ = _tmp39_->message;
					fprintf (_tmp38_, "%s\n", _tmp40_);
					_g_error_free0 (e);
				}
				__finally13:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_event_unref0 (e);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			} else {
				Event* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				_tmp41_ = e;
				_tmp42_ = event_is_error_event (_tmp41_);
				if (_tmp42_) {
					Event* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					Event* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					NotifyNotification* _tmp47_ = NULL;
					NotifyNotification* _tmp48_ = NULL;
					NotifyNotification* _tmp49_ = NULL;
					_tmp43_ = e;
					_tmp44_ = _tmp43_->message;
					_tmp45_ = e;
					_tmp46_ = _tmp45_->message_icon;
					_tmp47_ = notify_notification_new ("Syncmaildir", _tmp44_, _tmp46_);
					_g_object_unref0 (self->priv->notification);
					self->priv->notification = _tmp47_;
					_tmp48_ = self->priv->notification;
					notify_notification_set_timeout (_tmp48_, 0);
					_tmp49_ = self->priv->notification;
					notify_notification_add_action (_tmp49_, "clicked", "Handle error", _______lambda15__notify_action_callback, g_object_ref (self), g_object_unref);
					{
						NotifyNotification* _tmp50_ = NULL;
						_tmp50_ = self->priv->notification;
						notify_notification_show (_tmp50_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch14_g_error;
						}
					}
					goto __finally14;
					__catch14_g_error:
					{
						GError* e = NULL;
						FILE* _tmp51_ = NULL;
						GError* _tmp52_ = NULL;
						const gchar* _tmp53_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp51_ = stderr;
						_tmp52_ = e;
						_tmp53_ = _tmp52_->message;
						fprintf (_tmp51_, "%s\n", _tmp53_);
						_g_error_free0 (e);
					}
					__finally14:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
			}
		}
	}
	_tmp55_ = e;
	if (_tmp55_ != NULL) {
		Event* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		_tmp56_ = e;
		_tmp57_ = _tmp56_->enter_error_mode;
		_tmp54_ = _tmp57_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		GtkStatusIcon* _tmp58_ = NULL;
		GtkStatusIcon* _tmp59_ = NULL;
		gboolean _tmp60_ = FALSE;
		GtkLabel* l_ctx = NULL;
		GtkBuilder* _tmp62_ = NULL;
		GObject* _tmp63_ = NULL;
		GtkLabel* _tmp64_ = NULL;
		GtkLabel* l_cause = NULL;
		GtkBuilder* _tmp65_ = NULL;
		GObject* _tmp66_ = NULL;
		GtkLabel* _tmp67_ = NULL;
		GtkLabel* _tmp68_ = NULL;
		Event* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		GtkLabel* _tmp71_ = NULL;
		Event* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		GHashTable* _tmp74_ = NULL;
		GtkGrid* vb = NULL;
		GtkBuilder* _tmp75_ = NULL;
		GObject* _tmp76_ = NULL;
		GtkGrid* _tmp77_ = NULL;
		GtkGrid* _tmp78_ = NULL;
		GList* _tmp79_ = NULL;
		Event* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		Event* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		Event* _tmp120_ = NULL;
		GeeArrayList* _tmp121_ = NULL;
		GtkWidget* x = NULL;
		GtkBuilder* _tmp169_ = NULL;
		GObject* _tmp170_ = NULL;
		GtkWidget* _tmp171_ = NULL;
		GtkWidget* _tmp172_ = NULL;
		Event* _tmp173_ = NULL;
		const gchar* _tmp174_ = NULL;
		GtkBuilder* _tmp175_ = NULL;
		GObject* _tmp176_ = NULL;
		GtkWidget* _tmp177_ = NULL;
		GtkWidget* _tmp178_ = NULL;
		Event* _tmp179_ = NULL;
		const gchar* _tmp180_ = NULL;
		GtkBuilder* _tmp181_ = NULL;
		GObject* _tmp182_ = NULL;
		GtkWidget* _tmp183_ = NULL;
		GtkWidget* _tmp184_ = NULL;
		Event* _tmp185_ = NULL;
		GeeArrayList* _tmp186_ = NULL;
		gint _tmp187_ = 0;
		gint _tmp188_ = 0;
		_tmp58_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp58_, "error");
		_tmp59_ = self->priv->si;
		gtk_status_icon_set_tooltip_text (_tmp59_, "smd-applet encountered an error");
		self->priv->error_mode = TRUE;
		_tmp60_ = self->priv->notification_server_has_persistence;
		if (!_tmp60_) {
			GtkStatusIcon* _tmp61_ = NULL;
			_tmp61_ = self->priv->si;
			gtk_status_icon_set_visible (_tmp61_, TRUE);
		}
		_tmp62_ = self->priv->builder;
		_tmp63_ = gtk_builder_get_object (_tmp62_, "lContext");
		_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp63_) : NULL);
		l_ctx = _tmp64_;
		_tmp65_ = self->priv->builder;
		_tmp66_ = gtk_builder_get_object (_tmp65_, "lCause");
		_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp66_) : NULL);
		l_cause = _tmp67_;
		_tmp68_ = l_ctx;
		_tmp69_ = e;
		_tmp70_ = _tmp69_->context;
		gtk_label_set_text (_tmp68_, _tmp70_);
		_tmp71_ = l_cause;
		_tmp72_ = e;
		_tmp73_ = _tmp72_->cause;
		gtk_label_set_text (_tmp71_, _tmp73_);
		_tmp74_ = self->priv->command_hash;
		g_hash_table_remove_all (_tmp74_);
		_tmp75_ = self->priv->builder;
		_tmp76_ = gtk_builder_get_object (_tmp75_, "vbRun");
		_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp76_) : NULL);
		vb = _tmp77_;
		_tmp78_ = vb;
		_tmp79_ = gtk_container_get_children ((GtkContainer*) _tmp78_);
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp79_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp80_ = NULL;
				GtkWidget* w = NULL;
				_tmp80_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp80_;
				{
					GtkGrid* _tmp81_ = NULL;
					GtkWidget* _tmp82_ = NULL;
					_tmp81_ = vb;
					_tmp82_ = w;
					gtk_container_remove ((GtkContainer*) _tmp81_, _tmp82_);
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
		_tmp83_ = e;
		_tmp84_ = _tmp83_->permissions;
		if (_tmp84_ != NULL) {
			GtkLabel* l = NULL;
			GtkBuilder* _tmp85_ = NULL;
			GObject* _tmp86_ = NULL;
			GtkLabel* _tmp87_ = NULL;
			GtkLabel* _tmp88_ = NULL;
			Event* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			_tmp85_ = self->priv->builder;
			_tmp86_ = gtk_builder_get_object (_tmp85_, "lPermissions");
			_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp86_) : NULL);
			l = _tmp87_;
			_tmp88_ = l;
			_tmp89_ = e;
			_tmp90_ = _tmp89_->permissions;
			gtk_label_set_text (_tmp88_, _tmp90_);
			_g_object_unref0 (l);
		}
		_tmp91_ = e;
		_tmp92_ = _tmp91_->mail_name;
		if (_tmp92_ != NULL) {
			GtkEntry* fn = NULL;
			GtkBuilder* _tmp93_ = NULL;
			GObject* _tmp94_ = NULL;
			GtkEntry* _tmp95_ = NULL;
			GtkEntry* _tmp96_ = NULL;
			Event* _tmp97_ = NULL;
			const gchar* _tmp98_ = NULL;
			GtkTextView* l = NULL;
			GtkBuilder* _tmp99_ = NULL;
			GObject* _tmp100_ = NULL;
			GtkTextView* _tmp101_ = NULL;
			GtkTextBuffer* b = NULL;
			GtkTextView* _tmp102_ = NULL;
			GtkTextBuffer* _tmp103_ = NULL;
			GtkTextBuffer* _tmp104_ = NULL;
			GtkTextBuffer* _tmp105_ = NULL;
			Event* _tmp106_ = NULL;
			const gchar* _tmp107_ = NULL;
			GtkTextIter it = {0};
			GtkTextIter subj = {0};
			GtkTextBuffer* _tmp108_ = NULL;
			GtkTextIter _tmp109_ = {0};
			GtkTextIter _tmp110_ = {0};
			gboolean _tmp111_ = FALSE;
			_tmp93_ = self->priv->builder;
			_tmp94_ = gtk_builder_get_object (_tmp93_, "eMailName");
			_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp94_) : NULL);
			fn = _tmp95_;
			_tmp96_ = fn;
			_tmp97_ = e;
			_tmp98_ = _tmp97_->mail_name;
			gtk_entry_set_text (_tmp96_, _tmp98_);
			_tmp99_ = self->priv->builder;
			_tmp100_ = gtk_builder_get_object (_tmp99_, "tvMail");
			_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp100_) : NULL);
			l = _tmp101_;
			_tmp102_ = l;
			_tmp103_ = gtk_text_view_get_buffer (_tmp102_);
			_tmp104_ = _g_object_ref0 (_tmp103_);
			b = _tmp104_;
			_tmp105_ = b;
			_tmp106_ = e;
			_tmp107_ = _tmp106_->mail_body;
			gtk_text_buffer_set_text (_tmp105_, _tmp107_, -1);
			_tmp108_ = b;
			gtk_text_buffer_get_start_iter (_tmp108_, &_tmp109_);
			it = _tmp109_;
			_tmp111_ = gtk_text_iter_forward_search (&it, "Subject:", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp110_, NULL, NULL);
			subj = _tmp110_;
			if (_tmp111_) {
				GtkTextMark* insert = NULL;
				GtkTextBuffer* _tmp112_ = NULL;
				GtkTextMark* _tmp113_ = NULL;
				GtkTextMark* _tmp114_ = NULL;
				GtkTextBuffer* _tmp115_ = NULL;
				GtkTextIter _tmp116_ = {0};
				GtkTextIter _tmp117_ = {0};
				GtkTextView* _tmp118_ = NULL;
				GtkTextMark* _tmp119_ = NULL;
				_tmp112_ = b;
				_tmp113_ = gtk_text_buffer_get_insert (_tmp112_);
				_tmp114_ = _g_object_ref0 (_tmp113_);
				insert = _tmp114_;
				_tmp115_ = b;
				_tmp116_ = subj;
				_tmp117_ = subj;
				gtk_text_buffer_select_range (_tmp115_, &_tmp116_, &_tmp117_);
				_tmp118_ = l;
				_tmp119_ = insert;
				gtk_text_view_scroll_to_mark (_tmp118_, _tmp119_, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (insert);
			}
			_g_object_unref0 (b);
			_g_object_unref0 (l);
			_g_object_unref0 (fn);
		}
		_tmp120_ = e;
		_tmp121_ = _tmp120_->commands;
		if (_tmp121_ != NULL) {
			{
				GeeArrayList* _command_list = NULL;
				Event* _tmp122_ = NULL;
				GeeArrayList* _tmp123_ = NULL;
				GeeArrayList* _tmp124_ = NULL;
				gint _command_size = 0;
				GeeArrayList* _tmp125_ = NULL;
				gint _tmp126_ = 0;
				gint _tmp127_ = 0;
				gint _command_index = 0;
				_tmp122_ = e;
				_tmp123_ = _tmp122_->commands;
				_tmp124_ = _g_object_ref0 (_tmp123_);
				_command_list = _tmp124_;
				_tmp125_ = _command_list;
				_tmp126_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp125_);
				_tmp127_ = _tmp126_;
				_command_size = _tmp127_;
				_command_index = -1;
				while (TRUE) {
					gint _tmp128_ = 0;
					gint _tmp129_ = 0;
					gint _tmp130_ = 0;
					gchar* command = NULL;
					GeeArrayList* _tmp131_ = NULL;
					gint _tmp132_ = 0;
					gpointer _tmp133_ = NULL;
					GtkGrid* hb = NULL;
					GtkGrid* _tmp134_ = NULL;
					GtkGrid* _tmp135_ = NULL;
					GtkGrid* _tmp136_ = NULL;
					gchar* nice_command = NULL;
					GtkLabel* lbl = NULL;
					const gchar* _tmp152_ = NULL;
					GtkLabel* _tmp153_ = NULL;
					GtkLabel* _tmp154_ = NULL;
					GtkButton* but = NULL;
					GtkButton* _tmp155_ = NULL;
					GHashTable* _tmp156_ = NULL;
					GtkButton* _tmp157_ = NULL;
					GtkWidget* _tmp158_ = NULL;
					const gchar* _tmp159_ = NULL;
					gchar* _tmp160_ = NULL;
					GtkButton* _tmp161_ = NULL;
					GtkGrid* _tmp162_ = NULL;
					GtkLabel* _tmp163_ = NULL;
					GtkGrid* _tmp164_ = NULL;
					GtkButton* _tmp165_ = NULL;
					GtkGrid* _tmp166_ = NULL;
					GtkGrid* _tmp167_ = NULL;
					GtkGrid* _tmp168_ = NULL;
					_tmp128_ = _command_index;
					_command_index = _tmp128_ + 1;
					_tmp129_ = _command_index;
					_tmp130_ = _command_size;
					if (!(_tmp129_ < _tmp130_)) {
						break;
					}
					_tmp131_ = _command_list;
					_tmp132_ = _command_index;
					_tmp133_ = gee_abstract_list_get ((GeeAbstractList*) _tmp131_, _tmp132_);
					command = (gchar*) _tmp133_;
					_tmp134_ = (GtkGrid*) gtk_grid_new ();
					g_object_ref_sink (_tmp134_);
					hb = _tmp134_;
					_tmp135_ = hb;
					gtk_grid_set_column_homogeneous (_tmp135_, FALSE);
					_tmp136_ = hb;
					gtk_grid_set_column_spacing (_tmp136_, (guint) 10);
					{
						GMatchInfo* i_mailto = NULL;
						GRegex* mailto_rex = NULL;
						GRegex* _tmp137_ = NULL;
						GRegex* _tmp138_ = NULL;
						const gchar* _tmp139_ = NULL;
						GMatchInfo* _tmp140_ = NULL;
						gboolean _tmp141_ = FALSE;
						_tmp137_ = g_regex_new ("^gnome-open..mailto:", 0, 0, &_inner_error_);
						mailto_rex = _tmp137_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_match_info_unref0 (i_mailto);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch15_g_regex_error;
							}
							_g_match_info_unref0 (i_mailto);
							_g_free0 (nice_command);
							_g_object_unref0 (hb);
							_g_free0 (command);
							_g_object_unref0 (_command_list);
							_g_object_unref0 (vb);
							_g_object_unref0 (l_cause);
							_g_object_unref0 (l_ctx);
							_event_unref0 (e);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp138_ = mailto_rex;
						_tmp139_ = command;
						_tmp141_ = g_regex_match (_tmp138_, _tmp139_, 0, &_tmp140_);
						_g_match_info_unref0 (i_mailto);
						i_mailto = _tmp140_;
						if (_tmp141_) {
							const gchar* _tmp142_ = NULL;
							gchar* _tmp143_ = NULL;
							gchar* _tmp144_ = NULL;
							gchar* _tmp145_ = NULL;
							gchar* _tmp146_ = NULL;
							gchar* _tmp147_ = NULL;
							_tmp142_ = command;
							_tmp143_ = g_uri_unescape_string (_tmp142_, NULL);
							_tmp144_ = _tmp143_;
							_tmp145_ = string_substring (_tmp144_, (glong) 12, (glong) 70);
							_tmp146_ = _tmp145_;
							_tmp147_ = g_strconcat (_tmp146_, "...", NULL);
							_g_free0 (nice_command);
							nice_command = _tmp147_;
							_g_free0 (_tmp146_);
							_g_free0 (_tmp144_);
						} else {
							const gchar* _tmp148_ = NULL;
							gchar* _tmp149_ = NULL;
							_tmp148_ = command;
							_tmp149_ = g_strdup (_tmp148_);
							_g_free0 (nice_command);
							nice_command = _tmp149_;
						}
						_g_regex_unref0 (mailto_rex);
						_g_match_info_unref0 (i_mailto);
					}
					goto __finally15;
					__catch15_g_regex_error:
					{
						GError* e = NULL;
						const gchar* _tmp150_ = NULL;
						gchar* _tmp151_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp150_ = command;
						_tmp151_ = g_strdup (_tmp150_);
						_g_free0 (nice_command);
						nice_command = _tmp151_;
						_g_error_free0 (e);
					}
					__finally15:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (nice_command);
						_g_object_unref0 (hb);
						_g_free0 (command);
						_g_object_unref0 (_command_list);
						_g_object_unref0 (vb);
						_g_object_unref0 (l_cause);
						_g_object_unref0 (l_ctx);
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp152_ = nice_command;
					_tmp153_ = (GtkLabel*) gtk_label_new (_tmp152_);
					g_object_ref_sink (_tmp153_);
					lbl = _tmp153_;
					_tmp154_ = lbl;
					gtk_misc_set_alignment ((GtkMisc*) _tmp154_, 0.0f, 0.5f);
					_tmp155_ = (GtkButton*) gtk_button_new_from_stock ("gtk-execute");
					g_object_ref_sink (_tmp155_);
					but = _tmp155_;
					_tmp156_ = self->priv->command_hash;
					_tmp157_ = but;
					_tmp158_ = _g_object_ref0 ((GtkWidget*) _tmp157_);
					_tmp159_ = command;
					_tmp160_ = g_strdup (_tmp159_);
					g_hash_table_insert (_tmp156_, _tmp158_, _tmp160_);
					_tmp161_ = but;
					g_signal_connect_object (_tmp161_, "clicked", (GCallback) _______lambda16__gtk_button_clicked, self, 0);
					_tmp162_ = hb;
					_tmp163_ = lbl;
					gtk_grid_attach (_tmp162_, (GtkWidget*) _tmp163_, 1, 0, 1, 1);
					_tmp164_ = hb;
					_tmp165_ = but;
					gtk_grid_attach (_tmp164_, (GtkWidget*) _tmp165_, 0, 0, 1, 1);
					_tmp166_ = vb;
					_tmp167_ = hb;
					gtk_container_add ((GtkContainer*) _tmp166_, (GtkWidget*) _tmp167_);
					_tmp168_ = hb;
					gtk_widget_show_all ((GtkWidget*) _tmp168_);
					_g_object_unref0 (but);
					_g_object_unref0 (lbl);
					_g_free0 (nice_command);
					_g_object_unref0 (hb);
					_g_free0 (command);
				}
				_g_object_unref0 (_command_list);
			}
		}
		_tmp169_ = self->priv->builder;
		_tmp170_ = gtk_builder_get_object (_tmp169_, "fDisplayPermissions");
		_tmp171_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp170_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp170_) : NULL);
		x = _tmp171_;
		_tmp172_ = x;
		_tmp173_ = e;
		_tmp174_ = _tmp173_->permissions;
		gtk_widget_set_visible (_tmp172_, _tmp174_ != NULL);
		_tmp175_ = self->priv->builder;
		_tmp176_ = gtk_builder_get_object (_tmp175_, "fDisplayMail");
		_tmp177_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp176_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp176_) : NULL);
		_g_object_unref0 (x);
		x = _tmp177_;
		_tmp178_ = x;
		_tmp179_ = e;
		_tmp180_ = _tmp179_->mail_name;
		gtk_widget_set_visible (_tmp178_, _tmp180_ != NULL);
		_tmp181_ = self->priv->builder;
		_tmp182_ = gtk_builder_get_object (_tmp181_, "fRun");
		_tmp183_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp182_) : NULL);
		_g_object_unref0 (x);
		x = _tmp183_;
		_tmp184_ = x;
		_tmp185_ = e;
		_tmp186_ = _tmp185_->commands;
		_tmp187_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp186_);
		_tmp188_ = _tmp187_;
		gtk_widget_set_visible (_tmp184_, _tmp188_ > 0);
		_g_object_unref0 (x);
		_g_object_unref0 (vb);
		_g_object_unref0 (l_cause);
		_g_object_unref0 (l_ctx);
	} else {
		gboolean _tmp189_ = FALSE;
		Event* _tmp190_ = NULL;
		_tmp190_ = e;
		if (_tmp190_ != NULL) {
			Event* _tmp191_ = NULL;
			gboolean _tmp192_ = FALSE;
			_tmp191_ = e;
			_tmp192_ = _tmp191_->enter_network_error_mode;
			_tmp189_ = _tmp192_;
		} else {
			_tmp189_ = FALSE;
		}
		if (_tmp189_) {
			GtkStatusIcon* _tmp193_ = NULL;
			GtkStatusIcon* _tmp194_ = NULL;
			self->priv->network_error_mode = TRUE;
			_tmp193_ = self->priv->si;
			gtk_status_icon_set_from_icon_name (_tmp193_, "dialog-warning");
			_tmp194_ = self->priv->si;
			gtk_status_icon_set_tooltip_text (_tmp194_, "Network error");
		} else {
			Event* _tmp195_ = NULL;
			_tmp195_ = e;
			if (_tmp195_ != NULL) {
				GtkStatusIcon* _tmp196_ = NULL;
				GtkStatusIcon* _tmp197_ = NULL;
				self->priv->network_error_mode = FALSE;
				_tmp196_ = self->priv->si;
				gtk_status_icon_set_from_icon_name (_tmp196_, "mail-send-receive");
				_tmp197_ = self->priv->si;
				gtk_status_icon_set_tooltip_text (_tmp197_, "smd-applet is running");
			}
		}
	}
	result = TRUE;
	_event_unref0 (e);
	return result;
}


static void smd_applet_close_err_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_reset_to_regular_run (self, FALSE);
}


static gboolean smd_applet_close_err_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_reset_to_regular_run (self, FALSE);
	result = TRUE;
	return result;
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force) {
	GtkWindow* _tmp0_ = NULL;
	GtkStatusIcon* _tmp1_ = NULL;
	GtkStatusIcon* _tmp2_ = NULL;
	GThread* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->err_win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->error_mode = FALSE;
	_tmp1_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp1_, "smd-applet is running");
	_tmp2_ = self->priv->si;
	gtk_status_icon_set_from_icon_name (_tmp2_, "mail-send-receive");
	debug ("joining smdThread");
	_tmp3_ = self->priv->thread;
	if (_tmp3_ != NULL) {
		GThread* _tmp4_ = NULL;
		GThread* _tmp5_ = NULL;
		_tmp4_ = self->priv->thread;
		_tmp5_ = _g_thread_ref0 (_tmp4_);
		g_thread_join (_tmp5_);
	}
	self->priv->thread_die = FALSE;
	debug ("starting smdThread");
	_tmp6_ = force;
	smd_applet_start_smdThread (self, _tmp6_);
}


static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_prefs (self);
	result = TRUE;
	return result;
}


static void smd_applet_close_prefs (smdApplet* self) {
	GtkWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp2_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->config_wait_mode;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkStatusIcon* _tmp4_ = NULL;
		self->priv->config_wait_mode = FALSE;
		_tmp4_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp4_, "mail-send-receive");
		debug ("starting smdThread since smd stack is configured");
		smd_applet_start_smdThread (self, FALSE);
	}
}


static void smd_applet_pause (smdApplet* self) {
	GPid _tmp0_ = 0;
	GtkStatusIcon* _tmp5_ = NULL;
	GtkStatusIcon* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	debug ("enter pause mode");
	_tmp0_ = self->priv->pid;
	if (((gint) _tmp0_) != 0) {
		GPid _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GPid _tmp4_ = 0;
		_tmp1_ = self->priv->pid;
		_tmp2_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) _tmp1_));
		_tmp3_ = _tmp2_;
		debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp4_)), SIGTERM);
	}
	self->priv->thread_die = TRUE;
	_tmp5_ = self->priv->si;
	gtk_status_icon_set_from_stock (_tmp5_, "gtk-media-pause");
	_tmp6_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp6_, "smd-applet is paused");
}


static void smd_applet_unpause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("exit pause mode");
	smd_applet_reset_to_regular_run (self, TRUE);
}


static gboolean smd_applet_is_smd_loop_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean rc = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkBox* l = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = SMD_LOOP_CFG;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	rc = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "bErrLoop");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
	l = _tmp4_;
	_tmp5_ = rc;
	if (!_tmp5_) {
		GtkBox* _tmp6_ = NULL;
		_tmp6_ = l;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkBox* _tmp7_ = NULL;
		_tmp7_ = l;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean rc = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkBox* l = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = SMD_PP_DEF_CFG;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	rc = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "bErrPushPull");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
	l = _tmp4_;
	_tmp5_ = rc;
	if (!_tmp5_) {
		GtkBox* _tmp6_ = NULL;
		_tmp6_ = l;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkBox* _tmp7_ = NULL;
		_tmp7_ = l;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_stack_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean a = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean b = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_is_smd_loop_configured (self);
	a = _tmp0_;
	_tmp1_ = smd_applet_is_smd_pushpull_configured (self);
	b = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = b;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}


static void smd_applet_update_loglist (smdApplet* self) {
	GtkTextView* tv = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkTextView* _tmp2_ = NULL;
	GtkTextBuffer* b = NULL;
	GtkTextView* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "tvLog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp1_) : NULL);
	tv = _tmp2_;
	_tmp3_ = tv;
	_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	b = _tmp5_;
	{
		GDir* d = NULL;
		const gchar* _tmp6_ = NULL;
		GDir* _tmp7_ = NULL;
		gchar* file = NULL;
		GeeArrayList* new_lognames = NULL;
		void* _tmp8_ = NULL;
		GDestroyNotify _tmp9_ = NULL;
		GeeEqualDataFunc _tmp10_ = NULL;
		GeeArrayList* _tmp11_ = NULL;
		gboolean _tmp18_ = FALSE;
		GeeArrayList* _tmp19_ = NULL;
		GeeArrayList* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp6_ = SMD_LOGS_DIR;
		_tmp7_ = g_dir_open (_tmp6_, (guint) 0, &_inner_error_);
		d = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch17_g_file_error;
			}
			_g_object_unref0 (b);
			_g_object_unref0 (tv);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = gee_functions_get_equal_func_for (G_TYPE_STRING, &_tmp8_, &_tmp9_);
		_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp10_, _tmp8_, _tmp9_);
		new_lognames = _tmp11_;
		while (TRUE) {
			GDir* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			GeeArrayList* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp12_ = d;
			_tmp13_ = g_dir_read_name (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (file);
			file = _tmp14_;
			_tmp15_ = file;
			if (!(_tmp15_ != NULL)) {
				break;
			}
			_tmp16_ = new_lognames;
			_tmp17_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
		}
		_tmp19_ = new_lognames;
		_tmp20_ = self->priv->lognames;
		_tmp21_ = gee_collection_contains_all ((GeeCollection*) _tmp19_, (GeeCollection*) _tmp20_);
		if (!_tmp21_) {
			_tmp18_ = TRUE;
		} else {
			GeeArrayList* _tmp22_ = NULL;
			GeeArrayList* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp22_ = self->priv->lognames;
			_tmp23_ = new_lognames;
			_tmp24_ = gee_collection_contains_all ((GeeCollection*) _tmp22_, (GeeCollection*) _tmp23_);
			_tmp18_ = !_tmp24_;
		}
		if (_tmp18_) {
			GtkComboBoxText* _tmp25_ = NULL;
			GtkTreeModel* _tmp26_ = NULL;
			GeeArrayList* _tmp27_ = NULL;
			GeeArrayList* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			_tmp25_ = self->priv->cblogs;
			_tmp26_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp25_);
			gtk_list_store_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_list_store_get_type (), GtkListStore));
			_tmp27_ = self->priv->lognames;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp27_);
			{
				GeeArrayList* _f_list = NULL;
				GeeArrayList* _tmp28_ = NULL;
				GeeArrayList* _tmp29_ = NULL;
				gint _f_size = 0;
				GeeArrayList* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _f_index = 0;
				_tmp28_ = new_lognames;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_f_list = _tmp29_;
				_tmp30_ = _f_list;
				_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_f_size = _tmp32_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					gint _tmp35_ = 0;
					gchar* f = NULL;
					GeeArrayList* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					gpointer _tmp38_ = NULL;
					GeeArrayList* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					GtkComboBoxText* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					_tmp33_ = _f_index;
					_f_index = _tmp33_ + 1;
					_tmp34_ = _f_index;
					_tmp35_ = _f_size;
					if (!(_tmp34_ < _tmp35_)) {
						break;
					}
					_tmp36_ = _f_list;
					_tmp37_ = _f_index;
					_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
					f = (gchar*) _tmp38_;
					_tmp39_ = self->priv->lognames;
					_tmp40_ = f;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
					_tmp41_ = self->priv->cblogs;
					_tmp42_ = f;
					gtk_combo_box_text_append_text (_tmp41_, _tmp42_);
					_g_free0 (f);
				}
				_g_object_unref0 (_f_list);
			}
			_tmp43_ = self->priv->lognames;
			_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp45_ == 0) {
				GtkTextBuffer* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				_tmp46_ = b;
				_tmp47_ = SMD_LOGS_DIR;
				_tmp48_ = g_strdup_printf ("No logs in %s", _tmp47_);
				_tmp49_ = _tmp48_;
				gtk_text_buffer_set_text (_tmp46_, _tmp49_, -1);
				_g_free0 (_tmp49_);
			} else {
				GtkComboBoxText* _tmp50_ = NULL;
				GtkComboBoxText* _tmp51_ = NULL;
				_tmp50_ = self->priv->cblogs;
				gtk_combo_box_set_title ((GtkComboBox*) _tmp50_, "Choose log file");
				_tmp51_ = self->priv->cblogs;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp51_, 0);
			}
		}
		_g_object_unref0 (new_lognames);
		_g_free0 (file);
		_g_dir_close0 (d);
	}
	goto __finally17;
	__catch17_g_file_error:
	{
		GError* e = NULL;
		GtkTextBuffer* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp52_ = b;
		_tmp53_ = SMD_LOGS_DIR;
		_tmp54_ = g_strdup_printf ("Unable to list directory %s", _tmp53_);
		_tmp55_ = _tmp54_;
		gtk_text_buffer_set_text (_tmp52_, _tmp55_, -1);
		_g_free0 (_tmp55_);
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (b);
		_g_object_unref0 (tv);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (tv);
}


static void smd_applet_update_logcontents (smdApplet* self) {
	gint selected = 0;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cblogs;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	selected = _tmp1_;
	_tmp2_ = selected;
	if (_tmp2_ >= 0) {
		gchar* file = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gpointer _tmp5_ = NULL;
		gchar* content = NULL;
		_tmp3_ = self->priv->lognames;
		_tmp4_ = selected;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
		file = (gchar*) _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			_tmp7_ = SMD_LOGS_DIR;
			_tmp8_ = file;
			_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			_tmp12_ = g_file_get_contents (_tmp10_, &_tmp11_, NULL, &_inner_error_);
			_g_free0 (content);
			content = _tmp11_;
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp10_);
			_tmp6_ = _tmp13_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch18_g_file_error;
				}
				_g_free0 (content);
				_g_free0 (file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (_tmp6_) {
				GtkTextView* tv = NULL;
				GtkBuilder* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GtkTextView* _tmp16_ = NULL;
				GtkTextBuffer* b = NULL;
				GtkTextView* _tmp17_ = NULL;
				GtkTextBuffer* _tmp18_ = NULL;
				GtkTextBuffer* _tmp19_ = NULL;
				GtkTextIter end_iter = {0};
				GtkTextIter start_iter = {0};
				GtkTextBuffer* _tmp20_ = NULL;
				GtkTextIter _tmp21_ = {0};
				GtkTextBuffer* _tmp22_ = NULL;
				GtkTextIter _tmp23_ = {0};
				const gchar* _tmp24_ = NULL;
				GtkTextBuffer* _tmp25_ = NULL;
				GtkTextIter _tmp26_ = {0};
				GtkTextIter _tmp27_ = {0};
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp14_ = self->priv->builder;
				_tmp15_ = gtk_builder_get_object (_tmp14_, "tvLog");
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp15_) : NULL);
				tv = _tmp16_;
				_tmp17_ = tv;
				_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
				_tmp19_ = _g_object_ref0 (_tmp18_);
				b = _tmp19_;
				_tmp20_ = b;
				gtk_text_buffer_get_end_iter (_tmp20_, &_tmp21_);
				end_iter = _tmp21_;
				_tmp22_ = b;
				gtk_text_buffer_get_start_iter (_tmp22_, &_tmp23_);
				start_iter = _tmp23_;
				_tmp24_ = content;
				_tmp25_ = b;
				_tmp26_ = start_iter;
				_tmp27_ = end_iter;
				_tmp28_ = gtk_text_buffer_get_text (_tmp25_, &_tmp26_, &_tmp27_, FALSE);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strcmp0 (_tmp24_, _tmp29_) != 0;
				_g_free0 (_tmp29_);
				if (_tmp30_) {
					GtkTextBuffer* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					GtkTextBuffer* _tmp33_ = NULL;
					GtkTextIter _tmp34_ = {0};
					GtkTextView* _tmp35_ = NULL;
					GtkTextIter _tmp36_ = {0};
					_tmp31_ = b;
					_tmp32_ = content;
					gtk_text_buffer_set_text (_tmp31_, _tmp32_, -1);
					_tmp33_ = b;
					gtk_text_buffer_get_end_iter (_tmp33_, &_tmp34_);
					end_iter = _tmp34_;
					_tmp35_ = tv;
					_tmp36_ = end_iter;
					gtk_text_view_scroll_to_iter (_tmp35_, &_tmp36_, 0.0, TRUE, 0.0, 0.0);
				}
				_g_object_unref0 (b);
				_g_object_unref0 (tv);
			} else {
				FILE* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				_tmp37_ = stderr;
				_tmp38_ = SMD_LOGS_DIR;
				_tmp39_ = file;
				_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
				_tmp41_ = _tmp40_;
				fprintf (_tmp37_, "Unable to read %s\n", _tmp41_);
				_g_free0 (_tmp41_);
			}
		}
		goto __finally18;
		__catch18_g_file_error:
		{
			GError* e = NULL;
			FILE* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			GError* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp42_ = stderr;
			_tmp43_ = SMD_LOGS_DIR;
			_tmp44_ = file;
			_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
			_tmp46_ = _tmp45_;
			_tmp47_ = e;
			_tmp48_ = _tmp47_->message;
			fprintf (_tmp42_, "Unable to read %s: %s\n", _tmp46_, _tmp48_);
			_g_free0 (_tmp46_);
			_g_error_free0 (e);
		}
		__finally18:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (content);
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
		_g_free0 (file);
	}
}


static gboolean _smd_applet_eat_event_gsource_func (gpointer self) {
	gboolean result;
	result = smd_applet_eat_event ((smdApplet*) self);
	return result;
}


static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_prefs_event ((smdApplet*) self, event);
	return result;
}


static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_err_event ((smdApplet*) self, event);
	return result;
}


static void ___lambda17_ (smdApplet* self, NotifyNotification* n, const gchar* a) {
	GtkStatusIcon* _tmp0_ = NULL;
	g_return_if_fail (n != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = self->priv->si;
	g_signal_emit_by_name (_tmp0_, "activate");
}


static void ____lambda17__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	___lambda17_ ((smdApplet*) self, notification, action);
}


void smd_applet_start (smdApplet* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GThread* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _smd_applet_eat_event_gsource_func, g_object_ref (self), g_object_unref);
	_tmp0_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp0_) {
		smd_applet_start_smdThread (self, FALSE);
	} else {
		self->priv->config_wait_mode = TRUE;
	}
	_tmp1_ = self->priv->win;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "delete-event", (GCallback) _smd_applet_close_prefs_event_gtk_widget_delete_event, self, 0);
	_tmp2_ = self->priv->err_win;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "delete-event", (GCallback) _smd_applet_close_err_event_gtk_widget_delete_event, self, 0);
	_tmp3_ = self->priv->config_wait_mode;
	if (_tmp3_) {
		GtkStatusIcon* _tmp5_ = NULL;
		GtkStatusIcon* _tmp6_ = NULL;
		GtkStatusIcon* _tmp7_ = NULL;
		NotifyNotification* _tmp9_ = NULL;
		NotifyNotification* _tmp10_ = NULL;
		GVariant* _tmp11_ = NULL;
		GVariant* _tmp12_ = NULL;
		NotifyNotification* _tmp13_ = NULL;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = gtk_events_pending ();
			if (!_tmp4_) {
				break;
			}
			gtk_main_iteration ();
		}
		_tmp5_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp5_, FALSE);
		sleep ((guint) 5);
		_tmp6_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp6_, TRUE);
		_tmp7_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp7_, "error");
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = gtk_events_pending ();
			if (!_tmp8_) {
				break;
			}
			gtk_main_iteration ();
		}
		_tmp9_ = notify_notification_new ("Syncmaildir", "Syncmaildir is not configured properly.", "dialog-error");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp9_;
		_tmp10_ = self->priv->notification;
		_tmp11_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		notify_notification_set_hint (_tmp10_, "transient", _tmp12_);
		_g_variant_unref0 (_tmp12_);
		_tmp13_ = self->priv->notification;
		notify_notification_add_action (_tmp13_, "configure", "Configure now", ____lambda17__notify_action_callback, g_object_ref (self), g_object_unref);
		{
			NotifyNotification* _tmp14_ = NULL;
			_tmp14_ = self->priv->notification;
			notify_notification_show (_tmp14_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch19_g_error;
			}
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
			FILE* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = stderr;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			fprintf (_tmp15_, "%s\n", _tmp17_);
			_g_error_free0 (e);
		}
		__finally19:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	g_application_run ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), 0, NULL);
	_tmp18_ = self->priv->thread;
	if (_tmp18_ != NULL) {
		GThread* _tmp19_ = NULL;
		GThread* _tmp20_ = NULL;
		_tmp19_ = self->priv->thread;
		_tmp20_ = _g_thread_ref0 (_tmp19_);
		g_thread_join (_tmp20_);
	}
}


static void smd_applet_class_init (smdAppletClass * klass) {
	gchar* _tmp0_ = NULL;
	smd_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (smdAppletPrivate));
	G_OBJECT_CLASS (klass)->finalize = smd_applet_finalize;
	_tmp0_ = g_strdup ("\n" \
"\t<interface>\n" \
"\t  <menu id='app-menu'>\n" \
"\t    <section>\n" \
"\t      <item>\n" \
"\t        <attribute name='label' translatable='yes'>_Quit</attribute>" \
"\n" \
"\t        <attribute name='action'>app.quit</attribute>\n" \
"\t      </item>\n" \
"\t    </section>\n" \
"\t  </menu>\n" \
"\t</interface>\n" \
"\t");
	smd_applet_menu_ui = _tmp0_;
}


static void smd_applet_instance_init (smdApplet * self) {
	self->priv = SMD_APPLET_GET_PRIVATE (self);
	self->priv->builder = NULL;
	self->priv->si = NULL;
	self->priv->win = NULL;
	self->priv->err_win = NULL;
	self->priv->notebook = NULL;
	self->priv->sync_active = NULL;
	self->priv->cblogs = NULL;
	self->priv->lognames = NULL;
	self->priv->settings = NULL;
	self->priv->thread = NULL;
	self->priv->thread_die = FALSE;
	g_mutex_init (&self->priv->events_lock);
	self->priv->events = NULL;
	self->priv->error_mode = FALSE;
	self->priv->network_error_mode = FALSE;
	self->priv->command_hash = NULL;
	self->priv->net_manager = NULL;
	self->priv->notification = NULL;
	self->priv->notification_server_has_persistence = FALSE;
}


static void smd_applet_finalize (GObject* obj) {
	smdApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SMD_APPLET, smdApplet);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->si);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->err_win);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->sync_active);
	_g_object_unref0 (self->priv->cblogs);
	_g_object_unref0 (self->priv->lognames);
	_g_object_unref0 (self->priv->settings);
	_g_thread_unref0 (self->priv->thread);
	_vala_clear_GMutex (&self->priv->events_lock);
	_g_object_unref0 (self->priv->events);
	_g_hash_table_unref0 (self->priv->command_hash);
	_g_object_unref0 (self->priv->net_manager);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (smd_applet_parent_class)->finalize (obj);
}


GType smd_applet_get_type (void) {
	static volatile gsize smd_applet_type_id__volatile = 0;
	if (g_once_init_enter (&smd_applet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (smdAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) smd_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (smdApplet), 0, (GInstanceInitFunc) smd_applet_instance_init, NULL };
		GType smd_applet_type_id;
		smd_applet_type_id = g_type_register_static (gtk_application_get_type (), "smdApplet", &g_define_type_info, 0);
		g_once_init_leave (&smd_applet_type_id__volatile, smd_applet_type_id);
	}
	return smd_applet_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* PREFIX = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gchar* homedir = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* conf_home = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GOptionEntry* oe = NULL;
	GOptionEntry _tmp46_ = {0};
	GOptionEntry _tmp47_ = {0};
	GOptionEntry _tmp48_ = {0};
	GOptionEntry* _tmp49_ = NULL;
	gint oe_length1 = 0;
	gint _oe_size_ = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp50_ = NULL;
	GOptionContext* _tmp51_ = NULL;
	GOptionEntry* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup (SMD_CONF_PREFIX);
	PREFIX = _tmp0_;
	_tmp1_ = PREFIX;
	_tmp2_ = g_strconcat (_tmp1_, SMD_APPLET_UI, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	_tmp5_ = !_tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		FILE* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		FILE* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		FILE* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = PREFIX;
		fprintf (_tmp6_, "error: file not found: %s + %s\n", _tmp7_, SMD_APPLET_UI);
		_tmp8_ = g_strdup ("./smd-loop");
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp8_;
		_tmp9_ = stderr;
		_tmp10_ = smd_applet_smd_loop_cmd;
		fprintf (_tmp9_, "smd-applet not installed, " "assuming smd-loop is: %s\n", _tmp10_);
		_tmp11_ = g_strdup ("./smd-applet.ui");
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp11_;
		_tmp12_ = stderr;
		_tmp13_ = smd_applet_smd_applet_ui;
		fprintf (_tmp12_, "smd-applet not installed, " "assuming smd-applet.ui is: %s\n", _tmp13_);
		_tmp14_ = g_strdup ("./smd-push");
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp14_;
		_tmp15_ = stderr;
		_tmp16_ = smd_applet_smd_push_cmd;
		fprintf (_tmp15_, "smd-applet not installed, " "assuming smd-push is: %s\n", _tmp16_);
		_tmp17_ = g_strdup ("./smd-applet.desktop");
		_g_free0 (smd_applet_smd_applet_desktop);
		smd_applet_smd_applet_desktop = _tmp17_;
		_tmp18_ = stderr;
		_tmp19_ = smd_applet_smd_applet_desktop;
		fprintf (_tmp18_, "smd-applet not installed, " "assuming smd-applet.desktop is: %s\n", _tmp19_);
	} else {
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		_tmp20_ = PREFIX;
		_tmp21_ = g_strconcat (_tmp20_, SMD_LOOP, NULL);
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp21_;
		_tmp22_ = PREFIX;
		_tmp23_ = g_strconcat (_tmp22_, SMD_PUSH, NULL);
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp23_;
		_tmp24_ = PREFIX;
		_tmp25_ = g_strconcat (_tmp24_, SMD_APPLET_UI, NULL);
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp25_;
		_tmp26_ = PREFIX;
		_tmp27_ = g_strconcat (_tmp26_, SMD_APPLET_DESKTOP, NULL);
		_g_free0 (smd_applet_smd_applet_desktop);
		smd_applet_smd_applet_desktop = _tmp27_;
	}
	_tmp28_ = g_get_home_dir ();
	_tmp29_ = g_strdup (_tmp28_);
	homedir = _tmp29_;
	_tmp30_ = homedir;
	_tmp31_ = g_strconcat (_tmp30_, "/.smd/log/", NULL);
	_g_free0 (SMD_LOGS_DIR);
	SMD_LOGS_DIR = _tmp31_;
	_tmp32_ = homedir;
	_tmp33_ = g_strconcat (_tmp32_, "/.smd/loop", NULL);
	_g_free0 (SMD_LOOP_CFG);
	SMD_LOOP_CFG = _tmp33_;
	_tmp34_ = homedir;
	_tmp35_ = g_strconcat (_tmp34_, "/.smd/config.default", NULL);
	_g_free0 (SMD_PP_DEF_CFG);
	SMD_PP_DEF_CFG = _tmp35_;
	_tmp36_ = g_getenv ("XDG_CONFIG_HOME");
	_tmp37_ = g_strdup (_tmp36_);
	conf_home = _tmp37_;
	_tmp38_ = conf_home;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp39_ = conf_home;
		_tmp40_ = g_strconcat (_tmp39_, "/autostart/smd-applet.desktop", NULL);
		_g_free0 (XDG_AUTORUN_FILE);
		XDG_AUTORUN_FILE = _tmp40_;
	} else {
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		_tmp41_ = homedir;
		_tmp42_ = g_strconcat (_tmp41_, "/.config/autostart/smd-applet.desktop", NULL);
		_g_free0 (XDG_AUTORUN_FILE);
		XDG_AUTORUN_FILE = _tmp42_;
	}
	_tmp43_ = XDG_AUTORUN_FILE;
	_tmp44_ = g_path_get_dirname (_tmp43_);
	_tmp45_ = _tmp44_;
	g_mkdir_with_parents (_tmp45_, 0700);
	_g_free0 (_tmp45_);
	gtk_init (&args_length1, &args);
	notify_init ("smd-applet");
	memset (&_tmp46_, 0, sizeof (GOptionEntry));
	_tmp46_.long_name = "verbose";
	_tmp46_.short_name = 'v';
	_tmp46_.flags = 0;
	_tmp46_.arg = G_OPTION_ARG_NONE;
	_tmp46_.arg_data = &verbose;
	_tmp46_.description = "verbose output, for debugging only";
	_tmp46_.arg_description = NULL;
	memset (&_tmp47_, 0, sizeof (GOptionEntry));
	_tmp47_.long_name = "smd-loop";
	_tmp47_.short_name = 'l';
	_tmp47_.flags = 0;
	_tmp47_.arg = G_OPTION_ARG_STRING;
	_tmp47_.arg_data = &smd_applet_smd_loop_cmd;
	_tmp47_.description = "override smd-loop command name, debugging only";
	_tmp47_.arg_description = "program";
	memset (&_tmp48_, 0, sizeof (GOptionEntry));
	_tmp48_.long_name = NULL;
	_tmp49_ = g_new0 (GOptionEntry, 3);
	_tmp49_[0] = _tmp46_;
	_tmp49_[1] = _tmp47_;
	_tmp49_[2] = _tmp48_;
	oe = _tmp49_;
	oe_length1 = 3;
	_oe_size_ = oe_length1;
	_tmp50_ = g_option_context_new (" - syncmaildir applet");
	oc = _tmp50_;
	_tmp51_ = oc;
	_tmp52_ = oe;
	_tmp52__length1 = oe_length1;
	g_option_context_add_main_entries (_tmp51_, _tmp52_, NULL);
	{
		GOptionContext* _tmp53_ = NULL;
		_tmp53_ = oc;
		g_option_context_parse (_tmp53_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch20_g_option_error;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally20;
	__catch20_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp54_ = NULL;
		GError* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp54_ = stderr;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		fprintf (_tmp54_, "%s\n", _tmp56_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		smdApplet* smd_applet = NULL;
		smdApplet* _tmp57_ = NULL;
		smdApplet* _tmp58_ = NULL;
		_tmp57_ = smd_applet_new (&_inner_error_);
		smd_applet = _tmp57_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == EXIT) {
				goto __catch21_exit;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp58_ = smd_applet;
		smd_applet_start (_tmp58_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (smd_applet);
			if (_inner_error_->domain == EXIT) {
				goto __catch21_exit;
			}
			_g_object_unref0 (smd_applet);
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (smd_applet);
	}
	goto __finally21;
	__catch21_exit:
	{
		GError* e = NULL;
		FILE* _tmp59_ = NULL;
		GError* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp59_ = stderr;
		_tmp60_ = e;
		_tmp61_ = _tmp60_->message;
		fprintf (_tmp59_, "abort: %s\n", _tmp61_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (oc);
	oe = (g_free (oe), NULL);
	_g_free0 (conf_home);
	_g_free0 (homedir);
	_g_free0 (PREFIX);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,32,0)
	g_thread_init (NULL);
#endif
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



