/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef _SC_QSUPPORTALGORITHMS_H
#define _SC_QSUPPORTALGORITHMS_H

namespace sc
{

/**
 * Predicate based lowerBound, based on Qt4 qLowerBound. @a C could look
 * like this:
 * 
 *  class equal
 *  {
 *  public:
 *    bool operator()( T item, V value )
 *    {
 *      return item->attribute() < value;
 *    }
 *  };
 *
 *
 * The container must be sorted by attribute()!
 */
template< typename T, typename V, typename C > T lowerBound( T begin, T end, V v, C c )
{
  T middle;
  int n = end - begin;
  int half;

  while( n > 0 )
  {
    half   = n >> 1;
    middle = begin + half;

    if( c(*middle,v) )
    {
      begin = middle + 1;
      n    -= half + 1;
    }
    else
    {
      n = half;
    }
  }
  return begin;
}

/**
 * Predicate based binaryBound, based on Qt4 qBinaryFind. @a C could look
 * like this:
 * 
 *  class equal
 *  {
 *  public:
 *    bool operator()( T item, V value )
 *    {
 *      return item->attribute() < value;
 *    }
 *
 *    bool operator()( V attr, T item )
 *    {
 *      return value < item->attribute();
 *    }
 *  };
 *
 *
 * The container must be sorted by attribute()!
 */

template< typename T, typename V, typename C > T binaryFind( T begin, T end, V v, C c ) 
{
  int l = 0;
  int r = end - begin - 1;
  if( r < 0 )
    return end;
  int i = (l + r + 1) / 2;

  while( r != l )
  {
    if( c(v,begin[i]) )
      r = i - 1;
    else
      l = i;
    i = (l + r + 1) / 2;
  }
  if ( c(begin[i],v) || c(v,begin[i]) )
    return end;
  else
    return begin + i;
}


} // namespace

#endif // _SC_QSUPPORTALGORITHMS_H
