/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ADDCMD_H
#define _SC_ADDCMD_H

// sc
#include "ScCmd.h"
class AddParam;
class CmdResultCallback;


/**
 * Command for adding files or dirs to a working copy.
 */
class AddCmd : public ScCmd
{
public:
  /**
   * Construct an AddCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  AddCmd( AddParam* param, CmdResultCallback* cb );
  ~AddCmd();

  void run();

private:
  // in
  AddParam*          _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_ADDCMD_H
