/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.nxg.unity.SimpleUnit;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitRepresentation;

public class SimpleDecimalUnit
extends SimpleUnit {
    private static final Pattern unitWithPrefix = Pattern.compile("(da|[qryzafpnumcdhkMGTPEZYRQ])(.+)");
    private final boolean unitWasGuessed;

    SimpleDecimalUnit(UnitDefinitionMap.Resolver resolver, int n, String string, UnitDefinition unitDefinition, float f) {
        super(resolver, n, string, unitDefinition, f, false);
        this.unitWasGuessed = false;
    }

    SimpleDecimalUnit(UnitDefinitionMap.Resolver resolver, int n, String string, UnitDefinition unitDefinition, float f, boolean bl, boolean bl2) {
        super(resolver, n, string, unitDefinition, f, bl);
        this.unitWasGuessed = bl2;
    }

    @Override
    SimpleDecimalUnit reciprocate() {
        return new SimpleDecimalUnit(this.getUnitResolver(), this.getPrefix(), this.getBaseUnitString(), this.getBaseUnitDefinition(), -this.getExponent(), this.isQuoted(), this.unitWasGuessed);
    }

    @Override
    SimpleDecimalUnit pow(double d) {
        return new SimpleDecimalUnit(this.getUnitResolver(), this.getPrefix(), this.getBaseUnitString(), this.getBaseUnitDefinition(), (float)d, this.isQuoted(), this.unitWasGuessed);
    }

    @Override
    boolean hasPermittedPrefix(UnitRepresentation unitRepresentation) {
        return this.getPrefix() == 0 || unitRepresentation.mayHaveSIPrefixes();
    }

    @Override
    public boolean wasGuessed() {
        return this.unitWasGuessed;
    }

    static SimpleUnit.PrefixSplit splitUnitString(String string) {
        final Matcher matcher = unitWithPrefix.matcher(string);
        if (matcher.matches()) {
            int n;
            char c = matcher.group(1).equals("da") ? (char)'\u0001' : (char)matcher.group(1).charAt(0);
            switch (c) {
                case 'q': {
                    n = -30;
                    break;
                }
                case 'r': {
                    n = -27;
                    break;
                }
                case 'y': {
                    n = -24;
                    break;
                }
                case 'z': {
                    n = -21;
                    break;
                }
                case 'a': {
                    n = -18;
                    break;
                }
                case 'f': {
                    n = -15;
                    break;
                }
                case 'p': {
                    n = -12;
                    break;
                }
                case 'n': {
                    n = -9;
                    break;
                }
                case 'u': {
                    n = -6;
                    break;
                }
                case 'm': {
                    n = -3;
                    break;
                }
                case 'c': {
                    n = -2;
                    break;
                }
                case 'd': {
                    n = -1;
                    break;
                }
                case '\u0001': {
                    n = 1;
                    break;
                }
                case 'h': {
                    n = 2;
                    break;
                }
                case 'k': {
                    n = 3;
                    break;
                }
                case 'M': {
                    n = 6;
                    break;
                }
                case 'G': {
                    n = 9;
                    break;
                }
                case 'T': {
                    n = 12;
                    break;
                }
                case 'P': {
                    n = 15;
                    break;
                }
                case 'E': {
                    n = 18;
                    break;
                }
                case 'Z': {
                    n = 21;
                    break;
                }
                case 'Y': {
                    n = 24;
                    break;
                }
                case 'R': {
                    n = 27;
                    break;
                }
                case 'Q': {
                    n = 30;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Impossible decimal prefix: '" + c + "'"));
                }
            }
            final int n2 = n;
            return new SimpleUnit.PrefixSplit(){

                @Override
                public int getPower() {
                    return n2;
                }

                @Override
                public boolean isBinaryPrefix() {
                    return false;
                }

                @Override
                public String getUnit() {
                    return matcher.group(2);
                }
            };
        }
        return null;
    }

    @Override
    String prefixPowerToString() {
        String string;
        switch (this.getPrefix()) {
            case -30: {
                string = "q";
                break;
            }
            case -27: {
                string = "r";
                break;
            }
            case -24: {
                string = "y";
                break;
            }
            case -21: {
                string = "z";
                break;
            }
            case -18: {
                string = "a";
                break;
            }
            case -15: {
                string = "f";
                break;
            }
            case -12: {
                string = "p";
                break;
            }
            case -9: {
                string = "n";
                break;
            }
            case -6: {
                string = "u";
                break;
            }
            case -3: {
                string = "m";
                break;
            }
            case -2: {
                string = "c";
                break;
            }
            case -1: {
                string = "d";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "da";
                break;
            }
            case 2: {
                string = "h";
                break;
            }
            case 3: {
                string = "k";
                break;
            }
            case 6: {
                string = "M";
                break;
            }
            case 9: {
                string = "G";
                break;
            }
            case 12: {
                string = "T";
                break;
            }
            case 15: {
                string = "P";
                break;
            }
            case 18: {
                string = "E";
                break;
            }
            case 21: {
                string = "Z";
                break;
            }
            case 24: {
                string = "Y";
                break;
            }
            case 27: {
                string = "R";
                break;
            }
            case 30: {
                string = "Q";
                break;
            }
            default: {
                throw new AssertionError((Object)("Impossible decimal prefix power: " + this.getPrefix()));
            }
        }
        return string;
    }

    @Override
    String prefixPowerToStringLaTeX() {
        String string;
        switch (this.getPrefix()) {
            case -30: {
                string = "\\quecto";
                break;
            }
            case -27: {
                string = "\\ronto";
                break;
            }
            case -24: {
                string = "\\yocto";
                break;
            }
            case -21: {
                string = "\\zepto";
                break;
            }
            case -18: {
                string = "\\atto";
                break;
            }
            case -15: {
                string = "\\femto";
                break;
            }
            case -12: {
                string = "\\pico";
                break;
            }
            case -9: {
                string = "\\nano";
                break;
            }
            case -6: {
                string = "\\micro";
                break;
            }
            case -3: {
                string = "\\milli";
                break;
            }
            case -2: {
                string = "\\centi";
                break;
            }
            case -1: {
                string = "\\deci";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = "\\deca";
                break;
            }
            case 2: {
                string = "\\hecto";
                break;
            }
            case 3: {
                string = "\\kilo";
                break;
            }
            case 6: {
                string = "\\mega";
                break;
            }
            case 9: {
                string = "\\giga";
                break;
            }
            case 12: {
                string = "\\tera";
                break;
            }
            case 15: {
                string = "\\peta";
                break;
            }
            case 18: {
                string = "\\exa";
                break;
            }
            case 21: {
                string = "\\zetta";
                break;
            }
            case 24: {
                string = "\\yotta";
                break;
            }
            case 27: {
                string = "\\ronna";
                break;
            }
            case 30: {
                string = "\\quetta";
                break;
            }
            default: {
                throw new AssertionError((Object)("Impossible decimal prefix power: " + this.getPrefix()));
            }
        }
        return string;
    }
}

