/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_10 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 3036, "epsg", 3036,
        "Moznet / UTM zone 36S");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=WGS84 +towgs84=0,0,0,-0");
    add_proj4text (p, 1,
        ",-0,-0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Moznet / UTM zone 36S\",GEOGCS[\"Moznet\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Moznet_ITRF94\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,-0,-0,-");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6130\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4130\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"3036\"]]");
    p = add_epsg_def (filter, first, last, 3037, "epsg", 3037,
        "Moznet / UTM zone 37S");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=WGS84 +towgs84=0,0,0,-0");
    add_proj4text (p, 1,
        ",-0,-0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Moznet / UTM zone 37S\",GEOGCS[\"Moznet\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Moznet_ITRF94\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,-0,-0,-");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6130\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4130\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"3037\"]]");
    p = add_epsg_def (filter, first, last, 3038, "epsg", 3038,
        "ETRS89 / TM26");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM26\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-27],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3038\"]]");
    p = add_epsg_def (filter, first, last, 3039, "epsg", 3039,
        "ETRS89 / TM27");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM27\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-21],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3039\"]]");
    p = add_epsg_def (filter, first, last, 3040, "epsg", 3040,
        "ETRS89 / TM28");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM28\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3040\"]]");
    p = add_epsg_def (filter, first, last, 3041, "epsg", 3041,
        "ETRS89 / TM29");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM29\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-9],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3041\"]]");
    p = add_epsg_def (filter, first, last, 3042, "epsg", 3042,
        "ETRS89 / TM30");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM30\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-3],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3042\"]]");
    p = add_epsg_def (filter, first, last, 3043, "epsg", 3043,
        "ETRS89 / TM31");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM31\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",3],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3043\"]]");
    p = add_epsg_def (filter, first, last, 3044, "epsg", 3044,
        "ETRS89 / TM32");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM32\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",9],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3044\"]]");
    p = add_epsg_def (filter, first, last, 3045, "epsg", 3045,
        "ETRS89 / TM33");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM33\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3045\"]]");
    p = add_epsg_def (filter, first, last, 3046, "epsg", 3046,
        "ETRS89 / TM34");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM34\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",21],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3046\"]]");
    p = add_epsg_def (filter, first, last, 3047, "epsg", 3047,
        "ETRS89 / TM35");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM35\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",27],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3047\"]]");
    p = add_epsg_def (filter, first, last, 3048, "epsg", 3048,
        "ETRS89 / TM36");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM36\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",33],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3048\"]]");
    p = add_epsg_def (filter, first, last, 3049, "epsg", 3049,
        "ETRS89 / TM37");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM37\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",39],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3049\"]]");
    p = add_epsg_def (filter, first, last, 3050, "epsg", 3050,
        "ETRS89 / TM38");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM38\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",45],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3050\"]]");
    p = add_epsg_def (filter, first, last, 3051, "epsg", 3051,
        "ETRS89 / TM39");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM39\",GEOGCS[\"ETRS89\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",51],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3051\"]]");
    p = add_epsg_def (filter, first, last, 3054, "epsg", 3054,
        "Hjorsey 1955 / UTM zone 26N");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=intl +towgs84=-73,46,-86,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hjorsey 1955 / UTM zone 26N\",GEOGCS[\"Hjorsey ");
    add_srs_wkt (p, 1,
        "1955\",DATUM[\"Hjorsey_1955\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-73,46,-86,0,0,0,0],AUTHORITY[\"EPSG\",\"6658\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4658\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-27],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3054\"]]");
    p = add_epsg_def (filter, first, last, 3055, "epsg", 3055,
        "Hjorsey 1955 / UTM zone 27N");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=intl +towgs84=-73,46,-86,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hjorsey 1955 / UTM zone 27N\",GEOGCS[\"Hjorsey ");
    add_srs_wkt (p, 1,
        "1955\",DATUM[\"Hjorsey_1955\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-73,46,-86,0,0,0,0],AUTHORITY[\"EPSG\",\"6658\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4658\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-21],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3055\"]]");
    p = add_epsg_def (filter, first, last, 3056, "epsg", 3056,
        "Hjorsey 1955 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-73,46,-86,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hjorsey 1955 / UTM zone 28N\",GEOGCS[\"Hjorsey ");
    add_srs_wkt (p, 1,
        "1955\",DATUM[\"Hjorsey_1955\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-73,46,-86,0,0,0,0],AUTHORITY[\"EPSG\",\"6658\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4658\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-15],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3056\"]]");
    p = add_epsg_def (filter, first, last, 3057, "epsg", 3057,
        "ISN93 / Lambert 1993");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19");
    add_proj4text (p, 1,
        " +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN93 / Lambert 1993\",GEOGCS[\"ISN93\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Islands_Net_1993\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"6659\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4659\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",64.25],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "tandard_parallel_2\",65.75],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",65],PARAMETER[\"central_meridian\",-19],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",500");
    add_srs_wkt (p, 11,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3057");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 3058, "epsg", 3058,
        "Helle 1954 / Jan Mayen Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-8.5 +k=1 +x_0=50000 +y_0=-7");
    add_proj4text (p, 1,
        "800000 +ellps=intl +towgs84=982.609,552.753,-540.873,6.6");
    add_proj4text (p, 2,
        "8163,-31.6115,-19.8482,16.805 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Helle 1954 / Jan Mayen Grid\",GEOGCS[\"Helle 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Helle_1954\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[982.6");
    add_srs_wkt (p, 3,
        "09,552.753,-540.873,6.68163,-31.6115,-19.8482,16.805],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6660\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "660\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "8.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",50000],PARAMETER[\"false_northing\",-7800000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"3058\"]]");
    p = add_epsg_def (filter, first, last, 3059, "epsg", 3059,
        "LKS92 / Latvia TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LKS92 / Latvia TM\",GEOGCS[\"LKS92\",DATUM[\"La");
    add_srs_wkt (p, 1,
        "tvia_1992\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6661\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 6,
        "61\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",24");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",-6000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3059\"]]");
    p = add_epsg_def (filter, first, last, 3060, "epsg", 3060,
        "IGN72 Grande Terre / UTM zone 58S");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=intl +towgs84=-11.64,-3");
    add_proj4text (p, 1,
        "48.6,291.98,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN72 Grande Terre / UTM zone 58S\",GEOGCS[\"IG");
    add_srs_wkt (p, 1,
        "N72 Grande Terre\",DATUM[\"IGN72_Grande_Terre\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[-11.64,-348.6,291.98,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6634\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4662\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",165],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",10000000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "060\"]]");
    p = add_epsg_def (filter, first, last, 3061, "epsg", 3061,
        "Porto Santo 1995 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-502.862,-247.43");
    add_proj4text (p, 1,
        "8,312.724,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Porto Santo 1995 / UTM zone 28N\",GEOGCS[\"Port");
    add_srs_wkt (p, 1,
        "o Santo 1995\",DATUM[\"Porto_Santo_1995\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-502.862,-247.438,312.724,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6663\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4663\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-15],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3061\"]]");
    p = add_epsg_def (filter, first, last, 3062, "epsg", 3062,
        "Azores Oriental 1995 / UTM zone 26N");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=intl +towgs84=-204.619,140.176");
    add_proj4text (p, 1,
        ",55.226,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Azores Oriental 1995 / UTM zone 26N\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Azores Oriental 1995\",DATUM[\"Azores_Oriental_Islands_1");
    add_srs_wkt (p, 2,
        "995\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7022\"]],TOWGS84[-204.619,140.176,55.226,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6664\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4664\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-27],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"3062\"]]");
    p = add_epsg_def (filter, first, last, 3063, "epsg", 3063,
        "Azores Central 1995 / UTM zone 26N");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=intl +towgs84=-106.226,166.366");
    add_proj4text (p, 1,
        ",-37.893,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Azores Central 1995 / UTM zone 26N\",GEOGCS[\"A");
    add_srs_wkt (p, 1,
        "zores Central 1995\",DATUM[\"Azores_Central_Islands_1995");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7022\"]],TOWGS84[-106.226,166.366,-37.893,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6665\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4665\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3063\"]]");
    p = add_epsg_def (filter, first, last, 3064, "epsg", 3064,
        "IGM95 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGM95 / UTM zone 32N\",GEOGCS[\"IGM95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Istituto_Geografico_Militaire_1995\",SPHEROID[\"WGS 84\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6670\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4670\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",9],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"3064\"]]");
    p = add_epsg_def (filter, first, last, 3065, "epsg", 3065,
        "IGM95 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGM95 / UTM zone 33N\",GEOGCS[\"IGM95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Istituto_Geografico_Militaire_1995\",SPHEROID[\"WGS 84\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6670\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4670\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",15],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3065\"]]");
    p = add_epsg_def (filter, first, last, 3066, "epsg", 3066,
        "ED50 / Jordan TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=37 +k=0.9998 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-3000000 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / Jordan TM\",GEOGCS[\"ED50\",DATUM[\"Euro");
    add_srs_wkt (p, 1,
        "pean_Datum_1950\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",37],PARAMETER[\"scale_factor\",0.9998],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",-3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"3066\"]]");
    p = add_epsg_def (filter, first, last, 3067, "epsg", 3067,
        "ETRS89 / TM35FIN(E,N)");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM35FIN(E,N)\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3067\"]]");
    p = add_epsg_def (filter, first, last, 3068, "epsg", 3068,
        "DHDN / Soldner Berlin");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=52.41864827777778 +lon_0=13.6272036666");
    add_proj4text (p, 1,
        "6667 +x_0=40000 +y_0=10000 +datum=potsdam +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / Soldner Berlin\",GEOGCS[\"DHDN\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[598.1,73.7,418.2,0.202,0.045,-2.455,6.7],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 8,
        "origin\",52.41864827777778],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",13.62720366666667],PARAMETER[\"false_easting\",40000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",10000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"3068\"]]");
    p = add_epsg_def (filter, first, last, 3069, "epsg", 3069,
        "NAD27 / Wisconsin Transverse Mercator");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=-4500000 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin Transverse Mercator\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-90],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",-4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"3069\"]]");
    p = add_epsg_def (filter, first, last, 3070, "epsg", 3070,
        "NAD83 / Wisconsin Transverse Mercator");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y");
    add_proj4text (p, 1,
        "_0=-4480000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin Transverse Mercator\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-90],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",520000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",-4480000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"3070\"]]");
    p = add_epsg_def (filter, first, last, 3071, "epsg", 3071,
        "NAD83(HARN) / Wisconsin Transverse Mercator");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y");
    add_proj4text (p, 1,
        "_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin Transverse Mercator\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refere");
    add_srs_wkt (p, 2,
        "nce_Network\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "90],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",520000],PARAMETER[\"false_northing\",-4480000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3071\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3072, "epsg", 3072,
        "NAD83 / Maine CS2000 East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0");
    add_proj4text (p, 1,
        ".99998 +x_0=700000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine CS2000 East\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",43.83333333333");
    add_srs_wkt (p, 8,
        "334],PARAMETER[\"central_meridian\",-67.875],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99998],PARAMETER[\"false_easting\",7000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"3072\"]]");
    p = add_epsg_def (filter, first, last, 3073, "epsg", 3073,
        "NAD83 / Maine CS2000 Central (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500");
    add_proj4text (p, 1,
        "000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine CS2000 Central (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43],PARAMETER[\"central_meridian\",-69.125],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99998],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"3073\"]]");
    p = add_epsg_def (filter, first, last, 3074, "epsg", 3074,
        "NAD83 / Maine CS2000 West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0");
    add_proj4text (p, 1,
        ".99998 +x_0=300000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine CS2000 West\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",42.83333333333");
    add_srs_wkt (p, 8,
        "334],PARAMETER[\"central_meridian\",-70.375],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99998],PARAMETER[\"false_easting\",3000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"3074\"]]");
    p = add_epsg_def (filter, first, last, 3075, "epsg", 3075,
        "NAD83(HARN) / Maine CS2000 East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0");
    add_proj4text (p, 1,
        ".99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine CS2000 East\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",43.83333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-67.875],PARAMETER[\"scale_factor\",0.99998],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",700000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3075\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3076, "epsg", 3076,
        "NAD83(HARN) / Maine CS2000 Central (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500");
    add_proj4text (p, 1,
        "000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine CS2000 Central (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Re");
    add_srs_wkt (p, 2,
        "ference_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",43],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-69.125],PARAMETER[\"scale_factor\",0.99998],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3076\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 3077, "epsg", 3077,
        "NAD83(HARN) / Maine CS2000 West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0");
    add_proj4text (p, 1,
        ".99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine CS2000 West\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",42.83333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-70.375],PARAMETER[\"scale_factor\",0.99998],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",300000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3077\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3078, "epsg", 3078,
        "NAD83 / Michigan Oblique Mercator");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=33");
    add_proj4text (p, 1,
        "7.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +ga");
    add_proj4text (p, 2,
        "mma=337.25556 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan Oblique Mercator\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Hotine_");
    add_srs_wkt (p, 7,
        "Oblique_Mercator\"],PARAMETER[\"latitude_of_center\",45.");
    add_srs_wkt (p, 8,
        "30916666666666],PARAMETER[\"longitude_of_center\",-86],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"azimuth\",337.25556],PARAMETER[\"rectified_gr");
    add_srs_wkt (p, 10,
        "id_angle\",337.25556],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",2546731.496],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",-4354009.816],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"3078\"]]");
    p = add_epsg_def (filter, first, last, 3079, "epsg", 3079,
        "NAD83(HARN) / Michigan Oblique Mercator");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=33");
    add_proj4text (p, 1,
        "7.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +ga");
    add_proj4text (p, 2,
        "mma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan Oblique Mercator\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_center\",45.30916666666666],PARAMETER[\"long");
    add_srs_wkt (p, 9,
        "itude_of_center\",-86],PARAMETER[\"azimuth\",337.25556],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"rectified_grid_angle\",337.25556],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",254");
    add_srs_wkt (p, 12,
        "6731.496],PARAMETER[\"false_northing\",-4354009.816],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3079\"]]");
    p = add_epsg_def (filter, first, last, 3080, "epsg", 3080,
        "NAD27 / Shackleford");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=914400 +y_");
    add_proj4text (p, 2,
        "0=914400 +datum=NAD27 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Shackleford\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",27.41666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",34.91666666666666],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",31.16666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-100],PARAMETER[\"false_easting\",3000");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",3000000],UNIT[\"foot\"");
    add_srs_wkt (p, 12,
        ",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3080\"]]");
    p = add_epsg_def (filter, first, last, 3081, "epsg", 3081,
        "NAD83 / Texas State Mapping System");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=1000000 +y");
    add_proj4text (p, 2,
        "_0=1000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas State Mapping System\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",27.41666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",34.91666666666666],PARAMETER[\"latitude_of_origin\",31.");
    add_srs_wkt (p, 10,
        "16666666666667],PARAMETER[\"central_meridian\",-100],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",1000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"3081\"]]");
    p = add_epsg_def (filter, first, last, 3082, "epsg", 3082,
        "NAD83 / Texas Centric Lambert Conformal");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=5000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas Centric Lambert Conformal\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"626");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",27.5],PARAMETER[\"standard_parallel_2\",35],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",18],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-100],PARAMETER[\"false_easting\",1500000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",5000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"3082\"]]");
    p = add_epsg_def (filter, first, last, 3083, "epsg", 3083,
        "NAD83 / Texas Centric Albers Equal Area");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=6000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas Centric Albers Equal Area\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"626");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"A");
    add_srs_wkt (p, 7,
        "lbers_Conic_Equal_Area\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",27.5],PARAMETER[\"standard_parallel_2\",35],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_center\",18],PARAMETER[\"longitude_of_ce");
    add_srs_wkt (p, 10,
        "nter\",-100],PARAMETER[\"false_easting\",1500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",6000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"3083\"]]");
    p = add_epsg_def (filter, first, last, 3084, "epsg", 3084,
        "NAD83(HARN) / Texas Centric Lambert Conformal");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas Centric Lambert Conformal\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refe");
    add_srs_wkt (p, 2,
        "rence_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",27.5],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",35],PARAMETER[\"latitude_of_origin\",18");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"central_meridian\",-100],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",1500000],PARAMETER[\"false_northing\",5000000");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3084\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 3085, "epsg", 3085,
        "NAD83(HARN) / Texas Centric Albers Equal Area");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas Centric Albers Equal Area\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refe");
    add_srs_wkt (p, 2,
        "rence_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4152\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",27.5],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",35],PARAMETER[\"latitude_of_center\",18],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"longitude_of_center\",-100],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",1500000],PARAMETER[\"false_northing\",6000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3085\"]]");
    p = add_epsg_def (filter, first, last, 3086, "epsg", 3086,
        "NAD83 / Florida GDL Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_");
    add_proj4text (p, 1,
        "0=400000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida GDL Albers\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_");
    add_srs_wkt (p, 7,
        "Equal_Area\"],PARAMETER[\"standard_parallel_1\",24],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",31.5],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_center\",24],PARAMETER[\"longitude_of_center\",-84],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",400000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3086\"]]");
    p = add_epsg_def (filter, first, last, 3087, "epsg", 3087,
        "NAD83(HARN) / Florida GDL Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_");
    add_proj4text (p, 1,
        "0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida GDL Albers\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",24],PARAMETER[\"standard_parallel_2\",31");
    add_srs_wkt (p, 9,
        ".5],PARAMETER[\"latitude_of_center\",24],PARAMETER[\"lon");
    add_srs_wkt (p, 10,
        "gitude_of_center\",-84],PARAMETER[\"false_easting\",4000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"3087\"]]");
    p = add_epsg_def (filter, first, last, 3088, "epsg", 3088,
        "NAD83 / Kentucky Single Zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 ");
    add_proj4text (p, 2,
        "+y_0=1000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky Single Zone\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37");
    add_srs_wkt (p, 8,
        ".08333333333334],PARAMETER[\"standard_parallel_2\",38.66");
    add_srs_wkt (p, 9,
        "666666666666],PARAMETER[\"latitude_of_origin\",36.333333");
    add_srs_wkt (p, 10,
        "33333334],PARAMETER[\"central_meridian\",-85.75],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",1500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"3088\"]]");
    p = add_epsg_def (filter, first, last, 3089, "epsg", 3089,
        "NAD83 / Kentucky Single Zone (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 ");
    add_proj4text (p, 2,
        "+y_0=999999.9998983998 +datum=NAD83 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky Single Zone (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",37.08333333333334],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",38.66666666666666],PARAMETER[\"latitude_of_origin\",36.");
    add_srs_wkt (p, 10,
        "33333333333334],PARAMETER[\"central_meridian\",-85.75],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",4921250],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",3280833.333],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3089\"]]");
    p = add_epsg_def (filter, first, last, 3090, "epsg", 3090,
        "NAD83(HARN) / Kentucky Single Zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 ");
    add_proj4text (p, 2,
        "+y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kentucky Single Zone\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",37.08333333333334],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",38.66666666666666],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",36.33333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 11,
        "ridian\",-85.75],PARAMETER[\"false_easting\",1500000],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"3090\"]]");
    p = add_epsg_def (filter, first, last, 3091, "epsg", 3091,
        "NAD83(HARN) / Kentucky Single Zone (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 ");
    add_proj4text (p, 2,
        "+y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kentucky Single Zone (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "52\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",37.08333333333334],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",38.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",36.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-85.75],PARAMETER[\"false_easting\",49212");
    add_srs_wkt (p, 12,
        "50],PARAMETER[\"false_northing\",3280833.333],UNIT[\"US ");
    add_srs_wkt (p, 13,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 15,
        "SG\",\"3091\"]]");
    p = add_epsg_def (filter, first, last, 3092, "epsg", 3092,
        "Tokyo / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=bessel +towgs84=-146.414,507.3");
    add_proj4text (p, 1,
        "37,680.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / UTM zone 51N\",GEOGCS[\"Tokyo\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.337,");
    add_srs_wkt (p, 3,
        "680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",123],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3092\"]]");
    p = add_epsg_def (filter, first, last, 3093, "epsg", 3093,
        "Tokyo / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=bessel +towgs84=-146.414,507.3");
    add_proj4text (p, 1,
        "37,680.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / UTM zone 52N\",GEOGCS[\"Tokyo\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.337,");
    add_srs_wkt (p, 3,
        "680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",129],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3093\"]]");
    p = add_epsg_def (filter, first, last, 3094, "epsg", 3094,
        "Tokyo / UTM zone 53N");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=bessel +towgs84=-146.414,507.3");
    add_proj4text (p, 1,
        "37,680.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / UTM zone 53N\",GEOGCS[\"Tokyo\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.337,");
    add_srs_wkt (p, 3,
        "680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",135],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3094\"]]");
    p = add_epsg_def (filter, first, last, 3095, "epsg", 3095,
        "Tokyo / UTM zone 54N");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=bessel +towgs84=-146.414,507.3");
    add_proj4text (p, 1,
        "37,680.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / UTM zone 54N\",GEOGCS[\"Tokyo\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.337,");
    add_srs_wkt (p, 3,
        "680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",141],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3095\"]]");
    p = add_epsg_def (filter, first, last, 3096, "epsg", 3096,
        "Tokyo / UTM zone 55N");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=bessel +towgs84=-146.414,507.3");
    add_proj4text (p, 1,
        "37,680.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / UTM zone 55N\",GEOGCS[\"Tokyo\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.337,");
    add_srs_wkt (p, 3,
        "680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",147],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3096\"]]");
    p = add_epsg_def (filter, first, last, 3097, "epsg", 3097,
        "JGD2000 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / UTM zone 51N\",GEOGCS[\"JGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2000\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",123],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3097\"]]");
    p = add_epsg_def (filter, first, last, 3098, "epsg", 3098,
        "JGD2000 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / UTM zone 52N\",GEOGCS[\"JGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2000\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",129],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3098\"]]");
    p = add_epsg_def (filter, first, last, 3099, "epsg", 3099,
        "JGD2000 / UTM zone 53N");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / UTM zone 53N\",GEOGCS[\"JGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2000\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",135],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3099\"]]");
    p = add_epsg_def (filter, first, last, 3100, "epsg", 3100,
        "JGD2000 / UTM zone 54N");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / UTM zone 54N\",GEOGCS[\"JGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2000\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",141],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3100\"]]");
    p = add_epsg_def (filter, first, last, 3101, "epsg", 3101,
        "JGD2000 / UTM zone 55N");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / UTM zone 55N\",GEOGCS[\"JGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2000\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",147],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3101\"]]");
    p = add_epsg_def (filter, first, last, 3102, "epsg", 3102,
        "American Samoa 1962 / American Samoa Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.266666666");
    add_proj4text (p, 1,
        "66667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=951");
    add_proj4text (p, 2,
        "69.31165862332 +ellps=clrk66 +towgs84=-115,118,426,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"American Samoa 1962 / American Samoa Lambert\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"American Samoa 1962\",DATUM[\"American_Samoa_19");
    add_srs_wkt (p, 2,
        "62\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898");
    add_srs_wkt (p, 3,
        "2,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[-115,118,426,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6169\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4169\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",-14.26666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-170],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",312234.65],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3102\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 3103, "epsg", 3103,
        "Mauritania 1999 / UTM zone 28N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mauritania 1999 / UTM zone 28N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Mauritania 1999\",DATUM[\"Mauritania_1999\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6681\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4681\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-15],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"3103\"]]");
    p = add_epsg_def (filter, first, last, 3104, "epsg", 3104,
        "Mauritania 1999 / UTM zone 29N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mauritania 1999 / UTM zone 29N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Mauritania 1999\",DATUM[\"Mauritania_1999\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6681\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4681\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3104\"]]");
    p = add_epsg_def (filter, first, last, 3105, "epsg", 3105,
        "Mauritania 1999 / UTM zone 30N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mauritania 1999 / UTM zone 30N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Mauritania 1999\",DATUM[\"Mauritania_1999\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6681\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4681\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-3],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3105\"]]");
    p = add_epsg_def (filter, first, last, 3106, "epsg", 3106,
        "Gulshan 303 / Bangladesh Transverse Mercator");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +a=6377276.345 +b=6356075.413140239 +towgs84=283.7,7");
    add_proj4text (p, 2,
        "35.9,261.1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Gulshan 303 / Bangladesh Transverse Mercator\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Gulshan 303\",DATUM[\"Gulshan_303\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7015\"]],TOWGS84[283.7,735.9,261.1,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6682\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4682\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",90],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3106\"]]");
    p = add_epsg_def (filter, first, last, 3107, "epsg", 3107,
        "GDA94 / SA Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-28 +lat_2=-36 +lat_0=-32 +lon_0=135 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / SA Lambert\",GEOGCS[\"GDA94\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "eocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",-28]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",-36],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",-32],PARAMETER[\"central_meridian\",135");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",1000000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"3107\"]]");
    p = add_epsg_def (filter, first, last, 3108, "epsg", 3108,
        "ETRS89 / Guernsey Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49.5 +lon_0=-2.416666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99997 +x_0=47000 +y_0=50000 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Guernsey Grid\",GEOGCS[\"ETRS89\",DATU");
    add_srs_wkt (p, 1,
        "M[\"European_Terrestrial_Reference_System_1989\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "49.5],PARAMETER[\"central_meridian\",-2.416666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.999997],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",47000],PARAMETER[\"false_northing\",50000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3108\"]]");
    p = add_epsg_def (filter, first, last, 3109, "epsg", 3109,
        "ETRS89 / Jersey Transverse Mercator");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49.225 +lon_0=-2.135 +k=0.99999990000");
    add_proj4text (p, 1,
        "00001 +x_0=40000 +y_0=70000 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Jersey Transverse Mercator\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89\",DATUM[\"European_Terrestrial_Reference_System_1");
    add_srs_wkt (p, 2,
        "989\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",49.225],PARAMETER[\"central_meridian\",-2.");
    add_srs_wkt (p, 9,
        "135],PARAMETER[\"scale_factor\",0.9999999],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",40000],PARAMETER[\"false_northing\",70000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3109\"]]");
    p = add_epsg_def (filter, first, last, 3110, "epsg", 3110,
        "AGD66 / Vicgrid66");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x");
    add_proj4text (p, 1,
        "_0=2500000 +y_0=4500000 +ellps=aust_SA +towgs84=-117.808");
    add_proj4text (p, 2,
        ",-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / Vicgrid66\",GEOGCS[\"AGD66\",DATUM[\"Au");
    add_srs_wkt (p, 1,
        "stralian_Geodetic_Datum_1966\",SPHEROID[\"Australian Nat");
    add_srs_wkt (p, 2,
        "ional Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "3\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.234");
    add_srs_wkt (p, 4,
        ",-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4202\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",-36],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-38],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",-37],PARAMETER[\"central_meridian\",145],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2500000],PARAMETER[\"false_northing\",45");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"3110\"]]");
    p = add_epsg_def (filter, first, last, 3111, "epsg", 3111,
        "GDA94 / Vicgrid94");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x");
    add_proj4text (p, 1,
        "_0=2500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / Vicgrid94\",GEOGCS[\"GDA94\",DATUM[\"Ge");
    add_srs_wkt (p, 1,
        "ocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",-36]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",-38],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",-37],PARAMETER[\"central_meridian\",145");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",2500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"3111\"]]");
    p = add_epsg_def (filter, first, last, 3112, "epsg", 3112,
        "GDA94 / Geoscience Australia Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=134 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / Geoscience Australia Lambert\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "GDA94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 8,
        "_parallel_1\",-18],PARAMETER[\"standard_parallel_2\",-36");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",134],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"3112\"]]");
    p = add_epsg_def (filter, first, last, 3113, "epsg", 3113,
        "GDA94 / BCSG02");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-28 +lon_0=153 +k=0.99999 +x_0=50000 ");
    add_proj4text (p, 1,
        "+y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / BCSG02\",GEOGCS[\"GDA94\",DATUM[\"Geoce");
    add_srs_wkt (p, 1,
        "ntric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",-28],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",153],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",50000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"3113\"]]");
    p = add_epsg_def (filter, first, last, 3114, "epsg", 3114,
        "MAGNA-SIRGAS / Colombia Far West zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-80.07750791");
    add_proj4text (p, 1,
        "666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MAGNA-SIRGAS / Colombia Far West zone\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"MAGNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacional_de_R");
    add_srs_wkt (p, 2,
        "eferencia\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6686\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 7,
        "86\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",4.596200416666666],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-80.07750791666666],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3114\"]]");
    p = add_epsg_def (filter, first, last, 3115, "epsg", 3115,
        "MAGNA-SIRGAS / Colombia West zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-77.07750791");
    add_proj4text (p, 1,
        "666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MAGNA-SIRGAS / Colombia West zone\",GEOGCS[\"MA");
    add_srs_wkt (p, 1,
        "GNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacional_de_Refer");
    add_srs_wkt (p, 2,
        "encia\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6686\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4686\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",4.596200416666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-77.07750791666666],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"3115\"]]");
    p = add_epsg_def (filter, first, last, 3116, "epsg", 3116,
        "MAGNA-SIRGAS / Colombia Bogota zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-74.07750791");
    add_proj4text (p, 1,
        "666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MAGNA-SIRGAS / Colombia Bogota zone\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "MAGNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacional_de_Ref");
    add_srs_wkt (p, 2,
        "erencia\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6686\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4686");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",4.596200416666666],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-74.07750791666666],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"3116\"]]");
    p = add_epsg_def (filter, first, last, 3117, "epsg", 3117,
        "MAGNA-SIRGAS / Colombia East Central zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-71.07750791");
    add_proj4text (p, 1,
        "666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MAGNA-SIRGAS / Colombia East Central zone\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"MAGNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacional_");
    add_srs_wkt (p, 2,
        "de_Referencia\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6686\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4686\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",4.596200416666666],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-71.07750791666666],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",1000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"3117\"]]");
    p = add_epsg_def (filter, first, last, 3118, "epsg", 3118,
        "MAGNA-SIRGAS / Colombia East zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-68.07750791");
    add_proj4text (p, 1,
        "666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MAGNA-SIRGAS / Colombia East zone\",GEOGCS[\"MA");
    add_srs_wkt (p, 1,
        "GNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacional_de_Refer");
    add_srs_wkt (p, 2,
        "encia\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6686\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4686\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",4.596200416666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-68.07750791666666],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"3118\"]]");
    p = add_epsg_def (filter, first, last, 3119, "epsg", 3119,
        "Douala 1948 / AEF west");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +");
    add_proj4text (p, 1,
        "y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Douala 1948 / AEF west\",GEOGCS[\"Douala 1948\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Douala_1948\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-206.1,");
    add_srs_wkt (p, 3,
        "-174.7,-87.7,0,0,0,0],AUTHORITY[\"EPSG\",\"6192\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4192\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",10.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3119\"]]");
    p = add_epsg_def (filter, first, last, 3120, "epsg", 3120,
        "Pulkovo 1942(58) / Poland zone I");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0");
    add_proj4text (p, 1,
        ".9998 +x_0=4637000 +y_0=5467000 +ellps=krass +towgs84=33");
    add_proj4text (p, 2,
        ".4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Poland zone I\",GEOGCS[\"Pul");
    add_srs_wkt (p, 1,
        "kovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Kra");
    add_srs_wkt (p, 2,
        "ssowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4179\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",50.625],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",21.08333333333333],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "998],PARAMETER[\"false_easting\",4637000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",5467000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"3120\"]]");
    p = add_epsg_def (filter, first, last, 3121, "epsg", 3121,
        "PRS92 / Philippines zone 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.06");
    add_proj4text (p, 2,
        "8,4.903,1.578,-1.06 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PRS92 / Philippines zone 1\",GEOGCS[\"PRS92\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Philippine_Reference_System_1992\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[-127.62,-67.24,-47.04,-3.068,4.903,1");
    add_srs_wkt (p, 4,
        ".578,-1.06],AUTHORITY[\"EPSG\",\"6683\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3121\"]]");
    p = add_epsg_def (filter, first, last, 3122, "epsg", 3122,
        "PRS92 / Philippines zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.06");
    add_proj4text (p, 2,
        "8,4.903,1.578,-1.06 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PRS92 / Philippines zone 2\",GEOGCS[\"PRS92\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Philippine_Reference_System_1992\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[-127.62,-67.24,-47.04,-3.068,4.903,1");
    add_srs_wkt (p, 4,
        ".578,-1.06],AUTHORITY[\"EPSG\",\"6683\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",119],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3122\"]]");
    p = add_epsg_def (filter, first, last, 3123, "epsg", 3123,
        "PRS92 / Philippines zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.06");
    add_proj4text (p, 2,
        "8,4.903,1.578,-1.06 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PRS92 / Philippines zone 3\",GEOGCS[\"PRS92\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Philippine_Reference_System_1992\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[-127.62,-67.24,-47.04,-3.068,4.903,1");
    add_srs_wkt (p, 4,
        ".578,-1.06],AUTHORITY[\"EPSG\",\"6683\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",121],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3123\"]]");
    p = add_epsg_def (filter, first, last, 3124, "epsg", 3124,
        "PRS92 / Philippines zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.06");
    add_proj4text (p, 2,
        "8,4.903,1.578,-1.06 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PRS92 / Philippines zone 4\",GEOGCS[\"PRS92\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Philippine_Reference_System_1992\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[-127.62,-67.24,-47.04,-3.068,4.903,1");
    add_srs_wkt (p, 4,
        ".578,-1.06],AUTHORITY[\"EPSG\",\"6683\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3124\"]]");
    p = add_epsg_def (filter, first, last, 3125, "epsg", 3125,
        "PRS92 / Philippines zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.06");
    add_proj4text (p, 2,
        "8,4.903,1.578,-1.06 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PRS92 / Philippines zone 5\",GEOGCS[\"PRS92\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Philippine_Reference_System_1992\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[-127.62,-67.24,-47.04,-3.068,4.903,1");
    add_srs_wkt (p, 4,
        ".578,-1.06],AUTHORITY[\"EPSG\",\"6683\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",125],PARAMETER[\"scale_factor\",0.99995],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3125\"]]");
    p = add_epsg_def (filter, first, last, 3126, "epsg", 3126,
        "ETRS89 / ETRS-GK19FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK19FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",19],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3126\"]]");
    p = add_epsg_def (filter, first, last, 3127, "epsg", 3127,
        "ETRS89 / ETRS-GK20FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK20FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",20],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3127\"]]");
    p = add_epsg_def (filter, first, last, 3128, "epsg", 3128,
        "ETRS89 / ETRS-GK21FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK21FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3128\"]]");
    p = add_epsg_def (filter, first, last, 3129, "epsg", 3129,
        "ETRS89 / ETRS-GK22FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK22FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",22],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3129\"]]");
    p = add_epsg_def (filter, first, last, 3130, "epsg", 3130,
        "ETRS89 / ETRS-GK23FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK23FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",23],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3130\"]]");
    p = add_epsg_def (filter, first, last, 3131, "epsg", 3131,
        "ETRS89 / ETRS-GK24FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK24FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",24],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3131\"]]");
    p = add_epsg_def (filter, first, last, 3132, "epsg", 3132,
        "ETRS89 / ETRS-GK25FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK25FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",25],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3132\"]]");
    p = add_epsg_def (filter, first, last, 3133, "epsg", 3133,
        "ETRS89 / ETRS-GK26FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK26FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",26],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3133\"]]");
    p = add_epsg_def (filter, first, last, 3134, "epsg", 3134,
        "ETRS89 / ETRS-GK27FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK27FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3134\"]]");
    p = add_epsg_def (filter, first, last, 3135, "epsg", 3135,
        "ETRS89 / ETRS-GK28FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK28FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",28],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3135\"]]");
    p = add_epsg_def (filter, first, last, 3136, "epsg", 3136,
        "ETRS89 / ETRS-GK29FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK29FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",29],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3136\"]]");
    p = add_epsg_def (filter, first, last, 3137, "epsg", 3137,
        "ETRS89 / ETRS-GK30FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK30FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",30],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3137\"]]");
    p = add_epsg_def (filter, first, last, 3138, "epsg", 3138,
        "ETRS89 / ETRS-GK31FIN");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / ETRS-GK31FIN\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",31],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"3138\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

