-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;
with StringList;

--# inherit E_Strings,
--#         StringList;

package SparkMakeDebug is

   procedure Report_Text (Text : in String);
   --# derives null from Text;

   procedure Report_Text_E_Text (Text   : in String;
                                 E_Text : in E_Strings.T);
   --# derives null from E_Text,
   --#                   Text;

   procedure Report_List (Text : in String;
                          List : in StringList.Object);
   --# derives null from List,
   --#                   Text;

   procedure Report_Cond_Text (Cond       : in Boolean;
                               True_Text  : in String;
                               False_Text : in String);
   --# derives null from Cond,
   --#                   False_Text,
   --#                   True_Text;

end SparkMakeDebug;
