// ==========================================================
// Definition of solar system data : 
// Equatorial radius, oblateness and mu for solar system bodies
//
// eqRad: Equatorial radius (m) 
// obla: Oblateness
// mu: Gravitational constant (m^3/s^2)
// 
// Note:
// The gravitational constants for Mars, Jupiter, Saturn, Uranus, Neptune and Pluto
// are the gravitational constant of the body and its natural satellites.
//
// Bibliography
// 1) The shape of bodies can be found in the following document:
// Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2009
// (Chapter 7, Table 4 and 5)
//
// 2) The gravitational constants can be found in the following document:
// The IAU 2009 system of astronomical constants: the report of the IAU working 
// group on numerical standards for Fundamental Astronomy
// (Chapter 2, Table 1)
// 
// ==========================================================


// Sun - IAU 2009
data.body.Sun.eqRad = 696000e3
polRad = 696000e3
data.body.Sun.obla = 1 - polRad / data.body.Sun.eqRad
data.body.Sun.mu = 1.32712440041e20    // TDB compatible
// Other values for info: 
// data.body.Sun.mu = 1.32712442099e20 // TCB compatible

// Earth - Same values as in physical_data.scd for consistency
data.body.Earth.eqRad = 6378.1363e3
data.body.Earth.obla = 1/298.257223563
data.body.Earth.mu = 3.986004415e14  // same value as IAU 2009 - TT compatible
// Other values for info: 
// data.body.Earth.mu = 3.986004418e14  // IAU 2009 - TCB compatible 
// data.body.Earth.mu = 3.986004356e14  // IAU 2009 - TDB compatible

// Mercury - IAU 2009
data.body.Mercury.eqRad = 2439.7e3
polRad = 2439.7e3
data.body.Mercury.obla = 1 - polRad / data.body.Mercury.eqRad
data.body.Mercury.mu = (1/6.0236e6) * data.body.Sun.mu

// Venus - IAU 2009
data.body.Venus.eqRad = 6051.8e3
polRad = 6051.8e3
data.body.Venus.obla = 1 - polRad / data.body.Venus.eqRad
data.body.Venus.mu = (1/4.08523719e5) * data.body.Sun.mu

// Mars - IAU 2009
data.body.Mars.eqRad = 3396.19e3
polRad = 3376.2e3 // Average polar radius (N 3373.19e3 - S 3379.21e3)
data.body.Mars.obla = 1 - polRad / data.body.Mars.eqRad
data.body.Mars.mu = (1/3.09870359e6) * data.body.Sun.mu

// Jupiter - IAU 2009
data.body.Jupiter.eqRad = 71492e3
polRad = 66854e3 
data.body.Jupiter.obla = 1 - polRad / data.body.Jupiter.eqRad
data.body.Jupiter.mu = (1/1.047348644e3) * data.body.Sun.mu

// Saturn - IAU 2009
data.body.Saturn.eqRad = 60268e3
polRad = 54364e3 
data.body.Saturn.obla = 1 - polRad / data.body.Saturn.eqRad
data.body.Saturn.mu = (1/3.4979018e3) * data.body.Sun.mu

// Uranus - IAU 2009
data.body.Uranus.eqRad = 25559e3
polRad = 24973e3 
data.body.Uranus.obla = 1 - polRad / data.body.Uranus.eqRad
data.body.Uranus.mu = (1/2.290298e4) * data.body.Sun.mu

// Neptune - IAU 2009
data.body.Neptune.eqRad = 24764e3
polRad = 24341e3 
data.body.Neptune.obla = 1 - polRad / data.body.Neptune.eqRad
data.body.Neptune.mu = (1/1.941226e4) * data.body.Sun.mu

// Pluto - IAU 2009
data.body.Pluto.eqRad = 1195e3
polRad = 1195e3 
data.body.Pluto.obla = 1 - polRad / data.body.Pluto.eqRad
data.body.Pluto.mu = (1/1.36566e8) * data.body.Sun.mu

// Moon - IAU 2009
data.body.Moon.eqRad = 1737.4e3
data.body.Moon.obla = 0
data.body.Moon.mu = 1.23000371e-2 * data.body.Earth.mu
