/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.IProperties;
import com.simontuffs.onejar.JarClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Boot {
    public static final String BOOT_CLASS = "Boot-Class";
    public static final String ONE_JAR_CLASSLOADER = "One-Jar-Class-Loader";
    public static final String ONE_JAR_MAIN_CLASS = "One-Jar-Main-Class";
    public static final String ONE_JAR_DEFAULT_MAIN_JAR = "One-Jar-Default-Main-Jar";
    public static final String ONE_JAR_MAIN_ARGS = "One-Jar-Main-Args";
    public static final String ONE_JAR_URL_FACTORY = "One-Jar-URL-Factory";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MAIN_JAR = "main/main.jar";
    public static final String WRAP_CLASS_LOADER = "Wrap-Class-Loader";
    public static final String WRAP_DIR = "wrap";
    public static final String WRAP_JAR = "/wrap/wraploader.jar";
    public static final String PROPERTY_PREFIX = "one-jar.";
    public static final String P_MAIN_CLASS = "one-jar.main.class";
    public static final String P_MAIN_JAR = "one-jar.main.jar";
    public static final String P_MAIN_APP = "one-jar.main.app";
    public static final String P_RECORD = "one-jar.record";
    public static final String P_JARNAMES = "one-jar.jar.names";
    public static final String P_VERBOSE = "one-jar.verbose";
    public static final String P_INFO = "one-jar.info";
    public static final String P_STATISTICS = "one-jar.statistics";
    public static final String P_SHOW_PROPERTIES = "one-jar.show.properties";
    public static final String P_JARPATH = "one-jar.jar.path";
    public static final String P_ONE_JAR_CLASS_PATH = "one-jar.class.path";
    public static final String P_JAVA_CLASS_PATH = "java.class.path";
    public static final String P_PATH_SEPARATOR = "|";
    public static final String P_EXPAND_DIR = "one-jar.expand.dir";
    public static final String A_HELP = "--one-jar-help";
    public static final String A_VERSION = "--one-jar-version";
    public static final String[] HELP_PROPERTIES = new String[]{"one-jar.main.class", "Specifies the name of the class which should be executed \n(via public static void main(String[])", "one-jar.main.app", "Specifies the name of the main/<app>.jar to be executed", "one-jar.record", "true:  Enables recording of the classes loaded by the application", "one-jar.jar.names", "true:  Recorded classes are kept in directories corresponding to their jar names.\nfalse: Recorded classes are flattened into a single directory.  \nDuplicates are ignored (first wins)", "one-jar.verbose", "true:  Print verbose classloading information", "one-jar.info", "true:  Print informative classloading information", "one-jar.statistics", "true:  Shows statistics about the One-Jar Classloader", "one-jar.jar.path", "Full path of the one-jar file being executed.  \nOnly needed if java.class.path does not contain the path to the jar, e.g. on Max OS/X.", "one-jar.class.path", "Extra classpaths to be added to the execution environment.  \nUse platform independent path separator '|'", "one-jar.expand.dir", "Directory to use for expanded files.", "one-jar.show.properties", "true:  Shows the JVM system properties."};
    public static final String[] HELP_ARGUMENTS = new String[]{"--one-jar-help", "Shows this message, then exits.", "--one-jar-version", "Shows the version of One-JAR, then exits."};
    protected static String mainJar;
    protected static boolean info;
    protected static boolean verbose;
    protected static boolean statistics;
    protected static String myJarPath;
    protected static long startTime;
    protected static long endTime;
    private static JarClassLoader loader;
    static /* synthetic */ Class class$com$simontuffs$onejar$Boot;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$simontuffs$onejar$JarClassLoader;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static synchronized JarClassLoader getClassLoader() {
        return loader;
    }

    public static synchronized void setClassLoader(JarClassLoader $loader) {
        if (loader != null) {
            throw new RuntimeException("Attempt to set a second Boot loader");
        }
        loader = $loader;
    }

    protected static void VERBOSE(String message) {
        if (verbose) {
            System.out.println("Boot: " + message);
        }
    }

    protected static void WARNING(String message) {
        System.err.println("Boot: Warning: " + message);
    }

    protected static void INFO(String message) {
        if (info) {
            System.out.println("Boot: Info: " + message);
        }
    }

    protected static void PRINTLN(String message) {
        System.out.println("Boot: " + message);
    }

    public static void main(String[] args) throws Exception {
        Boot.run(args);
    }

    public static void run(String[] args) throws Exception {
        URL url;
        String mainargs;
        args = Boot.processArgs(args);
        String mainClass = null;
        Properties properties = new Properties();
        String props = "one-jar.properties";
        InputStream is = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream("/" + props);
        if (is != null) {
            Boot.INFO("loading properties from " + props);
            properties.load(is);
        }
        if (new File(props).exists() && (is = new FileInputStream(props)) != null) {
            Boot.INFO("merging properties from " + props);
            properties.load(is);
        }
        Enumeration<?> _enum = properties.propertyNames();
        while (_enum.hasMoreElements()) {
            String name = (String)_enum.nextElement();
            if (System.getProperty(name) != null) continue;
            System.setProperty(name, properties.getProperty(name));
        }
        if (Boolean.valueOf(System.getProperty(P_SHOW_PROPERTIES, "false")).booleanValue()) {
            Properties props2 = System.getProperties();
            Object[] keys = props2.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                System.out.println((String)key + "=" + props2.get(key));
            }
        }
        if (mainClass == null) {
            mainClass = System.getProperty(P_MAIN_CLASS);
        }
        if (mainJar == null) {
            String app = System.getProperty(P_MAIN_APP);
            mainJar = app != null ? "main/" + app + ".jar" : System.getProperty(P_MAIN_JAR, MAIN_JAR);
        }
        String jar = Boot.getMyJarPath();
        JarFile jarFile = new JarFile(jar);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String bootLoaderName = attributes.getValue(ONE_JAR_CLASSLOADER);
        if (mainJar == null) {
            mainJar = attributes.getValue(ONE_JAR_DEFAULT_MAIN_JAR);
        }
        if ((mainargs = attributes.getValue(ONE_JAR_MAIN_ARGS)) != null && args.length == 0) {
            args = mainargs.split("[^\\\\]\\s");
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].replaceAll("\\\\(\\s)", "$1");
            }
        }
        if (mainClass == null && (mainClass = attributes.getValue(ONE_JAR_MAIN_CLASS)) == null && (mainClass = attributes.getValue(BOOT_CLASS)) != null) {
            Boot.WARNING("The manifest attribute Boot-Class is deprecated in favor of the attribute One-Jar-Main-Class");
        }
        if (mainClass == null) {
            InputStream is2 = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream("/" + mainJar);
            if (is2 != null) {
                JarInputStream jis = new JarInputStream(is2);
                Manifest mainmanifest = jis.getManifest();
                jis.close();
                mainClass = mainmanifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            } else if (!"".equals(mainJar)) {
                Boot.INFO("Unable to locate main jar '" + mainJar + "' in the JAR file " + Boot.getMyJarPath());
            }
        }
        if ((url = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResource(WRAP_JAR)) != null) {
            JarClassLoader bootLoader = Boot.getBootLoader(bootLoaderName);
            bootLoader.load(null);
            InputStream is3 = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream(WRAP_JAR);
            if (is3 != null) {
                JarInputStream jis = new JarInputStream(is3);
                String wrapLoader = jis.getManifest().getMainAttributes().getValue(WRAP_CLASS_LOADER);
                jis.close();
                if (wrapLoader == null) {
                    Boot.WARNING(url + " did not contain a " + WRAP_CLASS_LOADER + " attribute, unable to load wrapping classloader");
                } else {
                    Boot.INFO("using " + wrapLoader);
                    JarClassLoader wrapped = Boot.getWrapLoader(bootLoader, wrapLoader);
                    if (wrapped == null) {
                        Boot.WARNING("Unable to instantiate " + wrapLoader + " from " + WRAP_DIR + ": using default JarClassLoader");
                        wrapped = Boot.getBootLoader(null);
                    }
                    Boot.setClassLoader(wrapped);
                }
            }
        } else {
            Boot.setClassLoader(Boot.getBootLoader(bootLoaderName, (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getClassLoader()));
            Boot.INFO("using JarClassLoader: " + Boot.getClassLoader().getClass().getName());
        }
        String urlfactory = attributes.getValue(ONE_JAR_URL_FACTORY);
        if (urlfactory != null) {
            loader.setURLFactory(urlfactory);
        }
        if ((mainClass = loader.load(mainClass)) == null && !loader.isExpanded()) {
            throw new Exception(Boot.getMyJarName() + " main class was not found (fix: add main/main.jar with a Main-Class manifest attribute, or specify -D" + P_MAIN_CLASS + "=<your.class.name>), or use " + ONE_JAR_MAIN_CLASS + " in the manifest");
        }
        if (mainClass != null) {
            String bootClass = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getName();
            if (bootClass.equals(mainClass)) {
                throw new Exception(Boot.getMyJarName() + " main class (" + mainClass + ") would cause infinite recursion: check main.jar/META-INF/MANIFEST.MF/Main-Class attribute: " + mainClass);
            }
            Class<?> cls = loader.loadClass(mainClass);
            endTime = System.currentTimeMillis();
            Boot.showTime();
            Method main = cls.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Boot.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            main.invoke(null, new Object[]{args});
        }
    }

    public static void showTime() {
        long endtime = System.currentTimeMillis();
        if (statistics) {
            Boot.PRINTLN("Elapsed time: " + (endtime - startTime) + "ms");
        }
    }

    public static void setProperties(IProperties jarloader) {
        Boot.INFO("setProperties(" + jarloader + ")");
        if (Boot.getProperty(P_RECORD)) {
            jarloader.setRecord(true);
            jarloader.setRecording(System.getProperty(P_RECORD));
        }
        if (Boot.getProperty(P_JARNAMES)) {
            jarloader.setRecord(true);
            jarloader.setFlatten(false);
        }
        if (Boot.getProperty(P_VERBOSE)) {
            jarloader.setVerbose(true);
            jarloader.setInfo(true);
            verbose = true;
        }
        if (Boot.getProperty(P_INFO)) {
            jarloader.setInfo(true);
            info = true;
        }
        statistics = Boot.getProperty(P_STATISTICS);
    }

    public static boolean getProperty(String key) {
        return Boolean.valueOf(System.getProperty(key, "false"));
    }

    public static String getMyJarName() {
        String name = Boot.getMyJarPath();
        int last = name.lastIndexOf("/");
        if (last >= 0) {
            name = name.substring(last + 1);
        }
        return name;
    }

    public static String getMyJarPath() {
        if (myJarPath != null) {
            return myJarPath;
        }
        myJarPath = System.getProperty(P_JARPATH);
        if (myJarPath == null) {
            try {
                String jarname = System.getProperty(P_JAVA_CLASS_PATH);
                String[] jars = jarname.split(System.getProperty("path.separator"));
                for (int i = 0; i < jars.length; ++i) {
                    jarname = jars[i];
                    Boot.VERBOSE("Checking " + jarname + " as One-Jar file");
                    InputStream is = null;
                    try {
                        is = new URL(jarname).openStream();
                    }
                    catch (MalformedURLException mux) {
                        try {
                            is = new FileInputStream(jarname);
                        }
                        catch (IOException iox) {
                            continue;
                        }
                    }
                    ZipEntry entry = Boot.findJarEntry(new JarInputStream(is), (class$com$simontuffs$onejar$Boot == null ? Boot.class$("com.simontuffs.onejar.Boot") : class$com$simontuffs$onejar$Boot).getName().replace('.', '/') + ".class");
                    if (entry != null) {
                        myJarPath = jarname;
                    } else {
                        entry = Boot.findZipEntry(new ZipFile(jarname), (class$com$simontuffs$onejar$Boot == null ? Boot.class$("com.simontuffs.onejar.Boot") : class$com$simontuffs$onejar$Boot).getName().replace('.', '/') + ".class");
                        if (entry == null) continue;
                        myJarPath = jarname;
                    }
                    break;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                Boot.WARNING("jar=" + myJarPath + " loaded from " + P_JAVA_CLASS_PATH + " (" + System.getProperty(P_JAVA_CLASS_PATH) + ")");
            }
        }
        if (myJarPath == null) {
            throw new IllegalArgumentException("Unable to locate " + (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getName() + " in the java.class.path: consider using -D" + P_JARPATH + " to specify the one-jar filename.");
        }
        myJarPath = myJarPath.replace('\\', '/');
        return myJarPath;
    }

    public static JarEntry findJarEntry(JarInputStream jis, String name) throws IOException {
        JarEntry entry;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static ZipEntry findZipEntry(ZipFile zip, String name) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Boot.VERBOSE("findZipEntry(): entry=" + entry.getName());
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static int firstWidth(String[] table) {
        int width = 0;
        for (int i = 0; i < table.length; i += 2) {
            if (table[i].length() <= width) continue;
            width = table[i].length();
        }
        return width;
    }

    public static String pad(String indent, String string, int width) {
        StringBuffer buf = new StringBuffer();
        buf.append(indent);
        buf.append(string);
        for (int i = 0; i < width - string.length(); ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String wrap(String indent, String string, int width) {
        String padding = Boot.pad(indent, "", width);
        string = string.replaceAll("\n", "\n" + padding);
        return string;
    }

    public static String[] processArgs(String[] args) throws Exception {
        Boot.VERBOSE("processArgs(" + Arrays.asList(args) + ")");
        ArrayList<String> list = new ArrayList<String>();
        for (int a = 0; a < args.length; ++a) {
            String argument = args[a];
            if (argument.startsWith(A_HELP)) {
                int i;
                int width = Boot.firstWidth(HELP_ARGUMENTS);
                System.out.println("One-Jar uses the following command-line arguments");
                for (i = 0; i < HELP_ARGUMENTS.length; ++i) {
                    System.out.print(Boot.pad("    ", HELP_ARGUMENTS[i++], width + 1));
                    System.out.println(Boot.wrap("    ", HELP_ARGUMENTS[i], width + 1));
                }
                System.out.println();
                width = Boot.firstWidth(HELP_PROPERTIES);
                System.out.println("One-Jar uses the following VM properties (-D<property>=<true|false|string>)");
                for (i = 0; i < HELP_PROPERTIES.length; ++i) {
                    System.out.print(Boot.pad("    ", HELP_PROPERTIES[i++], width + 1));
                    System.out.println(Boot.wrap("    ", HELP_PROPERTIES[i], width + 1));
                }
                System.out.println();
                System.exit(0);
                continue;
            }
            if (argument.startsWith(A_VERSION)) {
                InputStream is = (class$com$simontuffs$onejar$Boot == null ? Boot.class$("com.simontuffs.onejar.Boot") : class$com$simontuffs$onejar$Boot).getResourceAsStream("/.version");
                if (is != null) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String version = br.readLine();
                    br.close();
                    System.out.println("One-JAR version " + version);
                } else {
                    System.out.println("Unable to determine One-JAR version (missing /.version resource in One-JAR archive)");
                }
                System.exit(0);
                continue;
            }
            list.add(argument);
        }
        return list.toArray(new String[0]);
    }

    protected static JarClassLoader getBootLoader(final String loader) {
        JarClassLoader bootLoader = (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    try {
                        Class<?> cls = Class.forName(loader);
                        Constructor<?> ctor = cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Boot.class$("java.lang.String")) : class$java$lang$String);
                        return ctor.newInstance(Boot.WRAP_DIR);
                    }
                    catch (Exception x) {
                        Boot.WARNING("Unable to instantiate " + loader + ": " + x + " continuing using default " + (class$com$simontuffs$onejar$JarClassLoader == null ? (class$com$simontuffs$onejar$JarClassLoader = Boot.class$("com.simontuffs.onejar.JarClassLoader")) : class$com$simontuffs$onejar$JarClassLoader).getName());
                    }
                }
                return new JarClassLoader(Boot.WRAP_DIR);
            }
        });
        return bootLoader;
    }

    protected static JarClassLoader getBootLoader(final String loader, ClassLoader parent) {
        return (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    try {
                        Class<?> cls = Class.forName(loader);
                        Constructor<?> ctor = cls.getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Boot.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                        return ctor.newInstance((class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getClassLoader());
                    }
                    catch (Exception x) {
                        Boot.WARNING("Unable to instantiate " + loader + ": " + x + " continuing using default " + (class$com$simontuffs$onejar$JarClassLoader == null ? (class$com$simontuffs$onejar$JarClassLoader = Boot.class$("com.simontuffs.onejar.JarClassLoader")) : class$com$simontuffs$onejar$JarClassLoader).getName());
                    }
                }
                return new JarClassLoader((class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getClassLoader());
            }
        });
    }

    protected static JarClassLoader getWrapLoader(final ClassLoader bootLoader, final String wrapLoader) {
        return (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> jarLoaderClass = bootLoader.loadClass(wrapLoader);
                    Constructor<?> ctor = jarLoaderClass.getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Boot.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                    return ctor.newInstance(bootLoader);
                }
                catch (Throwable t) {
                    Boot.WARNING(t.toString());
                    return null;
                }
            }
        });
    }

    public static long getEndTime() {
        return endTime;
    }

    public static long getStartTime() {
        return startTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        startTime = System.currentTimeMillis();
        endTime = 0L;
        loader = null;
    }
}

