#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

# Menu

proc HelpMenu {mb} {
    global ds9

    $mb add cascade -label [msgcat::mc {Help}] -menu $mb.help

    menu $mb.help
    $mb.help add command -label [msgcat::mc {Reference Manual}]\
	-command HelpRef
    $mb.help add command -label [msgcat::mc {User Manual}]\
	-command HelpUser
    $mb.help add command -label [msgcat::mc {Mouse & Keyboard}] \
	-command HelpKeyboard
    $mb.help add separator
    $mb.help add command -label [msgcat::mc {FAQ}] \
	-command HelpFAQ
    $mb.help add command -label [msgcat::mc {New Features}] \
	-command HelpNew
    $mb.help add command -label [msgcat::mc {Release Notes}] \
	-command HelpRelease
    $mb.help add command -label [msgcat::mc {Help Desk}] \
	-command HelpDesk
    $mb.help add separator
    $mb.help add command -label [msgcat::mc {Story of SAOImage DS9}] \
	-command HelpStory
    $mb.help add command -label [msgcat::mc {Acknowledgment}] \
	-command HelpAck

    switch $ds9(wm) {
	x11 -
	win32 {
	    $mb.help add separator
	    $mb.help add command \
		-label "[msgcat::mc {About SAOImage DS9}]..." \
		-command AboutBox
	}
	aqua {}
    }
}

proc PrefsDialogHelpMenu {w} {
    set f [ttk::labelframe $w.mhelp -text [msgcat::mc {Help}]]

    PrefsDialogButtonbarHelp $f.buttonbar

    grid $f.buttonbar -padx 2 -pady 2 -sticky w

    pack $f -side top -fill both -expand true
}

# Buttons

proc ButtonsHelpDef {} {
    global pbuttons

    array set pbuttons {
	help,ref 1
	help,user 1
	help,keyboard 1
	help,faq 0
	help,new 0
	help,release 1
	help,desk 1
	help,story 0
	help,ack 1
	help,about 1
    }
}

proc CreateButtonsHelp {} {
    global buttons
    global ds9

    ttk::frame $ds9(buttons).help

    ButtonButton $ds9(buttons).help.ref \
	[string tolower [msgcat::mc {Reference}]] HelpRef
    ButtonButton $ds9(buttons).help.user \
	[string tolower [msgcat::mc {User}]] HelpUser
    ButtonButton $ds9(buttons).help.keyboard \
	[string tolower [msgcat::mc {Keyboard}]] HelpKeyboard
    ButtonButton $ds9(buttons).help.faq \
	[string tolower [msgcat::mc {FAQ}]] HelpFAQ
    ButtonButton $ds9(buttons).help.new \
	[string tolower [msgcat::mc {New Features}]] HelpNew
    ButtonButton $ds9(buttons).help.release \
	[string tolower [msgcat::mc {Release}]] HelpRelease
    ButtonButton $ds9(buttons).help.desk \
	[string tolower [msgcat::mc {Help Desk}]] HelpDesk
    ButtonButton $ds9(buttons).help.story \
	[string tolower [msgcat::mc {Story}]] HelpStory
    ButtonButton $ds9(buttons).help.ack \
	[string tolower [msgcat::mc {Acknowledgment}]] HelpAck
    ButtonButton $ds9(buttons).help.about \
	[string tolower [msgcat::mc {About}]] AboutBox

    set buttons(help) "
        $ds9(buttons).help.ref pbuttons(help,ref)
        $ds9(buttons).help.user pbuttons(help,user)
        $ds9(buttons).help.keyboard pbuttons(help,keyboard)
        $ds9(buttons).help.faq pbuttons(help,faq)
        $ds9(buttons).help.new pbuttons(help,new)
        $ds9(buttons).help.release pbuttons(help,release)
        $ds9(buttons).help.desk pbuttons(help,desk)
        $ds9(buttons).help.story pbuttons(help,story)
        $ds9(buttons).help.ack pbuttons(help,ack)
        $ds9(buttons).help.about pbuttons(help,about)
    "
}

proc PrefsDialogButtonbarHelp {f} {
    global buttons
    global pbuttons

    ttk::menubutton $f -text [msgcat::mc {Buttonbar}] -menu $f.menu
    
    set m $f.menu
    menu $m
    $m add checkbutton -label [msgcat::mc {Reference Manual}]\
	-variable pbuttons(help,ref) -command {UpdateButtons buttons(help)}
    $m add checkbutton -label [msgcat::mc {User Manual}]\
	-variable pbuttons(help,user) -command {UpdateButtons buttons(help)}
    $m add checkbutton -label [msgcat::mc {Keyboard Shortcuts}] \
	-variable pbuttons(help,keyboard) -command {UpdateButtons buttons(help)}
    $m add separator
    $m add checkbutton -label [msgcat::mc {FAQ}] \
	-variable pbuttons(help,faq) -command {UpdateButtons buttons(help)}
    $m add checkbutton -label [msgcat::mc {New Features}] \
	-variable pbuttons(help,new) -command {UpdateButtons buttons(help)}
    $m add checkbutton -label [msgcat::mc {Release Notes}] \
	-variable pbuttons(help,release) -command {UpdateButtons buttons(help)}
    $m add checkbutton -label [msgcat::mc {Help Desk}] \
	-variable pbuttons(help,desk) -command {UpdateButtons buttons(help)}
    $m add separator
    $m add checkbutton -label [msgcat::mc {Story of SAOImage DS9}] \
	-variable pbuttons(help,story) -command {UpdateButtons buttons(help)}
    $m add checkbutton -label [msgcat::mc {Acknowledgment}] \
	-variable pbuttons(help,ack) -command {UpdateButtons buttons(help)}
    $m add separator
    $m add checkbutton -label "[msgcat::mc {About SAOImage DS9}]..." \
	-variable pbuttons(help,about) -command {UpdateButtons buttons(help)}
}
