#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

# support

proc MarkerAnalysisPlot2dDialog {varname} {
    upvar #0 $varname var
    global $varname
    global marker

    set id $var(id)
    set frame $var(frame)

    set vvarname plot2d${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    set var(plot2d) [info exists ${vvarname}(top)]
    set var(method) average

    $var(mb).analysis add checkbutton -label [msgcat::mc {Plot 2D}] \
	-variable ${varname}(plot2d) \
	-command "MarkerAnalysisPlot2dCmd $varname"
    $var(mb).analysis add separator
    $var(mb).analysis add cascade \
	-label [msgcat::mc {Method}] \
	-menu $var(mb).analysis.method

    menu $var(mb).analysis.method
    $var(mb).analysis.method add radiobutton \
	-label [msgcat::mc {Average}] \
	-variable ${varname}(method) -value average \
	-command "MarkerAnalysisPlot2dMethod $varname"
    $var(mb).analysis.method add radiobutton \
	-label [msgcat::mc {Sum}] \
	-variable ${varname}(method) -value sum \
	-command "MarkerAnalysisPlot2dMethod $varname"
}

proc MarkerAnalysisPlot2dCmd {varname} {
    upvar #0 $varname var
    global $varname

    MarkerAnalysisPlot2d $var(frame) $var(id) $var(plot2d)
}

proc MarkerAnalysisPlot2d {frame id plot} {
    $frame marker $id analysis plot2d $plot
    if {$plot} {
	MarkerAnalysisPlot2dCB $frame $id

	set vvarname plot2d${id}${frame}
	upvar #0 $vvarname vvar
	global $vvarname

	PlotRaise $vvarname
    } else {
	MarkerAnalysisPlot2dDeleteCB $frame $id
    }
}

proc MarkerAnalysisPlot2dMethod {varname} {
    upvar #0 $varname var
    global $varname

    if {[info exists var(plot2d)]} {
	if {$var(plot2d)} {
	    MarkerAnalysisPlot2dCB $var(frame) $var(id)
	    MarkerAnalysisPlot2dYAxisTitle $var(frame) $var(id)
	}
    }
}

proc MarkerAnalysisPlot2dSystem {varname} {
    upvar #0 $varname var
    global $varname

    if {[info exists var(plot2d)]} {
	if {$var(plot2d)} {
	    MarkerAnalysisPlot2dCB $var(frame) $var(id)
	    MarkerAnalysisPlot2dXAxisTitle $var(frame) $var(id)
	}
    }
}

# hardcoded marker.C
proc MarkerAnalysisPlot2dCB {frame id} {
    set varname "mk${frame}-${id}"
    global $varname
    upvar #0 $varname var

    set vvarname plot2d${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    if {[info exists var(system)]} {
	set vvar(system) $var(system)
	set sys $var(system)
    } elseif {[info exists vvar(system)]} {
	set sys $vvar(system)
    } else {
	global wcs
	set vvar(system) $wcs(system)
	set sys $wcs(system)
    }

    if {[info exists var(sky)]} {
	set vvar(sky) $var(sky)
	set sky $var(sky)
    } elseif {[info exists vvar(sky)]} {
	set sky $vvar(sky)
    } else {
	global wcs
	set sky $wcs(sky)
    }

    if {[info exists var(method)]} {
	set vvar(method) $var(method)
	set method $var(method)
    } elseif {[info exists vvar(method)]} {
	set method $vvar(method)
    } else {
	set vvar(method) average
	set method average
    }

    set xdata plot2d${id}${frame}x
    set ydata plot2d${id}${frame}y
    set xcdata plot2d${id}${frame}xc
    set ycdata plot2d${id}${frame}yc
    global $xdata $ydata $xcdata $ycdata

    if {[PlotPing $vvarname]} {
	$frame get marker $id analysis plot2d $xdata $ydata $xcdata $ycdata \
	    $sys $sky $method
	PlotStats $vvarname
	PlotList $vvarname
    } else {
	set tt [string totitle [$frame get marker $id type]]
	PlotLineDialog $vvarname $tt $tt $sys Counts
	MarkerAnalysisPlot2dXAxisTitle $frame $id
	MarkerAnalysisPlot2dYAxisTitle $frame $id

	# setup our own formatting
	set vvar(graph,format) 0
	set vvar(xcdata) $xcdata
	set vvar(ycdata) $ycdata
	$vvar(graph) xaxis configure \
	    -command "MarkerAnalysisPlot2dXAxis $frame $id"

	set vvar(manage) 0
	set vvar(dim) xy
	set vvar(xdata) $xdata
	set vvar(ydata) $ydata
	set vvar(xedata) {}
	set vvar(yedata) {}
	blt::vector create $xdata $ydata $xcdata $ycdata

	$frame get marker $id analysis plot2d $xdata $ydata $xcdata $ycdata \
	    $sys $sky $method

	PlotExternal $vvarname
	$vvar(proc,createelement) $vvarname
	$vvar(proc,updateelement) $vvarname
	$vvar(proc,updategraph) $vvarname
	PlotStats $vvarname
	PlotList $vvarname
    }
}

proc MarkerAnalysisPlot2dDeleteCB {frame id} {
    # this routine could be called by the region 
    # after the dialog has been deleted

    set vvarname plot2d${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    set xcdata plot2d${id}${frame}xc
    set ycdata plot2d${id}${frame}yc

    # clear extra vectors
    global $xcdata $ycdata
    catch {blt::vector destroy $xcdata $ycdata}

    # clear any errors
    global errorInfo
    set errorInfo {}

    PlotDestroy $vvarname
}

proc MarkerAnalysisPlot2dXAxisTitle {frame id} {
    set vvarname plot2d${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    switch -- $vvar(system) {
	image -
	physical -
	amplifier -
	detector {set title "$vvar(system)"}
	default {
	    if {[$frame has wcs equatorial $vvar(system)]} {
		set title "$vvar(system)"
	    } else {
		set title "[$frame get wcs name $vvar(system)]"
	    }
	}
    }

    # set for plot code
    set vvar(graph,xaxis) $title

    # update now (may not make it into plot code)
    $vvar(graph) xaxis configure -title $vvar(graph,xaxis)
}

proc MarkerAnalysisPlot2dYAxisTitle {frame id} {
    set vvarname plot2d${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    # set for plot code
    set vvar(graph,yaxis) "Counts [string totitle $vvar(method)]"

    # update now (may not make it into plot code)
    $vvar(graph) yaxis configure -title $vvar(graph,yaxis)
}

proc MarkerAnalysisPlot2dXAxis {frame id w xx} {
    set vvarname plot2d${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    set x [expr $xx-1]

    global $vvar(xcdata) $vvar(ycdata)
    # sometimes, $x equals $vvar(xcdata) length
    set ll [$vvar(xcdata) length]
    if {($ll>=1) && ($x>=0) && ($x<$ll)} {
	set a [format "%6.3f" [expr "$$vvar(xcdata)\($x\)"]]
	set b [format "%6.3f" [expr "$$vvar(ycdata)\($x\)"]]
	return "$a\n$b"
    } else {
	return {}
    }
}
