///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting/Scripting.h>
#include <core/gui/ApplicationManager.h>
#include "StartupScriptExecutor.h"

namespace Scripting {

IMPLEMENT_PLUGIN_CLASS(StartupScriptExecutor, AutoStart)

/******************************************************************************
* This method is called several time by the system on application startup.
******************************************************************************/
void StartupScriptExecutor::startEvent(InitializationStage stage)
{
	// We want to run the startup script after the application has been fully initialized.
	if(stage != AutoStart::ApplicationRunning) return;

	// Check if an startup script has been specified.
	if(APPLICATION_MANAGER.startupScriptFile().isEmpty()) return;

	// Execute startup script using the master script engine.
	try {
		ScriptEngine& engine = ScriptEngine::master();
		int exitCode = engine.executeScriptFile(APPLICATION_MANAGER.startupScriptFile());

		// If the script returns an error code then OVITO should
		// return this error code as well.
		if(exitCode && APPLICATION_MANAGER.consoleMode())
			APPLICATION_MANAGER.setExitCode(exitCode);
	}
	catch(const Exception& ex) {
		if(APPLICATION_MANAGER.guiMode()) {
			// In GUI mode the error message is shown to the user and we can recover from the script
			// execution error.
			ex.showError();
		}
		else {
			// In non-GUI mode pass exception on to the application manager to terminate the application with
			// a proper exit code that indicates a failure.
			throw;
		}
	}
}

};
