#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# It is released under the GNU Public Licence
#

if(description)
{
 script_id(11154);
 script_version ("$Revision: 7591 $");
 script_tag(name:"risk_factor", value:"None");
 name = "Unknown services banners";
 script_name(name);
 
 desc = "
This plugin prints the banners from unknown service so that
the OpenVAS team can take them into account.

Risk factor : None";



 script_description(desc);
 
 summary = "Displays the unknown services banners";
 script_summary(summary);
 
 script_category(ACT_END); 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");

 script_family("Service detection");
 script_dependencie("find_service_nmap.nasl");
 script_require_ports("Services/unknown");
 exit(0);
}

#
include("misc_func.inc");
include("dump.inc");

port = get_kb_item("Services/unknown");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);
if (port == 139) exit(0);	# Avoid silly messages
if (! service_is_unknown(port: port)) exit(0);

banner = get_unknown_banner(port: port, dontfetch: 1);

if (!banner) exit(0);

h = hexdump(ddata: banner);
if( strlen(banner) >= 3 )
{
m = string("An unknown server is running on this port.\n",
  "If you know what it is, please send this banner to the OpenVAS team:\n",
  h);
security_note(port: port, data: m);
}

