# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-788-1 (tomcat6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64262);
 script_cve_id("CVE-2008-5515", "CVE-2009-0033", "CVE-2009-0580", "CVE-2009-0781", "CVE-2009-0783");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Ubuntu USN-788-1 (tomcat6)";
 script_name(name);

 desc = "The remote host is missing an update to tomcat6
announced via advisory USN-788-1.

Details follow:

Iida Minehiko discovered that Tomcat did not properly normalise paths. A
remote attacker could send specially crafted requests to the server and
bypass security restrictions, gaining access to sensitive content.
(CVE-2008-5515)

Yoshihito Fukuyama discovered that Tomcat did not properly handle errors
when the Java AJP connector and mod_jk load balancing are used. A remote
attacker could send specially crafted requests containing invalid headers
to the server and cause a temporary denial of service. (CVE-2009-0033)

D. Matscheko and T. Hackner discovered that Tomcat did not properly handle
malformed URL encoding of passwords when FORM authentication is used. A
remote attacker could exploit this in order to enumerate valid usernames.
(CVE-2009-0580)

Deniz Cevik discovered that Tomcat did not properly escape certain
parameters in the example calendar application which could result in
browsers becoming vulnerable to cross-site scripting attacks when
processing the output. With cross-site scripting vulnerabilities, if a user
were tricked into viewing server output during a crafted server request, a
remote attacker could exploit this to modify the contents, or steal
confidential data (such as passwords), within the same domain.
(CVE-2009-0781)

Philippe Prados discovered that Tomcat allowed web applications to replace
the XML parser used by other web applications. Local users could exploit
this to bypass security restrictions and gain access to certain sensitive
files. (CVE-2009-0783)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.10:
  libtomcat6-java                 6.0.18-0ubuntu3.2
  tomcat6-examples                6.0.18-0ubuntu3.2

Ubuntu 9.04:
  libtomcat6-java                 6.0.18-0ubuntu6.1
  tomcat6-examples                6.0.18-0ubuntu6.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-788-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-788-1 (tomcat6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libservlet2.5-java", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtomcat6-java", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-admin", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-common", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-docs", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-examples", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-user", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6", ver:"6.0.18-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libservlet2.5-java-doc", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libservlet2.5-java", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtomcat6-java", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-admin", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-common", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-docs", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-examples", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6-user", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat6", ver:"6.0.18-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
