###################################################################
# OpenVAS Network Vulnerability Test
#
# Sympa Detection
#
# LSS-NVT-2009-013
#
# Developed by LSS Security Team <http://security.lss.hr>
#
# Copyright (C) 2009 LSS <http://www.lss.hr>
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program. If not, see
# <http://www.gnu.org/licenses/>.
###################################################################

if(description)
{
 script_id(102013);
 script_version("$Revision: 7853 $");
 script_tag(name:"risk_factor", value:"None");

 script_name("Sympa Detection");

 desc = "
The remote host is running Sympa, an open source (GNU GPL) mailing list management (MLM) software
suite written in Perl.

See also : 

http://www.sympa.org/
";

 script_description(desc);

 script_summary("Detects Sympa");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (C) 2009 LSS");
 script_family("Service detection");
 script_exclude_keys("Settings/disable_cgi_scanning");
 script_require_ports("Services/www", 80, 443);
 
 exit(0);
}

include("global_settings.inc");
include("http_func.inc");
include("openvas-https.inc");


# Function that checks each dir for Sympa installation
# Optionally can use https

function CheckSympa(use_https) {
  dirs = make_list("/sympa", cgi_dirs());

  # Go through dirs
  foreach dir (dirs)
  {
    url = string(dir, "/");
    req = http_get(item:url, port:port);
    if(use_https==1)
      req = https_req_get(request: req, port:port);
    else
      req = http_send_recv(data: req, port:port);
      
    if(isnull(req)) return;

    # Check if it is Sympa
    pat='Powered by ([^>]*>)?Sympa ?v?([0-9.]+)';
    match=egrep(pattern:pat,string:req, icase:1);
    
    if(match || egrep(pattern:"<meta name=.generator. content=.Sympa",string:req,icase=1)) {
      
      # Instalation found, extract version
      item=eregmatch(pattern:pat,string:match, icase:1);
      ver=item[2];

      # If version couldn't be extracted, mark as unknown
      if(!ver) ver="unknown";

      set_kb_item(name:string("www/", port, "/sympa"),value:string(ver, " under ", dir));
      if(report_verbosity) {
        if(dir=="") dir="/";
        info+=" Version: " +ver + " under "+dir+'\n'+'\n';
      }
      n++;
      if(!thorough_tests) break;
    }
  }
}

n=0;
info="";

# Check for installations on https
port = get_kb_item("Services/www");
if(!port) port = 443;
if (get_port_state(port))
  CheckSympa(use_https: 1);

# Check for installations on http
if(!n || thorough_tests) {
  port = get_http_port(default:80);
  if (get_port_state(port))
    CheckSympa(use_https: 0);
}

if(!n) exit(0);

if(report_verbosity) {
  info="The following version(s) of Sympa were detected: "+'\n'+'\n'+info;
  security_note(port:port, data:info);
} else
  security_note(port:port);
