#
# GPL licensed by Tenable and distributed under Tenable GPL feed - 10 July 2006
#

#
# (C) Tenable Network Security
#
# $Id: solaris.inc,v 1.3 2004/11/20 01:25:51 renaud Exp $
#

function patch_installed(showrev, patch)
{
  local_var v, p,r,patches,spatches;
  v = split(patch, sep:"-", keep:0);
  patches = egrep(pattern:"^Patch: " + v[0], string:showrev);
  if ( ! patches ) return 0; # No patch
  #
  # there may be more then one patch version be listed, so split up the result
  # and do a foreach check.
  #
  spatches = split(patches, keep:0);
  foreach r (spatches)
    {
      # Get the revision number of the installed patch
      r = ereg_replace(pattern:"Patch: ([0-9]*-[0-9]*) .*", replace:"\1", string:r);
      p = split(r, sep:"-", keep:0);
      # If the installed patch is newer than or equal to what we expect, consider
      # it installed

      if  ( int(p[1]) >= int(v[1]) )
        {
          return 1; # Patch is installed
        }
    }
  return 0; # Patch is missing
}


# example call:
# solaris_check_patch(release:"5.10", arch:"i386", patch:"141015-01", package:"SUNWesu")

#
# solaris_check_patch() returns :
#	-1 if a patch is missing
#	0  if a patch is not installed but not required (ie: other architecture)
#	1 if the patch is installed
#
function solaris_check_patch(release, arch, patch, package, obsoleted_by)
{
 local_var showrev, r, flag, packages, p;

 if ( "_x86" >< release )
	release -= "_x86";

 kb_release = get_kb_item("ssh/login/solosversion") - '\n';
 kb_arch = get_kb_item("ssh/login/solhardwaretype") - '\n';

 if (kb_release != release || kb_arch != arch){
    return 0;
 }

 packages = get_kb_item("ssh/login/solpackages");
 showrev = get_kb_item("ssh/login/solpatches");
 if ( ! packages || ! showrev || !release || !patch ) return 0;


 # Look if at least one of the packages installed are affected
 # by this patch
 flag = 0;
 if ( strlen(package) )
 {
  package = split(package, sep:" ", keep:FALSE);
  foreach p (package)
    {
      if ( egrep(pattern:p , string:packages) ) flag ++;
    }
 } else flag = 1;

 # No package is affected  - return
 if ( flag == 0 ) return 0;
 

 if ( patch_installed(patch:patch, showrev:showrev) )
	return 1; # Installed

 if ( obsoleted_by && patch_installed(patch:obsoleted_by, showrev:showrev) )
	return 1; # Installed

 return -1; # Not installed
}
