##############################################################################
#
#  BitDefender 'pdf.xmd' Module PDF Parsing Remote DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/24
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0520
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900180);
  script_cve_id("CVE-2008-5409");
 script_bugtraq_id(32396);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_tag(name:"cvss_base", value:"9.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("BitDefender 'pdf.xmd' Module PDF Parsing Remote DoS Vulnerability");
  script_summary("Check for vulnerable version of BitDefender");
  desc = "
  Overview: This host is installed with BitDefender Internet Security and AntiVirus
  and is prone to denial of service vulnerability.

  The flaw is caused due to boundary error in 'pdf.xmd' module when parsing of
  data encoded using 'FlateDecode' and 'ASCIIHexDecode' filters. This can be
  exploited to cause a memory corruption during execution of 'bdc.exe'.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and can deny the service to the legitimate user.

  Impact Level: Application

  Affected Software/OS:
  BitDefender Internet Security and Antivirus version 10 and prior on Windows

  Fix: Update to higher version
  http://www.bitdefender.com/site/Downloads/

  References:
  http://milw0rm.com/exploits/7178
  http://secunia.com/advisories/32789

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 8.1
  Risk factor : Critical";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

bitDef = "SOFTWARE\BitDefender\About\";
bitName = registry_get_sz(key:bitDef, item:"ProductName");
if(("BitDefender Internet Security" >< bitName) ||
   ("BitDefender Antivirus" >< bitName))
{
  bitVer = registry_get_sz(key:bitDef, item:"ProductVersion");
  # Check the versions 10 and prior
  if(egrep(pattern:"10(\..*)", string:bitVer)){
    security_hole(0);
  }
}
