###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_zim_server_mult_vuln_800201.nasl 549 2008-12-01 17:00:05Z dec $
#
# ZIM Server Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800201);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5279", "CVE-2008-5280");
  script_bugtraq_id(27940);
  script_name("ZIM Server Multiple Vulnerabilities");
  desc = "

  Overview: The host is installed with ZIM Server and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The issues are due to,
  - boundary errors in the server while handling overly long crafted packets
    sent to default prot 7700.
  - a null pointer de-reference within the server will crash the service via
    a specially crafted packet sent to default port 7700.

  Impact:
  Successful exploitation could result in remote arbitrary code execution and
  cause denial of service.

  Impact Level: System

  Affected Software/OS:
  Zilab Software Zilab Chat and Instant Messaging Server 2.1 and prior.

  Fix:Upgrde to Zilab Software Zilab Chat and Instant Messaging Server version 3.3 or later
  For updates refer, http://www.zilab.com/zim.shtml.

  References:
  http://aluigi.altervista.org/adv/zilabzcsx-adv.txt
  http://en.securitylab.ru/nvd/363848.php
  http://secunia.com/advisories/29062

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of ZIM IM Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
foreach item (entries)
{
  ver = registry_get_sz(key:key + item, item:"DisplayName");
  if("Zim" >< ver)
  {
    zimVer = eregmatch(pattern:"Zim v([0-9.]+)", string:ver);
    if(zimVer[1] != NULL)
    {
      # Grep for version <= 2.1
      if(version_is_less_equal(version:zimVer[1], test_version:"2.1")){
        security_hole(0);
      }
    }
    exit(0);
  }
}
