###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tor_dos_vuln_jul09_lin.nasl 3415 2009-07-16 22:02:29Z jul $
#
# Tor Denial Of Service Vulnerability - July09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800841);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2425");
  script_bugtraq_id(35505);
  script_name("Tor Denial Of Service Vulnerability - July09 (Linux)");
  desc = "

  Overview:
  This host is installed with Tor and is prone to Denial Of Service
  vulnerability.

  Vulnerability Insight:
  Error exists while parsing certain malformed router descriptors and can be
  exploited to crash Tor via specially crafted router descriptors.

  Impact:
  Successful exploitation will let the attackers to cause Denial of Service.

  Impact level: Application

  Affected Software/OS:
  Tor version 0.2.x before 0.2.0.35 on Linux.

  Fix: Upgrade to version 0.2.0.35 or later
  http://www.torproject.org/download.html.en

  References:
  http://secunia.com/advisories/35546
  http://xforce.iss.net/xforce/xfdb/51376
  http://archives.seul.org/or/announce/Jun-2009/msg00000.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Tor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_tor_detect_lin.nasl");
  script_require_keys("Tor/Linux/Ver");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

foreach torPort (make_list(9050, 9051, 8118))
{
  if(get_port_state(torPort))
  {
    sndReq = string("GET / HTTP/1.1", "\r\n",
                    "Host: ", get_host_name(), "\r\n\r\n");
  
    rcvRes = http_send_recv(port:torPort, data:sndReq);

    if(egrep(pattern:"<a\ href=?[^?]+:\/\/www\.torproject\.org",
             string:rcvRes) && "Tor" >< rcvRes)
    {
      torVer = get_kb_item("Tor/Linux/Ver");
      torVer = ereg_replace(pattern:"-", replace:".", string:torVer);
      if(torVer == NULL){
        exit(0);
      }

      # Check for Tor version 0.2 < 0.2.0.35
      if(version_in_range(version:torVer, test_version:"0.2",
                                          test_version2:"0.2.0.34.alpha"))
      {
        security_warning(torPort);
        exit(0);
      }
    }
  }
}
