###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_sys_web_serv_detect.nasl 2740 2009-06-17 15:50:35Z june $
#
# Sun Java System Web Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Updated By Veerendra G <veerendragg@secpod.com>
# date update: 2010/01/20
# Added for loop to check for all the ports (80, 8800, 8989, 8888)
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800810);
  script_version("$Revision: 7732 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Sun Java System Web Server Version Detection");
  desc = "
  Overview : This script is detects the installed version of Java System Web
  Server and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set version of Java System Web Server in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 8800, 8989, 8888);
  exit(0);
}


include("http_func.inc");
include("openvas-https.inc");

foreach jswsPort (make_list(80, 8800, 8989, 8888))
{
  if(get_port_state(jswsPort))
  {
    banner = get_http_banner(port:jswsPort);
    if(banner != NULL)
    {

      if("Server: Sun-" >< banner) {
        
	url = "/admingui/version/copyright";
	req = http_get(item:url, port:jswsPort);
	body = http_send_recv(port: jswsPort, data: req);

	if("Location: https://" >< body) {
	  body = https_req_get(port:jswsPort, request: req);
	}

	if("Sun Java System Web Server" >< body) {
	  version = eregmatch(pattern: "Sun Java System Web Server ([^ ]+)", string: body);
	}

	if(!isnull(version[1])) {
          set_kb_item(name:string("Sun/JavaSysWebServ/",jswsPort,"/Ver"),value: version[1]);
	}  
      }	

      jswsVer = eregmatch(pattern:"Server: Sun-(ONE|Java-System)-Web-Server\/" +
                                  "([0-9]\.[0-9.]+)([^0-9.]|$)",
                          string:banner);
      if(jswsVer[2] != NULL)
      {
        set_kb_item(name:"Sun/JavaSysWebServ/Ver", value:jswsVer[2]);
        set_kb_item(name:"Sun/JavaSysWebServ/Port", value:jswsPort);
        security_note(data:"Sun Java System Web Server version " + jswsVer[2] +
                                      " was detected on the host");
        exit(0);
      }
    }
  }
}
