###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ocsinventory FEDORA-2010-1535
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861656);
  script_version("$Revision: 7426 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2010-1535");
  script_name("Fedora Update for ocsinventory FEDORA-2010-1535");
  desc = "

  Vulnerability Insight:
  Open Computer and Software Inventory Next Generation is an application
  designed to help a network or system administrator keep track of the
  computers configuration and software that are installed on the network.
  
  OCS Inventory is also able to detect all active devices on your network,
  such as switch, router, network printer and unattended devices.
  
  OCS Inventory NG includes package deployment feature on client computers.
  
  ocsinventory is a metapackage that will install the communication server,
  the administration console and the database server (MySQL).


  Affected Software/OS:
  ocsinventory on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/034876.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ocsinventory");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"ocsinventory", rpm:"ocsinventory~1.02.3~1.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}