# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 941-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56148);
 script_bugtraq_id(16250);
 script_cve_id("CVE-2005-3340");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 941-1 (tuxpaint)";
 script_name(name);

 desc = "The remote host is missing an update to tuxpaint
announced via advisory DSA 941-1.

Javier Fernandez-Sanguino Pena from the Debian Security Audit project
discovered that a script in tuxpaint, a paint program for young
children, creates a temporary file in an insecure fashion.

The old stable distribution (woody) does not contain tuxpaint packages.

For the stable distribution (sarge) this problem has been fixed in
version 0.9.14-2sarge0.

For the unstable distribution (sid) this problem has been fixed in
version 0.9.15b-1.

We recommend that you upgrade your tuxpaint package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20941-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 941-1 (tuxpaint)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tuxpaint-data", ver:"0.9.14-2sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tuxpaint", ver:"0.9.14-2sarge0", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
