# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 746-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54354);
 script_bugtraq_id(14088);
 script_cve_id("CVE-2005-1921");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 746-1 (phpgroupware)";
 script_name(name);

 desc = "The remote host is missing an update to phpgroupware
announced via advisory DSA 746-1.

A vulnerability had been identified in the xmlrpc library included with
phpgroupware, a web-based application including email, calendar and
other groupware functionality. This vulnerability could lead to the
execution of arbitrary commands on the server running phpgroupware.

The security team is continuing to investigate the version of
phpgroupware included with the old stable distribution (sarge). At this
time we recommend disabling phpgroupware or upgrading to the current
stable distribution (sarge).

For the current stable distribution (sarge) this problem has been fixed
in version 0.9.16.005-3.sarge0.

For the unstable distribution (sid) this problem has been fixed in
version 0.9.16.006-1.

We recommend that you upgrade your phpgroupware package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20746-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 746-1 (phpgroupware)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpgroupware-ftp", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-admin", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phpgwapi", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-infolog", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-registration", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-addressbook", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-news-admin", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-fudforum", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-preferences", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-nntp", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-sitemgr", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-chat", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phpbrain", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phonelog", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-wiki", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-bookmarks", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-developer-tools", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-skel", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-calendar", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-folders", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-etemplate", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-felamimail", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-filemanager", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-todo", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-projects", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-xmlrpc", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-email", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-comic", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-dj", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-setup", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-stocks", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-core", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-hr", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-headlines", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-phpsysinfo", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-img", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-eldaptir", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-messenger", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-soap", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-forum", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-manual", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-qmailldap", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-tts", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-notes", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-polls", ver:"0.9.16.005-3.sarge0", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
