# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1912-2 (advi)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66099);
 script_cve_id("CVE-2009-3296", "CVE-2009-2660");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1912-2 (advi)");

 desc = "The remote host is missing an update to advi
announced via advisory DSA 1912-2.

Due to the fact that advi, an active DVI previewer and presenter,
statically links against camlimages it was neccessary to rebuilt it in
order to incorporate the latest security fixes for camlimages, which
could lead to integer overflows via specially crafted TIFF files
(CVE-2009-3296) or GIFF and JPEG images (CVE-2009-2660).


For the stable distribution (lenny), these problems have been fixed in
version 1.6.0-13+lenny2.

Due to a bug in the archive system, the fix for the oldstable
distribution (etch) cannot be released at the same time. These problems
will be fixed in version 1.6.0-12+etch2, once it is available.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 1.6.0-14+b1.


We recommend that you upgrade your advi package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201912-2

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1912-2 (advi)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"advi-examples", ver:"1.6.0-13+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"advi", ver:"1.6.0-13+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
