# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1875-1 (ikiwiki)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64760);
 script_cve_id("CVE-2009-2944");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1875-1 (ikiwiki)");

 desc = "The remote host is missing an update to ikiwiki
announced via advisory DSA 1875-1.

Josh Triplett discovered that the blacklist for potentially harmful TeX
code of the teximg module of the Ikiwiki wiki compiler was incomplete,
resulting in information disclosure.

The old stable distribution (etch) is not affected.

For the stable distribution (lenny), this problem has been fixed in
version 2.53.4.

For the unstable distribution (sid), this problem has been fixed in
version 3.1415926.

We recommend that you upgrade your ikiwiki package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201875-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1875-1 (ikiwiki)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ikiwiki", ver:"2.53.4", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
