# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1033-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56580);
 script_cve_id("CVE-2005-4190", "CVE-2006-1260", "CVE-2006-1491");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1033-1 (horde3)";
 script_name(name);

 desc = "The remote host is missing an update to horde3
announced via advisory DSA 1033-1.

Several remote vulnerabilities have been discovered in the Horde web
application framework, which may lead to the execution of arbitrary
web script code. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2005-4190

Several Cross-Site-Scripting vulnerabilities have been discovered in
the share edit window.

CVE-2006-1260

Null characters in the URL parameter bypass a sanity check, which
allowed remote attackers to read arbitrary files, which allowed
information disclosure.

CVE-2006-1491

User input in the help viewer was passed unsanitised to the eval()
function, which allowed injection of arbitrary web code.


The old stable distribution (woody) doesn't contain horde3 packages.

For the stable distribution (sarge) these problems have been fixed in
version 3.0.4-4sarge3.

For the unstable distribution (sid) these problems have been fixed in
version 3.1.1-1.

We recommend that you upgrade your horde3 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201033-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1033-1 (horde3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"horde3", ver:"3.0.4-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
