# Generates the contents of "components_defs.mk".

from components import (
	EmulationCore, iterBuildableComponents, iterComponents,
	requiredLibrariesFor
	)
from makeutils import extractMakeVariables
from outpututils import rewriteIfChanged

import sys

def iterComponentDefs(probeMakePath):
	probeVars = extractMakeVariables(probeMakePath)

	yield '# Automatically generated by build process.'
	yield ''

	yield 'LIBRARY_COMPILE_FLAGS:='
	yield 'LIBRARY_LINK_FLAGS:='
	for libName in requiredLibrariesFor(iterBuildableComponents(probeVars)):
		yield '# %s' % libName
		yield 'LIBRARY_COMPILE_FLAGS+=' + probeVars.get(libName + '_CFLAGS', '')
		yield 'LIBRARY_LINK_FLAGS+=' + probeVars.get(libName + '_LDFLAGS', '')
	yield ''

	for component in iterComponents():
		yield 'COMPONENT_%s:=%s' % (
			component.makeName,
			str(component.canBuild(probeVars)).lower()
			)

if len(sys.argv) == 3:
	rewriteIfChanged(sys.argv[1], iterComponentDefs(sys.argv[2]))
else:
	print >> sys.stderr, (
		'Usage: python components2defs.py COMPONENTS_DEFS PROBE_MAKE'
		)
	sys.exit(2)
