// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_Circle_HeaderFile
#define _Geom_Circle_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom_Circle_HeaderFile
#include <Handle_Geom_Circle.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom_Conic_HeaderFile
#include <Geom_Conic.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Standard_ConstructionError;
class Standard_RangeError;
class gp_Circ;
class gp_Ax2;
class gp_Pnt;
class gp_Vec;
class gp_Trsf;
class Geom_Geometry;


//! Describes a circle in 3D space. <br>
//! A circle is defined by its radius and, as with any conic <br>
//! curve, is positioned in space with a right-handed <br>
//! coordinate system (gp_Ax2 object) where: <br>
//! - the origin is the center of the circle, and <br>
//! - the origin, "X Direction" and "Y Direction" define the <br>
//!   plane of the circle. <br>
//! This coordinate system is the local coordinate <br>
//! system of the circle. <br>
//! The "main Direction" of this coordinate system is the <br>
//! vector normal to the plane of the circle. The axis, of <br>
//! which the origin and unit vector are respectively the <br>
//! origin and "main Direction" of the local coordinate <br>
//! system, is termed the "Axis" or "main Axis" of the circle. <br>
//! The "main Direction" of the local coordinate system <br>
//! gives an explicit orientation to the circle (definition of <br>
//! the trigonometric sense), determining the direction in <br>
//! which the parameter increases along the circle. <br>
//! The Geom_Circle circle is parameterized by an angle: <br>
//! P(U) = O + R*Cos(U)*XDir + R*Sin(U)*YDir, where: <br>
//! - P is the point of parameter U, <br>
//! - O, XDir and YDir are respectively the origin, "X <br>
//! Direction" and "Y Direction" of its local coordinate system, <br>
//! - R is the radius of the circle. <br>
//! The "X Axis" of the local coordinate system therefore <br>
//! defines the origin of the parameter of the circle. The <br>
//! parameter is the angle with this "X Direction". <br>
//! A circle is a closed and periodic curve. The period is <br>
//! 2.*Pi and the parameter range is [ 0, 2.*Pi [. <br>
class Geom_Circle : public Geom_Conic {

public:

  //!  Constructs a circle by conversion of the gp_Circ circle C. <br>
  Standard_EXPORT   Geom_Circle(const gp_Circ& C);
  //! Constructs a circle of radius Radius, where A2 locates the circle and <br>
//!   defines its orientation in 3D space such that: <br>
//!   - the center of the circle is the origin of A2, <br>
//!   - the origin, "X Direction" and "Y Direction" of A2 <br>
//!    define the plane of the circle, <br>
//!   - A2 is the local coordinate system of the circle. <br>
//!  Note: It is possible to create a circle where Radius is equal to 0.0. <br>//! raised if Radius < 0. <br>
  Standard_EXPORT   Geom_Circle(const gp_Ax2& A2,const Standard_Real Radius);
  
//!  Set <me> so that <me> has the same geometric properties as C. <br>
  Standard_EXPORT     void SetCirc(const gp_Circ& C) ;
  //! Assigns the value R to the radius of this circle. <br>
//! Note: it is possible to have a circle with a radius equal to 0.0. <br>
//! Exceptions - Standard_ConstructionError if R is negative. <br>
  Standard_EXPORT     void SetRadius(const Standard_Real R) ;
  
//!  returns the non transient circle from gp with the same <br>
//!  geometric properties as <me>. <br>
  Standard_EXPORT     gp_Circ Circ() const;
  //! Returns the radius of this circle. <br>
  Standard_EXPORT     Standard_Real Radius() const;
  //! Computes the parameter on the reversed circle for <br>
//! the point of parameter U on this circle. <br>
//! For a circle, the returned value is: 2.*Pi - U. <br>
  Standard_EXPORT     Standard_Real ReversedParameter(const Standard_Real U) const;
  //! Returns the eccentricity  e = 0 for a circle. <br>
  Standard_EXPORT     Standard_Real Eccentricity() const;
  //! Returns the value of the first parameter of this <br>
//! circle. This is  0.0, which gives the start point of this circle, or <br>
//!  The start point and end point of a circle are coincident. <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  //! Returns the value of the last parameter of this <br>
//! circle. This is 2.*Pi, which gives the end point of this circle. <br>
//! The start point and end point of a circle are coincident. <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  //! returns True. <br>
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  //! returns True. <br>
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  //! Returns in P the point of parameter U. <br>
//!  P = C + R * Cos (U) * XDir + R * Sin (U) * YDir <br>
//!  where C is the center of the circle , XDir the XDirection and <br>
//!  YDir the YDirection of the circle's local coordinate system. <br>
  Standard_EXPORT     void D0(const Standard_Real U,gp_Pnt& P) const;
  
//!  Returns the point P of parameter U and the first derivative V1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V1) const;
  
//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. <br>
  Standard_EXPORT     void D2(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const;
  
//!  Returns the point P of parameter u, the first second and third <br>
//!  derivatives V1 V2 and V3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) const;
  
//!  The returned vector gives the value of the derivative for the <br>
//!  order of derivation N. <br>//! Raised if N < 1. <br>
  Standard_EXPORT     gp_Vec DN(const Standard_Real U,const Standard_Integer N) const;
  //! Applies the transformation T to this circle. <br>
  Standard_EXPORT     void Transform(const gp_Trsf& T) ;
  //! Creates a new object which is a copy of this circle. <br>
  Standard_EXPORT     Handle_Geom_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom_Circle)

protected:




private: 


Standard_Real radius;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
