/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.db;

import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.db.MapBrokerService;
import org.apache.turbine.services.db.PoolBrokerService;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.db.adapter.DB;
import org.apache.turbine.util.db.map.DatabaseMap;
import org.apache.turbine.util.db.pool.DBConnection;

public abstract class TurbineDB {
    public static String getDefaultMap() {
        return "default";
    }

    public static DatabaseMap getDatabaseMap() throws TurbineException {
        return TurbineDB.getMapBroker().getDatabaseMap();
    }

    public static DatabaseMap getDatabaseMap(String name) throws TurbineException {
        return TurbineDB.getMapBroker().getDatabaseMap(name);
    }

    public static String getDefaultDB() {
        return "default";
    }

    public static DBConnection getConnection() throws Exception {
        return TurbineDB.getPoolBroker().getConnection();
    }

    public static DBConnection getConnection(String name) throws Exception {
        return TurbineDB.getPoolBroker().getConnection(name);
    }

    public static DBConnection getConnection(String driver, String url, String username, String password) throws Exception {
        return TurbineDB.getPoolBroker().getConnection(driver, url, username, password);
    }

    public static void releaseConnection(DBConnection dbconn) throws Exception {
        TurbineDB.getPoolBroker().releaseConnection(dbconn);
    }

    public static void registerPool(String name, String driver, String url, String username, String password) throws Exception {
        TurbineDB.getPoolBroker().registerPool(name, driver, url, username, password);
    }

    public static DB getDB() throws Exception {
        return TurbineDB.getPoolBroker().getDB();
    }

    public static DB getDB(String name) throws Exception {
        return TurbineDB.getPoolBroker().getDB(name);
    }

    private static MapBrokerService getMapBroker() {
        return (MapBrokerService)TurbineServices.getInstance().getService("MapBrokerService");
    }

    private static PoolBrokerService getPoolBroker() {
        return (PoolBrokerService)TurbineServices.getInstance().getService("PoolBrokerService");
    }
}

