c
c     get solvent data
c
      logical function solv_data(solvname_short,solvname_long, !short and long solvent names
     &   eps,epsinf,sola,solb,solc,solg,solh,soln,icds)
c
      implicit none
c
      integer icds
c
      character*8 solvname_short ! short name of solvent
      character*35 solvname_long ! long name of solvent
      double precision eps,epsinf
c
      double precision sola,solb,solc,solg,solh,soln
      solv_data=.true.
c
c     get the solvent data
c
      if (solvname_short.eq.'h2o') solvname_long='water' ! default
      if (solvname_short.eq.'unkn') then
         solvname_long='unknown'  ! default
         solv_data=.false.
         return
      endif
      eps=0d0
      epsinf=0d0
      call DATSOLMN(solvname_short,solvname_long,
     &     EPS,EPSINF,
     &     SOLA,SOLB,SOLC,SOLG,SOLH,SOLN)
      if(eps.eq.0d0.and.epsinf.eq.0d0) then
         write(6,*) ' no data from solv_data for',solvname_short
         solv_data=.false.
         return
      endif
c
c     set icds
c
      icds = 1 ! for water
      if (solvname_short.ne.'h2o'.and.solvname_long.ne.'water') 
     &   icds = 2
c
      return
      end
c
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C*MODULE MNSOL  *DECK DATSOLMN
C
C     Source: http://comp.chem.umn.edu/solvation/mnsddb.pdf
C
      SUBROUTINE DATSOLMN
     $(ZSOLMN,ZSOLMNLONG,EPS,EPSINF,SOLA,SOLB,SOLC,SOLG,
     $ SOLH,SOLN)
C     
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C     
C     LOGICAL MASWRK
C   
      CHARACTER*8 ZSOLMN,SOLMN
      CHARACTER*35 ZSOLMNLONG,SOLMNLONG
C
      DIMENSION SOLMN(179),DEPS(179),DSOLA(179),DSOLB(179),
     $          DSOLC(179),DSOLG(179),DSOLH(179),DSOLN(179),
     $          SOLMNLONG(179)
C
C SHORT NAMES OF 179 AVAILABLE SOLVENTS
      DATA SOLMN/
     $ 'acetacid',
     $ 'acetone ',
     $ 'acetntrl',
     $ 'acetphen',
     $ 'aniline ',
     $ 'anisole ',
     $ 'benzaldh',
     $ 'benzene ',
     $ 'benzntrl',
     $ 'benzylcl',
     $ 'brisobut',
     $ 'brbenzen',
     $ 'brethane',
     $ 'bromform',
     $ 'broctane',
     $ 'brpentan',
     $ 'brpropa2',
     $ 'brpropan',
     $ 'butanal ',
     $ 'butacid ',
     $ 'butanol ',
     $ 'butanol2',
     $ 'butanone',
     $ 'butantrl',
     $ 'butile  ',
     $ 'nba     ',
     $ 'nbutbenz',
     $ 'sbutbenz',
     $ 'tbutbenz',
     $ 'cs2     ',
     $ 'carbntet',
     $ 'clbenzen',
     $ 'secbutcl',
     $ 'chcl3   ',
     $ 'clhexane',
     $ 'clpentan',
     $ 'clpropan',
     $ 'ocltolue',
     $ 'm-cresol',
     $ 'o-cresol',
     $ 'cychexan',
     $ 'cychexon',
     $ 'cycpentn',
     $ 'cycpntol',
     $ 'cycpnton',
     $ 'declncis',
     $ 'declntra',
     $ 'declnmix',
     $ 'decane  ',
     $ 'decanol ',
     $ 'edb12   ',
     $ 'dibrmetn',
     $ 'butyleth',
     $ 'odiclbnz',
     $ 'edc12   ',
     $ 'c12dce  ',
     $ 't12dce  ',
     $ 'dcm     ',
     $ 'ether   ',
     $ 'et2s    ',
     $ 'dietamin',
     $ 'mi      ',
     $ 'dipe    ',
     $ 'dmds    ',
     $ 'dmso    ',
     $ 'dma     ',
     $ 'cisdmchx',
     $ 'dmf     ',
     $ 'dmepen24',
     $ 'dmepyr24',
     $ 'dmepyr26',
     $ 'dioxane ',
     $ 'phoph   ',
     $ 'dproamin',
     $ 'dodecan ',
     $ 'meg     ',
     $ 'etsh    ',
     $ 'ethanol ',
     $ 'etoac   ',
     $ 'etome   ',
     $ 'eb      ',
     $ 'phenetol',
     $ 'c6h5f   ',
     $ 'foctane ',
     $ 'formamid',
     $ 'formacid',
     $ 'heptane ',
     $ 'heptanol',
     $ 'heptnon2',
     $ 'heptnon4',
     $ 'hexadecn',
     $ 'hexane  ',
     $ 'hexnacid',
     $ 'hexanol ',
     $ 'hexanon2',
     $ 'hexene  ',
     $ 'hexyne  ',
     $ 'c6h5i   ',
     $ 'iobutane',
     $ 'c2h5i   ',
     $ 'iohexdec',
     $ 'ch3i    ',
     $ 'iopentan',
     $ 'iopropan',
     $ 'cumene  ',
     $ 'p-cymene',
     $ 'mesityln',
     $ 'methanol',
     $ 'egme    ',
     $ 'meacetat',
     $ 'mebnzate',
     $ 'mebutate',
     $ 'meformat',
     $ 'mibk    ',
     $ 'mepropyl',
     $ 'isobutol',
     $ 'terbutol',
     $ 'nmeaniln',
     $ 'mecychex',
     $ 'nmfmixtr',
     $ 'isohexan',
     $ 'mepyrid2',
     $ 'mepyrid3',
     $ 'mepyrid4',
     $ 'c6h5no2 ',
     $ 'c2h5no2 ',
     $ 'ch3no2  ',
     $ 'ntrprop1',
     $ 'ntrprop2',
     $ 'ontrtolu',
     $ 'nonane  ',
     $ 'nonanol ',
     $ 'nonanone',
     $ 'octane  ',
     $ 'octanol ',
     $ 'octanon2',
     $ 'pentdecn',
     $ 'pentanal',
     $ 'npentane',
     $ 'pentacid',
     $ 'pentanol',
     $ 'pentnon2',
     $ 'pentnon3',
     $ 'pentene ',
     $ 'e2penten',
     $ 'pentacet',
     $ 'pentamin',
     $ 'pfb     ',
     $ 'benzalcl',
     $ 'propanal',
     $ 'propacid',
     $ 'propanol',
     $ 'propnol2',
     $ 'propntrl',
     $ 'propenol',
     $ 'propacet',
     $ 'propamin',
     $ 'pyridine',
     $ 'c2cl4   ',
     $ 'thf     ',
     $ 'sulfolan',
     $ 'tetralin',
     $ 'thiophen',
     $ 'phsh    ',
     $ 'toluene ',
     $ 'tbp     ',
     $ 'tca111  ',
     $ 'tca112  ',
     $ 'tce     ',
     $ 'et3n    ',
     $ 'tfe222  ',
     $ 'tmben124',
     $ 'isoctane',
     $ 'undecane',
     $ 'm-xylene',
     $ 'o-xylene',
     $ 'p-xylene',
     $ 'xylenemx',
     $ 'h2o'/
C
C LONG NAMES OF 178 AVAILABLE NONAQUEOUS SOLVENTS
      DATA SOLMNLONG/
     $ 'acetic acid',
     $ 'acetone',
     $ 'acetonitrile',
     $ 'acetophenone',
     $ 'aniline',
     $ 'anisole',
     $ 'benzaldehyde',
     $ 'benzene',
     $ 'benzonitrile',
     $ 'benzyl chloride',
     $ '1-bromo-2-methylpropane',
     $ 'bromobenzene',
     $ 'bromoethane',
     $ 'bromoform',
     $ '1-bromooctane',
     $ '1-bromopentane',
     $ '2-bromopropane',
     $ '1-bromopropane',
     $ 'butanal',
     $ 'butanoic acid',
     $ '1-butanol',
     $ '2-butanol',
     $ 'butanone',
     $ 'butanonitrile',
     $ 'butyl acetate',
     $ 'butylamine',
     $ 'n-butylbenzene',
     $ 'sec-butylbenzene',
     $ 'tert-butylbenzene',
     $ 'carbon disulfide',
     $ 'carbon tetrachloride',
     $ 'chlorobenzene',
     $ 'sec-butyl chloride',
     $ 'chloroform',
     $ '1-chlorohexane',
     $ '1-chloropentane',
     $ '1-chloropropane',
     $ 'o-chlorotoluene',
     $ 'm-cresol',
     $ 'o-cresol',
     $ 'cyclohexane',
     $ 'cyclohexanone',
     $ 'cyclopentane',
     $ 'cyclopentanol',
     $ 'cyclopentanone',
     $ 'cis-decalin',
     $ 'trans-decalin',
     $ 'decalin (cis/trans mixture)',
     $ 'n-decane',
     $ '1-decanol',
     $ '1,2-dibromoethane',
     $ 'dibromomethane',
     $ 'dibutyl ether',
     $ 'o-dichlorobenzene',
     $ '1,2-dichloroethane',
     $ 'cis-dichloroethylene',
     $ 'trans-dichloroethylene',
     $ 'dichloromethane',
     $ 'diethyl ether',
     $ 'diethyl sulfide',
     $ 'diethylamine',
     $ 'diiodomethane',
     $ 'diisopropyl ether',
     $ 'dimethyl disulfide',
     $ 'dimethylsulfoxide',
     $ 'N,N-dimethylacetamide',
     $ 'cis-1,2-dimethylcyclohexane',
     $ 'N,N-dimethylformamide',
     $ '2,4-dimethylpentane',
     $ '2,4-dimethylpyridine',
     $ '2,6-dimethylpyridine',
     $ '1,4-dioxane',
     $ 'diphenyl ether',
     $ 'dipropylamine',
     $ 'n-dodecane',
     $ '1,2-ethanediol',
     $ 'ethanethiol',
     $ 'ethanol',
     $ 'ethyl acetate',
     $ 'ethyl formate',
     $ 'ethylbenzene',
     $ 'ethylphenyl ether',
     $ 'fluorobenzene',
     $ '1-fluorooctane',
     $ 'formamide',
     $ 'formic acid',
     $ 'n-heptane',
     $ '1-heptanol',
     $ '2-heptanone',
     $ '4-heptanone',
     $ 'n-hexadecane',
     $ 'n-hexane',
     $ 'hexanoic acid',
     $ '1-hexanol',
     $ '2-hexanone',
     $ '1-hexene',
     $ '1-hexyne',
     $ 'iodobenzene',
     $ '1-iodobutane',
     $ 'iodoethane',
     $ '1-iodohexadecane',
     $ 'iodomethane',
     $ '1-iodopentane',
     $ '1-iodopropane',
     $ 'isopropylbenzene',
     $ 'p-isopropyltoluene',
     $ 'mesitylene',
     $ 'methanol',
     $ '2-methoxyethanol',
     $ 'methyl acetate',
     $ 'methyl benzoate',
     $ 'methyl butanoate',
     $ 'methyl formate',
     $ '4-methyl-2-pentanone',
     $ 'methyl propanoate',
     $ '2-methyl-1-propanol',
     $ '2-methyl-2-propanol',
     $ 'N-methylaniline',
     $ 'methylcyclohexane',
     $ 'N-methylformamide (E/Z mixture)',
     $ '2-methylpentane',
     $ '2-methylpyridine',
     $ '3-methylpyridine',
     $ '4-methylpyridine',
     $ 'nitrobenzene',
     $ 'nitroethane',
     $ 'nitromethane',
     $ '1-nitropropane',
     $ '2-nitropropane',
     $ 'o-nitrotoluene',
     $ 'n-nonane',
     $ '1-nonanol',
     $ '5-nonanone',
     $ 'n-octane',
     $ '1-octanol',
     $ '2-octanone',
     $ 'n-pentadecane',
     $ 'pentanal',
     $ 'n-pentane',
     $ 'pentanoic acid',
     $ '1-pentanol',
     $ '2-pentanone',
     $ '3-pentanone',
     $ '1-pentene',
     $ 'E-2-pentene',
     $ 'pentyl acetate',
     $ 'pentylamine',
     $ 'perfluorobenzene',
     $ 'phenylmethanol',
     $ 'propanal',
     $ 'propanoic acid',
     $ '1-propanol',
     $ '2-propanol',
     $ 'propanonitrile',
     $ '2-propen-1-ol',
     $ 'propyl acetate',
     $ 'propylamine',
     $ 'pyridine',
     $ 'tetrachloroethene',
     $ 'tetrahydrofuran',
     $ 'tetrahydrothiophene-S,S-dioxide',
     $ 'tetralin',
     $ 'thiophene',
     $ 'thiophenol',
     $ 'toluene',
     $ 'tributyl phosphate',
     $ '1,1,1-trichloroethane',
     $ '1,1,2-trichloroethane',
     $ 'trichloroethene',
     $ 'triethylamine',
     $ '2,2,2-trifluoroethanol',
     $ '1,2,4-trimethylbenzene',
     $ '2,2,4-trimethylpentane',
     $ 'n-undecane',
     $ 'm-xylene',
     $ 'o-xylene',
     $ 'p-xylene',
     $ 'xylene (mixture)',
     $ 'water'/
C
C DIELECTRIC CONSTANT AT 298 K
      DATA DEPS/
     $ 6.2528,
     $ 20.493,
     $ 35.688,
     $ 17.44,
     $ 6.8882,
     $ 4.2247,
     $ 18.220,
     $ 2.2706,
     $ 25.592,
     $ 6.7175,
     $ 7.7792,
     $ 5.3954,
     $ 9.01,
     $ 4.2488,
     $ 5.0244,
     $ 6.269,
     $ 9.3610,
     $ 8.0496,
     $ 13.45,
     $ 2.9931,
     $ 17.332,
     $ 15.944,
     $ 18.246,
     $ 24.291,
     $ 4.9941,
     $ 4.6178,
     $ 2.36,
     $ 2.3446,
     $ 2.3447,
     $ 2.6105,
     $ 2.2280,
     $ 5.6968,
     $ 8.3930,
     $ 4.7113,
     $ 5.9491,
     $ 6.5022,
     $ 8.3548,
     $ 4.6331,
     $ 12.44,
     $ 6.76,
     $ 2.0165,
     $ 15.619,
     $ 1.9608,
     $ 16.989,
     $ 13.58,
     $ 2.2139,
     $ 2.1781,
     $ 2.196,
     $ 1.9846,
     $ 7.5305,
     $ 4.9313,
     $ 7.2273,
     $ 3.0473,
     $ 9.9949,
     $ 10.125,
     $ 9.2,
     $ 2.14,
     $ 8.93,
     $ 4.2400,
     $ 5.723,
     $ 3.5766,
     $ 5.32,
     $ 3.38,
     $ 9.6,
     $ 46.826,
     $ 37.781,
     $ 2.06,
     $ 37.219,
     $ 1.8939,
     $ 9.4176,
     $ 7.1735,
     $ 2.2099,
     $ 3.73,
     $ 2.9112,
     $ 2.0060,
     $ 40.245,
     $ 6.667,
     $ 24.852,
     $ 5.9867,
     $ 8.3310,
     $ 2.4339,
     $ 4.1797,
     $ 5.42,
     $ 3.89,
     $ 108.94,
     $ 51.1,
     $ 1.9113,
     $ 11.321,
     $ 11.658,
     $ 12.257,
     $ 2.0402,
     $ 1.8819,
     $ 2.6,
     $ 12.51,
     $ 14.136,
     $ 2.0717,
     $ 2.615,
     $ 4.5470,
     $ 6.173,
     $ 7.6177,
     $ 3.5338,
     $ 6.8650,
     $ 5.6973,
     $ 6.9626,
     $ 2.3712,
     $ 2.2322,
     $ 2.2650,
     $ 32.613,
     $ 17.2,
     $ 6.8615,
     $ 6.7367,
     $ 5.5607,
     $ 8.8377,
     $ 12.887,
     $ 6.0777,
     $ 16.777,
     $ 12.47,
     $ 5.9600,
     $ 2.024,
     $ 181.56,
     $ 1.89,
     $ 9.9533,
     $ 11.645,
     $ 11.957,
     $ 34.809,
     $ 28.29,
     $ 36.562,
     $ 23.73,
     $ 25.654,
     $ 25.669,
     $ 1.9605,
     $ 8.5991,
     $ 10.6,
     $ 1.9406,
     $ 9.8629,
     $ 9.4678,
     $ 2.0333,
     $ 10.00,
     $ 1.8371,
     $ 2.6924,
     $ 15.13,
     $ 15.200,
     $ 16.78,
     $ 1.9905,
     $ 2.051,
     $ 4.7297,
     $ 4.2010,
     $ 2.029,
     $ 12.457,
     $ 18.5,
     $ 3.44,
     $ 20.524,
     $ 19.264,
     $ 29.324,
     $ 19.011,
     $ 5.5205,
     $ 4.9912,
     $ 12.978,
     $ 2.268,
     $ 7.4257,
     $ 43.962,
     $ 2.771,
     $ 2.7270,
     $ 4.2728,
     $ 2.3741,
     $ 8.1781,
     $ 7.0826,
     $ 7.1937,
     $ 3.422,
     $ 2.3832,
     $ 26.726,
     $ 2.3653,
     $ 1.9358,
     $ 1.9910,
     $ 2.3478,
     $ 2.5454,
     $ 2.2705,
     $ 2.3879,
     $ 78.40/
C 
C ABRAHAM'S ALPHAS
      DATA DSOLA/
     $ 0.61,
     $ 0.04,
     $ 0.07,
     $ 0.00,
     $ 0.26,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.15,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.60,
     $ 0.37,
     $ 0.33,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.16,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.15,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.57,
     $ 0.52,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.32,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.37,
     $ 0.10,
     $ 0.10,
     $ 0.00,
     $ 0.00,
     $ 0.10,
     $ 0.11,
     $ 0.09,
     $ 0.10,
     $ 0.00,
     $ 0.00,
     $ 0.08,
     $ 0.05,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.08,
     $ 0.00,
     $ 0.58,
     $ 0.00,
     $ 0.37,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.62,
     $ 0.75,
     $ 0.00,
     $ 0.37,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.60,
     $ 0.37,
     $ 0.00,
     $ 0.00,
     $ 0.12,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.43,
     $ 0.30,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.37,
     $ 0.31,
     $ 0.17,
     $ 0.00,
     $ 0.40,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.02,
     $ 0.06,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.37,
     $ 0.00,
     $ 0.00,
     $ 0.37,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.60,
     $ 0.37,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.16,
     $ 0.00,
     $ 0.33,
     $ 0.00,
     $ 0.60,
     $ 0.37,
     $ 0.33,
     $ 0.02,
     $ 0.38,
     $ 0.00,
     $ 0.16,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.09,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.13,
     $ 0.08,
     $ 0.00,
     $ 0.57,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.82/  ! water
C
C ABRAHAM'S BETAS
      DATA DSOLB/
     $ 0.44,
     $ 0.49,
     $ 0.32,
     $ 0.48,
     $ 0.41,
     $ 0.29,
     $ 0.39,
     $ 0.14,
     $ 0.33,
     $ 0.33,
     $ 0.12,
     $ 0.09,
     $ 0.12,
     $ 0.06,
     $ 0.12,
     $ 0.12,
     $ 0.14,
     $ 0.12,
     $ 0.45,
     $ 0.45,
     $ 0.48,
     $ 0.56,
     $ 0.51,
     $ 0.36,
     $ 0.45,
     $ 0.61,
     $ 0.15,
     $ 0.16,
     $ 0.16,
     $ 0.07,
     $ 0.00,
     $ 0.07,
     $ 0.12,
     $ 0.02,
     $ 0.10,
     $ 0.10,
     $ 0.10,
     $ 0.07,
     $ 0.34,
     $ 0.30,
     $ 0.00,
     $ 0.56,
     $ 0.00,
     $ 0.56,
     $ 0.52,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.00,
     $ 0.48,
     $ 0.17,
     $ 0.10,
     $ 0.45,
     $ 0.04,
     $ 0.11,
     $ 0.05,
     $ 0.05,
     $ 0.05,
     $ 0.41,
     $ 0.32,
     $ 0.69,
     $ 0.23,
     $ 0.41,
     $ 0.28,
     $ 0.88,
     $ 0.78,
     $ 0.00,
     $ 0.74,
     $ 0.00,
     $ 0.63,
     $ 0.63,
     $ 0.64,
     $ 0.20,
     $ 0.69,
     $ 0.00,
     $ 0.78,
     $ 0.24,
     $ 0.48,
     $ 0.45,
     $ 0.38,
     $ 0.15,
     $ 0.32,
     $ 0.10,
     $ 0.10,
     $ 0.60,
     $ 0.38,
     $ 0.00,
     $ 0.48,
     $ 0.51,
     $ 0.51,
     $ 0.00,
     $ 0.00,
     $ 0.45,
     $ 0.48,
     $ 0.51,
     $ 0.07,
     $ 0.10,
     $ 0.12,
     $ 0.15,
     $ 0.15,
     $ 0.15,
     $ 0.13,
     $ 0.15,
     $ 0.15,
     $ 0.16,
     $ 0.19,
     $ 0.19,
     $ 0.47,
     $ 0.84,
     $ 0.45,
     $ 0.46,
     $ 0.45,
     $ 0.38,
     $ 0.51,
     $ 0.45,
     $ 0.48,
     $ 0.60,
     $ 0.43,
     $ 0.00,
     $ 0.55,
     $ 0.00,
     $ 0.58,
     $ 0.54,
     $ 0.54,
     $ 0.28,
     $ 0.33,
     $ 0.31,
     $ 0.31,
     $ 0.33,
     $ 0.27,
     $ 0.00,
     $ 0.48,
     $ 0.51,
     $ 0.00,
     $ 0.48,
     $ 0.51,
     $ 0.00,
     $ 0.45,
     $ 0.00,
     $ 0.45,
     $ 0.48,
     $ 0.51,
     $ 0.51,
     $ 0.07,
     $ 0.07,
     $ 0.45,
     $ 0.61,
     $ 0.00,
     $ 0.56,
     $ 0.45,
     $ 0.45,
     $ 0.48,
     $ 0.56,
     $ 0.36,
     $ 0.48,
     $ 0.45,
     $ 0.61,
     $ 0.52,
     $ 0.00,
     $ 0.48,
     $ 0.88,
     $ 0.19,
     $ 0.15,
     $ 0.16,
     $ 0.14,
     $ 1.21,
     $ 0.09,
     $ 0.13,
     $ 0.03,
     $ 0.79,
     $ 0.25,
     $ 0.19,
     $ 0.00,
     $ 0.00,
     $ 0.16,
     $ 0.16,
     $ 0.16,
     $ 0.16,
     $ 0.35/  ! water
C
C AROMATICITY: fraction of non-hydrogenic solvent atoms that are aromatic carbon atoms
      DATA DSOLC/
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.667,
     $ 0.857,
     $ 0.750,
     $ 0.857,
     $ 1.000,
     $ 0.750,
     $ 0.750,
     $ 0.000,
     $ 0.857,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.600,
     $ 0.600,
     $ 0.600,
     $ 0.000,
     $ 0.000,
     $ 0.857,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.750,
     $ 0.750,
     $ 0.750,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.750,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.625,
     $ 0.625,
     $ 0.000,
     $ 0.923,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.750,
     $ 0.667,
     $ 0.857,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.857,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.667,
     $ 0.600,
     $ 0.667,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.600,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.750,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.714,
     $ 0.714,
     $ 0.714,
     $ 0.667,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.600,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.500,
     $ 0.750,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.833,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.600,
     $ 0.800,
     $ 0.857,
     $ 0.857,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.667,
     $ 0.000,
     $ 0.000,
     $ 0.750,
     $ 0.750,
     $ 0.750,
     $ 0.750,
     $ 0.00/  ! water
C
C MACROSCOPIC SURFACE TENSION AT 298 K
      DATA DSOLG/
     $ 39.01,
     $ 33.77,
     $ 41.25,
     $ 56.19,
     $ 60.62,
     $ 50.52,
     $ 54.69,
     $ 40.62,
     $ 55.83,
     $ 53.04,
     $ 34.69,
     $ 50.72,
     $ 34,
     $ 64.58,
     $ 41.28,
     $ 38.7,
     $ 33.46,
     $ 36.36,
     $ 35.06,
     $ 37.49,
     $ 35.88,
     $ 32.44,
     $ 34.5,
     $ 38.75,
     $ 35.81,
     $ 33.74,
     $ 41.33,
     $ 40.35,
     $ 39.78,
     $ 45.45,
     $ 38.04,
     $ 47.48,
     $ 31.1,
     $ 38.39,
     $ 37.03,
     $ 35.12,
     $ 30.66,
     $ 47.43,
     $ 51.37,
     $ 53.11,
     $ 35.48,
     $ 49.76,
     $ 31.49,
     $ 46.8,
     $ 47.21,
     $ 45.45,
     $ 42.19,
     $ 43.82,
     $ 33.64,
     $ 41.04,
     $ 56.93,
     $ 56.21,
     $ 35.98,
     $ 52.72,
     $ 45.86,
     $ 39.8,
     $ 37.13,
     $ 39.15,
     $ 23.96,
     $ 35.36,
     $ 28.57,
     $ 95.25,
     $ 24.86,
     $ 48.06,
     $ 61.78,
     $ 47.62,
     $ 36.28,
     $ 49.56,
     $ 25.42,
     $ 46.86,
     $ 44.64,
     $ 47.14,
     $ 38.5,
     $ 32.11,
     $ 35.85,
     $ 69.07,
     $ 33.22,
     $ 31.62,
     $ 33.67,
     $ 33.36,
     $ 41.38,
     $ 46.65,
     $ 38.37,
     $ 33.92,
     $ 82.08,
     $ 53.44,
     $ 28.28,
     $ 38.5,
     $ 37.6,
     $ 35.98,
     $ 38.93,
     $ 25.75,
     $ 39.65,
     $ 37.15,
     $ 36.63,
     $ 25.76,
     $ 28.79,
     $ 55.72,
     $ 40.65,
     $ 40.96,
     $ 46.48,
     $ 43.67,
     $ 41.56,
     $ 41.45,
     $ 39.85,
     $ 38.34,
     $ 39.65,
     $ 31.77,
     $ 44.39,
     $ 35.59,
     $ 53.5,
     $ 35.44,
     $ 35.06,
     $ 33.83,
     $ 35.18,
     $ 32.38,
     $ 28.73,
     $ 53.11,
     $ 33.52,
     $ 55.44,
     $ 24.3,
     $ 47.5,
     $ 49.61,
     $ 50.17,
     $ 57.54,
     $ 46.25,
     $ 52.58,
     $ 43.32,
     $ 42.16,
     $ 59.12,
     $ 32.21,
     $ 40.14,
     $ 37.83,
     $ 30.43,
     $ 39.01,
     $ 37.29,
     $ 38.34,
     $ 36.62,
     $ 22.3,
     $ 38.4,
     $ 36.5,
     $ 33.46,
     $ 35.61,
     $ 22.24,
     $ 23.62,
     $ 36.23,
     $ 35.54,
     $ 31.74,
     $ 52.96,
     $ 32.48,
     $ 37.71,
     $ 33.57,
     $ 30.13,
     $ 38.5,
     $ 36.39,
     $ 34.26,
     $ 31.31,
     $ 52.62,
     $ 45.19,
     $ 39.44,
     $ 87.49,
     $ 47.74,
     $ 44.16,
     $ 55.24,
     $ 40.2,
     $ 27.55,
     $ 36.24,
     $ 48.97,
     $ 41.45,
     $ 29.1,
     $ 42.02,
     $ 42.03,
     $ 26.38,
     $ 34.85,
     $ 40.98,
     $ 42.83,
     $ 40.32,
     $ 41.38,
     $ 103.62/  ! water
C
C ELECTRONEGATIVE HALOGENICITY: fraction of non-hydrogenic solvent atoms that are F, Cl, or Br
      DATA DSOLH/
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.125,
     $ 0.200,
     $ 0.143,
     $ 0.333,
     $ 0.750,
     $ 0.111,
     $ 0.167,
     $ 0.250,
     $ 0.250,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.800,
     $ 0.143,
     $ 0.200,
     $ 0.750,
     $ 0.143,
     $ 0.167,
     $ 0.250,
     $ 0.125,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.500,
     $ 0.667,
     $ 0.000,
     $ 0.250,
     $ 0.500,
     $ 0.500,
     $ 0.500,
     $ 0.667,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.143,
     $ 0.111,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.500,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.667,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.600,
     $ 0.600,
     $ 0.600,
     $ 0.000,
     $ 0.500,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.000,
     $ 0.00/  ! water
C
C INDEX OF REFRACTION AT OPTICAL FREQUENCY AT 293 K  
      DATA DSOLN/
     $ 1.3720,
     $ 1.3588,
     $ 1.3442,
     $ 1.5372,
     $ 1.5863,
     $ 1.5174,
     $ 1.5463,
     $ 1.5011,
     $ 1.5289,
     $ 1.5391,
     $ 1.4348,
     $ 1.5597,
     $ 1.4239,
     $ 1.6005,
     $ 1.4524,
     $ 1.4447,
     $ 1.4251,
     $ 1.4343,
     $ 1.3843,
     $ 1.3980,
     $ 1.3993,
     $ 1.3978,
     $ 1.3788,
     $ 1.3842,
     $ 1.3941,
     $ 1.4031,
     $ 1.4898,
     $ 1.4895,
     $ 1.4927,
     $ 1.6319,
     $ 1.4601,
     $ 1.5241,
     $ 1.3971,
     $ 1.4459,
     $ 1.4199,
     $ 1.4127,
     $ 1.3879,
     $ 1.5268,
     $ 1.5438,
     $ 1.5361,
     $ 1.4266,
     $ 1.4507,
     $ 1.4065,
     $ 1.4530,
     $ 1.4366,
     $ 1.4810,
     $ 1.4695,
     $ 1.4753,
     $ 1.4102,
     $ 1.4372,
     $ 1.5387,
     $ 1.5420,
     $ 1.3992,
     $ 1.5515,
     $ 1.4448,
     $ 1.4490,
     $ 1.4454,
     $ 1.4242,
     $ 1.3526,
     $ 1.4430,
     $ 1.3864,
     $ 1.7425,
     $ 1.3679,
     $ 1.5289,
     $ 1.4170,
     $ 1.4380,
     $ 1.4360,
     $ 1.4305,
     $ 1.3815,
     $ 1.5010,
     $ 1.4953,
     $ 1.4224,
     $ 1.5787,
     $ 1.4050,
     $ 1.4216,
     $ 1.4318,
     $ 1.4310,
     $ 1.3611,
     $ 1.3723,
     $ 1.3599,
     $ 1.4959,
     $ 1.5076,
     $ 1.4684,
     $ 1.3935,
     $ 1.4472,
     $ 1.3714,
     $ 1.3878,
     $ 1.4249,
     $ 1.4088,
     $ 1.4069,
     $ 1.4345,
     $ 1.3749,
     $ 1.4163,
     $ 1.4178,
     $ 1.4007,
     $ 1.3837,
     $ 1.3989,
     $ 1.6200,
     $ 1.5001,
     $ 1.5133,
     $ 1.4806,
     $ 1.5380,
     $ 1.4959,
     $ 1.5058,
     $ 1.4915,
     $ 1.4909,
     $ 1.4994,
     $ 1.3288,
     $ 1.4024,
     $ 1.3614,
     $ 1.5164,
     $ 1.3878,
     $ 1.3433,
     $ 1.3962,
     $ 1.3775,
     $ 1.3955,
     $ 1.3878,
     $ 1.5684,
     $ 1.4231,
     $ 1.4319,
     $ 1.3715,
     $ 1.4957,
     $ 1.5040,
     $ 1.5037,
     $ 1.5562,
     $ 1.3917,
     $ 1.3817,
     $ 1.4018,
     $ 1.3944,
     $ 1.5450,
     $ 1.4054,
     $ 1.4333,
     $ 1.4195,
     $ 1.3974,
     $ 1.4295,
     $ 1.4151,
     $ 1.4315,
     $ 1.3944,
     $ 1.3575,
     $ 1.4085,
     $ 1.4101,
     $ 1.3895,
     $ 1.3924,
     $ 1.3715,
     $ 1.3793,
     $ 1.4023,
     $ 1.448,
     $ 1.3777,
     $ 1.5396,
     $ 1.3636,
     $ 1.3869,
     $ 1.3850,
     $ 1.3776,
     $ 1.3655,
     $ 1.4135,
     $ 1.3842,
     $ 1.3870,
     $ 1.5095,
     $ 1.5053,
     $ 1.4050,
     $ 1.4833,
     $ 1.5413,
     $ 1.5289,
     $ 1.5893,
     $ 1.4961,
     $ 1.4224,
     $ 1.4379,
     $ 1.4714,
     $ 1.4773,
     $ 1.4010,
     $ 1.2907,
     $ 1.5048,
     $ 1.3915,
     $ 1.4398,
     $ 1.4972,
     $ 1.5055,
     $ 1.4958,
     $ 1.4995,
     $ 1.333/  ! water
C
       DO I=1,179
        IF (ZSOLMN.EQ.SOLMN(I)) THEN
           ZSOLMNLONG=SOLMNLONG(I)
           EPS=DEPS(I)
           SOLA=DSOLA(I)
           SOLB=DSOLB(I)
           SOLC=DSOLC(I)
           SOLG=DSOLG(I)
           SOLH=DSOLH(I)
           SOLN=DSOLN(I)
           EPSINF=SOLN**2
           RETURN
        ENDIF
       ENDDO
C
       ZSOLMNLONG='unknown'
C
       RETURN
C
      END 
c $Id$
