# -*- coding: utf-8 -*-
# -*- coding: utf8 -*-
"""Autogenerated file - DO NOT EDIT
If you spot a bug, please report it on the mailing list and/or change the generator."""

import os

from ...base import (
    CommandLine,
    CommandLineInputSpec,
    SEMLikeCommandLine,
    TraitedSpec,
    File,
    Directory,
    traits,
    isdefined,
    InputMultiPath,
    OutputMultiPath,
)


class scalartransformInputSpec(CommandLineInputSpec):
    input_image = File(desc="Image to tranform", exists=True, argstr="--input_image %s")
    output_image = traits.Either(
        traits.Bool,
        File(),
        hash_files=False,
        desc="The transformed image",
        argstr="--output_image %s",
    )
    transformation = traits.Either(
        traits.Bool,
        File(),
        hash_files=False,
        desc="Output file for transformation parameters",
        argstr="--transformation %s",
    )
    invert = traits.Bool(desc="Invert tranform before applying.", argstr="--invert ")
    deformation = File(
        desc="Deformation field.", exists=True, argstr="--deformation %s"
    )
    h_field = traits.Bool(desc="The deformation is an h-field.", argstr="--h_field ")
    interpolation = traits.Enum(
        "nearestneighbor",
        "linear",
        "cubic",
        desc="Interpolation type (nearestneighbor, linear, cubic)",
        argstr="--interpolation %s",
    )


class scalartransformOutputSpec(TraitedSpec):
    output_image = File(desc="The transformed image", exists=True)
    transformation = File(desc="Output file for transformation parameters", exists=True)


class scalartransform(SEMLikeCommandLine):
    """title: ScalarTransform (DTIProcess)

    category: Legacy.Registration

    version: 1.0.0

    documentation-url: http://www.slicer.org/slicerWiki/index.php/Documentation/Nightly/Extensions/DTIProcess

    license: Copyright (c)  Casey Goodlett. All rights reserved.
      See http://www.ia.unc.edu/dev/Copyright.htm for details.
         This software is distributed WITHOUT ANY WARRANTY; without even
         the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
         PURPOSE.  See the above copyright notices for more information.

    contributor: Casey Goodlett
    """

    input_spec = scalartransformInputSpec
    output_spec = scalartransformOutputSpec
    _cmd = " scalartransform "
    _outputs_filenames = {
        "output_image": "output_image.nii",
        "transformation": "transformation",
    }
    _redirect_x = False
