/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2011 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2011 Sun Microsystems, Inc.
 */

package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.openide.filesystems.FileSystem;

/**
 *
 * @author Vladimir Voskresensky
 */
public final class FileBufferSnapshot implements APTFileBuffer {
    
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private final char[] buffer;
    private final long timeStamp;
    private Reference<Line2Offset> lines;
    private final APTFileBuffer.BufferType bufType;
    
    public FileBufferSnapshot(FileSystem fileSystem, CharSequence absPath, APTFileBuffer.BufferType bufType, char[] buffer, int[] linesCache, long timeStamp) {
        this.absPath = absPath;
        this.fileSystem = fileSystem;
        this.buffer = buffer;
        this.timeStamp = timeStamp;
        if (linesCache != null) {
             lines = new WeakReference<>(new Line2Offset(buffer, linesCache));
        } else {
             lines = new WeakReference<>(null);
        }
        this.bufType = bufType;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    @Override
    public APTFileBuffer.BufferType getType() {
        return bufType;
    }
    
    @Override
    public CharSequence getAbsolutePath() {
        return absPath;
    }

    @Override
    public FileSystem getFileSystem() {
        return fileSystem;
    }

    @Override
    @SuppressWarnings("ReturnOfCollectionOrArrayField")
    public char[] getCharBuffer() throws IOException {
        return buffer;
    }

    public int[] getLineColumnByOffset(int offset) throws IOException {
        return getLine2Offset().getLineColumnByOffset(offset);
    }

    public int getOffsetByLineColumn(int line, int column) throws IOException {
        return getLine2Offset().getOffsetByLineColumn(line, column);
    }

    private Line2Offset getLine2Offset() throws IOException{
        Line2Offset lines2Offset = null;
        Reference<Line2Offset> aLines = lines;
        if (aLines != null) {
            lines2Offset = aLines.get();
        }
        if (lines2Offset == null) {
            lines2Offset = new Line2Offset(getText());
            lines = new WeakReference<>(lines2Offset);
        }
        return lines2Offset;
    }
    
    public String getText(int start, int end) {
        return new String(buffer, start, end - start);
    }
    
    public String getText() {
        return new String(buffer);
    }
}
