/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Microline Widget Library, originally made available under the NPL by Neuron Data <http://www.neurondata.com>.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * In addition, as a special exception to the GNU GPL, the copyright holders
 * give permission to link the code of this program with the Motif and Open
 * Motif libraries (or with modified versions of these that use the same
 * license), and distribute linked combinations including the two. You
 * must obey the GNU General Public License in all respects for all of
 * the code used other than linking with Motif/Open Motif. If you modify
 * this file, you may extend this exception to your version of the file,
 * but you are not obligated to do so. If you do not wish to do so,
 * delete this exception statement from your version.
 *
 * ***** END LICENSE BLOCK ***** */


#include <XmL/XmL.h>
#include <XmL/Folder.h>
#include <XmL/Grid.h>
#include <XmL/Progress.h>
#include <XmL/Tree.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/Protocols.h>

#include <X11/IntrinsicP.h>
#include <X11/cursorfont.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

static void CreateWidgetEdit();
static Widget AddWidgetSample();
static void CreateText();
static void CreatePixmap();
void AddCoverTabForm();
void AddIntroTabForm();
void AddFolderTabForm();
void AddGridTabForm();
void AddProgTabForm();
void AddTreeTabForm();

/*
   Main Window
*/

static void exitCB();
static void editCB();
static void folderCB();

#define BOLDFONT "-*-helvetica-bold-r-*--*-100-*-*-*-*-iso8859-1"

main(argc, argv)
int argc;
char *argv[];
{
	XtAppContext context;
	Widget w, shell, form, folder;
	int i;
	XrmDatabase db;
	static String resources[] =
	{
		"*fontList: -*-helvetica-medium-r-*--*-100-*-*-*-*-iso8859-1",
		"*XmText.fontList: -*-helvetica-medium-r-*--*-100-*-*-*-*-iso8859-1",
		"*XmLProgress.fontList: -*-helvetica-bold-r-*--*-100-*-*-*-*-iso8859-1",
		"*background: #D0D0D0",
		"*foreground: black",
		"*topShadowColor: white",
		"*bottomShadowColor: #404040",
		"*XmLGrid.topShadowColor: #F0F0F0",
		"*XmLGrid.selectBackground: #000060",
		"*XmLGrid.selectForeground: white",
		"*XmLProgress.topShadowColor: #E0E0E0",
		"*XmLProgress.bottomShadowColor: #404040",
		"*XmToggleButton.selectColor: blue",
		"*XmToggleButton.marginHeight: 0",
		"*XmToggleButton.spacing: 4",
		"*XmText.marginHeight: 2",
		"*XmForm.marginHeight: 8",
		"*XmForm.marginWidth: 10",
		"*XmForm.horizontalSpacing: 8",
		"*XmForm.verticalSpacing: 10",
		"*XmLabel.marginWidth: 0",
		"*XmLFolder.XmForm.marginHeight: 16",
		"*XmLFolder.XmForm.marginWidth: 16",
		"*XmPushButton.marginHeight: 4",
		"*WidgetEdit*name.foreground: #000060",
		"*WidgetEdit*class.foreground: #000060",
		"*WidgetEdit*XmText.background: white",
		"*XmLTree.blankBackground: white",
		"*XmLTree.selectBackground: #000060",
		"*XmLTree.selectForeground: white",
		"*XmLTree.connectingLineColor: black",
		NULL
	};

	shell =  XtVaAppInitialize(&context, "Test", NULL, 0,
#ifdef X11R4
		(Cardinal *)&argc, argv, resources, NULL);
#else
		(int *)&argc, argv, resources, NULL);
#endif

	/* Force override of the falback resources.  Normally, we would
	   have an app-default file or similar but since this is a demo,
	   we don't want the user to have to set anything up to run */
	db = XtDatabase(XtDisplay(shell));
	i = 0;
	while (resources[i])
	{
		XrmPutLineResource(&db, resources[i]);
		i++;
	}

	XtVaSetValues(
		shell,
		XmNtitle, "Microline Widget Library",
		NULL);

	form = XtVaCreateWidget("form",
		xmFormWidgetClass, shell,
		XmNshadowThickness, 0,
		NULL);

	w = XtVaCreateManagedWidget("Exit",
		xmPushButtonWidgetClass, form,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNwidth, 100,
		NULL);
	XtAddCallback(w, XmNactivateCallback, exitCB, (XtPointer)shell);

	w = XtVaCreateManagedWidget("Editor",
		xmPushButtonWidgetClass, form,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, w,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNwidth, 100,
		NULL);
	XtAddCallback(w, XmNactivateCallback, editCB, NULL);
	CreateWidgetEdit(form);

	folder = XtVaCreateManagedWidget("folder",
		xmlFolderWidgetClass, form,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, w,
		XmNbottomOffset, 5,
		XmNtabsPerRow, 3,
		NULL);
	AddCoverTabForm(folder);
	AddIntroTabForm(folder);
	AddGridTabForm(folder);
	AddTreeTabForm(folder);
	AddFolderTabForm(folder);
	AddProgTabForm(folder);

	XtAddCallback(folder, XmNactivateCallback, folderCB, NULL);

	XtManageChild(form);

	XtRealizeWidget(shell);
	XtAppMainLoop(context);
}

static void exitCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	Widget shell;

	shell = (Widget)clientData;
	exit(0);
}

/*
   Widget Editor Functions
*/

static void _getResourceAsString();
static void _editCB();
static void _editCommandCB();
static void _editChooseCB();
static void _editShowCB();
static void _editCloseCB();
static void _wmCloseCB();

Widget _editDialog, _editClassL, _editNameL, _editGrid, _editCommandT;
Widget _editWidget;
Boolean _editShowInherited, _editDialogUp;
int _editRow, _editCol;

static void CreateWidgetEdit(parent)
Widget parent;
{
	Widget form, w;
	Widget chooseB, closeB;
	Atom WM_DELETE_WINDOW;

	_editWidget = 0;
	_editShowInherited = 0;
	_editDialogUp = False;

	_editDialog = XtVaAppCreateShell("WidgetEdit", "WidgetEdit",
		topLevelShellWidgetClass, XtDisplay(parent),
		XtNtitle, "Widget Editor",
		XmNdeleteResponse, XmDO_NOTHING,
		NULL);

	WM_DELETE_WINDOW = XmInternAtom(XtDisplay(parent),
		"WM_DELETE_WINDOW", False);
	XmAddWMProtocolCallback(_editDialog, WM_DELETE_WINDOW,
		_wmCloseCB, (XtPointer)_editDialog);

	form = XtVaCreateWidget("form",
		xmFormWidgetClass, _editDialog,
		XmNautoUnmanage, False,
		XmNshadowThickness, 0,
		NULL);

	/* Top Row */
	w = XtVaCreateManagedWidget("Name:",
		xmLabelWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		NULL);
	_editNameL = XtVaCreateManagedWidget("name",
		xmLabelWidgetClass, form,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, w,
		XmNtopAttachment, XmATTACH_FORM,
		NULL);

	w = XtVaCreateManagedWidget("Class:",
		xmLabelWidgetClass, form,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, _editNameL,
		XmNtopAttachment, XmATTACH_FORM,
		NULL);
	_editClassL = XtVaCreateManagedWidget("class",
		xmLabelWidgetClass, form,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, w,
		XmNtopAttachment, XmATTACH_FORM,
		NULL);

	w = XtVaCreateManagedWidget("Show All",
		xmToggleButtonWidgetClass, form,
		XmNtopAttachment, XmATTACH_FORM,
		XmNtopOffset, 4,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	XtAddCallback(w, XmNvalueChangedCallback, _editShowCB, 0);

	_editGrid = XtVaCreateManagedWidget("Grid",
		xmlGridWidgetClass, form,
		XtVaTypedArg, XmNblankBackground, XmRString, "white", 6,
		XmNcolumns, 4,
		XmNsimpleWidths, "16c 18c 24c 16c",
		XmNvisibleColumns, 9,
		XmNheadingRows, 1,
		XmNvsbDisplayPolicy, XmSTATIC,
		XmNsimpleHeadings, "Class|Type|Resource|Value",
		XmNvisibleRows, 8,
		XmNshadowThickness, 0,
		XmNscrollBarMargin, 4,
		XmNselectionPolicy, XmSELECT_NONE,
		XmNallowColumnResize, True,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, w,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);

	XtVaSetValues(_editGrid,
		XmNcellDefaults, True,
		XmNcellMarginRight, 2,
		XmNcellAlignment, XmALIGNMENT_LEFT,
		XtVaTypedArg, XmNcellBackground, XmRString, "white", 6,
		XmNcellLeftBorderType, XmBORDER_NONE,
		XmNcellRightBorderType, XmBORDER_NONE,
		XmNcellTopBorderType, XmBORDER_NONE,
		XmNcellBottomBorderType, XmBORDER_NONE,
		NULL);
	XtVaSetValues(_editGrid,
		XmNcellDefaults, True,
		XmNcolumn, 3,
		XmNcellEditable, True,
		NULL);

	XtAddCallback(_editGrid, XmNeditCallback, _editCB, 0);

	w = XtVaCreateManagedWidget("Command",
		xmLabelWidgetClass, form,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 11,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
	_editCommandT = XtVaCreateManagedWidget("editCommandT",
		xmTextWidgetClass, form,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, w,
		NULL);
	XtAddCallback(_editCommandT, XmNactivateCallback, _editCommandCB, 0);

	/* Bottom Row */
	chooseB = XtVaCreateManagedWidget("Choose",
		xmPushButtonWidgetClass, form,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNmarginWidth, 18,
		NULL);
	XtAddCallback(chooseB, XmNactivateCallback, _editChooseCB, 0);
	closeB = XtVaCreateManagedWidget("Close",
		xmPushButtonWidgetClass, form,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNmarginWidth, 24,
		NULL);
	XtAddCallback(closeB, XmNactivateCallback, _editCloseCB, 0);
	XtVaSetValues(chooseB,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, closeB,
		NULL);
	XtVaSetValues(_editCommandT,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, chooseB,
		NULL);
	XtVaSetValues(_editGrid,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, closeB,
		NULL);
	XtManageChild(form);
}

static void SetEditWidget(w)
Widget w;
{
	WidgetClass wc, superWc;
	XtResourceList resList;
	char className[50], *resName, *resType;
	Cardinal resCount;
	int i, j, n, skip, done, superSize;
	char resVal[50], line[100];
	XmString str;
	char *s;
	static char *skipType[] =
	{
		"Callback",
		0
	};

	_editWidget = w;
	if (_editWidget)
		s = XtName(_editWidget);
	else
		s = "none";
	if (s)
	{
		str = XmStringCreateSimple(s);
		XtVaSetValues(_editNameL, XmNlabelString, str, NULL);
		XmStringFree(str);
	}
	if (_editWidget)
	{
		wc = XtClass(_editWidget);
		s = wc->core_class.class_name;
	}
	else
		s = "none";
	if (s)
	{
		str = XmStringCreateSimple(s);
		XtVaSetValues(_editClassL, XmNlabelString, str, NULL);
		XmStringFree(str);
	}
	if (!_editWidget)
	{
		XmLGridDeleteAllRows(_editGrid, XmCONTENT);
		return;
	}
	n = 0;
	done = 0;
	XtVaSetValues(_editGrid, XmNlayoutFrozen, True, NULL);
	XmLGridDeleteAllRows(_editGrid, XmCONTENT);
	while (!done)
	{
		if (!wc)
		{
			wc = XtClass(XtParent(_editWidget));
			XtGetConstraintResourceList(wc, &resList, &resCount);
			sprintf(className, "%s [C]", wc->core_class.class_name);
			superSize = 0;
			done = 1;
		}
		else
		{
			XtGetResourceList(wc, &resList, &resCount);
			sprintf(className, wc->core_class.class_name);
			superWc = wc->core_class.superclass;
			if (superWc)
				superSize = superWc->core_class.widget_size;
		}
		for (i = 0; i < resCount; i++)
		{
			resName = resList[i].resource_name;
			resType = resList[i].resource_type;
			if (resList[i].resource_offset < superSize)
				continue;
			skip = 0;
			for (j = 0; skipType[j]; j++)
				if (!strcmp(skipType[j], resType))
					skip = 1;
			if (skip)
				continue;
			_getResourceAsString(resName, resType, resVal);
			sprintf(line, "%s|%s|%s|%s", className, resType, resName, resVal);
			XmLGridAddRows(_editGrid, XmCONTENT, -1, 1);
			XmLGridSetStringsPos(_editGrid, XmCONTENT, n, XmCONTENT, 0, line);
			n++;
		}
		wc = wc->core_class.superclass;
		XtFree((char *)resList);
		if (_editShowInherited == False)
			done = 1;
	}
	XtVaSetValues(_editGrid, XmNlayoutFrozen, False, NULL);
}

static void _getResourceAsString(res, type, str)
char *res;
char *type;
char *str;
{
	Boolean bool;
	Dimension dimension;
	int i;
	static char *skipRes[] =
	{
		XmNrowExpands,
		XmNrowIsExpanded,
		XmNrowHeight,
		XmNrowLevel,
		XmNcolumnWidth,
		XmNcellColumnSpan,
		XmNcellEditable,
		XmNcellMarginBottom,
		XmNcellMarginLeft,
		XmNcellMarginRight,
		XmNcellMarginTop,
		XmNcellRowSpan,
		XmNcellToggleSet,
		0
	};

	for (i = 0; skipRes[i]; i++)
		if (!strcmp(skipRes[i], res))
		{
			sprintf(str, "");
			return;
		}
	if (!strcmp(type, XmRInt))
	{
		XtVaGetValues(_editWidget, res, &i, NULL);
		sprintf(str, "%d", i);
	}
	else if (!strcmp(type, XmRDimension))
	{
		XtVaGetValues(_editWidget, res, &dimension, NULL);
		sprintf(str, "%d", (int)dimension);
	}
	else if (!strcmp(type, XmRBoolean))
	{
		XtVaGetValues(_editWidget, res, &bool, NULL);
		if (bool == True)
			sprintf(str, "True");
		else
			sprintf(str, "False");
	}
	else
		sprintf(str, "");
}

static void _editCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	XmLGridCallbackStruct *cbs;
	int resRow, rowType, row, rowEnd, colType, col, colEnd;
	XmLGridRow rowp;
	XmLGridColumn colp;
	XmString resStr, valStr;
	char *s, *resS, *valS;
	static char *emptyValS = "";

	cbs = (XmLGridCallbackStruct *)callData;
	if (cbs->reason != XmCR_EDIT_COMPLETE)
		return;
	resRow = cbs->row;

	/* get resource and value */
	rowp = XmLGridGetRow(_editGrid, XmCONTENT, resRow);
	colp = XmLGridGetColumn(_editGrid, XmCONTENT, 2);
	XtVaGetValues(_editGrid,
		XmNrowPtr, rowp,
		XmNcolumnPtr, colp,
		XmNcellString, &resStr,
		NULL);
	if (!resStr)
		resS = 0;
	else
		XmStringGetLtoR(resStr, XmSTRING_DEFAULT_CHARSET, &resS);
	colp = XmLGridGetColumn(_editGrid, XmCONTENT, 3);
	XtVaGetValues(_editGrid,
		XmNrowPtr, rowp,
		XmNcolumnPtr, colp,
		XmNcellString, &valStr,
		NULL);
	if (!valStr)
		valS = emptyValS;
	else
		XmStringGetLtoR(valStr, XmSTRING_DEFAULT_CHARSET, &valS);

	if (XmLIsGrid(_editWidget))
		XtVaSetValues(_editWidget,
			XmNrow, _editRow,
			XmNcolumn, _editCol,
			XtVaTypedArg, resS,
			XmRString, valS, strlen(valS) + 1,
			NULL);
	else
		XtVaSetValues(_editWidget,
			XtVaTypedArg, resS,
			XmRString, valS, strlen(valS) + 1,
			NULL);

	if (resS)
		XtFree(resS);
	if (resStr)
		XmStringFree(resStr);
	if (valS != emptyValS)
		XtFree(valS);
	if (valStr)
		XmStringFree(valStr);
}

static void _editCommandCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	char op[40], *cmd;
	int *rowPos, *colPos, *newPos;
	int i, l1, l2, l3, l4, n, count;
	XmString str;

	cmd = XmTextGetString(_editCommandT);
	if (_editWidget && XmLIsGrid(_editWidget))
	{
		n = sscanf(cmd, "%s %d %d %d %d", op, &l1, &l2, &l3, &l4);
		/* Tree commands */
		if (!strcmp(op, "addTreeRow") && n == 5)
		{
			str = XmStringCreateSimple("New Node");
			XmLTreeAddRow(_editWidget, l1, (Boolean)l2, (Boolean)l3, l4,
				XmUNSPECIFIED_PIXMAP, XmUNSPECIFIED_PIXMAP, str);
			XmStringFree(str);
		}
		/* Grid commands */
		else if (!strcmp(op, "addHRows") && n == 3)
			XmLGridAddRows(_editWidget, XmHEADING, l1, l2);
		else if (!strcmp(op, "addFRows") && n == 3)
			XmLGridAddRows(_editWidget, XmFOOTER, l1, l2);
		else if (!strcmp(op, "addRows") && n == 3)
			XmLGridAddRows(_editWidget, XmCONTENT, l1, l2);
		else if (!strcmp(op, "addHColumns") && n == 3)
			XmLGridAddColumns(_editWidget, XmHEADING, l1, l2);
		else if (!strcmp(op, "addFColumns") && n == 3)
			XmLGridAddColumns(_editWidget, XmFOOTER, l1, l2);
		else if (!strcmp(op, "addColumns") && n == 3)
			XmLGridAddColumns(_editWidget, XmCONTENT, l1, l2);
		else if (!strcmp(op, "deleteHRows") && n == 3)
			XmLGridDeleteRows(_editWidget, XmHEADING, l1, l2);
		else if (!strcmp(op, "deleteFRows") && n == 3)
			XmLGridDeleteRows(_editWidget, XmFOOTER, l1, l2);
		else if (!strcmp(op, "deleteRows") && n == 3)
			XmLGridDeleteRows(_editWidget, XmCONTENT, l1, l2);
		else if (!strcmp(op, "deleteHColumns") && n == 3)
			XmLGridDeleteColumns(_editWidget, XmHEADING, l1, l2);
		else if (!strcmp(op, "deleteFColumns") && n == 3)
			XmLGridDeleteColumns(_editWidget, XmFOOTER, l1, l2);
		else if (!strcmp(op, "deleteColumns") && n == 3)
			XmLGridDeleteColumns(_editWidget, XmCONTENT, l1, l2);
		else if (!strcmp(op, "copyPos") && n == 3)
			XmLGridCopyPos(_editWidget, CurrentTime, XmCONTENT,
				l1, XmCONTENT, l2, 3, 3);
		else if (!strcmp(op, "copySelected") && n == 1)
			XmLGridCopySelected(_editWidget, CurrentTime);
		else if (!strcmp(op, "paste") && n == 1)
			XmLGridPaste(_editWidget);
		else if (!strcmp(op, "pastePos") && n == 3)
			XmLGridPastePos(_editWidget, XmCONTENT, l1, XmCONTENT, l2);
		else if (!strcmp(op, "moveColumns") && n == 1)
			XmLGridMoveColumns(_editWidget, 3, 1, 2);
		else if (!strcmp(op, "moveRows") && n == 1)
			XmLGridMoveRows(_editWidget, 3, 1, 2);
		else if (!strcmp(op, "printSelected") && n == 1)
		{
			printf ("--- Current Selections ---\n");
			count = XmLGridGetSelectedRowCount(_editWidget);
			if (count)
			{
				rowPos = (int *)malloc(sizeof(int) * count);
				XmLGridGetSelectedRows(_editWidget, rowPos, count);
				printf ("Selected Rows: ");
				for (i = 0; i < count; i++)
					printf ("%d ", rowPos[i]);
				printf ("\n");
				free((char *)rowPos);
			}

			count = XmLGridGetSelectedColumnCount(_editWidget);
			if (count)
			{
				colPos = (int *)malloc(sizeof(int) * count);
				XmLGridGetSelectedColumns(_editWidget, colPos, count);
				printf ("Selected Columns: ");
				for (i = 0; i < count; i++)
					printf ("%d ", colPos[i]);
				printf ("\n");
				free((char *)colPos);
			}

			count = XmLGridGetSelectedCellCount(_editWidget);
			if (count)
			{
				colPos = (int *)malloc(sizeof(int) * count);
				rowPos = (int *)malloc(sizeof(int) * count);
				XmLGridGetSelectedCells(_editWidget, rowPos, colPos, count);
				printf ("Selected Cells: ");
				for (i = 0; i < count; i++)
					printf ("[%d %d] ", rowPos[i], colPos[i]);
				printf ("\n");
				free((char *)colPos);
				free((char *)rowPos);
			}
		}
		else if (!strcmp(op, "setCell") && n == 3)
		{
			printf ("WidgetEdit: set row %d col %d\n", l1, l2);
			_editRow = l1;
			_editCol = l2;
		}
		else if (!strcmp(op, "reorderColumns") && n == 1)
		{
			XtVaGetValues(_editWidget,
				XmNcolumns, &count,
				NULL);
			newPos = (int *)malloc(count * sizeof(int));
			for (i = 0; i < count; i++)
				newPos[i] = i + 1;
			newPos[count - 1] = 0;
			XmLGridReorderColumns(_editWidget, newPos, 0, count);
			free((char *)newPos);
		}
		else if (!strcmp(op, "reorderRows") && n == 1)
		{
			XtVaGetValues(_editWidget,
				XmNrows, &count,
				NULL);
			newPos = (int *)malloc(count * sizeof(int));
			for (i = 0; i < count; i++)
				newPos[i] = i + 1;
			newPos[count - 1] = 0;
			XmLGridReorderRows(_editWidget, newPos, 0, count);
			free((char *)newPos);
		}
		else if (!strcmp(op, "write") && n == 1)
			XmLGridWrite(_editWidget, stdout, XmFORMAT_DELIMITED, '|', True);
		else if (!strcmp(op, "writeXL") && n == 1)
			XmLGridWrite(_editWidget, stdout, XmFORMAT_XL, 0, True);
		else if (!strcmp(op, "writePAD") && n == 1)
			XmLGridWrite(_editWidget, stdout, XmFORMAT_PAD, 0, True);
		else if (!strcmp(op, "writePos") && n == 3)
			XmLGridWritePos(_editWidget, stdout, XmFORMAT_DELIMITED, '|',
				True, XmCONTENT, 0, XmCONTENT, 0, l1, l2);
		else
			fprintf(stderr, "WidgetEdit: unknown command %s\n", cmd);
	}
	XtFree(cmd);
	XmTextSetString(_editCommandT, "");
}

static void _editChooseCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	Cursor cursor;
	Widget editW;

	cursor = XCreateFontCursor(XtDisplay(w), XC_hand2);
	editW = XmTrackingLocate(w, cursor, False);
	if (editW)
		SetEditWidget(editW);
	XFreeCursor(XtDisplay(w), cursor);
}

static void _editShowCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	XmToggleButtonCallbackStruct *cbs;

	cbs = (XmToggleButtonCallbackStruct *)callData;
	_editShowInherited = cbs->set;
	SetEditWidget(_editWidget);
}

static void _wmCloseCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	XtPopdown(XmLShellOfWidget((Widget)clientData));
	_editDialogUp = False;
}

static void _editCloseCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	XtPopdown(XmLShellOfWidget(w));
	_editDialogUp = False;
}

/*
   Callbacks which manipulate the Widget Editor
*/

static void folderCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	XmLFolderCallbackStruct *cbs;
	extern Widget _folder, _grid, _progress, _tree;

	cbs = (XmLFolderCallbackStruct *)callData;
	switch (cbs->pos)
	{
	case 2:
		_editWidget = _grid;
		break;
	case 3:
		_editWidget = _tree;
		break;
	case 4:
		_editWidget = _folder;
		break;
	case 5:
		_editWidget = _progress;
		break;
	default:
		_editWidget = 0;
		break;
	}
	if (_editDialogUp == True)
		SetEditWidget(_editWidget);
}

static void editCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	SetEditWidget(_editWidget);
	XtPopup(_editDialog, XtGrabNone);
	_editDialogUp = True;
}

/*
   Utility to add a sample tab and form to a folder, returning the form in
   the sample Folder created.
*/

static Widget AddWidgetSample(folder, name, desc)
Widget folder;
char *name, *desc;
{
	Widget form, sampleFolder, sampleForm;
	XmString str;
	char buf[20];
	int i;

	sprintf(buf, "%s Widget", name);
	str = XmStringCreateSimple(buf);
	form = XmLFolderAddTabForm(folder, str);
	XmStringFree(str);
	sampleFolder = XtVaCreateManagedWidget("sampleFolder",
		xmlFolderWidgetClass, form,
		XmNtabPlacement, XmFOLDER_RIGHT,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_POSITION,
		XmNbottomPosition, 55,
		XmNtabsPerRow, 3,
		NULL);
	for (i = 0; i < 3; i++)
	{
		if (!i)
			sprintf(buf, "%s One", name);
		else if (i == 1)
			sprintf(buf, "%s Two", name);
		else
			sprintf(buf, "%s Three", name);
		str = XmStringCreateSimple(buf);
		XmLFolderAddTab(sampleFolder, str);
		XmStringFree(str);
	}
	sampleForm = XtVaCreateManagedWidget("sampleForm",
		xmFormWidgetClass, sampleFolder,
		NULL);
	CreateText(form, desc, sampleFolder, 1);
	return sampleForm;
}

static void CreateText(form, data, topWidget, scrollVert)
Widget form;
char *data;
Widget topWidget;
int scrollVert;
{
	Widget text, sb;
	int n;
	Arg args[20];

	XtSetArg(args[0], XmNleftAttachment, XmATTACH_FORM);
	XtSetArg(args[1], XmNrightAttachment, XmATTACH_FORM);
	XtSetArg(args[2], XmNbottomAttachment, XmATTACH_FORM);
	XtSetArg(args[3], XmNwordWrap, True);
	XtSetArg(args[4], XmNscrollHorizontal, False);
	XtSetArg(args[5], XmNeditMode, XmMULTI_LINE_EDIT);
	XtSetArg(args[6], XmNeditable, False);
	XtSetArg(args[7], XmNcursorPositionVisible, False);
	XtSetArg(args[8], XmNhighlightThickness, 0);
	XtSetArg(args[9], XmNtopAttachment, XmATTACH_WIDGET);
	XtSetArg(args[10], XmNtopWidget, topWidget);
	n = 11;
	if (!scrollVert)
	{
		XtSetArg(args[11], XmNscrollVertical, False);
		n = 12;
	}
	text = XmCreateScrolledText(form, "text", args, n);
	XmTextSetString(text, data);
	XtManageChild(text);
	XtVaSetValues(text,
		XtVaTypedArg, XmNbackground, XmRString, "#D0D0D0", 8,
		XtVaTypedArg, XmNforeground, XmRString, "black", 6,
		XmNshadowThickness, 0,
		NULL);
	if (scrollVert)
	{
		XtVaGetValues(XtParent(text),
			XmNverticalScrollBar, &sb,
			NULL);
		XtVaSetValues(sb,
			XmNshadowThickness, 2,
			NULL);
	}
#ifndef MOTIF11
	/* multiple drop site in the same area conflict with one another */
	/* even if they are unmanaged - a Motif bug */
	XmDropSiteUnregister(text);
#endif
}

static void CreatePixmap(w, color, pixmap, pixmask, bits, width, height)
Widget w;
int color;
Pixmap *pixmap, *pixmask;
char *bits;
int width, height;
{
	Display *dpy;
	Window root;
	int depth;
	XColor col;
	Pixel black, white, fg, bg;

	dpy = XtDisplay(w);
	root = DefaultRootWindow(dpy);
	depth = DefaultDepthOfScreen(XtScreen(w));
	black = BlackPixelOfScreen(XtScreen(w));
	white = WhitePixelOfScreen(XtScreen(w));
	XtVaGetValues(w,
		XmNbackground, &bg,
		NULL);
	col.red = 0;
	col.green = 0;
	col.blue = 0;
	if (color == 0)
		fg = white;
	else if (color == 1)
		fg = black;
	else
	{
		if (color == 2)
			col.green = 40000;
		else if (color == 3)
			col.red = 45000;
		else if (color == 4)
			col.blue = 30000;
		col.flags = DoRed | DoGreen | DoBlue;
		XAllocColor(dpy, DefaultColormapOfScreen(XtScreen(w)), &col);
		fg = col.pixel;
	}
	*pixmap = XCreatePixmapFromBitmapData(dpy, root, bits,
		width, height, fg, bg, depth);
	*pixmask = XCreatePixmapFromBitmapData(dpy, root, bits,
		width, height, 1L, 0L, 1);
}

/*
   Cover Tab Form
*/

#define cover_width 230
#define cover_height 240
static unsigned char cover_bits[] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x03,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xff,
	0x01,0x00,0xc0,0x0f,0x00,0x00,0xe0,0x00,0x80,0x03,0x00,0x00,0x3c,0x00,0x00,
	0x00,0x00,0x38,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x80,0xff,0x01,
	0x00,0x30,0x1c,0x00,0x00,0xe0,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0x00,
	0x00,0x18,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x60,0xe0,0x01,0x00,
	0x0c,0x38,0x00,0x00,0x20,0x00,0x80,0x01,0x00,0x80,0x01,0x00,0x00,0x00,0x00,
	0x18,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x10,0xe0,0x00,0x00,0x06,
	0x78,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x1c,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x10,0xd0,0x00,0x00,0x03,0x70,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x18,0xd8,0x00,0x80,0x01,0x70,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x18,0xc8,0x00,0x80,0x01,0x70,0x18,0x08,
	0x30,0xe0,0xc0,0xe0,0x01,0x60,0x00,0x00,0x3c,0x00,0x0f,0x0c,0x1e,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x18,0xc4,0x00,0xc0,0x01,0x70,0x1e,0x0e,0x3c,
	0xf0,0xe1,0xf0,0x01,0x70,0x00,0x00,0x7f,0xc0,0x1f,0x0e,0x1f,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x38,0xc6,0x00,0xc0,0x00,0xf0,0x0d,0x06,0x1b,0x8c,
	0x61,0x98,0x00,0x70,0x00,0x80,0x79,0x60,0x1e,0x86,0x09,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x08,0xc3,0x00,0xe0,0x00,0x70,0x0c,0x06,0x18,0x8e,0x60,
	0x04,0x00,0x30,0x00,0xe0,0x70,0x38,0x1c,0x46,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0xe1,0x00,0xe0,0x00,0x70,0x0e,0x07,0x1c,0x06,0x70,0x03,
	0x00,0x30,0x00,0x60,0x70,0x18,0x1c,0x37,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x80,0xe1,0x00,0xe0,0x00,0x30,0x06,0x03,0x1c,0x07,0xf0,0x01,0x00,
	0x30,0x00,0x70,0x70,0x1c,0x1c,0x1f,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0xc0,0xff,0x00,0xe0,0x00,0x38,0x06,0x03,0x0c,0x07,0xf0,0x01,0x00,0x38,
	0x00,0x30,0x70,0x0c,0x1c,0x1f,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x60,0xe0,0x00,0xe0,0x00,0x18,0x86,0x03,0x0c,0x03,0xb0,0x03,0x00,0x18,0x00,
	0x39,0x30,0x0e,0x0c,0x3b,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
	0xe0,0x00,0xe0,0x00,0x18,0x87,0x01,0x8e,0x03,0x38,0x03,0x00,0x18,0x80,0x39,
	0x38,0x0e,0x8e,0x33,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x10,0x60,
	0x00,0xe0,0x00,0x0c,0x83,0x01,0x8e,0x03,0x38,0x03,0x00,0x0c,0x80,0x38,0x18,
	0x0e,0x86,0x33,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x1c,0x60,0x00,
	0xc0,0x01,0x06,0xc3,0x11,0x86,0x03,0x19,0x07,0x00,0x04,0xe0,0x38,0x0c,0x0e,
	0x83,0x71,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xc0,0x0f,0xe0,0x0c,0xc0,
	0x01,0x03,0xb3,0x0d,0xe6,0xc3,0x18,0x06,0x80,0xff,0x7f,0x78,0x06,0x9e,0x81,
	0x61,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xc0,0x07,0xe0,0x07,0x80,0xc7,
	0x81,0xcf,0x03,0x9f,0x3f,0x1c,0x0e,0xc0,0xff,0x7f,0xf8,0x03,0xfe,0xc0,0xe1,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0xe0,0x01,0x70,0x00,0x00,0xff,0x01,
	0xc3,0x00,0x06,0x0f,0x0c,0x0c,0xe0,0xff,0x3f,0xf0,0x00,0x3c,0xc0,0xc0,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,
	0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x04,0x00,
	0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x04,0x00,0x00,
	0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x04,0x00,0x00,0x00,
	0x00,0x70,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x87,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,0x00,
	0xe0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xce,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,0x80,
	0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0c,0x00,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
	0x00,0x18,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,
	0x18,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x1c,
	0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x01,0x03,0x00,0x0c,0x30,
	0x38,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x07,0x03,0x00,0x0c,0x38,0x3c,
	0xd8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0xe1,0x7f,0x80,0xff,0x39,0x3b,0xc6,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x91,0x03,0x40,0x0e,0xd8,0x38,0xc7,0x01,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x83,0x81,0x01,0x00,0x06,0x38,0x18,0xe3,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x80,0xc3,0x81,0x01,0x00,0x06,0x1c,0x9c,0x33,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0xc1,0xc0,0x01,0x00,0x07,0x0c,0x9c,0x1b,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x80,0xc1,0xc0,0x01,0x00,0x07,0x0c,0xcc,0x07,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0xe1,0xc0,0x00,0x00,0x03,0x0c,0xcc,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0xe1,0xc0,0x00,0x00,0x03,0x0e,0xce,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x71,
	0xe4,0x10,0x80,0x43,0x06,0xce,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x6d,0xe3,
	0x0c,0x80,0x33,0x06,0xee,0xe3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xe3,0xe0,0x03,
	0x80,0x0f,0x07,0xde,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x31,0xc0,0x00,0x00,
	0x03,0x01,0x86,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x3f,0xc0,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x3f,0xc0,0xfc,0xff,0xff,0xff,0xff,0x3f,0xf8,0xff,0xff,0xff,0x1f,0xfe,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x3f,0xc0,0x0c,0xfe,0x1f,0x3e,0xfc,0x07,0xe3,0x0f,0x00,0xff,0x03,0xf0,0x1f,
	0xfe,0x0f,0x1f,0xfe,0xcf,0x07,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,
	0xc0,0x0c,0xfe,0x1f,0x3e,0xfc,0xc3,0xdf,0x0f,0x1f,0xfc,0xf1,0xc3,0x1f,0xfe,
	0x0f,0x1f,0xfc,0xcf,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,
	0x0c,0xfc,0x0f,0x3e,0xfc,0xf1,0x9f,0x0f,0x3f,0xfc,0xf8,0x87,0x1f,0xfe,0x0f,
	0x1f,0xfc,0xcf,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0x0c,
	0xfc,0x0f,0x3e,0xfc,0xf8,0x3f,0x0f,0x7f,0x7c,0xf8,0x0f,0x1f,0xfe,0x0f,0x1f,
	0xf8,0xcf,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0x0c,0xf8,
	0x07,0x3e,0x7c,0xf8,0x7f,0x0e,0x7f,0x78,0xfc,0x0f,0x1f,0xfe,0x0f,0x1f,0xf0,
	0xcf,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0x0c,0xf8,0x07,
	0x3e,0x7c,0xfc,0xff,0x0f,0x7f,0x38,0xfc,0x1f,0x1e,0xfe,0x0f,0x9f,0xf0,0xcf,
	0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0x4c,0xf8,0x17,0x3e,
	0x3c,0xfc,0xff,0x0f,0x7f,0x38,0xfe,0x1f,0x1e,0xfe,0x0f,0x9f,0xe0,0xcf,0x87,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0x4c,0xf0,0x13,0x3e,0x3c,
	0xfc,0xff,0x0f,0x7f,0x18,0xfe,0x1f,0x1e,0xfe,0x0f,0x9f,0xc1,0xcf,0x87,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0xf0,0x13,0x3e,0x3c,0xfc,
	0xff,0x0f,0x7f,0x18,0xfe,0x1f,0x1c,0xfe,0x0f,0x9f,0x83,0xcf,0x87,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0xe0,0x19,0x3e,0x1c,0xfe,0xff,
	0x0f,0x3f,0x1c,0xfe,0x1f,0x1c,0xfe,0x0f,0x9f,0x83,0xcf,0x87,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0xe1,0x19,0x3e,0x1c,0xfe,0xff,0x0f,
	0x1f,0x1c,0xfe,0x3f,0x1c,0xfe,0x0f,0x9f,0x07,0xcf,0x07,0x80,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0xe1,0x1d,0x3e,0x1c,0xfe,0xff,0x0f,0x01,
	0x1f,0xfe,0x3f,0x1c,0xfe,0x0f,0x9f,0x0f,0xce,0x07,0x80,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x3f,0xc0,0xcc,0xc1,0x1c,0x3e,0x1c,0xfe,0xff,0x0f,0xc3,0x1f,
	0xfe,0x3f,0x1c,0xfe,0x0f,0x9f,0x0f,0xce,0x87,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x3f,0xc0,0xcc,0xc3,0x1c,0x3e,0x1c,0xfe,0xff,0x0f,0xc3,0x1f,0xfe,
	0x3f,0x1c,0xfe,0x0f,0x9f,0x1f,0xcc,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x3f,0xc0,0xcc,0x03,0x1e,0x3e,0x1c,0xfc,0xff,0x0f,0x87,0x1f,0xfe,0x1f,
	0x1c,0xfe,0x0f,0x9f,0x3f,0xc8,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x3f,0xc0,0xcc,0x07,0x1e,0x3e,0x1c,0xfc,0xff,0x0f,0x87,0x1f,0xfe,0x1f,0x1e,
	0xfe,0x0f,0x9f,0x7f,0xc8,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,
	0xc0,0xcc,0x07,0x1e,0x3e,0x3c,0xfc,0xff,0x0f,0x0f,0x3f,0xfe,0x1f,0x1e,0xfe,
	0x0f,0x9f,0x7f,0xc0,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,
	0xcc,0x07,0x1f,0x3e,0x3c,0xfc,0xff,0x0c,0x0f,0x3f,0xfc,0x1f,0x1e,0xfe,0x0f,
	0x9f,0xff,0xc0,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,
	0x0f,0x1f,0x3e,0x7c,0xf8,0x7f,0x0e,0x1f,0x3e,0xfc,0x0f,0x1f,0xfe,0x0f,0x9f,
	0xff,0xc1,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0x8f,
	0x1f,0x3e,0xfc,0xf0,0x3f,0x0f,0x1f,0x7e,0xfc,0x8f,0x1f,0xfe,0x0f,0x9f,0xff,
	0xc1,0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0x9f,0x1f,
	0x3e,0xfc,0xe0,0x1f,0x0f,0x3f,0xfc,0xf8,0x87,0x1f,0xfe,0x0f,0x9f,0xff,0xc3,
	0x87,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0x9f,0x1f,0x3e,
	0xfc,0x83,0x87,0x0f,0x3f,0xfc,0xf1,0xc3,0x1f,0x00,0x0c,0x9f,0xff,0xc7,0x07,
	0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xcc,0xff,0x1f,0x3e,0xfc,
	0x07,0xe0,0x0f,0x7f,0xf8,0x03,0xf0,0x1f,0x00,0x0c,0x9f,0xff,0xc7,0x07,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xfc,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x3f,0xc0,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x3f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0xf0,0x07,0xf8,0x03,0xfc,0xf9,0x81,0xff,0xff,0x00,
	0x00,0xf8,0x0f,0x00,0xfc,0xff,0x7f,0xfe,0xff,0xff,0x01,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0xe0,0x07,0xf8,0x03,0xfc,0xf8,0x81,0xff,0xff,0x03,0x00,
	0xff,0x7f,0x00,0xfc,0xff,0x7f,0xfe,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0xe0,0x07,0xf8,0x07,0xfc,0xf8,0x81,0xff,0xff,0x0f,0x80,0xff,
	0xff,0x01,0xfc,0xff,0x7f,0xfe,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0xe0,0x0f,0xf8,0x07,0xfc,0xf8,0x81,0xff,0xff,0x1f,0xc0,0xff,0xff,
	0x03,0xfc,0xff,0x7f,0xfe,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0xc0,0x0f,0xfc,0x07,0x7e,0xf8,0x81,0x1f,0xc0,0x3f,0xe0,0x0f,0xf8,0x07,
	0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0xc0,0x0f,0xfc,0x07,0x7e,0xf8,0x81,0x1f,0x00,0x3f,0xf0,0x07,0xe0,0x0f,0xfc,
	0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,
	0x0f,0xbc,0x0f,0x7e,0xf8,0x81,0x1f,0x00,0x7f,0xf8,0x03,0xc0,0x0f,0xfc,0x00,
	0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x80,0x1f,
	0xbc,0x0f,0x3e,0xf8,0x81,0x1f,0x00,0x7e,0xf8,0x01,0x00,0x00,0xfc,0x00,0x00,
	0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x80,0x1f,0xbe,
	0x0f,0x3f,0xf8,0x81,0x1f,0x00,0xfe,0xf8,0x01,0x00,0x00,0xfc,0x00,0x00,0x00,
	0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x80,0x1f,0xbe,0x0f,
	0x3f,0xf8,0x81,0x1f,0x00,0xfc,0xfc,0x00,0x00,0x00,0xfc,0xff,0x3f,0x00,0xfc,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x1f,0x1e,0x1f,0x1f,
	0xf8,0x81,0x1f,0x00,0xfc,0xfc,0x00,0xfe,0x0f,0xfc,0xff,0x3f,0x00,0xfc,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x3f,0x1e,0x1f,0x1f,0xf8,
	0x81,0x1f,0x00,0xfc,0xfc,0x00,0xfe,0x0f,0xfc,0xff,0x3f,0x00,0xfc,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x3f,0x1f,0x9f,0x1f,0xf8,0x81,
	0x1f,0x00,0xfc,0xfc,0x00,0xfe,0x0f,0xfc,0xff,0x3f,0x00,0xfc,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x3e,0x1f,0x9e,0x0f,0xf8,0x81,0x1f,
	0x00,0xfc,0xfc,0x00,0xfe,0x0f,0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x7e,0x0f,0xbe,0x0f,0xf8,0x81,0x1f,0x00,
	0xfc,0xfc,0x01,0x80,0x0f,0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x7e,0x0f,0xbe,0x0f,0xf8,0x81,0x1f,0x00,0x7e,
	0xf8,0x01,0x80,0x0f,0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0xfc,0x0f,0xfc,0x07,0xf8,0x81,0x1f,0x00,0x7f,0xf8,
	0x03,0xc0,0x0f,0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0xfc,0x07,0xfc,0x07,0xf8,0x81,0x1f,0x00,0x3f,0xf0,0x07,
	0xe0,0x0f,0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0xf8,0x07,0xfc,0x07,0xf8,0x81,0x1f,0xc0,0x3f,0xe0,0x1f,0xf8,
	0x0f,0xfc,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0xf8,0x07,0xfc,0x03,0xf8,0x81,0xff,0xff,0x1f,0xc0,0xff,0xff,0x0f,
	0xfc,0xff,0xff,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0xf8,0x07,0xf8,0x03,0xf8,0x81,0xff,0xff,0x0f,0x80,0xff,0x7f,0x0f,0xfc,
	0xff,0xff,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0xf0,0x03,0xf8,0x03,0xf8,0x81,0xff,0xff,0x03,0x00,0xfe,0x3f,0x0f,0xfc,0xff,
	0xff,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xf0,
	0x03,0xf8,0x01,0xf8,0x81,0xff,0xff,0x00,0x00,0xf0,0x07,0x0f,0xfc,0xff,0xff,
	0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x01,0x00,0x3c,0xf0,0xff,0x07,0xe0,0xff,0x0f,0x00,0x80,0x03,0x00,0xfe,
	0xff,0xe1,0x03,0x00,0x38,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x01,0x00,0x3c,0xf0,0x00,0x1f,0xe0,0x01,0x3f,0x00,0x80,0x03,0x00,0x1e,0xe0,
	0xc3,0x07,0x00,0x1c,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,
	0x00,0x3c,0xf0,0x00,0x3c,0xe0,0x01,0x78,0x00,0xc0,0x07,0x00,0x1e,0x80,0x8f,
	0x0f,0x00,0x0e,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,
	0x3c,0xf0,0x00,0x3c,0xe0,0x01,0xf8,0x00,0xc0,0x07,0x00,0x1e,0x00,0x0f,0x1f,
	0x00,0xe7,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,
	0xf0,0x00,0x3c,0xe0,0x01,0xf0,0x00,0x60,0x0f,0x00,0x1e,0x00,0x0f,0x1e,0x80,
	0x43,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,
	0x00,0x3c,0xe0,0x01,0xf0,0x00,0x30,0x1f,0x00,0x1e,0x00,0x0f,0x3c,0x80,0x41,
	0xc5,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0x00,
	0x3c,0xe0,0x01,0x78,0x00,0x30,0x1e,0x00,0x1e,0x00,0x0f,0x78,0xc0,0x01,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0x00,0x1c,
	0xe0,0x01,0x78,0x00,0x18,0x3c,0x00,0x1e,0x80,0x07,0xf8,0xe0,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0x80,0x07,0xe0,
	0x01,0x3e,0x00,0x18,0x3c,0x00,0x1e,0xc0,0x03,0xf0,0x61,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0xff,0x00,0xe0,0xff,
	0x07,0x00,0x0c,0x78,0x00,0xfe,0x7f,0x00,0xe0,0x19,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0xc0,0x0f,0xe0,0x7f,0x00,
	0x00,0x0c,0xf8,0x00,0xfe,0x07,0x00,0xc0,0x1f,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0x00,0x1e,0xe0,0xfd,0x00,0x00,
	0xfe,0xff,0x00,0x9e,0x0f,0x00,0x80,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0x00,0x7c,0xe0,0xf9,0x00,0x00,0xff,
	0xff,0x01,0x1e,0x1f,0x00,0x00,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x01,0x00,0x3c,0xf0,0x00,0x78,0xe0,0xf1,0x03,0x00,0x03,0xe0,
	0x01,0x1e,0x3e,0x00,0x00,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x01,0x00,0x3c,0xf0,0x00,0x78,0xe0,0xc1,0x07,0x80,0x01,0xc0,0x03,
	0x1e,0x78,0x00,0x00,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x01,0x00,0x3c,0xf0,0x00,0x78,0xe0,0x81,0x07,0x80,0x01,0xc0,0x03,0x1e,
	0xf0,0x00,0x00,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x01,0x00,0x3c,0xf0,0x00,0x78,0xe0,0x01,0x1f,0xc0,0x00,0x80,0x07,0x1e,0xe0,
	0x03,0x00,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,
	0x00,0x3c,0xf0,0x00,0x78,0xe0,0x01,0x3e,0xe0,0x00,0x00,0x0f,0x1e,0xc0,0x07,
	0x00,0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,
	0x3c,0xf0,0x00,0x3c,0xe0,0x01,0x7c,0x60,0x00,0x00,0x0e,0x1e,0x80,0x07,0x00,
	0x0f,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x1f,0x3c,
	0xf0,0x00,0x0f,0xe0,0x01,0xf8,0x71,0x00,0x00,0x1e,0x1e,0x00,0x1f,0x00,0x0f,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x1f,0x3c,0xf0,
	0xff,0x03,0xe0,0x01,0xe0,0x33,0x00,0x00,0x1c,0x1e,0x00,0x3e,0x00,0x0f,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
	0x03,0x00,0xfc,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,
	0x00,0xfe,0x01,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x1c,0x00,
	0x87,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x18,0x00,0x03,
	0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x18,0x80,0x01,0x06,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x01,0x06,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x80,0x01,0x06,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x07,0x80,0x01,0x06,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x80,0x01,0x06,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x01,0x06,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x30,0x80,0x01,0x06,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x30,0x80,0x01,0x06,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x30,0x80,0x01,0x06,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0c,0x30,0x80,0x01,0x06,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x1c,0x38,0x00,0x03,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,
	0x1c,0x00,0x87,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,
	0x06,0xfe,0x01,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x03,0x06,
	0xfc,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x40,0x20,0x40,0x70,0x38,0x3c,0x00,0x82,0xc3,0xe1,0x40,0x90,0x00,0x00,0x48,
	0x00,0x00,0x78,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x20,
	0x46,0x60,0x88,0x44,0x04,0x00,0x43,0x24,0x12,0xc1,0x18,0x00,0x00,0x08,0x00,
	0x00,0x84,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x10,0x89,
	0x50,0x88,0x44,0x02,0x80,0x42,0x24,0x12,0xc0,0x98,0x18,0xe5,0x48,0x1a,0x0e,
	0x84,0x38,0x7f,0x44,0x8e,0x72,0x00,0x00,0xc0,0x00,0x00,0x00,0x90,0x90,0x40,
	0x88,0x44,0x1e,0x00,0x42,0x24,0xd2,0x40,0x95,0x24,0x13,0x49,0x26,0x11,0x04,
	0x44,0x52,0x44,0x91,0x89,0x00,0x00,0xc0,0x00,0x00,0x00,0x90,0x80,0x40,0xc8,
	0x64,0x22,0x00,0x42,0x26,0x33,0x41,0x95,0x04,0x11,0x49,0x22,0x11,0x78,0x44,
	0x92,0x2a,0x90,0x88,0x00,0x00,0xc0,0x00,0x00,0x00,0x90,0x80,0x40,0xb0,0x58,
	0x20,0x00,0x82,0xc5,0x12,0x41,0x95,0x04,0x11,0x49,0x22,0x1f,0x80,0x44,0x92,
	0x2a,0x9e,0xf8,0x00,0x00,0xc0,0x00,0x00,0x00,0x90,0x90,0x40,0x80,0x40,0x20,
	0x00,0x02,0x04,0x12,0x41,0x95,0x04,0x11,0x49,0x22,0x01,0x84,0x44,0x92,0x2a,
	0x91,0x08,0x00,0x00,0xc0,0x00,0x00,0x00,0x10,0x89,0x40,0x88,0x44,0x22,0x00,
	0x42,0x24,0x12,0x41,0x92,0x24,0x11,0x49,0x22,0x11,0x84,0x44,0x12,0x11,0x99,
	0x88,0x00,0x00,0xc0,0x00,0x00,0x00,0x20,0x46,0x40,0x70,0x38,0x1c,0x02,0x82,
	0xc3,0xe1,0x40,0x92,0x18,0xe1,0x48,0x22,0x0e,0x78,0x38,0x32,0x11,0x96,0x70,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x40,0x20,0x00,0x00,0x00,0x00,0x02,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0
};

Pixmap coverPixmapW, coverPixmapB, coverPixmask;
GC coverGC;

static void CoverExpose();

void AddCoverTabForm(folder)
Widget folder;
{
	Widget form, da;
	Display *dpy;
	Window root;
	XmString str;

	str = XmStringCreateSimple("Cover Page");
	form = XmLFolderAddTabForm(folder, str);
	XmStringFree(str);
	CreatePixmap(form, 0, &coverPixmapW, &coverPixmask,
		(char *)cover_bits, cover_width, cover_height);
	CreatePixmap(form, 1, &coverPixmapB, &coverPixmask,
		(char *)cover_bits, cover_width, cover_height);

	dpy = XtDisplay(form);
	root = DefaultRootWindow(dpy);
	coverGC = XCreateGC(dpy, root, 0, NULL);
	da = XtVaCreateManagedWidget("drawArea",
		xmDrawingAreaWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	XtAddCallback(da, XmNexposeCallback, CoverExpose, NULL);

}

static void CoverExpose(w, clientData, callData)
Widget w;
XtPointer clientData, callData;
{
	XRectangle rect;
	Pixel black, white;

	XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, False);
	black = BlackPixelOfScreen(XtScreen(w));
	white = WhitePixelOfScreen(XtScreen(w));
	rect.x = 1;
	rect.y = 1;
	XtVaGetValues(w,
		XmNwidth, &rect.width,
		XmNheight, &rect.height,
		NULL);
	XmLPixmapDraw(w, coverPixmapW, coverPixmask, cover_width, cover_height,
		XmALIGNMENT_CENTER, coverGC, &rect, &rect);
	rect.x = 0;
	rect.y = 0;
	XmLPixmapDraw(w, coverPixmapB, coverPixmask, cover_width, cover_height,
		XmALIGNMENT_CENTER, coverGC, &rect, &rect);
}

/*
   Intro Tab Form
*/

#define logo_width 230
#define logo_height 90
static unsigned char logo_bits[] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xf8,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0xf8,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0xf8,0xff,0xff,0xff,0xff,0x7f,
	0xf0,0xff,0xff,0xff,0x3f,0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x18,0xfc,0x3f,0x7c,0xf8,0x0f,0xc6,
	0x1f,0x00,0xfe,0x07,0xe0,0x3f,0xfc,0x1f,0x3e,0xfc,0x9f,0x0f,0x00,0xfe,0xff,
	0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x18,0xfc,0x3f,0x7c,0xf8,0x87,0xbf,0x1f,
	0x3e,0xf8,0xe3,0x87,0x3f,0xfc,0x1f,0x3e,0xf8,0x9f,0x0f,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x7f,0xc0,0x18,0xf8,0x1f,0x7c,0xf8,0xe3,0x3f,0x1f,0x7e,
	0xf8,0xf1,0x0f,0x3f,0xfc,0x1f,0x3e,0xf8,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x7f,0xc0,0x18,0xf8,0x1f,0x7c,0xf8,0xf1,0x7f,0x1e,0xfe,0xf8,
	0xf0,0x1f,0x3e,0xfc,0x1f,0x3e,0xf0,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x7f,0xc0,0x18,0xf0,0x0f,0x7c,0xf8,0xf0,0xff,0x1c,0xfe,0xf0,0xf8,
	0x1f,0x3e,0xfc,0x1f,0x3e,0xe0,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x7f,0xc0,0x18,0xf0,0x0f,0x7c,0xf8,0xf8,0xff,0x1f,0xfe,0x70,0xf8,0x3f,
	0x3c,0xfc,0x1f,0x3e,0xe1,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x7f,0xc0,0x98,0xf0,0x2f,0x7c,0x78,0xf8,0xff,0x1f,0xfe,0x70,0xfc,0x3f,0x3c,
	0xfc,0x1f,0x3e,0xc1,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,
	0xc0,0x98,0xe0,0x27,0x7c,0x78,0xf8,0xff,0x1f,0xfe,0x30,0xfc,0x3f,0x3c,0xfc,
	0x1f,0x3e,0x83,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,
	0x98,0xe1,0x27,0x7c,0x78,0xf8,0xff,0x1f,0xfe,0x30,0xfc,0x3f,0x38,0xfc,0x1f,
	0x3e,0x07,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,
	0xc1,0x33,0x7c,0x38,0xfc,0xff,0x1f,0x7e,0x38,0xfc,0x3f,0x38,0xfc,0x1f,0x3e,
	0x07,0x9f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0xc3,
	0x33,0x7c,0x38,0xfc,0xff,0x1f,0x3e,0x38,0xfc,0x7f,0x38,0xfc,0x1f,0x3e,0x0f,
	0x9e,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0xc3,0x3b,
	0x7c,0x38,0xfc,0xff,0x1f,0x02,0x3e,0xfc,0x7f,0x38,0xfc,0x1f,0x3e,0x1f,0x9c,
	0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0x83,0x39,0x7c,
	0x38,0xfc,0xff,0x1f,0x86,0x3f,0xfc,0x7f,0x38,0xfc,0x1f,0x3e,0x1f,0x9c,0x0f,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0x87,0x39,0x7c,0x38,
	0xfc,0xff,0x1f,0x86,0x3f,0xfc,0x7f,0x38,0xfc,0x1f,0x3e,0x3f,0x98,0x0f,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0x07,0x3c,0x7c,0x38,0xf8,
	0xff,0x1f,0x0e,0x3f,0xfc,0x3f,0x38,0xfc,0x1f,0x3e,0x7f,0x90,0x0f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0x0f,0x3c,0x7c,0x38,0xf8,0xff,
	0x1f,0x0e,0x3f,0xfc,0x3f,0x3c,0xfc,0x1f,0x3e,0xff,0x90,0x0f,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0x0f,0x3c,0x7c,0x78,0xf8,0xff,0x1f,
	0x1e,0x7e,0xfc,0x3f,0x3c,0xfc,0x1f,0x3e,0xff,0x80,0x0f,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0x7f,0xc0,0x98,0x0f,0x3e,0x7c,0x78,0xf8,0xff,0x19,0x1e,
	0x7e,0xf8,0x3f,0x3c,0xfc,0x1f,0x3e,0xff,0x81,0x0f,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x7f,0xc0,0x98,0x1f,0x3e,0x7c,0xf8,0xf0,0xff,0x1c,0x3e,0x7c,
	0xf8,0x1f,0x3e,0xfc,0x1f,0x3e,0xff,0x83,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0x7f,0xc0,0x98,0x1f,0x3f,0x7c,0xf8,0xe1,0x7f,0x1e,0x3e,0xfc,0xf8,
	0x1f,0x3f,0xfc,0x1f,0x3e,0xff,0x83,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0x7f,0xc0,0x98,0x3f,0x3f,0x7c,0xf8,0xc1,0x3f,0x1e,0x7e,0xf8,0xf1,0x0f,
	0x3f,0xfc,0x1f,0x3e,0xff,0x87,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x7f,0xc0,0x98,0x3f,0x3f,0x7c,0xf8,0x07,0x0f,0x1f,0x7e,0xf8,0xe3,0x87,0x3f,
	0x00,0x18,0x3e,0xff,0x8f,0x0f,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,
	0xc0,0x98,0xff,0x3f,0x7c,0xf8,0x0f,0xc0,0x1f,0xfe,0xf0,0x07,0xe0,0x3f,0x00,
	0x18,0x3e,0xff,0x8f,0x0f,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,
	0xf8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0xf8,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0xf8,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xe0,0x0f,0xf0,0x07,
	0xf8,0xf3,0x03,0xff,0xff,0x01,0x00,0xf0,0x1f,0x00,0xf8,0xff,0xff,0xfc,0xff,
	0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0x0f,0xf0,0x07,0xf8,
	0xf1,0x03,0xff,0xff,0x07,0x00,0xfe,0xff,0x00,0xf8,0xff,0xff,0xfc,0xff,0xff,
	0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0x0f,0xf0,0x0f,0xf8,0xf1,
	0x03,0xff,0xff,0x1f,0x00,0xff,0xff,0x03,0xf8,0xff,0xff,0xfc,0xff,0xff,0x03,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0x1f,0xf0,0x0f,0xf8,0xf1,0x03,
	0xff,0xff,0x3f,0x80,0xff,0xff,0x07,0xf8,0xff,0xff,0xfc,0xff,0xff,0x03,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x80,0x1f,0xf8,0x0f,0xfc,0xf0,0x03,0x3f,
	0x80,0x7f,0xc0,0x1f,0xf0,0x0f,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x80,0x1f,0xf8,0x0f,0xfc,0xf0,0x03,0x3f,0x00,
	0x7e,0xe0,0x0f,0xc0,0x1f,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x80,0x1f,0x78,0x1f,0xfc,0xf0,0x03,0x3f,0x00,0xfe,
	0xf0,0x07,0x80,0x1f,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x3f,0x78,0x1f,0x7c,0xf0,0x03,0x3f,0x00,0xfc,0xf0,
	0x03,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x3f,0x7c,0x1f,0x7e,0xf0,0x03,0x3f,0x00,0xfc,0xf1,0x03,
	0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x3f,0x7c,0x1f,0x7e,0xf0,0x03,0x3f,0x00,0xf8,0xf9,0x01,0x00,
	0x00,0xf8,0xff,0x7f,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x3e,0x3c,0x3e,0x3e,0xf0,0x03,0x3f,0x00,0xf8,0xf9,0x01,0xfc,0x1f,
	0xf8,0xff,0x7f,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x7e,0x3c,0x3e,0x3e,0xf0,0x03,0x3f,0x00,0xf8,0xf9,0x01,0xfc,0x1f,0xf8,
	0xff,0x7f,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x7e,0x3e,0x3e,0x3f,0xf0,0x03,0x3f,0x00,0xf8,0xf9,0x01,0xfc,0x1f,0xf8,0xff,
	0x7f,0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x7c,
	0x3e,0x3c,0x1f,0xf0,0x03,0x3f,0x00,0xf8,0xf9,0x01,0xfc,0x1f,0xf8,0x01,0x00,
	0x00,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xfc,0x1e,
	0x7c,0x1f,0xf0,0x03,0x3f,0x00,0xf8,0xf9,0x03,0x00,0x1f,0xf8,0x01,0x00,0x00,
	0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xfc,0x1e,0x7c,
	0x1f,0xf0,0x03,0x3f,0x00,0xfc,0xf0,0x03,0x00,0x1f,0xf8,0x01,0x00,0x00,0xf8,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xf8,0x1f,0xf8,0x0f,
	0xf0,0x03,0x3f,0x00,0xfe,0xf0,0x07,0x80,0x1f,0xf8,0x01,0x00,0x00,0xf8,0x01,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xf8,0x0f,0xf8,0x0f,0xf0,
	0x03,0x3f,0x00,0x7e,0xe0,0x0f,0xc0,0x1f,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xf0,0x0f,0xf8,0x0f,0xf0,0x03,
	0x3f,0x80,0x7f,0xc0,0x3f,0xf0,0x1f,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xf0,0x0f,0xf8,0x07,0xf0,0x03,0xff,
	0xff,0x3f,0x80,0xff,0xff,0x1f,0xf8,0xff,0xff,0x01,0xf8,0x01,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0xf0,0x0f,0xf0,0x07,0xf0,0x03,0xff,0xff,
	0x1f,0x00,0xff,0xff,0x1e,0xf8,0xff,0xff,0x01,0xf8,0x01,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0xe0,0x07,0xf0,0x07,0xf0,0x03,0xff,0xff,0x07,
	0x00,0xfc,0x7f,0x1e,0xf8,0xff,0xff,0x01,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0xe0,0x07,0xf0,0x03,0xf0,0x03,0xff,0xff,0x01,0x00,
	0xe0,0x0f,0x1e,0xf8,0xff,0xff,0x01,0xf8,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0xff,0x0f,0xc0,0xff,
	0x1f,0x00,0x00,0x07,0x00,0xfc,0xff,0xc3,0x07,0x00,0x70,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0x3e,0xc0,0x03,0x7e,
	0x00,0x00,0x07,0x00,0x3c,0xc0,0x87,0x0f,0x00,0x38,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0x78,0xc0,0x03,0xf0,0x00,
	0x80,0x0f,0x00,0x3c,0x00,0x1f,0x1f,0x00,0x1c,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0x78,0xc0,0x03,0xf0,0x01,0x80,
	0x0f,0x00,0x3c,0x00,0x1e,0x3e,0x00,0xce,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0x78,0xc0,0x03,0xe0,0x01,0xc0,0x1e,
	0x00,0x3c,0x00,0x1e,0x3c,0x00,0x87,0xce,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0x78,0xc0,0x03,0xe0,0x01,0x60,0x3e,0x00,
	0x3c,0x00,0x1e,0x78,0x00,0x83,0xca,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x80,0x03,0x00,0x78,0xe0,0x01,0x78,0xc0,0x03,0xf0,0x00,0x60,0x3c,0x00,0x3c,
	0x00,0x1e,0xf0,0x80,0x03,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
	0x03,0x00,0x78,0xe0,0x01,0x38,0xc0,0x03,0xf0,0x00,0x30,0x78,0x00,0x3c,0x00,
	0x0f,0xf0,0xc1,0x01,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
	0x00,0x78,0xe0,0x01,0x0f,0xc0,0x03,0x7c,0x00,0x30,0x78,0x00,0x3c,0x80,0x07,
	0xe0,0xc3,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,
	0x78,0xe0,0xff,0x01,0xc0,0xff,0x0f,0x00,0x18,0xf0,0x00,0xfc,0xff,0x00,0xc0,
	0x33,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,
	0xe0,0x81,0x1f,0xc0,0xff,0x00,0x00,0x18,0xf0,0x01,0xfc,0x0f,0x00,0x80,0x3f,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,
	0x01,0x3c,0xc0,0xfb,0x01,0x00,0xfc,0xff,0x01,0x3c,0x1f,0x00,0x00,0x1f,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,
	0xf8,0xc0,0xf3,0x01,0x00,0xfe,0xff,0x03,0x3c,0x3e,0x00,0x00,0x1e,0x00,0xc0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0xf0,
	0xc0,0xe3,0x07,0x00,0x06,0xc0,0x03,0x3c,0x7c,0x00,0x00,0x1e,0x00,0xc0,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0xf0,0xc0,
	0x83,0x0f,0x00,0x03,0x80,0x07,0x3c,0xf0,0x00,0x00,0x1e,0x00,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0xf0,0xc0,0x03,
	0x0f,0x00,0x03,0x80,0x07,0x3c,0xe0,0x01,0x00,0x1e,0x00,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0xf0,0xc0,0x03,0x3e,
	0x80,0x01,0x00,0x0f,0x3c,0xc0,0x07,0x00,0x1e,0x00,0xc0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0xf0,0xc0,0x03,0x7c,0xc0,
	0x01,0x00,0x1e,0x3c,0x80,0x0f,0x00,0x1e,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x80,0x03,0x00,0x78,0xe0,0x01,0x78,0xc0,0x03,0xf8,0xc0,0x00,
	0x00,0x1c,0x3c,0x00,0x0f,0x00,0x1e,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x80,0x03,0x3e,0x78,0xe0,0x01,0x1e,0xc0,0x03,0xf0,0xe3,0x00,0x00,
	0x3c,0x3c,0x00,0x3e,0x00,0x1e,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x80,0xff,0x3f,0x78,0xe0,0xff,0x07,0xc0,0x03,0xc0,0x67,0x00,0x00,0x38,
	0x3c,0x00,0x7c,0x00,0x1e,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0
};

void AddIntroTabForm(folder)
Widget folder;
{
	Widget form, label;
	Pixmap pixmap, pixmask;
	XmString str;
	static char *desc =
	"Welcome to a Quick Look at the Microline Widget Library version 3.0.  \
This program presents an overview of widgets contained in the library.\
\n\n\
If you understand widget resources, you may want to try clicking the Editor \
button to display and edit some of the example widget's resources.  \
Please note that the editor is blank for the Cover Page and this \
Introduction screen.\
\n\n\
Further information on the library including pricing, supported platforms, \
licensing policies, etc. may be found on our web site \
http://www.mlsoft.com.  You can also email us at info@mlsoft.com.\
\n\n\
Microline Widget Library is a trademark of Microline Software. \
All other trademarks are the property of their respective owners.";

	str = XmStringCreateSimple("Introduction");
	form = XmLFolderAddTabForm(folder, str);
	XmStringFree(str);
	CreatePixmap(form, 1, &pixmap, &pixmask,
		(char *)logo_bits, logo_width, logo_height);
	label = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, form,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, pixmap,
		XmNmarginHeight, 25,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);

	CreateText(form, desc, label, 0);
}

/*
   Folder Tab Form
*/


#define sphere_width 10
#define sphere_height 10
static unsigned char sphere_bits[] = {
	0x00, 0x00, 0x78, 0x00, 0xf4, 0x00, 0xe2, 0x01, 0xf6, 0x01, 0xfe, 0x01,
	0xfe, 0x01, 0xfc, 0x00, 0x78, 0x00, 0x00, 0x00};


#define cross_width 10
#define cross_height 10
static unsigned char cross_bits[] = {
	0x00, 0x00, 0x30, 0x00, 0xb4, 0x00, 0x30, 0x00, 0xfe, 0x01, 0xfe, 0x01,
	0x30, 0x00, 0xb4, 0x00, 0x30, 0x00, 0x00, 0x00};

static Pixmap spherePixmap;
static Pixmap spherePixmask;
static Pixmap crossPixmap;
static Pixmap crossPixmask;

static void FolderSwitchCB();

Widget _folder;

void AddFolderTabForm(folder)
Widget folder;
{
	Widget form, w, sampleForm;
	XmString str;
	int i;
	static char *labels[] =
	{
		"Configuration", "Appearance", "Documents", "Keys" 			};
	static char *desc =
	"The Folder widget provides a folder containing single or \
multiple rows of tabs along the top, bottom, left or right \
and an area managed by the tabs in the center.\
\n\n\
The Folder One sample contains a single row of tabs with arc-style \
corners, each containing a pixmap image.\
\n\n\
The Folder Two sample also contains a single row of tabs but placed on the \
bottom with the \"none\" corner style.  If you increase \
the width of the demo program, you will notice that this row of tabs \
will always fill the entire row with the individual tabs taking up \
a width proportional to their contents and the width of the row.\
\n\n\
The Folder Three sample contains tabs in 2 rows placed on the right.  \
Again, the size of the tabs are proportional to the size of \
their contents and will fit to the row.\
\n\n\
The Folder is a Manager widget and each tab \
consists of a Primitive widget (usually a DrawnButton widget) \
surrounded by tab decorations including an optional pixmap.  \
Any non-Primitive widget children of the Folder are placed in \
the center area.  Tab widgets may be assigned a widget \
in the center area of the folder to display/manage when the \
tab is selected or the application can change the contents \
in the center area itself as tabs are selected.\
\n\n\
Resources exist to set the style of the corners, pixmaps \
to display in the tabs, number of tabs per row, \
various colors, sizes and spacing in and around the tabs.  \
Also, since the tabs themselves \
have Primitive widgets like DrawnButtons inside of them, they \
retain all display abilities of their respective Primitive \
widgets.  DrawnButton tabs, for example, may be displayed with \
different fonts, character sets, colors, alignments, etc.\
\n\n\
Tabs may be be added or deleted by adding or deleting \
Primitive-based widgets to the Folder.  Callbacks are provided \
which can notify an application when a tab is activated, allowing \
the application to either accept or reject the activation.\
\n\n\
The 3.0 release adds multiple rows of tabs, improved tab layout \
and also a rewrite of the Folder's geometry management.\
\n\n\
Keyboard traversal of the tabs is supported by using the arrow \
keys to move from one tab to the next.  Tabs may be activated \
by either selection with the mouse or by activating their \
underlying Primitive widget.  For example, DrawnButton tabs \
may be activated by pressing the space bar when focus is in the tab.";

	form = AddWidgetSample(folder, "Folder", desc);
	_folder = XtVaCreateManagedWidget("sampleFolder",
		xmlFolderWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNmarginWidth, 4,
		NULL);
	CreatePixmap(_folder, 4, &spherePixmap, &spherePixmask,
		(char *)sphere_bits, sphere_width, sphere_height);
	CreatePixmap(_folder, 2, &crossPixmap, &crossPixmask,
		(char *)cross_bits, cross_width, cross_height);
	for (i = 0; i < 4; i++)
	{
		str = XmStringCreateSimple(labels[i]);
		w = XmLFolderAddTab(_folder, str);
		XmStringFree(str);
		if (i % 2)
			XtVaSetValues(w,
				XmNtabPixmap, crossPixmap,
				XmNtabInactivePixmap, crossPixmap,
				NULL);
		else
			XtVaSetValues(w,
				XmNtabPixmap, spherePixmap,
				XmNtabInactivePixmap, spherePixmap,
				NULL);
	}
	sampleForm = XtVaCreateManagedWidget("sampleForm",
		xmFormWidgetClass, _folder,
		NULL);
	str = XmStringCreateLtoR("\nSample Folder\nPage Area\n",
		XmSTRING_DEFAULT_CHARSET);
	XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, sampleForm,
		XmNlabelString, str,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	XmStringFree(str);


	XtAddCallback(XtParent(form), XmNactivateCallback, FolderSwitchCB, NULL);
}

static void FolderSwitchCB(w, clientData, callData)
Widget w;
XtPointer clientData, callData;
{
	XmLFolderCallbackStruct *cbs;

	cbs = (XmLFolderCallbackStruct *)callData;
	if (cbs->pos == 0)
		XtVaSetValues(_folder,
			XmNcornerStyle, XmCORNER_ARC,
			XmNcornerDimension, 2,
			XmNtabPlacement, XmFOLDER_TOP,
			XmNtabsPerRow, 0,
			NULL);
	else if (cbs->pos == 1)
		XtVaSetValues(_folder,
			XmNcornerStyle, XmCORNER_NONE,
			XmNtabPlacement, XmFOLDER_BOTTOM,
			XmNtabsPerRow, 4,
			NULL);
	else
		XtVaSetValues(_folder,
			XmNcornerStyle, XmCORNER_ARC,
			XmNcornerDimension, 3,
			XmNtabPlacement, XmFOLDER_RIGHT,
			XmNtabsPerRow, 2,
			NULL);
}

/*
   Grid Tab Form
*/

static void GridSwitchCB();
static void GridSample1();
static void GridSample2();
static void GridSample3();
Widget _grid;

void AddGridTabForm(folder)
Widget folder;
{
	Widget form;
	XmString str;
	static char *desc =
	"The Grid widget provides an editable grid of \
cells containing text or images in rows and columns.\
\n\n\
The Grid One sample above is a multiple row selection Grid which \
allows column resizing by dragging column headings larger or smaller.  \
It contains one heading row and has columns fixed on the left and right.  \
The arrows in the Price column are an example of pixmap (image) cell \
types.\
\n\n\
The Grid Two sample demonstrates cell spanning (the 1995 Income \
Summary heading spans 2 columns) and control of cell borders, \
colors and alignment.  This Grid is set to not allow selection.\
\n\n\
The Grid Three sample allows editing and is set to allow \
selection of mulitple rows, columns and/or cells.  Note that an \
edit may be accepted by pressing Return or by moving to a new \
location and may be rejected with the Escape key.  You may \
edit an existing cell's contents using the F2 or Insert key.  \
This Grid also supports interactive row and column resizing.  \
Drag and drop is permitted by selecting an area to be dragged \
and performing a drag-and-drop operation (using mouse button 2) \
to copy the selected area to another location.\
\n\n\
The Grid includes a number of advanced features such as:\
\n\
   - string (editable or non-editable XmString format) or pixmap cells\n\
   - keyboard traversal using arrow keys, page keys, etc.\n\
   - add, delete, reorder, move and hiding of rows/columns\n\
   - heading, content and footer rows/columns\n\
   - top, bottom, left and/or right fixed rows/columns\n\
   - rows/column intelligently size to cell fonts/images\n\
   - user-adjustable row/column sizes\n\
   - cells may span rows/columns\n\
   - full control of cell borders and colors\n\
   - 9 cell alignment options (top-left, center, etc)\n\
   - uses reference-counted cell attributes to save memory\n\
   - SetValues on ranges of cells/rows/columns\n\
   - callbacks for select, activate, draw, edit, focus, etc.\n\
   - cut, paste, drag and drop of cell contents\n\
   - ASCII file import and export\
\n\n\
The Grid widget is ideal for replacing single-column Motif \
scrolled lists with multi-column lists. Its also perfect for creating \
high-performance tables.  Tables may be created where the data \
displayed is not kept in the Grid itself but retrieved from a \
database when it needs to be displayed.  This direct database \
access can save memory and time loading/storing the table. \
Click-sorting may be added to the table to allow a user to \
sort rows by clicking on a column heading.\
\n\n\
Cell attributes in the Grid are reference counted.  If a number \
of cells in the Grid have similar attributes (color, fonts, etc) \
they may all contain a pointer to the same attributes structure \
instead of creating an attributes structure for each individual \
cell.  This reference counting is transparent to a programmer \
creating a Grid.\
\n\n\
Cells may have borders set on the top, bottom, left and right and \
have a number of color/alignment options.  Keyboard traversal is \
provided using the standard Motif key mappings of Page Up, \
Page Down, Home, etc.  Selection modes are provided to allow \
selection of a single row (browse mode or single mode), multiple \
rows and arbitrary regions of rows, columns and cells. \
Functions are provided to easily import data to and from text \
files.\
\n\n\
The 3.0 release has added resources allowing you to specify cell \
defaults on a per-column basis (e.g. all cells in column 2 will be \
editable).  Also, the Grid's layout has improved for sizing policies \
where scrollbars appear as needed.  The Grid now will use all the \
space it can for data instead of not using the space where the \
scrollbars would appear. \
\n\n\
A number of resources have been added in the 3.0 release to support \
better integration with interface builders.  You can now add and \
delete rows and also set column widths and simple headings through \
resources.\
\n\n\
Internally the Grid is a Manager widget which contains two \
ScrollBar children and one Text widget child.";

	form = AddWidgetSample(folder, "Grid", desc);

	_grid = XtVaCreateManagedWidget("grid",
		xmlGridWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	GridSample1();
	XtAddCallback(XtParent(form), XmNactivateCallback, GridSwitchCB, NULL);
}

static void GridSwitchCB(w, clientData, callData)
Widget w;
XtPointer clientData, callData;
{
	XmLFolderCallbackStruct *cbs;
	Pixel bg;

	cbs = (XmLFolderCallbackStruct *)callData;

	/* reset defaults to grid */
	XtVaSetValues(_grid,
		XmNallowDragSelected, False,
		XmNallowDrop, False,
		XmNallowColumnResize, False,
		XmNallowRowResize, False,
		XmNhighlightRowMode, False,
		XmNheadingRows, 0,
		XmNrows, 0,
		XmNfooterRows, 0,
		XmNheadingColumns, 0,
		XmNcolumns, 0,
		XmNfooterColumns, 0,
		XmNshadowThickness, 2,
		XmNtopFixedCount, 0,
		XmNbottomFixedCount, 0,
		XmNleftFixedCount, 0,
		XmNrightFixedCount, 0,
		NULL);
	XtVaGetValues(_grid,
		XmNbackground, &bg,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcellBackground, bg,
		XmNcellAlignment, XmALIGNMENT_CENTER,
		XmNcellLeftBorderType, XmBORDER_LINE,
		XmNcellRightBorderType, XmBORDER_LINE,
		XmNcellTopBorderType, XmBORDER_LINE,
		XmNcellBottomBorderType, XmBORDER_LINE,
		NULL);

	if (cbs->pos == 0)
		GridSample1();
	else if (cbs->pos == 1)
		GridSample2();
	else
		GridSample3();
}

static Pixmap upPixmap = XmUNSPECIFIED_PIXMAP;
static Pixmap upPixmask;
static Pixmap downPixmap = XmUNSPECIFIED_PIXMAP;
static Pixmap downPixmask;

#define up_width 12
#define up_height 16
static unsigned char up_bits[] = {
	0x00, 0x00, 0x60, 0x00, 0xf0, 0x00, 0xf8, 0x01, 0xfc, 0x03, 0xfe, 0x07,
	0xfe, 0x07, 0xf6, 0x06, 0xf2, 0x04, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
	0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x00, 0x00};

#define down_width 12
#define down_height 16
static unsigned char down_bits[] = {
	0x00, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
	0xf0, 0x00, 0xf2, 0x04, 0xf6, 0x06, 0xfe, 0x07, 0xfe, 0x07, 0xfc, 0x03,
	0xf8, 0x01, 0xf0, 0x00, 0x60, 0x00, 0x00, 0x00};

static void GridSample1()
{
	static char *data = 
	"Name|Price||Change|Close Date|Location|Yield\n\
TZZ 3.0 Tana Zin|102.23||-1.2|1/1/94|Tomano, RE|5.6%\n\
BLC 4.5 Board L|103.23||+2.5|2/15/94|Rino, LO|6.8%\n\
DGB 5.4 Dig Gen|101.53||+3.7|6/20/94|Carolana, CA|7.5%\n\
KLC 5.3 Kord L|108.98||-2.5|2/15/94|Cannes, CA|8.7%\n\
LLO 3.4 Liw Lol|107.24||+2.2|2/20/94|Tenise, MI|6.7%\n\
MMN 3.1 Mon Mor|105.63||+1.4|2/15/94|Waterton, MN|6.3%\n\
PLP 4.3 Pol Lab|102.12||-2.3|2/20/94|Holard, LM|7.6%\n\
SZN 4.5 Siml Zi|101.11||+1.6|2/15/94|Tempest, CA|5.4%\n\
TTL 5.6 Towa Tin|101.12||+2.7|3/15/94|Conila, OK|6.7%\n\
ULD 5.4 Upl La D|105.12||-2.2|4/15/94|Mandrill, HI|7.8%";

	XtVaSetValues(_grid, XmNlayoutFrozen, True, NULL);

	XtVaSetValues(_grid,
		XmNallowColumnResize, True,
		XmNselectionPolicy, XmSELECT_MULTIPLE_ROW,
		XmNhighlightRowMode, True,
		XmNheadingRows, 1,
		XmNcolumns, 7,
		XmNsimpleWidths, "18c 8c 16p 8c 12c 16c 6c",
		XmNrightFixedCount, 1,
		XmNleftFixedCount, 1,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XtVaTypedArg, XmNcellBackground, XmRString, "white", 6,
		XmNcellLeftBorderType, XmBORDER_NONE,
		XmNcellRightBorderType, XmBORDER_NONE,
		XmNcellTopBorderType, XmBORDER_NONE,
		XmNcellBottomBorderType, XmBORDER_NONE,
		NULL);
	XtVaSetValues(_grid,
		XmNrowType, XmHEADING,
		XmNcolumn, 1,
		XmNcellColumnSpan, 1,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcellAlignment, XmALIGNMENT_RIGHT,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcolumn, 0,
		XmNcellAlignment, XmALIGNMENT_LEFT,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcolumn, 1,
		XmNcellRightBorderType, XmBORDER_NONE,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcolumn, 2,
		XmNcellType, XmPIXMAP_CELL,
		XmNcellLeftBorderType, XmBORDER_NONE,
		NULL);
	XmLGridAddRows(_grid, XmCONTENT, -1, 10);
	XmLGridSetStrings(_grid, data);

	if (upPixmap == XmUNSPECIFIED_PIXMAP)
		CreatePixmap(_grid, 2, &upPixmap, &upPixmask,
			(char *)up_bits, up_width, up_height);
	if (downPixmap == XmUNSPECIFIED_PIXMAP)
		CreatePixmap(_grid, 3, &downPixmap, &downPixmask,
			(char *)down_bits, down_width, down_height);
	XtVaSetValues(_grid,
		XmNcolumn, 2,
		XmNcellPixmap, upPixmap,
		XmNcellPixmapMask, upPixmask,
		NULL);
	XtVaSetValues(_grid,
		XmNcolumn, 2,
		XmNrowStep, 3,
		XmNcellPixmap, downPixmap,
		XmNcellPixmapMask, downPixmask,
		NULL);

	XtVaSetValues(_grid, XmNlayoutFrozen, False, NULL);
}


static void GridSample2()
{
	static char *data =
	"|1995 Income Summary\n\
|Shampoo|Conditioner|Soap|Total\n\
Revenues:\n\
Sales|$ 1,600,000|$ 1,000,000|$  800,000|$ 3,400,000\n\
Less Discounts|(16,000)|(10,000)|(8,000)|(34,000)\n\
Less Return Allowance|(8,000)|(5,000)|(4,000)|(17,000)\n\
  Net Revenue|1,576,000|985,000|792,000|3,349,000\n\
\n\
Less Expenses:\n\
Cost of Goods Sold|(640,000)|(330,000)|(264,000)|(1,234,000)\n\
Salary Expense|(380,000)|(280,000)|(180,000)|(840,000)\n\
Marketing Expense|(157,600)|(98,500)|(79,200)|(335,300)\n\
Rent Expense|(36,000)|(36,000)|(36,000)|(108,000)\n\
Misc. Other Expense|(36,408)|(22,335)|(16,776)|(75,519)\n\
  Total Expenses|(1,250,008)|(766,835)|(575,976)|(2,592,819)\n\
\n\
Income Tax Expense|(130,397)|(87,266)|(86,410)|(304,072)\n\
Net Income|195,595|130,899|129,614|456,109";

	XtVaSetValues(_grid, XmNlayoutFrozen, True, NULL);

	XtVaSetValues(_grid,
		XmNheadingColumns, 1,
		XmNcolumns, 3,
		XmNfooterColumns, 1,
		XmNsimpleWidths, "22c 12c 12c 12c 12c",
		XmNselectionPolicy, XmSELECT_NONE,
		NULL);

	/* add 'Income Summary' heading row */
	XtVaSetValues(_grid, 
		XmNcellDefaults, True,
		XmNcellLeftBorderType, XmBORDER_NONE,
		XmNcellRightBorderType, XmBORDER_NONE,
		XmNcellTopBorderType, XmBORDER_NONE,
		XtVaTypedArg, XmNcellBottomBorderColor, XmRString, "black", 6,
		XmNcellAlignment, XmALIGNMENT_CENTER,
		XtVaTypedArg, XmNcellForeground, XmRString, "#000080", 8,
		NULL);
	XmLGridAddRows(_grid, XmHEADING, -1, 1);
	XtVaSetValues(_grid,
		XmNrowType, XmHEADING,
		XmNrow, 0,
		XmNcolumn, 0,
		XmNcellColumnSpan, 2,
		NULL);

	/* add 'Shampoo Conditioner Soap' heading row */
	XtVaSetValues(_grid, 
		XmNcellDefaults, True,
		XtVaTypedArg, XmNcellBackground, XmRString, "white", 6,
		XtVaTypedArg, XmNcellForeground, XmRString, "black", 6,
		XmNcellBottomBorderType, XmBORDER_NONE,
		NULL);
	XmLGridAddRows(_grid, XmHEADING, -1, 1);

	/* bold heading rows */
	XtVaSetValues(_grid,
		XmNrowType, XmHEADING,
		XmNcolumnType, XmALL_TYPES,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		NULL);

	/* add content and footer rows */
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcellAlignment, XmALIGNMENT_RIGHT,
		NULL);
	XmLGridAddRows(_grid, XmCONTENT, -1, 15);
	XmLGridAddRows(_grid, XmFOOTER, -1, 1);

	/* left justify left-most (heading) column */
	XtVaSetValues(_grid,
		XmNcolumn, 0,
		XmNcolumnType, XmHEADING,
		XmNrowType, XmALL_TYPES,
		XmNcellAlignment, XmALIGNMENT_LEFT,
		NULL);

	/* bold 'Revenues' cell */
	XtVaSetValues(_grid,
		XmNcolumnType, XmHEADING,
		XmNcolumn, 0,
		XmNrow, 0,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		NULL);

	/* bold 'Less Expenses' cell */
	XtVaSetValues(_grid,
		XmNcolumnType, XmHEADING,
		XmNcolumn, 0,
		XmNrow, 6,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		NULL);

	/* grey middle and footer content column */
	XtVaSetValues(_grid,
		XmNrowType, XmALL_TYPES,
		XmNcolumnType, XmALL_TYPES,
		XmNcolumnRangeStart, 2,
		XmNcolumnRangeEnd, 4,
		XmNcolumnStep, 2,
		XtVaTypedArg, XmNcellBackground, XmRString, "#E8E8E8", 8,
		NULL);

	/* set 'Income Summary' heading row yellow */
	XtVaSetValues(_grid,
		XmNcolumnType, XmALL_TYPES,
		XmNrowType, XmHEADING,
		XmNrow, 0,
		XtVaTypedArg, XmNcellBackground, XmRString, "#FFFF00", 8,
		NULL);

	/* blue and bold 'Net Revenue' and 'Total Expenses' rows */
	XtVaSetValues(_grid,
		XmNrowRangeStart, 4,
		XmNrowRangeEnd, 12,
		XmNrowStep, 8,
		XmNcolumnType, XmALL_TYPES,
		XtVaTypedArg, XmNcellForeground, XmRString, "white", 6,
		XtVaTypedArg, XmNcellBackground, XmRString, "#000080", 8,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		NULL);

	/* blue and bold 'Net Income' footer row */
	XtVaSetValues(_grid,
		XmNrow, 0,
		XmNrowType, XmFOOTER,
		XmNcolumnType, XmALL_TYPES,
		XtVaTypedArg, XmNcellForeground, XmRString, "white", 6,
		XtVaTypedArg, XmNcellBackground, XmRString, "#000080", 8,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		NULL);
	XmLGridSetStrings(_grid, data);

	XtVaSetValues(_grid, XmNlayoutFrozen, False, NULL);

}

static void GridSample3()
{
	char buf[4];
	int i;

	XtVaSetValues(_grid, XmNlayoutFrozen, True, NULL);

	XtVaSetValues(_grid,
		XmNallowDragSelected, True,
		XmNallowDrop, True,
		XmNhsbDisplayPolicy, XmSTATIC,
		XmNvsbDisplayPolicy, XmSTATIC,
		XmNselectionPolicy, XmSELECT_CELL,
		XmNallowColumnResize, True,
		XmNallowRowResize, True,
		XmNshadowThickness, 1,
		NULL);
	XtVaSetValues(_grid,
		XmNcellDefaults, True,
		XmNcellEditable, True,
		XmNcellAlignment, XmALIGNMENT_RIGHT,
		XtVaTypedArg, XmNcellBackground, XmRString, "white", 6,
		XmNcellLeftBorderType, XmBORDER_NONE,
		XmNcellTopBorderType, XmBORDER_NONE,
		NULL);
	XtVaSetValues(_grid,
		XmNheadingRows, 1,
		XmNheadingColumns, 1,
		XmNcolumns, 26,
		XmNrows, 100,
		NULL);

	XtVaSetValues(_grid, XmNlayoutFrozen, False, NULL);
	for (i = 0; i < 26; i++)
	{
		sprintf(buf, "%c", 'A' + i);
		XmLGridSetStringsPos(_grid, XmHEADING, 0, XmCONTENT, i, buf);
	}
	for (i = 0; i < 100; i++)
	{
		sprintf(buf, "%d", i + 1);
		XmLGridSetStringsPos(_grid, XmCONTENT, i, XmHEADING, 0, buf);
	}
	XtVaSetValues(_grid,
		XmNrowType, XmALL_TYPES,
		XmNcolumnType, XmHEADING,
		XmNcolumn, 0,
		XmNcellAlignment, XmALIGNMENT_CENTER,
		XtVaTypedArg, XmNcellBackground, XmRString, "#C0C0C0", 8,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		XmNcellLeftBorderType, XmBORDER_LINE,
		XmNcellTopBorderType, XmBORDER_LINE,
		NULL);
	XtVaSetValues(_grid,
		XmNrowType, XmHEADING,
		XmNrow, 0,
		XmNcellAlignment, XmALIGNMENT_CENTER,
		XtVaTypedArg, XmNcellBackground, XmRString, "#C0C0C0", 8,
		XtVaTypedArg, XmNcellFontList, XmRString,
		BOLDFONT, strlen(BOLDFONT) + 1,
		XmNcellLeftBorderType, XmBORDER_LINE,
		XmNcellTopBorderType, XmBORDER_LINE,
		NULL);
}

/*
   Progress Tab Form
*/

static void ProgSwitchCB();
static void ProgSweepCB();
Widget _progress;

void AddProgTabForm(folder)
Widget folder;
{
	Widget form, button;
	XmString str;
	static char *desc =
	"The Progress widget may be used to chart the completion of a task.\
\n\n\
The Progress One sample displays a standard bar-style Progress widget.  \
You may press the Quick Sweep or the Slow Sweep button to chart progress \
of a simulated task.\
\n\n\
The Progress Two sample displays a box-style Progress widget with 20 boxes.\
\n\n\
The Progress Three sample contains a bar-style Progress widget which \
displays elapsed time and estimated time to completion.  \
Press the Slow Sweep button to display this behavior.  These \
times are calculated automatically by the Progress widget. \
\n\n\
Resources exist to set colors, fonts, shadows, the style of the \
meter bar and the values used to determine level of completeness. \
\n\n\
The Progress widget is a subclasss of the Primitive widget.";

	form = AddWidgetSample(folder, "Progress", desc);
	_progress = XtVaCreateManagedWidget("progress",
		xmlProgressWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, 30,
		XmNheight, 24,
		XmNvalue, 50,
		XtVaTypedArg, XmNforeground, XmRString, "#0000C0", 8,
		XtVaTypedArg, XmNbackground, XmRString, "white", 6,
		NULL);
	button = XtVaCreateManagedWidget("Quick Sweep",
		xmPushButtonWidgetClass, form,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNmarginWidth, 15,
		NULL);
	XtAddCallback(button, XmNactivateCallback, ProgSweepCB, (XtPointer)1);
	button = XtVaCreateManagedWidget("Slow Sweep",
		xmPushButtonWidgetClass, form,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, button,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNmarginWidth, 15,
		NULL);
	XtAddCallback(button, XmNactivateCallback, ProgSweepCB, (XtPointer)0);
	XtAddCallback(XtParent(form), XmNactivateCallback, ProgSwitchCB, NULL);
}

static void ProgSwitchCB(w, clientData, callData)
Widget w;
XtPointer clientData, callData;
{
	XmLFolderCallbackStruct *cbs;

	cbs = (XmLFolderCallbackStruct *)callData;
	if (cbs->pos == 0)
		XtVaSetValues(_progress,
			XmNvalue, 50,
			XmNshadowThickness, 2,
			XmNmeterStyle, XmMETER_BAR,
			XtVaTypedArg, XmNforeground, XmRString, "#0000C0", 8,
			XmNshowTime, False,
			NULL);
	else if (cbs->pos == 1)
		XtVaSetValues(_progress,
			XmNvalue, 50,
			XmNshadowThickness, 1,
			XmNmeterStyle, XmMETER_BOXES,
			XmNnumBoxes, 20,
			XtVaTypedArg, XmNforeground, XmRString, "#0000C0", 8,
			XmNshowTime, False,
			NULL);
	else
		XtVaSetValues(_progress,
			XmNvalue, 50,
			XmNshadowThickness, 2,
			XmNmeterStyle, XmMETER_BAR,
			XtVaTypedArg, XmNforeground, XmRString, "#E00000", 8,
			XmNshowTime, True,
			NULL);
}

static void ProgSweepCB(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
{
	int i, quickSweep;

	quickSweep = (int)clientData;
	if (quickSweep)
		for (i = 0; i <= 100; i += 4)
			XtVaSetValues(_progress,
				XmNvalue, i,
				NULL);
	else
	{
		for (i = 0; i <= 100; i += 23)
		{
			XtVaSetValues(_progress,
				XmNvalue, i,
				NULL);
			sleep(1);
		}
		XtVaSetValues(_progress,
			XmNvalue, 100,
			NULL);
	}
}

/*
   Tree Tab Form
*/

static void TreeSwitchCB();
static void TreeSample();
Widget _tree;

void AddTreeTabForm(folder)
Widget folder;
{
	Widget form, w;
	XmString str;
	static char *desc =
	"The Tree widget may be used to display hierarchical data and \
parent-child relationships.\
\n\n\
The Tree One sample contains a simple Tree in browse select mode.  \
Note that horizontal scrolling is on a per-pixel basis while vertical \
scrolling is on a per-row basis and the horizontal and vertical \
scrollbars only appear as needed.  The plus and minus indicators \
may be used to expand and collapse rows.  Activating a row \
with Return or by double clicking on it will toggle the expanded \
state of the row.\
\n\n\
The Tree Two sample contains a Tree in multiple row select mode with \
application defined pixmaps.\
\n\n\
The Tree Three sample displays a Tree in browse select mode containing \
multiple columns.  The columns support interactive resizing by \
dragging a column heading larger or smaller.\
\n\n\
The Tree widget is a subclass of the Grid, meaning it includes all the \
functionality of the Grid widget.  This includes selection policies \
of single row, multiple row, etc. as well as full control over colors, \
fonts, alignment, borders, etc. on a per-cell basis.  The Tree \
also supports all the other features of the Grid, including heading, \
content and footer rows and columns, various cell types etc.\
\n\n\
An application may add rows to the Tree and let the Tree handle \
the expansion and collapse of rows, or for large trees, \
an application may handle the expansion and collapse of rows \
by adding (creating) and deleting rows dynamically as needed.\
\n\n\
Resources exist to set the indent level, various colors of the \
Tree, etc.  As stated earlier, the Tree also contains all the \
resources available in the Grid.\
\n\n\
This widget is new in the 3.0 release.";

	form = AddWidgetSample(folder, "Tree", desc);
	_tree = XtVaCreateManagedWidget("tree",
		xmlTreeWidgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	TreeSample(0);
	XtAddCallback(XtParent(form), XmNactivateCallback, TreeSwitchCB, NULL);
}

static void TreeSwitchCB(w, clientData, callData)
Widget w;
XtPointer clientData, callData;
{
	XmLFolderCallbackStruct *cbs;

	cbs = (XmLFolderCallbackStruct *)callData;
	TreeSample(cbs->pos);
}

#define dot_width 16
#define dot_height 16
static unsigned char dot_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x07, 0xe0, 0x0f, 0xb0, 0x1f,
	0x18, 0x3f, 0xb8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf0, 0x1f,
	0xe0, 0x0f, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x00};

#define win_width 16
#define win_height 16
static unsigned char win_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f, 0x08, 0x40, 0xe8, 0x6f, 0xe8, 0x61,
	0xe8, 0x61, 0xe8, 0x61, 0x28, 0x60, 0x28, 0x60, 0x28, 0x60, 0x08, 0x60,
	0x08, 0x60, 0xe8, 0x7f, 0xf0, 0x7f, 0x00, 0x00};

static Pixmap dotPixmap = XmUNSPECIFIED_PIXMAP;
static Pixmap dotPixmask;
static Pixmap winPixmap = XmUNSPECIFIED_PIXMAP;
static Pixmap winPixmask;

static void TreeSample(num)
int num;
{
	XmLTreeRowDefinition *rows;
	int i, n, size, level;
	Pixel bg;
	char buf[80];
	static struct
					{
		Boolean expands;
		int level;
	} defs[10] =
	{
		True, 0,
		True, 1,
		True, 2,
		False, 3,
		False, 2,
		False, 2,
		True, 1,
		False, 2,
		False, 2,
		True, 2,
	};

	if (dotPixmap == XmUNSPECIFIED_PIXMAP)
		CreatePixmap(_tree, 4, &dotPixmap, &dotPixmask,
			(char *)dot_bits, dot_width, dot_height);
	if (winPixmap == XmUNSPECIFIED_PIXMAP)
		CreatePixmap(_tree, 1, &winPixmap, &winPixmask,
			(char *)win_bits, win_width, win_height);

	XtVaSetValues(_tree,
		XmNlayoutFrozen, True,
		NULL);

	XmLGridDeleteAllRows(_tree, XmCONTENT);
	XtVaSetValues(_tree,
		XmNallowColumnResize, False,
		XmNheadingRows, 0,
		XmNcolumns, 1,
		XmNshadowThickness, 1,
		XmNselectionPolicy, XmSELECT_BROWSE_ROW,
		XmNhighlightRowMode, False,
		XmNglobalPixmapWidth, 0,
		XmNglobalPixmapHeight, 0,
		NULL);
	XtVaSetValues(_tree,
		XmNcolumn, 0,
		XmNcolumnSizePolicy, XmVARIABLE,
		NULL);
	XtVaGetValues(_tree,
		XmNbackground, &bg,
		NULL);
	XtVaSetValues(_tree,
		XmNcellDefaults, True,
		XmNcellBackground, bg,
		XmNcellLeftBorderType, XmBORDER_LINE,
		XmNcellRightBorderType, XmBORDER_LINE,
		XmNcellTopBorderType, XmBORDER_LINE,
		XmNcellBottomBorderType, XmBORDER_LINE,
		XmNcellAlignment, XmALIGNMENT_CENTER,
		NULL);

	n = 100;

	if (num == 1)
		XtVaSetValues(_tree,
			XmNselectionPolicy, XmSELECT_MULTIPLE_ROW,
			XmNglobalPixmapWidth, 16,
			XmNglobalPixmapHeight, 16,
			NULL);
	else if (num == 2)
		XtVaSetValues(_tree,
			XmNhighlightRowMode, True,
			XmNheadingRows, 1,
			XmNcolumns, 5,
			XmNsimpleHeadings, "Object|Position|Size|Method|Note",
			XmNsimpleWidths, "1c 10c 10c 15c 15c",
			XmNallowColumnResize, True,
			NULL);

	XtVaSetValues(_tree,
		XmNcellDefaults, True,
		XtVaTypedArg, XmNcellBackground, XmRString, "white", 6,
		XmNcellLeftBorderType, XmBORDER_NONE,
		XmNcellRightBorderType, XmBORDER_NONE,
		XmNcellTopBorderType, XmBORDER_NONE,
		XmNcellBottomBorderType, XmBORDER_NONE,
		XmNcellAlignment, XmALIGNMENT_RIGHT,
		NULL);
	if (num == 2)
		XtVaSetValues(_tree,
			XmNcellDefaults, True,
			XmNcolumnRangeStart, 3,
			XmNcolumnRangeEnd, 4,
			XmNcellAlignment, XmALIGNMENT_CENTER,
			NULL);

	size = sizeof(XmLTreeRowDefinition);
	rows = (XmLTreeRowDefinition *)malloc(size * n);
	level = 0;
	for (i = 0; i < n; i++)
	{
		rows[i].level = defs[i % 10].level;
		rows[i].expands = defs[i % 10].expands;
		rows[i].isExpanded = True;
		if (num < 2)
		{
			if (i % 30 >= 10)
				rows[i].level += 3;
			if (i % 30 >= 20)
				rows[i].level += 3;
		}
		if (num != 1)
		{
			rows[i].pixmap = XmUNSPECIFIED_PIXMAP;
			rows[i].pixmask = XmUNSPECIFIED_PIXMAP;
		}
		else
		{
			if (rows[i].expands == True)
			{
				rows[i].pixmap = dotPixmap;
				rows[i].pixmask = dotPixmask;
			}
			else
			{
				rows[i].pixmap = winPixmap;
				rows[i].pixmask = winPixmask;
			}
		}
		if (num == 0)
			sprintf(buf, "Row %d Level %d\n", i, rows[i].level);
		else if (num == 2)
		{
			if (rows[i].expands)
				sprintf(buf, "Composite");
			else if (i % 5)
				sprintf(buf, "Curve");
			else
				sprintf(buf, "Surface");
		}
		else
		{
			if (rows[i].expands == True)
				sprintf(buf, "Sector Number %d-%d%d",
					rows[i].level, i % 2, i + 413);
			else
				sprintf(buf, "Item Number %d%d%d", i % 12, i % 3, i % 2);
		}
		rows[i].string = XmStringCreateSimple(buf);
	}
	XmLTreeAddRows(_tree, rows, n, -1);
	for (i = 0; i < n; i++)
	{
		XmStringFree(rows[i].string);
		if (num == 2)
		{
			sprintf(buf, "%d %d|%d points|Open|In Progress",
				i % 20, i % 15, i % 4);
			XmLGridSetStringsPos(_tree, XmCONTENT, i, XmCONTENT, 1, buf);
		}
	}
	free((char *)rows);

	XtVaSetValues(_tree,
		XmNlayoutFrozen, False,
		NULL);
}
