---
Name: odgi
URL: https://github.com/pangenome/odgi
Description: >
  is an optimized dynamic graph/genome implementation.
---

The odgi module parses [odgi stats](https://odgi.readthedocs.io/en/latest/rst/commands/odgi_stats.html) reports. It is specifically designed to parse the output of

```sh
odgi stats -i input_graph.og -y
```

It is not guaranteed that output created using any other parameter combination can be parsed using this module.
It solely works with report files generated by [odgi stats](https://pangenome.github.io/odgi/odgi_docs.html#_odgi_stats1) in `.yaml` format, which look like the following:

```yaml
---
length: 206263
nodes: 3751
edges: 5195
paths: 13
num_weakly_connected_components: 1
weakly_connected_components:
  - component:
      id: 0
      nodes: 3751
      is_acyclic: "no"
num_nodes_self_loops:
  total: 0
  unique: 0
A: 57554
C: 43275
G: 41944
T: 63490
mean_links_length:
  - length:
      path: all_paths
      in_node_space: 1.64973
      in_nucleotide_space: 7.34035
      num_links_considered: 202793
      num_gap_links_not_penalized: 147940
sum_of_path_node_distances:
  - distance:
    path: all_paths
    in_node_space: 5.53383
    in_nucleotide_space: 2.1454
    nodes: 202806
    nucleotides: 3757597
    num_penalties: 231
    num_penalties_different_orientation: 0
```

For the odgi module to discover the [odgi stats](https://odgi.readthedocs.io/en/latest/rst/commands/odgi_stats.html) reports, the file must match one of the following patterns:

- "\*.og.stats.yaml"
- "\*.og.stats.yml"
- "\*.odgi.stats.yaml"
- "\*.odgi.stats.yml"

A bar graph is generated, which shows the length, number of nodes, edges and paths for each sample.
Additionally, a second bar graph is generated visualizing the `in_node_space` and `in_nucleotide_space` for every sample.

It is possible to add custom content to your MultiQC report including
[odgi viz](https://odgi.readthedocs.io/en/latest/rst/commands/odgi_viz.html) or [odgi draw](https://odgi.readthedocs.io/en/latest/rst/commands/odgi_draw.html) PNGs.
Ensure that the names of the PNGs match `*_odgi_viz_mqc.png`.
