/* +---------------------------------------------------------------------------+
   |                     Mobile Robot Programming Toolkit (MRPT)               |
   |                          http://www.mrpt.org/                             |
   |                                                                           |
   | Copyright (c) 2005-2015, Individual contributors, see AUTHORS file        |
   | See: http://www.mrpt.org/Authors - All rights reserved.                   |
   | Released under BSD License. See details in http://www.mrpt.org/License    |
   +---------------------------------------------------------------------------+ */

#ifndef _mrpt_math_H
#define _mrpt_math_H

#include <mrpt/math/distributions.h>
#include <mrpt/math/transform_gaussian.h>
#include <mrpt/math/fourier.h>
#include <mrpt/math/utils.h>
#include <mrpt/math/data_utils.h>
#include <mrpt/math/ops_vectors.h>
#include <mrpt/math/ops_matrices.h>
#include <mrpt/math/ops_containers.h>

#include <mrpt/math/CLevenbergMarquardt.h>
#include <mrpt/math/CQuaternion.h>
#include <mrpt/math/CQuaternion.h>
#include <mrpt/math/ransac.h>
#include <mrpt/math/ransac_applications.h>

#include <mrpt/math/CHistogram.h>
#include <mrpt/math/CMatrix.h>
#include <mrpt/math/CMatrixD.h>
#include <mrpt/math/CMatrixB.h>
#include <mrpt/math/CMatrixTemplateObjects.h>
#include <mrpt/math/CMatrixFixedNumeric.h>
#include <mrpt/math/CArray.h>

#include <mrpt/math/CPolygon.h>
#include <mrpt/math/geometry.h>

#include <mrpt/math/CSplineInterpolator1D.h>

#include <mrpt/math/lightweight_geom_data.h>
#include <mrpt/math/CSparseMatrixTemplate.h>
#include <mrpt/math/CSparseMatrix.h>
#include <mrpt/math/MatrixBlockSparseCols.h>

#include <mrpt/math/CBinaryRelation.h>
#include <mrpt/math/CMonteCarlo.h>
#include <mrpt/math/jacobians.h>

#include <mrpt/math/KDTreeCapable.h>
#include <mrpt/math/kmeans.h>
#include <mrpt/math/slerp.h>
#include <mrpt/math/model_search.h>

#endif
