/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "inc_iostream.h"
#include "MetviewUI.h"

static int xerror(Display *d, XErrorEvent *e)
{
  cout << "\nXlib error encountered!!!" << endl;
  cout << "   To find the originating location in the source code, i.e." << endl;
  cout << "   to get a proper call stack, run MetviewUI in a debugger" << endl;
  cout << "   with run-time flag '-synchronous' (otherwise call stack" << endl;
  cout << "   will not correspond to the originating error location).\n" << endl;

  char buf[1024];
  XGetErrorText(d,e->error_code,buf,sizeof(buf));
  cout << "xerror: " << buf << "\n" << endl;

  abort();
  return 0;    //-- we could use this for non-fatal errors...
}


int main (int argc, char **argv)
{
	XtToolkitInitialize ();
	MetviewUI app(XtCreateApplicationContext(), argc, argv);

	XSetErrorHandler(xerror);

	app.run();
}

