# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class LengthDistribution(TableAlgorithm):
    r"""
    LengthDistribution - Sample the distribution of representative "cell
    lengths"
     of a mesh.
    
    Superclass: TableAlgorithm
    
    LengthDistribution chooses a subset of N cells and, for each one,
    chooses two random connectivity entries of the cell. Then it computes
    the distance between the corresponding points and inserts the
    distance into an ordered set. The result is a cumulative distribution
    function (CDF) of lengths which are representative of the length
    scales present in the dataset. Quantiles (other than the extremal
    values) of this distribution should be relatively stable estimates of
    length scales compared to moment-based estimates that may be skewed
    by outlier elements.
    
    This filter produces a Table as its result, with N rows containing
    monotonically increasing length values. Only polydata and
    unstructured grids are accepted; other dataset types will produce an
    empty table and a warning.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLengthDistribution, obj, update, **traits)
    
    sort_sample = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _sort_sample_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSortSample,
                        self.sort_sample_)

    sample_size = traits.Int(100000, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _sample_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSampleSize,
                        self.sample_size)

    def get_length_quantile(self, *args):
        """
        get_length_quantile(self, qq:float=0.5) -> float
        C++: double get_length_quantile(double qq=0.5)
        Return the length scale at a particular quantile.
        
        This method must only be invoked after the filter has been run
        (i.e., the output is up-to-date with the filter inputs and
        parameters). It is a convenience method that fetches the
        cell-length column from the output table and returns the value at
        or immediately below the requested quantile. If the filter is
        configured not to sort data, this method will throw an exception
        since the output table is not a CDF.
        
        By default, the method returns the median length.
        """
        ret = self._wrap_call(self._vtk_obj.GetLengthQuantile, *args)
        return ret

    _updateable_traits_ = \
    (('sort_sample', 'GetSortSample'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('sample_size', 'GetSampleSize'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'sort_sample', 'object_name', 'progress_text',
    'sample_size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LengthDistribution, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LengthDistribution properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['sort_sample'], [], ['object_name', 'sample_size']),
            title='Edit LengthDistribution properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LengthDistribution properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

